/*
	$Id: DSMgr.h,v 1.1 2003/04/20 23:34:11 dasenbro Exp $

	File:		DSMgr.h

	Contains:	C++ class definitions for Apple Directory Services integration

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Copyright (c) 1996-1999 Apple Computer, Inc. All rights reserved.

	Written By: Michael Dasenbrock

	Change History:

		$Log: DSMgr.h,v $
		Revision 1.1  2003/04/20 23:34:11  dasenbro
		Initial check-in.
		
		Revision 1.27  2002/07/04 18:17:51  dasenbro
		Added HasPasswdServer() and GetPasswdServerInfo().
		
		Revision 1.26  2002/04/18 18:09:10  dasenbro
		Changed bool to Bool for word alignment.
		
		Revision 1.25  2002/03/21 16:38:52  dasenbro
		Addes network transition support.
		
		Revision 1.24  2002/03/11 23:07:52  dasenbro
		Added support for directory based host prefs.
		
		Revision 1.23  2002/03/05 19:27:40  dasenbro
		Added calls to update rejection list and removed calls
		to MailAdminEvents.h
		
		Revision 1.22  2002/02/20 21:06:15  dasenbro
		Removed #include "MailAdminAEvents.h", split the init calls to
		init the log prefs earlier than the rest and added better log messages
		 for server prefs.
		
		Revision 1.21  2002/01/14 17:30:58  dasenbro
		Initial S4 updates.
		
		Revision 1.20  2001/07/09 17:20:04  dasenbro
		Added kDSErrUnknownErr const.
		
		Revision 1.19  2001/06/21 20:50:55  dasenbro
		Updated file header info.
		
		Revision 1.18  2001/06/21 17:21:22  dasenbro
		Format changes.
		
		Revision 1.17  2001/05/23 22:13:52  dasenbro
		Added GetGroups() for ACL support.
		

 */

#ifndef __DSMgr_h__
#define __DSMgr_h__ 1

#include <DirectoryService/DirServices.h>
#include <DirectoryService/DirServicesUtils.h>
#include <DirectoryService/DirServicesConst.h>

#include "DSMailUserCache.h"

class	DSMailUser;
class	DSMailGroup;
class	DSServerPrefs;
class	DSHostPrefs;

class DSMgr
{
public:

typedef enum {
	kDSErrNoErr					=   0,
	kDSErrSyntaxError			=  -1,
	kDSErrFailedToOpen			=  -8,
	kDSErrMemAllocFailed		=  -9,
	kDSErrDuplicateUserName		= -10,
	kDSErrUserNotFound			= -11,
	kDSErrGroupNotFound			= -12,
	kDSErrInvalidUserName		= -13,
	kDSErrInvalidPassword		= -14,
	kDSErrInvalidNameAndPasswd	= -15,
	kDSErrUnknownErr			= -16,
	kDSErrEnd
} eDSErrors;

typedef enum {
	kDSAuthAPOP			= 1,
	kDSAuthCRAM_MD5		= 2,
	kDSAuthEnd
} eAuthType;
	
	// Static methods
	static 	DSServerPrefs*		GetServerPrefsObj	( void );
	static 	DSHostPrefs*		GetHostPrefsObj		( void );

	// Constructor/Destructor
				DSMgr					( void );
	virtual	   ~DSMgr					( void );

	// Initialization/DeInitialization
	tDirStatus 	Initialize				( void );
	sInt32	 	DeInitialize			( void );
	sInt32	 	ReInitialize			( void );

	// Check for Password Server
	tDirStatus	GetPasswdServerInfo		( void );

	// Init server prefs
	tDirStatus	InitServerPrefs			( void );
	tDirStatus	InitHostPrefs			( void );
	tDirStatus	InitServerLogPrefs		( void );
	void		InitializeGreetings		( void );

	// DSMailUsers
	sInt32		GetUserByName			( const char* inName, DSMailUser **outMailUser, Bool inUseCache = true );
	sInt32		GetUserByID				( long inUserID, DSMailUser **outMailUser, Bool inUseCache = true );
	
	sInt32		GetGroupByName			( const char* inName, DSMailGroup **outGroup, Bool inUseCache = true );
	sInt32		GetGroupByID			( long inShortID, DSMailGroup **outGroup, Bool inUseCache = true );

	sInt32		ValidatePassword		( const char* inPassword, DSMailUser *inMailUser );
	sInt32		VerifyUserOrGroup		( UserStruct *inData );

	sInt32		CheckPostmaster			( void );				// Ensure that the postmaster user exists

	Boolean		UserIsMemberOfGroup		( const char *inUserName, const char *inGroupName );
	sInt32		GetGroups				( const char *inUserName, uInt32 *outGroups );

	uInt32		GetMailGroupID			( Bool inCheckDirectory = false );

	bool		HasPasswdServer			( void );
	Bool		DoClearTextAuth			( char *inUserName, char *inPasswd );
	Bool		Validate_MD5_Digest		( char *inUserName, char *inChalenge, char *inResponse );
	Bool		Validate_APOP_Digest	( char *inUserName, char *inChalenge, char *inResponse );

	DSServerPrefs*	GetServerPrefs		( void ) { return( fSrvrPrefs ); };
	DSHostPrefs*	GetHostPrefs		( void ) { return( fHostPrefs ); };

private:
	tDirStatus		AllocateBuffs		( void );
	tDirStatus		OpenDirServices		( void );
	tDirStatus		OpenSearchNode		( void );
	tDirStatus		OpenLocalNode		( void );

	sInt32			ValidateResponse	( const char *inUserName, const char *inChallenge, const char *inResponse, eAuthType inAuthType );

	void			PrintThis			( const char *inStr, const uInt32 inValue );
	void			PrintThis			( const char *inStr, const char *inValue );

private:

	Bool					fInitialized;
	bool					fHasPasswdSrvr;
	tDirReference			fDSRef;
	tDirNodeReference		fSearchNodeRef;
	tDirNodeReference		fLocalNodeRef;
	tDataBuffer			   *fTDataBuff;
	tDataList			   *fUserRecType;
	tDataList			   *fUserAttrType;
	tDataList			   *fGroupRecType;
	tDataList			   *fGroupAttrType;
	tDataNode			   *fUIDAttrType;
	tDataNode			   *fGIDAttrType;
	DSMailCache				fMailCache;
	uInt32					fMailGroupID;
	DSServerPrefs		   *fSrvrPrefs;
	DSHostPrefs			   *fHostPrefs;
};

extern DSMgr *gDSMgr;
extern DSMgr *gDSMgrRouter;

#endif // 
