/*
	$Id: DSPrefs.h,v 1.1 2003/04/20 23:34:11 dasenbro Exp $

	File:		DSPrefs.h

	Contains:	class definition of DSPrefs object

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1996-2002 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: DSPrefs.h,v $
		Revision 1.1  2003/04/20 23:34:11  dasenbro
		Initial check-in.
		
		Revision 1.3  2002/04/18 18:09:10  dasenbro
		Changed bool to Bool for word alignment.
		
		Revision 1.2  2002/03/21 16:38:52  dasenbro
		Addes network transition support.
		
		Revision 1.1  2002/03/11 23:07:14  dasenbro
		Initial check-in.
		

	To Do:
*/

#ifndef __DSPrefs_h__
#define __DSPrefs_h__ 1

#include <DirectoryService/DirServicesTypes.h>
#include "CString.h"

class DSPrefs 
{
public:
					DSPrefs					( void );
	virtual		   ~DSPrefs					( void );

	void			SetDirNodeRef			( const tDirNodeReference inNodeRef );
	void			SetDirRecordRef			( const tRecordReference inRecordRef );

	void			SetDirRef				( const tDirReference inDirRef );

	void			DeInitialize			( void );

protected:
	Bool			AreWeSetup				( void );

	tDirStatus		GetAttributeValue		( const char *inAttrType, uInt32 *outValue, tRecordReference inRecRef = 0 );
	tDirStatus		SetAttributeValue		( const char *inAttrType, uInt32 inAttrValue, tRecordReference inRecRef = 0 );

	tDirStatus		GetAttributeValue		( const char *inAttrType, CString &outStr, tRecordReference inRecRef = 0 );
	tDirStatus		SetAttributeValue		( const char *inAttrType, const char *inAttrValue, tRecordReference inRecRef = 0 );
	tDirStatus		AddAttributeValue		( const char *inAttrType, const char *inAttrValue );
	tDirStatus		RemoveAttributeValue	( const char *inAttrType, const char *inAttrValue );

	tDirStatus		GetAttributeValues		( const char *inAttrType, StrListObj **outStrList );
	tDirStatus		SetAttributeValues		( const char *inAttrType, const StrListObj *inStrList );

	tDirStatus		GetBoolMember			( Bool &inMember, const char *inType, Bool *outValue, Bool inForceRead );
	tDirStatus		SetBoolMember			( Bool &inMember, const char *inType, Bool inFlag, Bool inForceWrite );

	tDirStatus		GetValueMember			( uInt32 &inMember, const char *inType, uInt32 *outValue, Bool inForceRead );
	tDirStatus		SetValueMember			( uInt32 &inMember, const char *inType, uInt32 inValue, Bool inForceWrite );

	tDirStatus		GetEmailAddrMember		( char* &inMember, const char *inType, CString &outStr, Bool inForceRead );
	tDirStatus		SetEmailAddrMember		( char* &inMember, const char *inType, const char *inStr, Bool inForceWrite );

	tDirStatus		GetStringMember			( char* &inMember, const char *inType, CString &outStr, Bool inForceRead );
	tDirStatus		SetStringMember			( char* &inMember, const char *inType, const char *inStr, Bool inForceWrite );

	tDirStatus		GetUserStructMember		( UserStruct* &inMember, const char *inType, UserStruct *outUser, Bool inForceRead );
	tDirStatus		SetUserStructMember		( UserStruct* &inMember, const char *inType, const UserStruct *inUser, Bool inForceWrite );

	tDirStatus		ResetAttribute			( const char *inAttrType );

protected:

	tDirReference		fDirRef;
	tDirNodeReference	fNodeRef;
	tRecordReference	fRecordRef;
	tDataBuffer		   *fNodeBuff;
};

#endif // __DSPrefs_h__
