/*
	$Id: MailGlobals.h,v 1.1 2003/04/20 23:25:37 dasenbro Exp $

	File: MailGlobals.h

	Contains: declarations for globals used througout the Mail Server code. 

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written By: Andrea Cheung

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:
		$Log: MailGlobals.h,v $
		Revision 1.1  2003/04/20 23:25:37  dasenbro
		Initial check-in.
		
		Revision 1.4  2002/03/21 16:41:14  dasenbro
		Updated file version information.
		
		Revision 1.3  2002/03/11 23:49:09  dasenbro
		Added SMTP consts.
		
		Revision 1.2  2002/02/20 21:26:55  dasenbro
		Added consts from MailAdminHooks.h.
		
		Revision 1.1  2002/01/14 16:50:59  dasenbro
		Initial S4 updates.
		
*/

#ifndef __MailGlobals_h__
#define __MailGlobals_h__ 1

#include "MailTypes.h"

class CDatabase;
extern uInt32		gSyncFoldersStamp;
extern uInt32 		gAllowedSMTPClients;
extern uInt32 		gAllowedPOP3Clients;
extern uInt32 		gMaxInConnectionsSMTP;
extern uInt32 		gMaxInConnectionsMail;

const uInt16 kMaxNotifyThreads			= 2;
const uInt32 kMaxSMTPClients			= 16;
const uInt32 kMaxPOP3Clients			= 16;
const uInt32 kMaxAdminConnections		= 5;
const uInt32 kMaxInSMTPConnections		= 256;
const uInt32 kMaxInMailConnections		= 1024;

typedef enum {
	kUknownPort		= 0,
	kSMTP_Port		= 25,
	kSMTP_OutPort	= 25,
	kPOP3_Port		= 110,
	kPASS_Port		= 106,
	kIMAP4_Port 	= 143,
	kSMTP_SSL_Port	= 587,
	kASIA_Port		= 626,		// ASIA admin port
	kIMAP_SSL_Port	= 993,		// IMAP4 over SSL s-imap
	kPOP3_SSL_Port	= 995,		// POP3  over SSL s-pop
	kFingerInPort	= 0xf001,
	kFingerOutPort	= 0xf002,
	kPhPort			= 0xf003,
	kWhoIsPort		= 0xf004,
	kLDAPPort		= 0xf005,
	kPortEnd		= 0xFFFF
} PortSelector;


typedef enum {
	kUknownType		= '????',
	kSMTP_Type		= 'SMTP',
	kPOP3_Type		= 'POP3',
	kIMAP4_Type	 	= 'IMAP',
	kSMTP_SSL_Type 	= 'SMSL',
	kASIA_Type		= 'ASIA',
	kIMAP_SSL_Type	= 'IMSL',
	kPOP3_SSL_Type	= 'PPSL',
	kEndType		= 'end '
} ProtocolType;

typedef enum
{
	kNoValue,
	kAllowAllMessages,
	kAllowLocalDelivery,
	kRejectAllMessages
} EInMsgPreference;

enum { kMaxHostNameLength = 255 };

typedef char                            InetDomainName[256];

#endif // __MailGlobals_h__
