/*
	File:		CMailboxes_10_1.cpp

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:
*/

// 
#include <string.h>

// App
#include "CMailboxes.10.1.h"
#include "CMailSpool.10.1.h"
#include "Database.10.1.h"
#include "CTokenizer.h"
#include "IMAPErrors.h"
#include "CUtils.h"
#include "CGlobals.h"

//--------------------------------------------------------------------------------------------------
//	* CMailboxes_10_1 ()
//
//--------------------------------------------------------------------------------------------------

CMailboxes_10_1::CMailboxes_10_1 ( char *inSession, Boolean inIs8BitOn, ObjID inAcctID )
{
	try
	{
		fSession		= nil;
		fAccountID		= inAcctID;
		f8BitOn			= inIs8BitOn;
		fArg1			= nil;
		fArg2			= nil;
		fCommand		= nil;
		fCmdType		= 0;
		fFlags			= 0;
		::memset( &fFldrPrefix, 0, sizeof( fFldrPrefix ) );
		fActions		= nil;
	}

	catch ( ExceptionCode err )
	{
		Throw_( err );
	}
} // CMailboxes_10_1



//--------------------------------------------------------------------------------------------------
//	* ~CMailboxes_10_1 ()
//
//--------------------------------------------------------------------------------------------------

CMailboxes_10_1::~CMailboxes_10_1 ( void )
{
	if ( fCommand != nil )
	{
		delete( fCommand );
		fCommand = nil;
	}

	if ( fArg1 != nil )
	{
		delete( fArg1 );
		fArg1 = nil;
	}

	if ( fArg2 != nil )
	{
		delete( fArg2 );
		fArg2 = nil;
	}

	if ( fActions != nil )
	{
		delete( fActions );
		fActions = nil;
	}
} // ~CMailboxes_10_1


//--------------------------------------------------------------------------------------------------
//	* GetCurrentMailboxID
//
//--------------------------------------------------------------------------------------------------

ObjID CMailboxes_10_1::GetCurrentMailboxID ( void )
{
	ObjID			mailboxID = 0;
	CMailSpool_10_1	   *mailSpool;

//	if ( fSession != nil )
//	{
//		mailSpool = fSession->GetSelectedSpool();
//		if ( mailSpool != nil )
//		{
//			mailboxID = mailSpool->GetMailSpoolID();
//		}
//	}

	return( mailboxID );

} // GetCurrentMailboxID



//--------------------------------------------------------------------------------------------------
//	* Initialize
//
//		-	Return bad command format if necessare ...
//
//--------------------------------------------------------------------------------------------------

void CMailboxes_10_1::Initialize ( const char *arg1, const char *arg2, const char *inCommand, eCommand inCmdType )
{
	SetMailbox1( arg1 );
	SetMailbox2( arg2 );

	fCmdType = inCmdType;

	if ( inCommand != nil )
	{
		if ( fCommand == nil )
		{
			fCommand = new CString( inCommand );
		}
		else
		{
			fCommand->Set( inCommand );
		}
	}

	SetupCommand( inCmdType );

} // Initialize



//--------------------------------------------------------------------------------------------------
//	* GetAccountID
//
//--------------------------------------------------------------------------------------------------

ObjID CMailboxes_10_1::GetAccountID ( void )
{
	return( fAccountID );
} // GetAccountID



//--------------------------------------------------------------------------------------------------
//	* SetAccountID
//
//--------------------------------------------------------------------------------------------------

void CMailboxes_10_1::SetAccountID ( ObjID inAcctID )
{
	fAccountID = inAcctID;
} // SetAccountID



//--------------------------------------------------------------------------------------------------
//	* HasPrefix
//
//		-	Check the incomming string for a root prefis - ~, or the hierarchy delimiter - /
//			 Return return true if either exist at the start of the string
//
//--------------------------------------------------------------------------------------------------

Boolean CMailboxes_10_1::HasPrefix ( char *inData )
{
	Boolean		result = false;

	if ( *inData == kHierRootChar || *inData == kHierDelimChar )
	{
		result = true;
	}

	return( result );
}


//--------------------------------------------------------------------------------------------------
//	* SetPrefixString
//
//		- Set the prefix string.  This will be returned in the response
//
//--------------------------------------------------------------------------------------------------

void CMailboxes_10_1::SetPrefixString ( char inChar, uInt16 inWhere )
{
	if ( (inWhere > 0) && (inWhere < 10) )
	{
		fFldrPrefix[ inWhere ] = inChar;
	}
} // SetPrefixString



//--------------------------------------------------------------------------------------------------
//	* StripPrefix
//
//--------------------------------------------------------------------------------------------------

void CMailboxes_10_1::StripPrefix ( char *inData )
{
	char   *p		= inData;
	sInt16	count	= 0;
	sInt16   len		= CUtils::Strlen( inData );

	if ( len > 0 )
	{
		if ( *p == kHierRootChar )
		{
			count++;
			p++;
		}

		if ( *p == kHierDelimChar )
		{
			count++;
			p++;
		}

		if ( count > 0 )
		{
			::memmove( inData, &inData[count], len - count);
			inData[ len - count ] = '\0';
		}
	}
} // StripPrefix



//--------------------------------------------------------------------------------------------------
//	* SetPrefix
//
//--------------------------------------------------------------------------------------------------

char* CMailboxes_10_1::SetPrefix ( char *inData )
{
	char	   *p = inData;
	uInt16		i = 0;

	if ( *p == kHierRootChar )
	{
		fFlags |= kHasPrefix;
		SetPrefixString( *p, i );
		i++;
		p++;
	}

	if ( *p == kHierDelimChar )
	{
		fFlags |= kHasPrefix;
		SetPrefixString( *p, i );
		i++;
		p++;
	}

	return( p );

} // SetPrefix



//--------------------------------------------------------------------------------------------------
//	* SetupCommand
//
//--------------------------------------------------------------------------------------------------

sInt16 CMailboxes_10_1::SetupCommand ( eCommand inCmdType )
{
	char	   *p		= nil;
	uInt32		result	= kNoErr;

	switch( inCmdType )
	{
		case kCmdFind:
			if ( fCommand != nil )
			{
				fCommand->Set( "MAILBOX " );
			}

			if ( CUtils::Stricmp( fArg1->GetData(), "ALL.MAILBOXES" ) == 0 )
			{
				fFlags |= kListAll;
			}
			else if ( CUtils::Stricmp( fArg1->GetData(), "MAILBOXES" ) == 0 )
			{
				fFlags |= kListSubOnly;
			}
			else
			{
				return( -1 );
			}

			fArg1->Clear();

			CombineArgs();

			result = VerifyArgs();
			break;

		case kCmdLsub:
			fFlags |= kListSubOnly;

		case kCmdList:
		case kCmd_X_List:
			CombineArgs();

			result = VerifyArgs();

			break;

		case kCmdCreate:
		case kCmdSelect:
		case kCmdExamine:
		case kCmdDelete:
		case kCmdRename:
		case kCmdStatus:
		case kCmdSubUnsub:
			p = SetPrefix( fArg1->GetData() );
			fArg1->Set( p );

			break;

		case kCmdCopy:
			break;
	}

	return( result );

} // SetupCommand



//--------------------------------------------------------------------------------------------------
//	* CombineArgs
//
//--------------------------------------------------------------------------------------------------

void CMailboxes_10_1::CombineArgs ( void )
{
	char	   *arg1	= fArg1->GetData();
	sInt32		len		= fArg1->GetLength();
	char	   *arg2	= fArg2->GetData();

	if ( len > 0 )
	{
		if ( (arg1[ len - 1 ] != kHierDelimChar ) && (*arg2 != kHierDelimChar) )
		{
			fArg1->Append( kHierDelimChar );
		}
		else if ( (arg1[ len - 1 ] == kHierDelimChar ) && (*arg2 == kHierDelimChar) )
		{
			fArg1->Set( fArg1->GetData(), len - 1 );
		}
	}

	fArg1->Append( fArg2->GetData() );

} // CombineArgs



//--------------------------------------------------------------------------------------------------
//	* VerifyArgs
//
//--------------------------------------------------------------------------------------------------

sInt16 CMailboxes_10_1::VerifyArgs ( void )
{
	sInt16	result	= kNoErr;

	try
	{
		char			c;
		sInt16			i				= 0;
		Boolean			wildChar		= false;
		sInt16			tmpActionCnt	= 0;

		// If the argument has a null mailbox name, then bail
		//	ie. inbox/temp//stuff
		
		if ( (fArg1->GetLength() > 1) && (CUtils::Strstr( fArg1->GetData(), kDoubleDelimStr ) != nil) )
		{
			return( kErrMBoxPathHasEmptyName );
		}

		// If the argument has a double *'s or double %'s
		//	ie. inbox/temp/**/stuff or inbox/temp/%%/stuff
		if ( (fArg1->GetLength() > 1) &&
			 ((::strstr( fArg1->GetData(), kDoubleStarStr ) != nil) ||
			  (::strstr( fArg1->GetData(), kStarPercentStr ) != nil) ||
			  (::strstr( fArg1->GetData(), kPercentStarStr ) != nil) ||
			  (::strstr( fArg1->GetData(), kDoublePercentStr ) != nil)) )
		{
			return( kNoErr );
		}

		fArg1->Set( SetPrefix( fArg1->GetData() ) );

		// Set the tokenizer for the arguments
		CTokenizer		tokenObj( *fArg1, kHierDelimStr );
		CString			cmdToken( 256 );

		fActionCnt = tokenObj.Count();
		if ( fActionCnt == 0 )
		{
			fFlags = kListRootOnly;
			fArg1->Clear();
		}
		else if ( fActionCnt > kMaxMailboxDepth_10_1 )
		{
			result = kErrMboxDepthTooDeep;
			fArg1->Clear();
		}
		else
		{
			// Add 1 to fActionCnt for a possible list arg of "tag list "" inbox/star*"
			//	This will add the kMatchAll as the last action

			fActions = new eActions[ fActionCnt + 1 ];
			ThrowIfNULL_( fActions );
			::memset( fActions, 0, sizeof( *fActions ) * (fActionCnt + 1) );

			i = 0;
			tmpActionCnt = fActionCnt;
			while ( i < fActionCnt )
			{
				cmdToken.Set( tokenObj.Get( i ), tokenObj.GetLength( i ) );

				if ( cmdToken.GetLength() == 1 )
				{
					c = cmdToken.GetData()[0];
					if ( c == '*' )
					{
						fActions[ i ] = kMatchAll;
						wildChar = true;
					}
					else if ( c == '%' )
					{
						fActions[ i ] = kMatchOnly;
						wildChar = true;
					}
					else
					{
						fActions[ i ] = kMatchExact;
					}
				}
				else
				{
					if ( (::strstr( cmdToken.GetData(), "%" ) != nil ) ||
						 (::strstr( cmdToken.GetData(), "*" ) != nil ) )
					{
						wildChar = true;
						fActions[ i ] = kMatchBetween;

						if ( cmdToken.GetData()[ cmdToken.GetLength() - 1 ] == '*' )
						{
							// Are we on the last list token
							if ( i == (fActionCnt - 1) )
							{
								// Add the match all action to the end of the list
								tmpActionCnt = fActionCnt +1;

								fActions[ fActionCnt ] = kMatchAll;

							}
						}
					}
					else
					{
						fActions[ i ] = kMatchExact;
					}
				}
				i++;
			}

			// Temp action count _MUST NOT_ be more than the action count + 1
			fActionCnt = tmpActionCnt;

			if ( wildChar == false )
			{
				fFlags = kListOneMailbox;
			}
		}
	}

	catch ( ExceptionCode err )
	{
		result = err;

		if ( fActions != nil )
		{
			delete( fActions );
			fActions = nil;
		}
		fActionCnt = 0;
	}

	return( result );

} // VerifyArgs



//--------------------------------------------------------------------------------------------------
//	* SetMailbox1
//
//--------------------------------------------------------------------------------------------------

void CMailboxes_10_1::SetMailbox1 ( const char *inStr )
{
	if ( fArg1 == nil )
	{
		fArg1 = new CString( inStr );
	}
	ThrowIfNULL_( fArg1 );
} // SetMailbox1



//--------------------------------------------------------------------------------------------------
//	* SetMailbox2
//
//--------------------------------------------------------------------------------------------------

void CMailboxes_10_1::SetMailbox2 ( const char *inStr )
{
	if ( fArg2 == nil )
	{
		fArg2 = new CString( inStr );
	}
	ThrowIfNULL_( fArg2 );
} // SetMailbox2



//--------------------------------------------------------------------------------------------------
//	* GetMailbox1ObjID
//
//--------------------------------------------------------------------------------------------------

ObjID CMailboxes_10_1::GetMailbox1ObjID ( void )
{
	return( VerifyMailboxPath( fArg1->GetData() ) );
} // GetMailbox1ObjID



//--------------------------------------------------------------------------------------------------
//	* GetMailbox2ObjID
//
//--------------------------------------------------------------------------------------------------

ObjID CMailboxes_10_1::GetMailbox2ObjID ( void )
{
	return( VerifyMailboxPath( fArg2->GetData() ) );
} // GetMailbox2ObjID




//--------------------------------------------------------------------------------------------------
//	* CreateMailbox
//
//--------------------------------------------------------------------------------------------------

sInt16 CMailboxes_10_1::CreateMailbox ( Boolean inIsShared, ObjID inSharedSpoolID, ObjID *outNewSpoolID )
{
	Boolean			isShared	= false;
	int				i			= 0;
	int				tokenCnt	= 0;
	sInt32			result		= kNoErr;
	uInt32			flags		= 0;
	ObjID			mailboxID	= 0;
	ObjID			parentID	= CMailSpool_10_1::kRootParent;
	char		   *mbName		= nil;
	CMailSpool_10_1	   *mbSpool		= nil;
	CTokenizer		tokenObj( *fArg1, kHierDelimStr );
	ObjID			spoolList[ kMaxMailboxDepth_10_1 ];

	try
	{
		// Set to null
		::memset( spoolList, 0, sizeof( spoolList ) );

		// Let's first check to see if they are trying to mess with the POP3 inbox
		CString	rootName( tokenObj.Get( 0 ), tokenObj.GetLength( 0 ) );
		if ( CUtils::Stricmp( rootName.GetData(), "POP3 INBOX" ) == 0 )
		{
			result = kErrCantCreatePOPInbox;
			if ( tokenObj.Count() > 1 )
			{
				result = kErrPOPInboxCantHaveSub;
			}
		}

		if ( result == kNoErr )
		{
			// Set default result code
			result = kErrCantCreateMbox;

			tokenCnt = tokenObj.Count();
			if ( tokenCnt <= kMaxMailboxDepth_10_1 )
			{
				while ( (i < tokenCnt) && (result == kErrCantCreateMbox) )
				{
					mbName = tokenObj.Get( i );
					mbName[ tokenObj.GetLength( i ) ] = '\0';

					// Make sure that the name is not too long
					if ( tokenObj.GetLength( i ) <= kMailboxNameLen_10_1 )
					{
						// Check to see if this mailbox already exists
						mailboxID = GetThisMailboxesID( mbName, parentID, isShared );
						if ( mailboxID == 0 )
						{
							if ( GetMailboxCount() <= kMaxMailboxCount_10_1 )
							{
								// The mailbox does not exis, so let's create it
								mbSpool = CMailSpool_10_1::Create( CMailSpool_10_1::kIMAP4Spool,
																  mbName,
																  fAccountID,
																  parentID );
								ThrowIfNULL_( mbSpool );
								if ( inIsShared == true )
								{
									flags = mbSpool->GetFlags();
									mbSpool->SetFlags( flags & CMailSpool_10_1::kSharedFlag );
									mbSpool->SetACLHeadID( inSharedSpoolID );
									*outNewSpoolID = mbSpool->GetMailSpoolID();
								}
								parentID = mbSpool->GetMailSpoolID();
								spoolList[ i ] = mbSpool->GetMailSpoolID();
								if ( i == tokenObj.Count() - 1 )
								{
									// It created the one we wanted ...
									result = kRespCommandCompleted;
								}

								mbSpool->Done ( mbSpool );
							}
							else
							{
								// We need to delete the mailboxes we created because
								//	the command faild
								for ( i = 0; i < kMaxMailboxDepth_10_1; i++ )
								{
									if (  spoolList[ i ] != 0 )
									{
										mbSpool = CMailSpool_10_1::FindByID(  spoolList[ i ] );
										if ( mbSpool != nil )
										{
											CMailSpool_10_1::Delete( mbSpool );
											mbSpool->Done( mbSpool );
										}
										spoolList[ i ] = 0;
									}
								}
								result = kErrMaxNumberMboxExceeded;
							}
						}
						else
						{
							if ( isShared == true )
							{
								result = kErrCantCreateSharedMbox;
							}
							else if ( i == (tokenCnt - 1) )
							{
								mbSpool = CMailSpool_10_1::FindByID( mailboxID );
								if ( mbSpool != nil )
								{
									// check to see if the delete flag was set
									if ( mbSpool->GetFlags() & CMailSpool_10_1::kDeletedFlag )
									{
										// Lets bring this one back to life...
										flags = mbSpool->GetFlags();
										flags &= ~CMailSpool_10_1::kDeletedFlag;
										flags &= ~CMailSpool_10_1::kNoSelectFlag;
										mbSpool->SetFlags( flags );

										result = kRespCommandCompleted;
									}
									mbSpool->Done( mbSpool );
								}
							}
							parentID = mailboxID;
						}
						i++;
					}
					else
					{
						result = kErrMboxNameTooLong;
					}
				}
			}
			else
			{
				result = kErrMboxDepthTooDeep;
			}
		}
	}

	catch ( ExceptionCode err )
	{
		mbSpool->Done( mbSpool );

		result = err;
	}

	return( result );

} // CreateMailbox



//--------------------------------------------------------------------------------------------------
//	* DeleteMailbox
//
//--------------------------------------------------------------------------------------------------

OSErr CMailboxes_10_1::DeleteMailbox ( void )
{
	return( 0 );
} // DeleteMailbox



//--------------------------------------------------------------------------------------------------
//	* MailboxHasInferiors
//
//--------------------------------------------------------------------------------------------------

OSStatus CMailboxes_10_1::MailboxHasInferiors ( ObjID inMbID )
{
	OSStatus		result	= kNoErr;
	Boolean			done	= false;
	ObjID			objID	= 0;
	CMailSpool_10_1	   *mbSpool	= nil;
	SDBIterator_10_1		iterator;

	try
	{
		// Look for inferiors
		result = gDB_10_1->CreateIterator( kMailSpoolSignature_10_1, &iterator, fAccountID );
		if ( result == kNoErr )
		{
			while ( (gDB_10_1->NextObject( &iterator, objID ) == kNoErr) && (!done) )
			{
				mbSpool = CMailSpool_10_1::FindByID( objID );
				if ( mbSpool != nil )
				{
					if ( mbSpool->GetParentID() == inMbID )
					{
						// We have inferiors, only delete the messages
						done = true;
						result = kErrDeleteHasInferiors;
					}
					mbSpool->Done( mbSpool );
				}
			}
		}
		gDB_10_1->ReleaseIterator( &iterator );
	}

	catch ( ExceptionCode err )
	{
		mbSpool->Done( mbSpool );

		gDB_10_1->ReleaseIterator( &iterator );

		result = err;
	}

	return( result );

} // MailboxHasInferiors



//--------------------------------------------------------------------------------------------------
//	* RenameMailbox
//
//--------------------------------------------------------------------------------------------------

sInt16 CMailboxes_10_1::RenameMailbox ( CMailSpool_10_1 *inMbSpool )
{
	return( 0 );
} // RenameMailbox



//--------------------------------------------------------------------------------------------------
//	* GetThisMailboxesID
//
//--------------------------------------------------------------------------------------------------

ObjID CMailboxes_10_1::GetThisMailboxesID ( char *inMailbox, ObjID inParentID, Boolean &IsShared )
{
	Boolean			matchCase		= false;
	ObjID			outMailboxID	= 0;
	CMailSpool_10_1	   *mbSpool			= nil;

	try
	{
		IsShared = false;

		if ( (CUtils::Stricmp( inMailbox, "INBOX" ) == 0) || 
			 (CUtils::Stricmp( inMailbox, "POP3 INBOX" ) == 0) )
		{
			matchCase = matchCase;
		}
		else
		{
			matchCase = f8BitOn;
		}

		mbSpool = CMailSpool_10_1::FindByNameParentID( inMailbox, inParentID, fAccountID, matchCase );

		if ( mbSpool != nil )
		{
			outMailboxID = mbSpool->GetMailSpoolID();
			if ( mbSpool->GetFlags() & CMailSpool_10_1::kSharedFlag )
			{
				IsShared = true;
			}
			mbSpool->Done( mbSpool );
		}
	}

	catch ( ExceptionCode err )
	{
		mbSpool->Done( mbSpool );
	}

	return( outMailboxID );

} // GetThisMailboxesID



//--------------------------------------------------------------------------------------------------
//	* VerifyMailboxPath
//
//--------------------------------------------------------------------------------------------------

ObjID CMailboxes_10_1::VerifyMailboxPath ( char *inMailboxPath )
{
	Boolean		notUsed		= false;
	char	   *p			= inMailboxPath;
	sInt16		i			= 0;
	sInt16		strLength	= 0;
	ObjID		parentID	= CMailSpool_10_1::kRootParent;
	ObjID		mailboxID	= 0;
	CString		mailboxStr( 128 );

	if ( *p == kHierRootChar )
	{
		*p++;
	}

	if ( *p == kHierDelimChar )
	{
		*p++;
	}

	strLength = CUtils::Strlen(p);
	if ( (p[ strLength - 1] == kHierDelimChar ) && (strLength > 0) )
	{
		mailboxStr.Set( p, strLength - 1 );
	}
	else
	{
		mailboxStr.Set( p );
	}

	CTokenizer tokenObj( mailboxStr, kHierDelimStr );

	while ( i < tokenObj.Count() )
	{
		char	*mbName = tokenObj.Get( i );
		mbName[ tokenObj.GetLength( i ) ] = '\0';

		mailboxID = GetThisMailboxesID( mbName, parentID, notUsed );

		if ( mailboxID == 0 )
		{
			break;
		}
		else
		{
			parentID = mailboxID;
		}
		i++;
	}

	return( mailboxID );

} // VerifyMailboxPath



//--------------------------------------------------------------------------------------------------
//	* MatchCase
//
//--------------------------------------------------------------------------------------------------

void CMailboxes_10_1::MatchCase ( CString &outMailboxStr )
{
	try
	{
		sInt16			i = 0;
		CTokenizer		userStr( *fArg1, kHierDelimStr );
		CTokenizer		mbStr( outMailboxStr, kHierDelimStr );
		CString			str1( 32 );
		CString			str2( 32 );
		CString			newStr( kMailboxNameLen_10_1 );

		sInt16	cnt = mbStr.Count();

		if ( fArg1->GetLength() > 0 )
		{
			while ( i < cnt )
			{
				try
				{
					str1.Set( userStr.Get( i ), userStr.GetLength( i ) );
				}
				catch ( ExceptionCode err )
				{
					str1.Clear();
				}

				try
				{
					str2.Set( mbStr.Get( i ), mbStr.GetLength( i ) );
				}
				catch ( ExceptionCode err )
				{
					str2.Clear();
				}

				if ( i > 0 )
				{
					newStr.Append( kHierDelimStr );
				}

				if ( CUtils::Stricmp( str1.GetData(), str2.GetData() ) == 0 )
				{
					newStr.Append( userStr.Get( i ), userStr.GetLength( i ) );
				}
				else
				{
					newStr.Append( mbStr.Get( i ), mbStr.GetLength( i ) );
				}
				i++;
			}
			outMailboxStr.Set( newStr.GetData() );
		}
	}
	catch ( ExceptionCode err )
	{
	}
} // MatchCase


//--------------------------------------------------------------------------------------------------
//	* WriteMailboxPath
//
//--------------------------------------------------------------------------------------------------

void CMailboxes_10_1::WriteMailboxPath ( CString &inMbPath,
									CString &outMbList,
									uInt32	 inMBFlags )
{
	Boolean		bAddQuote	= false;
	Boolean		bAddSpace	= false;
	CString		aString( 16 );

	if ( (outMbList.GetLength() + inMbPath.GetLength()) > (outMbList.GetAllocSize() - 32) )
	{
//		if ( fSession != nil )
//		{
//			CEndpoint  *endPt = fSession->GetEndpoint();
//			if ( endPt != nil )
//			{
//				endPt->WriteString( outMbList );
				outMbList.Clear( 1024 );
//			}
//		}
	}

	// Echo character string
	MatchCase( inMbPath );

	if ( CUtils::Stricmp( inMbPath.GetData(), "INBOX" ) != 0 )
	{
		if ( fFlags & kHasPrefix )
		{
			inMbPath.Prepend( fFldrPrefix );
		}
	}

	// Check for space in the mailbox name.  If there are spaces, we need to quote
	//	the outgoing mailbox name.

	if ( CUtils::Strstr( inMbPath.GetData(), " " ) != nil )
	{
		bAddQuote = true;
	}

	if ( fCmdType != kCmdFind )
	{
		if ( bAddQuote )
		{
			inMbPath.Prepend( " \"/\" \"" );
		}
		else
		{
			inMbPath.Prepend( " \"/\" " );
		}

		aString.Set( "(" );
		if ( inMBFlags & CMailSpool_10_1::kNoSelectFlag )
		{
			aString.Append( "\\Noselect" );
			bAddSpace = true;
		}

		if ( inMBFlags & CMailSpool_10_1::kNoInferiorsFlag )
		{
			if ( bAddSpace == true )
			{
				aString.Append( " " );
			}
			aString.Append( "\\Noinferiors" );
			bAddSpace = true;
		}

		if ( fCmdType == kCmd_X_List )
		{
			if ( inMBFlags & CMailSpool_10_1::kSharedFlag )
			{
				if ( bAddSpace == true )
				{
					aString.Append( " " );
				}
				aString.Append( "\\Shared" );
				bAddSpace = true;
			}

			if ( inMBFlags & CMailSpool_10_1::kPublishedFlag )
			{
				if ( bAddSpace == true )
				{
					aString.Append( " " );
				}
				aString.Append( "\\Published" );
				bAddSpace = true;
			}
		}

		aString.Append( ")" );
		inMbPath.Prepend( aString.GetData() );
	}

	if ( fCommand != nil )
	{
		inMbPath.Prepend( fCommand->GetData() );
	}
	inMbPath.Prepend( "* " );

	if ( fCmdType != kCmdFind )
	{
		if ( bAddQuote )
		{
			inMbPath.Append( "\"\r\n" );
		}
		else
		{
			inMbPath.Append( "\r\n" );
		}
	}
	else
	{
		inMbPath.Append( "\r\n" );
	}

	outMbList.Append( inMbPath.GetData() );

} // WriteMailboxPath



//--------------------------------------------------------------------------------------------------
//	* OkToList
//
//--------------------------------------------------------------------------------------------------

Boolean CMailboxes_10_1::OkToList ( CMailSpool_10_1 *inSpool, Boolean inListPopInbox )
{
	Boolean		result = true;

	if ( (fFlags & kListSubOnly) && 
		 (!(inSpool->GetFlags() & CMailSpool_10_1::kSubscribedFlag)) )
	{
		result = false;
	}

	if ( inListPopInbox == false )
	{
		result = false;
	}

	if ( !(inSpool->GetACLRights() & CMailSpool_10_1::kACLLookup) )
	{
		result = false;
	}

	return( result );

} // OkToList


//--------------------------------------------------------------------------------------------------
//	* ListMailboxes
//
//		-	Respond with list of the mailboxs
//
//--------------------------------------------------------------------------------------------------

void CMailboxes_10_1::ListMailboxes ( CString &outMbList, Boolean inListPopInbox )
{
	OSErr			result;
	ObjID			objID;
	Boolean			listIt;
	Boolean			listDeleted;
	SDBIterator_10_1		iterator;
	CMailSpool_10_1	   *mbSpool;
	CString			mailboxPath( 32 );

	try
	{
		if ( fFlags & kListRootOnly )
		{
			ListRoot( outMbList );
		}
		else if ( fFlags & kListOneMailbox )
		{
			objID = VerifyMailboxPath( fArg1->GetData() );

			mbSpool = CMailSpool_10_1::FindByID( objID );
			if ( mbSpool != nil )
			{
				if ( OkToList( mbSpool, inListPopInbox ) == true )
				{
					this->GetFullPath( mailboxPath, mbSpool );
					WriteMailboxPath( mailboxPath, outMbList, mbSpool->GetFlags() );
				}
				mbSpool->Done( mbSpool );
			}
		}
		else
		{
			try
			{
				result = gDB_10_1->CreateIterator( kMailSpoolSignature_10_1, &iterator, fAccountID );
				if ( result == kNoErr )
				{
					while ( gDB_10_1->NextObject( &iterator, objID ) == kNoErr )
					{
						mbSpool = CMailSpool_10_1::FindByID( objID );
						if ( mbSpool != nil )
						{
							if ( OkToList( mbSpool, inListPopInbox ) == true )
							{
								this->GetFullPath( mailboxPath, mbSpool );

								listIt = CheckListConditions( mailboxPath, listDeleted );

								if ( (mbSpool->GetFlags() & CMailSpool_10_1::kDeletedFlag) &&
									 (listDeleted == false) )
								{
									listIt = false;
								}

								if ( listIt == true )
								{
									WriteMailboxPath( mailboxPath, outMbList, mbSpool->GetFlags() );
								}
							}
							mbSpool->Done( mbSpool );
						}
					}
				}
				gDB_10_1->ReleaseIterator( &iterator );
			}

			catch ( ExceptionCode err )
			{
				mbSpool->Done( mbSpool );

				gDB_10_1->ReleaseIterator( &iterator );
			}
		}
	}

	catch ( ExceptionCode err )
	{
		mbSpool->Done( mbSpool );
	}

} // ListMailboxes



//--------------------------------------------------------------------------------------------------
//	* CheckListConditions
//	
//--------------------------------------------------------------------------------------------------

Boolean CMailboxes_10_1::CheckListConditions ( CString &inMbPath, Boolean &outListDeleted )
{
	sInt16			i			= 0;
	Boolean			done		= false;
	Boolean			result		= true;
	CTokenizer		mbToken( inMbPath, kHierDelimStr );
	CString			mbName( 256 );
	CTokenizer		ListToken( *fArg1, kHierDelimStr );
	CString			ListName( 256 );

	outListDeleted = false;

	if ( mbToken.Count() < ListToken.Count() )
	{
		result = false;
		done = true;
	}

	while ( (i < mbToken.Count()) && !done )
	{
		if ( i >= fActionCnt )
		{
			result = false;
			done = true;
		}
		else
		{
			switch ( fActions[ i ] )
			{
				case kMatchExact:
					mbName.Set( mbToken.Get( i ), mbToken.GetLength( i ) );
					ListName.Set( ListToken.Get( i ), ListToken.GetLength( i ) );
					if ( f8BitOn == true )
					{
						if ( CUtils::Strcmp( mbName.GetData(), ListName.GetData() ) != 0 )
						{
							result = false;
							done = true;
						}
					}
					else
					{
						if ( CUtils::Stricmp( mbName.GetData(), ListName.GetData() ) != 0 )
						{
							result = false;
							done = true;
						}
					}
					break;

				case kMatchOnly:
					if ( (i+1 == mbToken.Count()) &&
						 (i+1 == ListToken.Count()) )
					{
						outListDeleted = true;
					}
					break;

				case kMatchAll:
					if ( i == (fActionCnt - 1) )
					{
						done = true;
					}
					break;

				case kMatchBetween:
					mbName.Set( mbToken.Get( i ), mbToken.GetLength( i ) );
					ListName.Set( ListToken.Get( i ), ListToken.GetLength( i ) );
					result = DoesThisMatch( ListName, mbName );
					if ( (result == false) || (i == (fActionCnt - 1)) )
					{
						if ( mbToken.Count() > i+1 )
						{
							result = false;
						}
						done = true;
					}
					break;

				default:
					result = false;
					done = true;
					break;
			}
		}
		i++;
	}

	return( result );

} // CheckListConditions



//--------------------------------------------------------------------------------------------------
//	* DoesThisMatch
//	
//--------------------------------------------------------------------------------------------------

Boolean CMailboxes_10_1::DoesThisMatch ( CString &inCmdArgs, CString &inMbName )
{
	Boolean			result		= true;
	Boolean			done		= false;
	sInt16			i			= 0;
	char		   *p			= inCmdArgs.GetData();
	char		   *n			= inMbName.GetData();
	CString			arg			( 16 );
	CString			tokenList	( 32 );

	while ( *p != nil )
	{
		if ( (*p == '*') || (*p == '%') )
		{
			if ( tokenList.GetLength() > 0 )
			{
				tokenList.Append( kHierDelimStr );
			}
			tokenList.Append( *p );
			if ( *(p+1) != nil )
			{
				tokenList.Append( kHierDelimStr );
			}
		}
		else
		{
			tokenList.Append( *p );
		}
		p++;
	}

	CTokenizer tokenObj( tokenList, kHierDelimStr );
	while ( (i < tokenObj.Count()) && !done )
	{
		if ( (n == nil) )
		{
			done	= true;
			result	= false;
			break;
		}

		arg.Set( tokenObj.Get( i ), tokenObj.GetLength( i ) );

		if ( (CUtils::Strcmp( "*", arg.GetData() ) != 0) && (CUtils::Strcmp( "%", arg.GetData() ) != 0) )
		{
			p = arg.GetData();
			if ( i == 0 )
			{
				if ( f8BitOn == true )
				{
					if ( ::strncmp( n, p, arg.GetLength() ) != 0 )
					{
						n = nil;
					}
				}
				else
				{
					if ( CUtils::Strincmp( n, p, arg.GetLength() ) != 0 )
					{
						n = nil;
					}
				}
			}
			else
			{
				if ( f8BitOn == true )
				{
					n = CUtils::Strstr( n, p );
				}
				else
				{
					n = CUtils::Stristr( n, p );
				}
			}

			if ( n == nil )
			{
				done	= true;
				result	= false;
				break;
			}

			if ( result == true )
			{
				n += arg.GetLength();
			}
		}
		i++;
	}

	// Check for a trailing wild card
	if ( (result == true ) && ( *n != nil ) )
	{
		i = tokenObj.Count();
		arg.Set( tokenObj.Get( i - 1 ), tokenObj.GetLength( i - 1 ) );
		if ( (CUtils::Strcmp( "*", arg.GetData() ) == 0) || (CUtils::Strcmp( "%", arg.GetData() ) == 0) )
		{
			result = true;
		}
		else
		{
			result = false;
		}
	}

	return( result );

} // DoesThisMatch



//--------------------------------------------------------------------------------------------------
//	* GetArgToken
//	
//--------------------------------------------------------------------------------------------------

Boolean CMailboxes_10_1::GetArgToken ( char *inData, CString &inCmdArgs )
{
	Boolean		result	= false;
	char	   *p		= inData;

	inCmdArgs.Clear();

	while ( (*p != '%') && (*p != '*') && (*p != nil) )
	{
		inCmdArgs.Append( *p );
		result = true;
		p++;
	}

	return( result );

} // GetArgToken



//--------------------------------------------------------------------------------------------------
//	* ListRoot
//	
//--------------------------------------------------------------------------------------------------

void CMailboxes_10_1::ListRoot ( CString &outMbList )
{
	CString		root( 64 );

	// Untagged response
	root.Set( "* " );

	if ( fCommand != nil )
	{
		// Set the command name, LIST, LSUB or FIND
		root.Append( fCommand->GetData(), fCommand->GetLength() );
	}

	root.Append( "(\\Noselect) " );	// This is a non-selectable forlder
	root.Append( kQuotedDelimStr );	// hierarchy delimiter	- "/"
	root.Append( " " );				// space
	root.Append( kEmptyFieldStr );	// empty string			- ""
	root.Append( kEOL );			// end of line marker	- "\r\n"

	outMbList.Append( root.GetData() );

} // ListRoot



//--------------------------------------------------------------------------------------------------
//	* GetFullPath
//
//--------------------------------------------------------------------------------------------------

void CMailboxes_10_1::GetFullPath ( CString &inMailboxPath, CMailSpool_10_1 *inMailboxSpool )
{
	Boolean		root		= false;
	ObjID		parentID;
	CMailSpool_10_1 *mbSpool		= nil;

	try
	{
		inMailboxPath.Set( (char *)inMailboxSpool->GetMailSpoolName() );

		parentID = inMailboxSpool->GetParentID();

		while ( parentID != 0 )
		{
			mbSpool = CMailSpool_10_1::FindByID( parentID );
			if ( mbSpool != nil )
			{
				const char *mbName = mbSpool->GetMailSpoolName();
				if ( mbName[ 0 ] == '\0' )
				{
					mbSpool->SetMailSpoolName( "Empty_Mailbox" );
				}

				inMailboxPath.Prepend( kHierDelimStr );
				inMailboxPath.Prepend( (char *)mbSpool->GetMailSpoolName() );

				if ( mbSpool->GetParentID() == CMailSpool_10_1::kRootParent )
				{
					parentID = 0;
				}
				else
				{
					parentID = mbSpool->GetParentID();
				}

				mbSpool->Done( mbSpool );
			}
			else
			{
				parentID = 0;
			}
		}
	}

	catch ( ExceptionCode err )
	{
		mbSpool->Done( mbSpool );
	}

} // GetFullPath



//--------------------------------------------------------------------------------------------------
//	* IsInHierarchy
//
//--------------------------------------------------------------------------------------------------

Boolean CMailboxes_10_1::IsInHierarchy ( ObjID inTargetID, ObjID inParentID )
{
	Boolean			done	= false;
	Boolean			result	= false;
	ObjID			currID	= inParentID;
	CMailSpool_10_1	   *mbSpool	= nil;

	try
	{
		while ( !done )
		{
			if ( currID == inTargetID )
			{
				// This is what we are looking for
				result	= true;
				done	= true;
			}
			else
			{
				if ( currID == CMailSpool_10_1::kRootParent )
				{
					// We have reached the bottom of the list, time to bail
					done = true;
				}
				else
				{
					mbSpool = CMailSpool_10_1::FindByID( currID );
					if ( mbSpool != nil )
					{
						currID = mbSpool->GetParentID();
						mbSpool->Done( mbSpool );
					}
					else
					{
						done = true;
					}
				}
			}
		}
	}

	catch ( ExceptionCode err )
	{
		mbSpool->Done( mbSpool );
	}

	return( result );

} // IsInHierarchy



//--------------------------------------------------------------------------------------------------
//	* GetMailboxCount
//
//--------------------------------------------------------------------------------------------------

uInt32 CMailboxes_10_1::GetMailboxCount ( void )
{
	OSErr			result;
	uInt32			count	= 0;
	SDBIterator_10_1		iterator;

	result = gDB_10_1->CreateIterator( kMailSpoolSignature_10_1, &iterator, fAccountID );
	if ( result == kNoErr )
	{
		result = gDB_10_1->GetIteratorItemCnt( &iterator, count );
	}
	result = gDB_10_1->ReleaseIterator( &iterator );

	return( count );

} // GetMailboxCount

