 /*
	File:		CMailboxes.10.1.h

	Copyright:	 2003 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:
*/


#ifndef __CMailboxes_10_1_h__
#define __CMailboxes_10_1_h__

#include "CMailDatabase.10.1.h"
#include "CMailSpool.10.1.h"
#include "DatabaseTypes.h"
#include "CString.h"
#include "MailTypes.h"

// Mailbox class defines

#define		kNoFlags			"()"
#define		kQuotedDelimStr		"\"/\""
#define		kHierDelimStr		"/"
#define		kDoubleDelimStr		"//"
#define		kHierDelimChar		'/'
#define		kHierRootChar		'~'
#define		kHierRootStr		"~/"
#define		kEmptyFieldStr		"\"\""
#define		kEOL				"\r\n"
#define		kTerminator			'\0'
#define		kStarStr			"*"
#define		kPercentStr			"&"
#define		kDoubleStarStr		"**"
#define		kDoublePercentStr	"%%"
#define		kStarPercentStr		"*%"
#define		kPercentStarStr		"%*"

const	uInt16	kMailboxNameLen_10_1		= 128;
const	uInt16	kMaxMailboxDepth_10_1		= 32;
const	uInt32	kMaxMailboxCount_10_1		= 1000;

class CMailboxes_10_1
{
public:
	typedef enum
	{
		kMatchExact			= 0x0001,
		kMatchOnly			= 0x0002,
		kMatchAll			= 0x0004,
		kMatchBetween		= 0x0008,
		kHasPrefix			= 0x0100,
		kEndActions			= 0xFFFF
	} eActions;

	typedef enum
	{
		kListRootOnly		= 0x0001,
		kListOneMailbox		= 0x0002,
		kListAll			= 0x0010,
		kListSubOnly		= 0x0020,

		kEndFlags			= 0xFFFF
	} eFlags;

	typedef enum
	{
		kCmdFind			=  1,
		kCmdList			=  2,
		kCmdLsub			=  3,
		kCmdCreate			=  4,
		kCmdSelect			=  5,
		kCmdCopy			=  6,
		kCmdExamine			=  7,
		kCmdDelete			=  8,
		kCmdRename			=  9,
		kCmdStatus			= 10,
		kCmdSubUnsub		= 11,
		kCmd_X_List			= 12
	} eCommand;

					CMailboxes_10_1				( char *inSession, Boolean inIs8BitOn, ObjID inAcctID = 0 );
	virtual		   ~CMailboxes_10_1				( void );

	void			Initialize				( const char *arg1, const char *arg2, const char *inCommand, eCommand inCmdType );

	ObjID			GetCurrentMailboxID		( void );

	ObjID			GetMailbox1ObjID		( void );
	ObjID			GetMailbox2ObjID		( void );

	OSStatus		MailboxHasInferiors		( ObjID mailboxID );
	Boolean			CanDelete				( ObjID inMbID );

	ObjID			GetThisMailboxesID		( char *inMailbox, ObjID inParentID, Boolean &IsShared );
	void			GetFullPath				( CString &inMbPath, CMailSpool_10_1 *inMbSpool );
	uInt32			GetMailboxCount			( void );

	Boolean			IsInHierarchy			( ObjID inTargetID, ObjID inParentID );
	void			ListRoot				( CString &outMbList );

	ObjID			GetAccountID			( void );
	void			SetAccountID			( ObjID inAcctID );

	virtual	void	ListMailboxes			( CString &outMbList, Boolean inListPopInbox );
	virtual	ObjID	VerifyMailboxPath		( char *inMbPath );
	virtual sInt16	CreateMailbox			( Boolean inIsShared = false, ObjID inSharedSpoolID = 0, ObjID *outNewSpoolID = nil );
	virtual sInt16	RenameMailbox			( CMailSpool_10_1 *inMbSpool );
	virtual OSErr	DeleteMailbox			( void );

protected:
	Boolean			HasPrefix				( char *inData );
	char*			SetPrefix				( char *inData );
	void			SetPrefixString			( char inChar, uInt16 inWhere );
	void			StripPrefix				( char *inData );
	sInt16			SetupCommand			( eCommand inCmdType );

	void			MatchCase				( CString &inMbStr );
	void			WriteMailboxPath		( CString &inMbPath, CString &outMbList, uInt32 inMBFlags );

	Boolean			CheckListConditions		( CString &inMbPath, Boolean &outListDeleted );
	Boolean			DoesThisMatch			( CString &inCmdArgs, CString &inMbName );
	Boolean			GetArgToken				( char *inData, CString &inCmdArgs );

	void			CombineArgs				( void );
	sInt16			VerifyArgs				( void );
	Boolean			OkToList				( CMailSpool_10_1 *inSpool, Boolean inListPopInbox );

	void			SetMailbox1				( const char *inStr );
	void			SetMailbox2				( const char *inStr );

	char			fFldrPrefix[ 10 ];
	char		   *fSession;

	ObjID			fAccountID;

	CString		   *fArg1;
	CString		   *fArg2;
	CString		   *fCommand;
	uInt32			fCmdType;

	uInt16			fFlags;

	eActions	   *fActions;
	sInt16			fActionCnt;

private:
	Boolean			f8BitOn;

};

#endif // __CMailboxes_10_1_h__
