/*
	File:		CSmallMsgPart.10.1.h

	Contains:	C++ Class definition of a Blob-based message part

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CSmallMsgPart.10.1.h,v $
		Revision 1.1  2003/04/20 23:46:10  dasenbro
		Initial check-in.
		

	To Do:
*/


#ifndef __CSmallMessagePart_10_1_h___
#define __CSmallMessagePart_10_1_h___ 1

#include "CMailDatabase.10.1.h"
#include "CDBBaseObject.10.1.h"
#include "CDBMailBaseObject.10.1.h"
#include "DatabaseTypes.h"

// WARNING!!!! Many of the assumptions about the operation of the server (maximum number of connections,
// maximum write-behind cache depth, server performance, footprint, etc.) are set assuming that kMessagePartSize
// is near 8K.  If you change this value and don't understand the implications, you get what you deserve.
// If you make it bigger then the server will overestimate the "load" it can handle and most likely crash
// under stress/volume with out of memory problems....if you make it smaller the performance will tank
// upload/download, and the server will not fully utilize it's partition....don't screw with this value!!!

typedef struct
{	// NOTE: this structure should be kept in sync with the fields in the actual
	// CMessagePartData struct...
	StdDBObjHeader_10_1	fDBHeader;
	ObjID				fMessagePartID;
	ObjID				fEnvelopeID;

	OSType				fPartType;
	
	// Reserved
	uInt32				fReserved1;				// reserverd
	uInt32				fReserved2;				// reserverd

	Boolean				fLengthIsSet;
	Boolean				fDotStuffingRequired;
	uInt32				fDataLength;
	StdDBObjFooter_10_1	fDBFooter;
} SSmallMsgPartHeader4Calc_10_1;

const uInt32 kSmSlopSafety_10_1		= 12;
const uInt32 kSmallMsgPartSize_10_1	= ((kMaxIDTableSize_10_1 - kSmSlopSafety_10_1) / 3) - (sizeof(ObjID) + sizeof(SSmallMsgPartHeader4Calc_10_1));


typedef struct
{
	StdDBObjHeader_10_1	fDBHeader;
	ObjID			fMessagePartID;
	ObjID			fEnvelopeID;

	OSType			fPartType;
	
	// Reserved
	uInt32			fReserved1;				// reserverd
	uInt32			fReserved2;				// reserverd

	Boolean			fLengthIsSet;
	Boolean			fDotStuffingRequired;
	uInt32			fDataLength;
	char			fPartData[ kSmallMsgPartSize_10_1 ];
	StdDBObjFooter_10_1	fDBFooter;
} CSmallMsgPartData_10_1;

const uInt32 kSmallMsgPartFixedDataSize_10_1	= sizeof( CSmallMsgPartData_10_1 );						  
const uInt32 kSmallMsgPartVersion_10_1			= kDBCurrentVersion_10_1 + kSmallMsgPartFixedDataSize_10_1;


class CSmallMsgPart_10_1 : public CDBMailBaseObject_10_1
{
public:
	
	typedef	enum 
	{ 
		kUnknownPartType =	'--PT', 
		kHeaderPartType	 =	'hdPT',
		kDataPartType	 =	'daPT'
	} PartType;

	// Static Methods
	static CSmallMsgPart_10_1*	Create(OSType inPartType, ObjID inEnvelopeID);
	static Boolean			Delete(CSmallMsgPart_10_1* inMessagePart);
	static uInt32			Count (void);
	static Boolean			GetSetFields	( const eFieldDataRequest_10_1 inFieldRequest, const void *inObjDataPtr, void *outFieldData );
	virtual	ObjID			GetObjectID		( void );
	virtual	void			ChkCompilerStructAlignment		( void );
			void			Done			( CSmallMsgPart_10_1* &inPtr );

	static 	CSmallMsgPart_10_1*	FindByID			( const	ObjID	inObjectID );
	static	CDBBaseObject_10_1*	ObjectAllocNew		( void );

	static	OSType		GetObjTypeConstant	( void ) { return KSmallMsgPartSignature_10_1; }
	static	uInt32		GetObjVersConstant	( void ) { return kSmallMsgPartVersion_10_1; }
	static	uInt32		GetObjSizeConstant	( void ) { return kSmallMsgPartFixedDataSize_10_1; }

	// Constructor/Destructor/Initialization
				CSmallMsgPart_10_1();
	virtual		~CSmallMsgPart_10_1();
	
	// NeoAccess IDs
	ObjID		GetMessagePartID(void);

	ObjID		GetNextMessagePartID(void);
	void		SetNextMessagePartID(const ObjID inMessagePartID);
		
	ObjID		GetEnvelopeID (void);
	void		SetEnvelopeID (ObjID inEnvelopeID);
	
	OSType		GetPartType(void);
	void		SetPartType(OSType inPartType);
	
	uInt32		GetSequenceNumber (void);
	
	uInt32		GetDataLength(void);					// Actual length of data in fixed-sized part
	void		SetDataLength(uInt32 inDataLength);		// Actual length of data in fixed-sized part

	Boolean		GetDotStuffingRequired (void);
	void		SetDotStuffingRequired (const Boolean inDoDotStuffingFlag);
	
	char*		GetPartData(void);			// Start of part data
	
	virtual uInt32	GetObjectLength (void);

	CSmallMsgPartData_10_1*	GetWholeMessagePartData	( void );
	void				SetDirty (void);
	
	void				SetMsgHasBeenAttached	( const Boolean inSetFlag );
	Boolean				GetMsgHasBeenAttached	( void );
	
	Boolean				fMsgHasBeenAttached;
	CSmallMsgPartData_10_1	fMsgPartData;
};


#endif /* __CSmallMessagePart_10_1_h___ */

