/*
	File:		CTextObject.10.1.h

	Contains:	C++ class definitions for generic

	Copyright:	 2003 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CTextObject.10.1.h,v $
		Revision 1.1  2003/04/20 23:46:10  dasenbro
		Initial check-in.
		

	To Do:
*/

#ifndef __CTextObject_10_1_h__
#define __CTextObject_10_1_h__ 1

#include "CMailDatabase.10.1.h"
#include "CDBBaseObject.10.1.h"
#include "CDBMailBaseObject.10.1.h"
#include "DatabaseTypes.h"

// WARNING!!!! Many of the assumptions about the operation of the server (maximum number of connections,
// maximum write-behind cache depth, server performance, footprint, etc.) are set assuming that kMessagePartSize
// is near 8K.  If you change this value and don't understand the implications, you get what you deserve.
// If you make it bigger then the server will overestimate the "load" it can handle and most likely crash
// under stress/volume with out of memory problems....if you make it smaller the performance will tank
// upload/download, and the server will not fully utilize it's partition....don't screw with this value!!!

typedef struct
{	// NOTE: this structure should be kept in sync with the fields in the actual
	// CMessagePartData struct...
	StdDBObjHeader_10_1	fDBHeader;
	ObjID			fObjectID;
	ObjID			fNextObj;
	uInt32			fItemCount;
	uInt32			fOffset;

	// Reserved
	uInt32			fReserved1;				// reserverd
	uInt32			fReserved2;				// reserverd

	StdDBObjFooter_10_1	fDBFooter;
} STextObjectHdr4Calc_10_1;

const uInt32 kTextSlopSafety_10_1	= 12;
const uInt32 kTextObjSize_10_1		= ((kMaxIDTableSize_10_1 - kTextSlopSafety_10_1) / 2) - (sizeof( ObjID ) + sizeof( STextObjectHdr4Calc_10_1 ) );

typedef struct
{
	StdDBObjHeader_10_1	fDBHeader;
	ObjID			fObjectID;
	ObjID			fNextObj;
	uInt32			fItemCount;
	uInt32			fOffset;

	// Reserved
	uInt32			fReserved1;				// reserverd
	uInt32			fReserved2;				// reserverd

	char			fStringData[ kTextObjSize_10_1 ];

	StdDBObjFooter_10_1	fDBFooter;
} CTextObjectData_10_1;

const uInt32 kTextObjectDataSize_10_1	= sizeof( CTextObjectData_10_1 );						  
const uInt32 kTextObjectVersion_10_1	= kDBCurrentVersion_10_1 + kTextObjectDataSize_10_1;


#define		kStringMarker	"\0X"

class CTextObject_10_1 : public CDBMailBaseObject_10_1
{
public:
typedef enum {
	kNoError			= 0,
	kNullStirng			= -1076,
	kObjectFull			= -1077,
	kStringTooBig		= -1078,
	kOffsetTooBig		= -1079,
	kInvalidOffset		= -1080,
	kInvalidString		= -1081,
	kEmptyDestString	= -1082,
	kCorruptStrObj		= -1083
} eTextObjErrs;

	// Static Methods
	static CTextObject_10_1*		Create				( void );
	static Boolean 			Delete				( CTextObject_10_1 *inObjPtr );
	static uInt32			Count				( void );
	static void				VerifyAll			( void );
	static Boolean			GetSetFields		( const eFieldDataRequest_10_1 inFieldRequest, const void *inObjDataPtr,  void *outFieldData );
	static CTextObject_10_1*		FindByID			( const	ObjID inObjectID );
	static CDBBaseObject_10_1*	ObjectAllocNew		( void );

	static	OSType		GetObjTypeConstant	( void ) { return kTextObjectSignature_10_1; }
	static	uInt32		GetObjVersConstant	( void ) { return kTextObjectVersion_10_1; }
	static	uInt32		GetObjSizeConstant	( void ) { return kTextObjectDataSize_10_1; }

	virtual	ObjID		GetObjectID					( void );
	virtual	void		ChkCompilerStructAlignment	( void );
			void		Done						( CTextObject_10_1* &inPtr );

	// Construction/Destruction
						CTextObject_10_1			( void );
	virtual		 	   ~CTextObject_10_1			( void );

		ObjID			GetMyObjectID		( void );
		void			SetMyObjectID		( ObjID inObjID );

		ObjID			GetNextObjectID		( void );
		void			SetNextObjectID		( ObjID inObjID );

		uInt32			GetOffset			( void );
		void			SetOffset			( uInt32 inOffset );

		sInt32			GetItemCount		( void );
		void			SetItemCount		( sInt32 inCount );

		void			IncrementItemCount	( void );
		void			DecrementItemCount	( void );

		char*			GetDataBlock		( void );
		void			SetDataBlock		( char *inData );

		sInt32			AddString			( const char *inString, uInt16 *outOffset );
		sInt32			RemoveString		( uInt16 inOffset );
		sInt32			GetString			( uInt16 inOffset, char **outStr );

	CTextObjectData_10_1*	GetMyObjectData		( void );
	void				SetDirty			( void );

protected:

private:
	CTextObjectData_10_1		fObjectData;

};	// CTextObject_10_1

#endif // __CTextObject_10_1_h__

