/*
	File:		HostPrefs.10.1.h

	Copyright:	 200 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:
*/

#ifndef __HostPrefs_10_1_h__
#define __HostPrefs_10_1_h__	1

typedef enum
{
	kSunday		= 0,
	kMonday		= 1,
	kTuesday	= 2,
	kWednesday	= 3,
	kThursday	= 4,
	kFriday		= 5,
	kSaturday	= 6,
	kDayCount	= 7
} EDays;

typedef struct
{
	uInt32	fDayHours[ kDayCount ];
} SAllowConnectionTimes;

typedef struct HostPrefs
{
	// Incoming Mail
	bool			fDeliverToLocalOnlyFlag;	// Deliver mail to local addresses only (no SMTP relay)
	bool			fLogRejectionsFlag;			// Log recipient rejections to error log
	bool			fSendBCCofAllToUserFlag;	// Send BCC copies ov all messages to:
	UserStruct		fSendBCCofAllToUserInfo;	// BCC user data

	// Outgoing Mail
	uInt32			fOutMailPopupFlags;			// Outgoing mail pop-up
	bool			fNotifySenderOfNDRFlag;		// Notify Sender of non-deliver flag
	bool			fNotifyPostmasterOfNDR;		// Notify Postmaster of non-delivery flag
	bool			fRelaySMTPFlag;				// Relay all SMTP mail via flag
	uInt32			fExpireMsgAfterHours;		// Messages expire after ??? hours
	uInt32			fRetryFailedMinutes;		// Retry failed connections every ??? minutes
	uInt32			fNotifySenderOfNDRHours;	// Notify Sender of non-deliver after ??? hours
	char			fSMTPRelayServerName[ 128 ];// - MED - chage to string object

	// Network Settings
	uInt32			fDNS_RequestButtonFlag;		// DNS Request button settings (1,2,3...)
	uInt32			fCacheSettingsButtonFlag;	// Cache Settings button flag
	uInt32			fCacheDNSMinutes;			// Cache DNS info for ??? minutes
	uInt32			fOpenConnTimeoutSeconds;	// Open connection timeout in ??? seconds
	uInt32			fReadWriteTimeoutSeconds;	// Read/Write timeout in ??? seconds
	uInt32			fOutSMTPPortNumber;			// Default SMTP port number


// Edit Host - 'Mail In' panel
	bool					fMHPMailInAllowMailFromUserAtBtn;							// 101
	bool					fMHPMailInDeliverMailFromUserAtBtn;							// 102
	bool					fMHPMailInRejectAllMailFromUsersAtBtn;						// 103
	bool					fMHPMailInLogMsgRejectToErrorLogChk;						// 104
	bool					fMHPMailInLogRecipRejectToErrorLogChk1;						// 106
	bool					fMHPMailInSendBlindCarbonCopiesChk;							// 108

	uInt32					fMHPMailInSendBlindCarbonCopiesToUandGID;					// 109 is text. Data is uInt32.
//	sFingerPrint			fMHPMailInSendBCCFingerPrint;								// Finger print for Any User

// Edit Host - 'Mail Out' panel
	bool					fMHPMailOutAllowMailToHostBtn;								// 201
	bool					fMHPMailOutHoldMailToHostBtn;								// 202
	bool					fMHPMailOutDeleteMailToHostBtn;								// 203
	uInt32					fMHPMailOutMessageExpiresAfterEdit;							// 204
	bool					fMHPMailOutWarnSenderOfNonDeliveryChk;						// 205
	uInt32					fMHPMailOutWarnSenderOfNonDeliveryAfterEdit;				// 206
	bool					fMHPMailOutWarnPostmasterOfNonDeliveryChk;					// 207
	bool					fMHPMailOutForwardAllRemoteMailToChk;						// 208
	bool					fMHPMailOutNotifySenderThatMailToWasRejectedChk;			// 209
	bool					fMHPMailOutNotifyPostmasterThatMailToWasRejectedChk;		// 210
	Str255					fMHPMailOutForwardAllRemoteMailToEdit;						// 211
	bool					fMHPMailOutMessageExpiresAfterChk;							// 212

// Edit Host - 'Schedule' panel
	uInt32					fMHPScheduleConnectionPopup;								// 3
																						// kEditHostScheduleConnectionPopupConnectAsNeeded	= 1;
																						// kEditHostScheduleConnectionPopupUseCustome		= 2;

	SAllowConnectionTimes	fAllowConnectionTimes;

	bool					fMHPScheduleUseServersDefaultFrequencyBtn;					// 301
	bool					fMHPRemoteMailPollUseServerSchedule;						// To be done. Shadow 301 for now.
	bool					fMHPScheduleConnectEveryBtn;								// 302
	bool					fMHPRemoteMailPollRepeating;								// To be done. Shadow 302 for now.
	uInt32					fMHPScheduleConnectEveryEdit;								// 303
	uInt32					fMHPRemoteMailETRNScheduleFreq;								// To be done. Shadow 303 for now.
	bool					fMHPScheduleETRNAsNeededChk;								// 304. kEditHostScheduleConnectionPopupConnectAsNeeded.
	bool					fMHPScheduleETRNDuringScheduleChk;							//      kEditHostScheduleConnectionPopupUseCustome

// Edit Host - 'Network' panel
	uInt32					fMHPNetworkDNSPopup;										// 4
							// kEditHostNetworkDNSPopupCacheDNS					= 1;
							// kEditHostNetworkDNSPopupAlwaysCheckDNS			= 2;
							// kEditHostNetworkDNSPopupUseServerGeneral			= 3;

	bool					fMHPNetworkRespectTimeToLiveBtn;							// 401
	bool					fMHPNetworkCacheDNSBtn;										// 402
	uInt32					fMHPNetworkCacheDNSForEdit;									// 403
	bool					fMHPNetworkResolveMXListChk;								// 404
	bool					fMHPNetworkResolveDNSARecordChk;							// 405
	uInt32					fMHPNetworkOpenConnectionTimeoutEdit;						// 406
	uInt32					fMHPNetworkRNTimeoutEdit;									// 407
	bool					fMHPNetworkUseSMTPPortChk;									// 408
	uInt16					fMHPNetworkUseSMTPPortEdit;									// 409
	bool					fMHPNetworkNetworkTimeoutChk;								// 411

} HostPrefs;

#endif // __HostPrefs_h__

