 /*
	$Id: IMAPErrors.h,v 1.1 2003/04/20 23:30:51 dasenbro Exp $

	File:		IMAPErrors.h

	Contains:	

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: IMAPErrors.h,v $
		Revision 1.1  2003/04/20 23:30:51  dasenbro
		Initial check-in.
		
		Revision 1.13  2002/06/10 22:42:29  dasenbro
		Added strings and consts for required auth methods Kerberos and CRAM-MD5.
		
		Revision 1.12  2002/05/30 17:06:31  dasenbro
		Added login disabled const.
		
		Revision 1.11  2002/05/20 21:24:55  dasenbro
		Added "Not Admin" response.
		
		Revision 1.10  2002/03/25 22:54:49  dasenbro
		Added SSL response codes, strings and consts.
		
		Revision 1.9  2002/03/21 16:41:33  dasenbro
		Updated file version information.
		
		Revision 1.8  2002/03/05 19:47:11  dasenbro
		Added new error consts for IMAP user accounts.
		
		Revision 1.7  2001/06/21 20:51:04  dasenbro
		Updated file header info.
		
		Revision 1.6  2001/06/21 19:38:01  dasenbro
		Added Change History.
		

	Projector History:

	 <ASM28>	 3/15/99	MED		New error consts.
	 <ASM27>	  2/8/99	MED		Added user remote/local error constants.
		<26>	11/20/98	MED		Added kErrBadTermSequence.
		<25>	 9/21/98	MED		Added kErrBogusDateString const.
		<24>	 9/17/98	MED		Added kErrCantModifyOwnersRights const.
		<23>	 9/14/98	MED		Added more imap errors.
		<22>	  9/8/98	MED		Added misc alerts and invalid rights error string.
		<21>	 8/31/98	MED		Added database full error const.
		<20>	 8/24/98	MED		Added a "Disk Full" const.
		<19>	 8/10/98	MED		Added another ACL error const.
		<18>	  8/3/98	MED		6.1 - Added ACL error codes.
		<17>	 5/20/98	MED		Added Unexpected extra arguments error const.
		<16>	  5/6/98	MED		Added a max messages per mailbox error const.
		<15>	 4/28/98	MED		Yes, another error const was added.
		<14>	 4/25/98	MED		Added some error constants.
		<13>	 4/22/98	MED		Added an error const for Invalid body section.
		<12>	 3/28/98	MED		Added a pop locked mailbox error const.
		<11>	 3/17/98	MED		Did some re-org on the error codes, film at 11:00.
		<10>	 3/10/98	MED		Like, I added some new error constants.
		 <9>	 2/23/98	MED		Yes, I did add some more constants.
		 <8>	  2/9/98	MED		You guessed it, added more error constants.
		 <7>	  2/9/98	MED		Added Admin mode copy error constant.
		 <6>	  2/9/98	MED		Removed some unneeded admin port errors.
		 <5>	  2/7/98	MED		Added some Admin port only errors.
		 <4>	  2/4/98	MED		Added some more error constants.
		 <3>	 1/27/98	MED		Added error constants for POP maibox handling.
		 <2>	 11/5/97	MED		Added error const for Unsubscribe Inbox.

	To Do:
*/


#ifndef __IMAPErrors_h__
#define __IMAPErrors_h__

#include "MailTypes.h"

// IMAP "NO" Errors
enum {
	kErrInvalidTag					= -301,
	kErrBadLogin					= -302,
	kErrMboxIsReadOnly				= -303,
	kErrNoMboxFound					= -304,
	kErrMboxIsNoSelect				= -305,
	kErrMBoxPathHasEmptyName		= -306,
	kErrMBoxNameHasSpecial			= -307,
	kErrInvalidAttribute			= -308,
	kErrCantCreateMbox				= -309,
	kErrCantRenameMbox				= -310,
	kErrCantDeleteInbox				= -311,
	kErrDeleteHasInferiors			= -312,
	kErrCantUnsubInbox				= -313,
	kErrUnreconizedCharSet			= -314,
	kErrMBoxChangedSize				= -315,
	kErrMboxLockedByPop				= -316,
	kErrMessageMayNotExist			= -317,
	kErrMboxNameTooLong				= -318,
	kErrMaxNumberMboxExceeded		= -319,
	kErrMboxDepthTooDeep			= -320,
	kErrMboxAccessDenied			= -321,
	kErrMaxMsgsPerMailbox			= -322,
	kErrInvalidRights				= -323,
	kErrCantCreateSharedMbox		= -324,
	kErrMailNotEnabledForUser		= -325,
	kErrUserHasAutoForwardOn		= -326,
	kErrCantModifyOwnersRights		= -327,
	kErrUnsupportedCommand			= -328,
	kErrRootLoginErr				= -329,
	kErrCannotExpungErr				= -330,
	kErrUnknownMailUser				= -331,
	kErrDuplicateUser				= -332,
	kErrUnknownDSError				= -333,
	kErrTLSAlreadyStarted			= -334,
	kErrSSLSessionRequired			= -335,
	kErrUserIsNotAdminUser			= -336,
	kErrLoginDisabled				= -337,
	kErrCRAM_MD5Required			= -338,
	kErrKerberosRequired			= -339,
	kIMAPNoErrEnd					= -399
};

// IMAP "BAD" Errors
enum {
	kErrMissingArg					= -201,
	kErrInvalidArgument				= -202,
	kErrBogusSequence				= -203,
	kErrUnexpectedCommand			= -204,
	kErrBadSearchCriteria			= -205,
	kErrNoMboxSelected				= -206,
	kErrInvalidBodyPartial			= -207,
	kErrInvalidBodySection			= -208,
	kErrUnexpectedArguments			= -209,
	kErrBogusDateString				= -210,
	kErrBadTermSequence				= -211,
	kIMAPBadErrEnd					= -299
};

// Apple Mail IMAP Specific errors
enum {
	kErrCantCreatePOPInbox			= -401,
	kErrPOPInboxCantHaveSub			= -402,
	kErrCantDeletePOPInbox			= -403,
	kErrCantRenamePOPInbox			= -404,
	kErrCantRenameUsersInbox		= -405,
	kErrNoIMAPSession				= -406,
	kErrNoEndpoint					= -407,
	kErrMaxConnections				= -408,
	kErrNotNumberString				= -409,
	kErrUserAcctNotOnThisSrvr		= -410,
	kErrUserHasAcctOnAnotherSrvr	= -411,
	kErrUserDoesNotExist			= -412,
	kErrDirectoryError				= -413,
	kErrDiskIsFull					= -490,
	kErrDatabaseIsFull				= -481,
	kErrUnknownServerError			= -492,
	kIMAPAppleMailErrEnd			= -499
};

// Admin Errors
enum {
	kErrNotAllowedInAdminMode		= -500,
	kErrCantCreateSubsHere			= -501,
	kErrCantCopyHere				= -502,
	kErrCantCreateMboxHere			= -503,
	kErrCantDeleteMboxHere			= -504,
	kErrCantAppendToMbox			= -505,
	kIMAPAdminErrEnd				= -599
};

// ACL Errors
enum {
	kErrACLNotAdmin					= -601,
	kErrNoSuchUserOrGroup			= -602,
	kErrUserDoesntHaveRights		= -603,
	kIMAPACLErrEnd					= -699
};

// Completion codes
enum {
	kRespCommandCompleted			= 301,
	kRespCompletedReadOnly			= 302,
	kRespCompletedReadWrite			= 303,
	kRespUIDFetchCompleted			= 304,
	kRespUIDCopyCompleted			= 305,
	kRespUIDStoreCompleted			= 306,
	kRespUIDSearchCompleted			= 307,
	kRespCompletionCodeEnd			= 399
};

// Alert codes
enum {
	kAlertMaxMessages				= 401,
	kAlerServerShutDown				= 402,
	kAlerIdleLogOff					= 403,
	kAlerAdminLogOff				= 404,
	kAlertConnTerminated			= 405,
	kAlertCodesEnd					= 499
};

#endif
