/*
	$Id: CTextObjMgr.h,v 1.1 2003/04/20 23:31:08 dasenbro Exp $

	File:		CTextObjMgr.h

	Contains:	C++ class definitions for generic

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CTextObjMgr.h,v $
		Revision 1.1  2003/04/20 23:31:08  dasenbro
		Initial check-in.
		
		Revision 1.7  2002/07/17 01:38:31  dasenbro
		Removed a text object leak.
		
		Revision 1.6  2002/03/21 16:41:42  dasenbro
		Updated file version information.
		
		Revision 1.5  2001/06/21 19:55:00  dasenbro
		Added Change History.
		

	Projector History:


	To Do:
*/


#ifndef __CTextObjMgr_h__
#define __CTextObjMgr_h__ 1

#include "CTextObject.h"
#include "CDBMailBaseObject.h"
#include "CMailDatabase.h"

typedef struct {
	ObjID		fObID;
	uInt16		fOffset;
	uInt16		reserved;
} TextStrObj;

class CTextObjMgr
{
public:
	// Static Methods
	static sInt32			AddString			( const char *inString, TextStrObj *inStrObj );
	static sInt32 			RemoveString		( TextStrObj *inStrObj );
	static sInt32 			GetString			( TextStrObj *inStrObj, char **outStr );
	static void 			DeInitialize		( void );

	static CTextObjMgr*		sTextObjMgr;

	// Construction/Destruction
						CTextObjMgr			( void );
	virtual		 	   ~CTextObjMgr			( void );

protected:
	sInt32				Initialize			( void );
	bool				AddToFreeList		( CTextObject *inTextObj );
	void				DoCleanUp			( void );
	sInt32				SetNewCurrObj		( void );

	sInt32				AddThisString		( const char *inString, TextStrObj *outStrObj );
	sInt32				RemoveThisString	( TextStrObj *inStrObj );
	sInt32 				GetThisString		( TextStrObj *inStrObj, char **outStr );

private:
	CTextObject			*fTextObj;
};

#endif // __CTextObjMgr_h__

