/*
	$Id: CRootObject.h,v 1.1 2003/04/20 23:29:40 dasenbro Exp $

	File:		CRootObject.h

	Contains:	xxx put contents here xxx

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CRootObject.h,v $
		Revision 1.1  2003/04/20 23:29:40  dasenbro
		Initial check-in.
		
		Revision 1.12  2002/06/04 17:34:09  dasenbro
		Syntax changes.
		
		Revision 1.11  2002/05/20 21:41:41  dasenbro
		Added reset TOC calls.
		
		Revision 1.10  2002/05/09 16:59:04  dasenbro
		Changed all str... calls to CUtils::Str... to be NULL safe.
		
		Revision 1.9  2002/03/21 16:41:47  dasenbro
		Updated file version information.
		
		Revision 1.8  2001/06/21 20:44:31  dasenbro
		Added Change History.
		

	Projector History:

	 <ASM13>	  2/4/99	MED		Added getter/setter for version info.
		<12>	10/30/98	DOR		Added support for 2nd ID's to host entries.  We now move host's
									onto and off of a 2nd ID list based on their "nextAttemptTime"
									value.  The outgoing threads will only visit hosts on the
									"active" host list, therefore limiting the number of hosts that
									must be visited to process outgoing mail.
		<11>	 9/14/98	MED		Added comment for unused field.
		<10>	  9/8/98	MED		Added getters/setters for the unused data members.
		 <9>	  6/1/98	DOR		Remove the "kAdd" argument from Create since we no longer use
									it.
		 <8>	 5/19/98	MED		Added future expansion data members.
		 <7>	  4/2/98	DOR		Add an object ID to save dead envelopes.
		 <5>	 3/10/98	DOR		Remove outgoing & IMAP spool.
		 <4>	 2/23/98	MED		Added an IndexRefNum to stamp the V-Twin index file now that we
									have indexing on demand.
		 <3>	12/15/97	DOR		Update the object version to "include" the size of the
									dataportion of the object, and add an assert to "FindByID" that
									checks the version of the object.
		 <2>	 12/3/97	MED		Added a HostEntry default prefs ID field and the related Getter
									and Setter.

	To Do:
*/


#ifndef __CROOTOBJECT_H__
#define __CROOTOBJECT_H__ 1

#include "CMailDatabase.h"
#include "CDBMailBaseObject.h"

const uInt32	kCurrentRootVer	= 0x10020100;	// 10.2.1

typedef struct
{
	uInt32		fVersionInfoID;
} SVersionInfo;


typedef struct
{
	StdDBObjHeader	fDBHeader;

	ObjID			fRootObjID;				// 
	ObjID			fInSpoolID;				// Incoming spool ID
	ObjID			fEnvDieSpoolID;			// 
	ObjID 			fStatMgrID;				// 
	uInt32 			fTocResetValue;			// 
	uInt32 			fMessageTag;			// 
	ObjID			fAnyoneACLObjID;		// Holds a list of shared folders to group or anyone
	ObjID			fActiveHost2ndID;		// Holds the ObjID of the Active Host 2nd ID list..
	ObjID  			fTextObjectID;			// Holds the ID for the current text object
	uInt32			fIndexRefNum;			// 
	SVersionInfo	fVerInfo;				// 

	// Reserved
	uInt32			fReserved1;				// reserverd
	uInt32			fReserved2;				// reserverd

	StdDBObjFooter	fDBFooter;

} CRootObjectData;

const uInt32 kCRootObjectDataSize	= ( sizeof( CRootObjectData ) );
const uInt32 kCRootObjectVersion	= kDBCurrentVersion + kCRootObjectDataSize;

class CRootObject : public CDBMailBaseObject
{
public:
			CRootObject							( void );
		   ~CRootObject							( void );

	static	CRootObject*	Find				( void );
	static	CRootObject*	Create				( void );
	static  Boolean			Delete				( CRootObject *inRootObj );
	static	Boolean			GetSetFields		( const eFieldDataRequest inFieldRequest, const void *inObjDataPtr, void *outFieldData );

	static 	CRootObject*	FindByID			( const	ObjID	inObjectID );
	static	CDBBaseObject*	ObjectAllocNew		( void );

	static	OSType		GetObjTypeConstant		( void ) { return kMailRootSignature; }
	static	uInt32		GetObjVersConstant		( void ) { return kCRootObjectVersion; }
	static	uInt32		GetObjSizeConstant		( void ) { return kCRootObjectDataSize; }

	virtual	ObjID		GetObjectID					( void );
	virtual	void		ChkCompilerStructAlignment	( void );
		void			Done						( CRootObject* &inPtr );

	CRootObjectData*	GetRootObjectData		( void );
		void			SetDirty				( void );

		ObjID			GetRootObjID			( void );
		void			SetObjectID				( ObjID inObjID );

		ObjID			GetSysSpoolID			( const OSType inSpoolType );
		void			SetSysSpoolID			( const OSType inSpoolType, ObjID inSysSpoolID );

		ObjID			GetStatMgrID			( void );
		void			SetStatMgrID			( ObjID inStatMgrID );

		SVersionInfo*	GetVerInfoID			( void );
		void			SetVerInfoID			( SVersionInfo *inVerInfoStruct );

		ObjID			GetEnvelopeDieSpoolID	( void );
		void			SetEnvelopeDieSpoolID	( const ObjID inDieSpoolID );

		ObjID			GetAnyoneObjID			( void );
		void			SetAnyoneObjID			( ObjID inValue );

		uInt32			GetIndexRefNum			( void );
		void			SetIndexRefNum			( uInt32 inRefNum );

		uInt32			GetVersionInfo			( void );
		void			SetVersionInfo			( uInt32 inVersInfo );

		uInt32			GetActiveHost2ndID		( const Boolean inCreateFlag );
		void			SetActiveHost2ndID		( const ObjID inActiveHost2ndID );

		ObjID			GetMessageTag			( void );
		void			SetMessageTag			( const ObjID inHostID );

		ObjID			GetTOCResetValue		( void );
		void			SetTOCResetValue		( const uInt32 inValue );
		
		ObjID			GetCurrTextObjID		( void );
		void			SetCurrTextObjID		( ObjID inTextObjID );

private:

	CRootObjectData		fRootObjectData;
};

extern CRootObject *gRootObj;

#endif

