/*
	$Id: CStatStr.cpp,v 1.1 2003/04/20 23:29:40 dasenbro Exp $

	File:		CStatStr.cpp

	Contains:

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1999-2001 by Apple Computer, Inc., all rights reserved.

	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	File Ownership:
		DRI:				David M. O'Rourke
		Other Contact:		Michael Dasenbrock
		Technology:			NetInfo Plus

	Change History:

		$Log: CStatStr.cpp,v $
		Revision 1.1  2003/04/20 23:29:40  dasenbro
		Initial check-in.
		
		Revision 1.6  2002/03/21 16:41:47  dasenbro
		Updated file version information.
		
		Revision 1.5  2002/02/20 20:24:18  dasenbro
		Added user disk quota string tables.
		
		Revision 1.4  2001/06/21 20:10:47  dasenbro
		Added Change History.
		

	Projector History:


	To Do:
*/

#include <string.h>

#include "CStatStr.h"
#include "AppResources.h"
#include "AppResourcesStrings.h"
#include "IMAPStringsTable.h"
#include "IMAPStrings.h"


// ---------------------------------------------------------------------------
//	* GetStringFromList ()
//
// ---------------------------------------------------------------------------

const char* CStatStr::GetStringFromList ( const uInt32 inListID, const sInt32 inIndex )
{
	static const char	*_sNoMatch	= "<STRING NOT FOUND>";
				 char	*pStr		= (char *)_sNoMatch;

	if ( inIndex > 0 )
	{
		switch ( inListID )
		{
			case kAppInfoListID:			// 1500
				if ( (inIndex - 1) < (sInt32)(sizeof( sAppInfoStrList ) / sizeof( char * )) )
				{
					pStr = (char *)sAppInfoStrList[ inIndex - 1 ];
				}
				break;

			case kImapNoErrStrResID:		// 3001
				if ( (inIndex - 1) < (sInt32)(sizeof( sIMAPNoErrStrings ) / sizeof( char * )) )
				{
					pStr = (char *)sIMAPNoErrStrings[ inIndex - 1 ];
				}
				break;

			case kImapBadErrStrResID:		// 3002
				if ( (inIndex - 1) < (sInt32)(sizeof( sIMAPBadErrStrings ) / sizeof( char * )) )
				{
					pStr = (char *)sIMAPBadErrStrings[ inIndex - 1 ];
				}
				break;

			case kImapASIPErrStrResID:		// 3003
				if ( (inIndex - 1) < (sInt32)(sizeof( sIMAPASIPErrStrings ) / sizeof( char * )) )
				{
					pStr = (char *)sIMAPASIPErrStrings[ inIndex - 1 ];
				}
				break;

			case kImapAdminErrStrResID:		// 3004
				if ( (inIndex - 1) < (sInt32)(sizeof( sIMAPAdminErrStrings ) / sizeof( char * )) )
				{
					pStr = (char *)sIMAPAdminErrStrings[ inIndex - 1 ];
				}
				break;

			case kImapCompleteStrResID:		// 3005
				if ( (inIndex - 1) < (sInt32)(sizeof( sIMAPCompleteStrings ) / sizeof( char * )) )
				{
					pStr = (char *)sIMAPCompleteStrings[ inIndex - 1 ];
				}
				break;

			case kImapAlertStrResID:		// 3006
				if ( (inIndex - 1) < (sInt32)(sizeof( sIMAPAlertStrings ) / sizeof( char * )) )
				{
					pStr = (char *)sIMAPAlertStrings[ inIndex - 1 ];
				}
				break;

			case kACLErrStrResID:			// 3007
				if ( (inIndex - 1) < (sInt32)(sizeof( sACLErrStrings ) / sizeof( char * )) )
				{
					pStr = (char *)sACLErrStrings[ inIndex - 1 ];
				}
				break;

			default:
				break;
		}
	}

	return( pStr );

} // GetXndString
