/*
	$Id: CUtils.h,v 1.1 2003/04/20 23:29:40 dasenbro Exp $

	File:	CUtils.h

	Contains: Various OS Utilities

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by: Michael Dasenbrock

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CUtils.h,v $
		Revision 1.1  2003/04/20 23:29:40  dasenbro
		Initial check-in.
		
		Revision 1.11  2002/05/30 16:53:41  dasenbro
		Added CalcCRC() prototype.
		
		Revision 1.10  2002/05/09 16:59:05  dasenbro
		Changed all str... calls to CUtils::Str... to be NULL safe.
		
		Revision 1.9  2002/03/21 16:41:47  dasenbro
		Updated file version information.
		
		Revision 1.8  2002/01/14 17:05:05  dasenbro
		Initial S4 updates.
		
		Revision 1.7  2001/06/21 20:45:21  dasenbro
		Added Change History.
		

	Projector History:

		 <7>	 9/28/98	MED		Added MemiStr() to do searches in blocks of memory.
		 <6>	 9/21/98	MED		Added TimeFromInetTime().
		 <5>	 9/14/98	MED		Added StripQuotes().
		 <4>	  4/8/98	DOR		Add implementation of strncpy.
		 <3>	 3/24/98	MED		Added AppendNumToString to append a number to the end of a
									string.
		 <2>	03/17/98	DOR		Add utility functions to format a string for printing elasped
									times.
		 <1>	  2/3/98	MED		first checked in

	To Do:
 */


#ifndef __CUtils_h__
#define __CUtils_h__ 1

#include "CString.h"
#include "MailTypes.h"

class CUtils
{
public:
	static	char*	InetTime			( Boolean inTwoDigitYear = false );
	static	void	TimeFromInetTime	( char *inDateString, uInt32 *outTime );

	static	int		Strlen				( const char *inStr );
	static	char*	Strcpy				( char *inDestStr, const char *inSrcStr );
	static  void	Strncpy				( char *inDestStr, const char *inSrcStr, const uInt32 inMaxLength );

	static	char*	Strstr				( const char *inStr1, const char *inStr2 );
	static	char*	Stristr				( const char *inString, const char *inSubstr );
	static	char*	MemiStr				( const char* inBuff, const char* inSubStr, uInt32 inBuffLen );

	static	int		Strcmp				( const char *inStr1, const char *inStr2 );
	static	int		Stricmp				( const char *inStr1, const char *inStr2 );
	static	int		Strincmp			( const char *inStr1, const char *inStr2, size_t inLen );

	static	void	AppendNumToString	( CString &inString, uInt32 inNum );
	static	void	StripQuotes			( CString &inString );
	static	void	ProcessString		( CString &inString, uInt32 &outCharactersScanned );

	static	void	FormatDayHourMinSec	( const uInt32 inSeconds, CString	&theOutputString );
	static	void	FormatHourMinSec	( const uInt32 inSeconds, CString	&theOutputString );
	static	void	FormatMinSec		( const uInt32 inSeconds, CString	&theOutputString );
	static	void	FormatElapsedTimeFromSecs	( const uInt32 inSeconds, CString	&theOutputString );

	static	sInt32	EncodeBase64		( CString &inString, CString &outString );
	static	sInt32	DecodeBase64		( CString &inString, CString &outString );

	static	uInt32	CalcCRC				( const char *inStr );

	static char		fTimeBuf[ 34 ];
};

#endif
