/*
 * Copyright (c) 2004 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_LICENSE_HEADER_END@
 */

/*
 * od.h -- Open Directory authentication routines
 */


#ifndef __OD_H__
#define __OD_H__	1

#include "aod.h"
#include "prot.h"

#define	MAX_USER_NAME_SIZE		256
#define	MAX_USER_BUF_SIZE		512
#define	MAX_CHAL_BUF_SIZE		2048
#define	MAX_IO_BUF_SIZE			21848

#define	ODA_NO_ERROR			0
#define	ODA_AUTH_FAILED			-2000
#define	ODA_AUTH_CANCEL			-2001
#define	ODA_PROTOCOL_ERROR		-2002


typedef enum
{
	kSGSSSuccess		= 0,
	kSGSSBufferSizeErr	= -70001,
	kSGSSImportNameErr	= -70002,
	kSGSSAquireCredErr	= -70003,
	kSGSSInquireCredErr	= -70004,
	kSGSSAuthFailed		= -70005,
	kGSSErrUnknownType	= -70010,
	kUnknownErr			= -70010
} eGSSError;

int od_do_clear_text_auth	( const char *inUserID, const char *inPasswd );
int od_do_auth				( const char *inMethod, const char *inDigest, const char *inCont,
							  const char *inProtocol, struct protstream *inStreamIn,
							  struct protstream *inStreamOut, char **inOutCannonUser );

int odgetuseropts( const char *inUserID, struct od_user_opts *inOutOpts );

#endif /* __OD_H__ */