/*
	$Id: CExpansion.h,v 1.1 2003/04/20 23:33:11 dasenbro Exp $

	File:		CExpansion.h

	Contains:	C++ class definitions for generic

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CExpansion.h,v $
		Revision 1.1  2003/04/20 23:33:11  dasenbro
		Initial check-in.
		
		Revision 1.8  2002/06/04 21:04:40  dasenbro
		Fixed a typo in kExpansionVersion const.
		
		Revision 1.7  2002/03/21 16:24:19  dasenbro
		Updated version information.
		
		Revision 1.6  2001/06/21 20:50:50  dasenbro
		Updated file header info.
		
		Revision 1.5  2001/06/21 16:31:06  dasenbro
		Added Change History.
		

	Projector History:


	To Do:
*/


#ifndef __CExpansion_h__
#define __CExpansion_h__ 1

#include "CDBMailBaseObject.h"
#include "CMailDatabase.h"

class CString;

const	sInt16		kMaxDataBlockSize	= 128;

typedef struct
{
	StdDBObjHeader	fDBHeader;
	ObjID			fObjectID;				// this is us (denormalized)
	ObjID			fOwnerID;				// who ownes us

	ObjID			fPrevObjectID;			// Link to previous object
	ObjID			fNextObjectID;			// Link to next object

	sInt16			fItemCount;
	sInt16			fItemSize;

	// Reserved
	uInt32			fReserved1;				// reserverd
	uInt32			fReserved2;				// reserverd

	char			fDataBlock[ kMaxDataBlockSize ];
	StdDBObjFooter	fDBFooter;
} CExpandData;

// CDBMailBaseObject Constants
const uInt32 kExpansionDataSize	= sizeof( CExpandData );
const uInt32 kExpansionVersion	= kDBCurrentVersion + kExpansionDataSize;

class CExpansion : public CDBMailBaseObject
{
public:
	// Static Methods
	static CExpansion*		Create				( ObjID inOwner, uInt32 inItemSize );
	static Boolean 			Delete				( CExpansion *inObjPtr );
	static uInt32			Count				( void );
	static void				VerifyAll			( void );
	static Boolean			GetSetFields		( const eFieldDataRequest inFieldRequest, const void *inObjDataPtr,  void *outFieldData );
	static CExpansion*		FindByID			( const	ObjID inObjectID );
	static CDBBaseObject*	ObjectAllocNew		( void );

	static	OSType		GetObjTypeConstant	( void ) { return kExpansionSignature; }
	static	uInt32		GetObjVersConstant	( void ) { return kExpansionVersion; }
	static	uInt32		GetObjSizeConstant	( void ) { return kExpansionDataSize; }

	virtual	ObjID		GetObjectID			( void );
	virtual	void		ChkCompilerStructAlignment			( void );
		void			Done				( CExpansion* &inPtr );

	// Construction/Destruction
						CExpansion			( void );
	virtual		 	   ~CExpansion			( void );

		ObjID			GetMyObjectID		( void );
		void			SetMyObjectID		( ObjID inObjID );

		ObjID			GetOwnerID			( void );
		void			SetOwnerID			( ObjID inObjID );

		ObjID			GetNextObjectID		( void );
		void			SetNextObjectID		( ObjID inObjID );

		ObjID			GetPrevObjectID		( void );
		void			SetPrevObjectID		( ObjID inObjID );

		sInt16			GetItemCount		( void );
		void			SetItemCount		( sInt16 inCount );
		void			IncItemCount		( void );
		void			DecItemCount		( void );

		sInt16			GetItemSize			( void );
		void			SetItemSize			( sInt16 inSize );

		sInt16			GetMaxItems			( void );
		void			SetMaxItems			( void );

		CExpandData*	GetMyObjectData		( void );
		void			SetDirty			( void );

protected:
		void			GetDataBlock		( char *outData );
		void			SetDataBlock		( char *inData );

private:
	CExpandData			fObjectData;

	sInt16				fTotalItems;
};

#endif // __CExpansion_h__

