/*
	$Id: CGlobals.cpp,v 1.1 2003/04/20 23:25:37 dasenbro Exp $

	File: CGlobals.cpp

	Contains: Static application globals

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:
		$Log: CGlobals.cpp,v $
		Revision 1.1  2003/04/20 23:25:37  dasenbro
		Initial check-in.
		
		Revision 1.13  2002/05/20 21:44:15  dasenbro
		Added reset TOC calls.
		
		Revision 1.12  2002/05/09 16:58:53  dasenbro
		Changed all str... calls to CUtils::Str... to be NULL safe.
		
		Revision 1.11  2002/04/18 18:09:08  dasenbro
		Changed bool to bool for word alignment.
		
		Revision 1.10  2002/03/21 16:40:01  dasenbro
		Added network transition globals.
		
		Revision 1.9  2002/03/11 23:47:09  dasenbro
		Added host pref globals.
		
		Revision 1.8  2002/02/20 21:25:26  dasenbro
		Added routines from MailAdminHooks.h.
		
		Revision 1.7  2001/06/21 20:50:49  dasenbro
		Updated file header info.
		
		Revision 1.6  2001/06/21 16:21:20  dasenbro
		Added Change History.
		

	Projector History:
		01/11/01	ANC		Created by root on Thu Jan 11 2001


	To Do:

*/

#include <stdlib.h>		// for calloc

#include "CGlobals.h"

CGlobals::eAppState	CGlobals::sDieGasPumper		= CGlobals::kAppRunning;		// Quit app flag
ConnList		   *CGlobals::sConnList			= NULL;							// Current incoming connect list
bool				CGlobals::sRepairDB			= false;						// Command line repair flag
bool				CGlobals::sImport			= false;						// Import mail db to /var/mail/<users>
bool				CGlobals::sExport			= false;						// Export mail db to /var/mail/<users>
bool				CGlobals::sMigrate			= false;						// Migrage 6.x to 10.x
bool				CGlobals::sReadHostPrefs	= false;						// Used to reread the host prefs
bool				CGlobals::sReadServerPrefs	= false;						// Used to reread the server prefs
bool				CGlobals::sReadRelay		= false;						// Used to reread the IP relay list
bool				CGlobals::sReadReject		= false;						// Used to reread the SMTP rejection list
bool				CGlobals::sNetTransition	= false;						// Used to handle network transition
uInt32				CGlobals::sMsgCount			= 0;							// Current message count
uInt32				CGlobals::sTOCResetValue	= 0;							// Used to override internal TOC version

uInt32	gCntr = 0;

// ---------------------------------------------------------------------------
//	* QuitNow ()
//
// ---------------------------------------------------------------------------

bool CGlobals::QuitNow ( void )
{
	bool	bResult = false;

	if ( CGlobals::sDieGasPumper == CGlobals::kAppStopNow )
	{
		bResult = true;
	}

	return( bResult );

} // QuitNow


// ---------------------------------------------------------------------------
//	* SetAppQuit ()
//
// ---------------------------------------------------------------------------

void CGlobals::SetAppQuit ( void )
{
	CGlobals::sDieGasPumper = CGlobals::kAppStopNow;
} // SetAppQuit


// ---------------------------------------------------------------------------
//	* GetRepairDB ()
//
// ---------------------------------------------------------------------------

bool CGlobals::GetRepairDB ( void )
{
	return( CGlobals::sRepairDB );
} // GetRepairDB


// ---------------------------------------------------------------------------
//	* SetRepairDB ()
//
// ---------------------------------------------------------------------------

void CGlobals::SetRepairDB ( bool inState )
{
	CGlobals::sRepairDB = inState;
} // SetRepairDB


// ---------------------------------------------------------------------------
//	* GetImport ()
//
// ---------------------------------------------------------------------------

bool CGlobals::GetImport ( void )
{
	return( CGlobals::sImport );
} // GetImport


// ---------------------------------------------------------------------------
//	* SetImport ()
//
// ---------------------------------------------------------------------------

void CGlobals::SetImport ( bool inState )
{
	CGlobals::sImport = inState;
} // SetImport


// ---------------------------------------------------------------------------
//	* GetExport ()
//
// ---------------------------------------------------------------------------

bool CGlobals::GetExport ( void )
{
	return( CGlobals::sExport );
} // GetExport


// ---------------------------------------------------------------------------
//	* SetExport ()
//
// ---------------------------------------------------------------------------

void CGlobals::SetExport ( bool inState )
{
	CGlobals::sExport = inState;
} // SetExport


// ---------------------------------------------------------------------------
//	* GetMigrate ()
//
// ---------------------------------------------------------------------------

bool CGlobals::GetMigrate ( void )
{
	return( CGlobals::sMigrate );
} // GetMigrate


// ---------------------------------------------------------------------------
//	* SetMigrate ()
//
// ---------------------------------------------------------------------------

void CGlobals::SetMigrate ( bool inState )
{
	CGlobals::sMigrate = inState;
} // SetMigrate


// ---------------------------------------------------------------------------
//	* GetReadServerPrefs ()
//
// ---------------------------------------------------------------------------

bool CGlobals::GetReadServerPrefs ( void )
{
	return( CGlobals::sReadServerPrefs );
} // GetReadServerPrefs


// ---------------------------------------------------------------------------
//	* SetReadServerPrefs ()
//
// ---------------------------------------------------------------------------

void CGlobals::SetReadServerPrefs ( bool inState )
{
	CGlobals::sReadServerPrefs = inState;
} // SetReadServerPrefs


// ---------------------------------------------------------------------------
//	* GetReadHostPrefs ()
//
// ---------------------------------------------------------------------------

bool CGlobals::GetReadHostPrefs ( void )
{
	return( CGlobals::sReadHostPrefs );
} // GetReadHostPrefs


// ---------------------------------------------------------------------------
//	* SetReadHostPrefs ()
//
// ---------------------------------------------------------------------------

void CGlobals::SetReadHostPrefs ( bool inState )
{
	CGlobals::sReadHostPrefs = inState;
} // SetReadHostPrefs


// ---------------------------------------------------------------------------
//	* GetReadRelayList ()
//
// ---------------------------------------------------------------------------

bool CGlobals::GetReadRelayList ( void )
{
	return( CGlobals::sReadRelay );
} // GetReadRelayList


// ---------------------------------------------------------------------------
//	* SetReadRelayList ()
//
// ---------------------------------------------------------------------------

void CGlobals::SetReadRelayList ( bool inState )
{
	CGlobals::sReadRelay = inState;
} // SetReadRelayList


// ---------------------------------------------------------------------------
//	* GetReadSMTPReject ()
//
// ---------------------------------------------------------------------------

bool CGlobals::GetReadSMTPReject ( void )
{
	return( CGlobals::sReadReject );
} // GetReadSMTPReject


// ---------------------------------------------------------------------------
//	* SetReadSMTPReject ()
//
// ---------------------------------------------------------------------------

void CGlobals::SetReadSMTPReject ( bool inState )
{
	CGlobals::sReadReject = inState;
} // SetReadSMTPReject


// ---------------------------------------------------------------------------
//	* GetNetTransition ()
//
// ---------------------------------------------------------------------------

bool CGlobals::GetNetTransition ( void )
{
	return( CGlobals::sNetTransition );
} // GetNetTransition


// ---------------------------------------------------------------------------
//	* SetNetTransition ()
//
// ---------------------------------------------------------------------------

void CGlobals::SetNetTransition ( bool inState )
{
	if ( inState == true )
	{
		gCntr++;
		if ( gCntr == 2 )
		{
			CGlobals::sNetTransition = inState;
			gCntr = 0;
		}
	}
	else
	{
		CGlobals::sNetTransition = inState;
		gCntr = 0;
	}
} // SetNetTransition


// ---------------------------------------------------------------------------
//	* GetTOCResetValue ()
//
// ---------------------------------------------------------------------------

uInt32 CGlobals::GetTOCResetValue ( void )
{
	return( CGlobals::sTOCResetValue );
} // GetTOCResetValue


// ---------------------------------------------------------------------------
//	* SetTOCResetValue ()
//
// ---------------------------------------------------------------------------

void CGlobals::SetTOCResetValue ( const uInt32 inValue )
{
	CGlobals::sTOCResetValue = inValue;
} // SetTOCResetValue


// ---------------------------------------------------------------------------
//	* AddConnection ()
//
// ---------------------------------------------------------------------------

void CGlobals::AddConnection ( CProtocol *inConnection )
{
	bool		done		= false;
	uInt32		i			= 0;
	ConnList	*pCurrList	= nil;

	if ( sConnList == nil )
	{
		sConnList = (ConnList *)::calloc( sizeof( ConnList ), sizeof( char ) );
	}

	pCurrList = sConnList;
	while ( (pCurrList != nil) && !done )
	{
		if ( pCurrList->fCount < kMaxConnList )
		{
			for ( i = 0; i < kMaxConnList; i++ )
			{
				if ( pCurrList->fList[ i ] == nil )
				{
					pCurrList->fList[ i ] = inConnection;
					pCurrList->fCount++;
					done = true;
					break;
				}
			}
		}

		if ( !done )
		{
			if ( pCurrList->fNext == nil )
			{
				pCurrList->fNext = (ConnList *)::calloc( sizeof( ConnList ), sizeof( char ) );
			}

			pCurrList = pCurrList->fNext;
		}
	}
} // AddConnection


// ---------------------------------------------------------------------------
//	* RemoveConnection ()
//
// ---------------------------------------------------------------------------

void CGlobals::RemoveConnection ( CProtocol *inConnection )
{
	bool		done		= false;
	uInt32		i			= 0;
	ConnList	*pCurrList	= nil;

	pCurrList = sConnList;
	while ( (pCurrList != nil) && !done )
	{
		if ( pCurrList->fCount > 0 )
		{
			for ( i = 0; i < kMaxConnList; i++ )
			{
				if ( pCurrList->fList[ i ] == inConnection )
				{
					pCurrList->fList[ i ] = nil;
					pCurrList->fCount--;
					done = true;
					break;
				}
			}
		}

		pCurrList = pCurrList->fNext;
	}
} // RemoveConnection


// ---------------------------------------------------------------------------
//	* KillAllConnections ()
//
// ---------------------------------------------------------------------------

uInt32 CGlobals::KillAllConnections ( void )
{
	return( 0 );
} // KillAllConnections


// ---------------------------------------------------------------------------
//	* GetCurrentMessageCount ()
//
// ---------------------------------------------------------------------------

uInt32 CGlobals::GetCurrentMessageCount ( void )
{
	return( CGlobals::sMsgCount );
} // GetCurrentMessageCount


// ---------------------------------------------------------------------------
//	* SetCurrentMessageCount ()
//
// ---------------------------------------------------------------------------

void CGlobals::SetCurrentMessageCount ( uInt32 inCount )
{
	CGlobals::sMsgCount = inCount;
} // SetCurrentMessageCount


// ---------------------------------------------------------------------------
//	* IncrementCurMsgCount ()
//
// ---------------------------------------------------------------------------

void CGlobals::IncrementCurMsgCount ( void )
{
	CGlobals::sMsgCount++;
} // IncrementCurMsgCount



