/*
	File:		CDBMailBaseObject.10.1.h

	Contains:	C++ base class definition for persistent database objects

	Copyright:	 2003 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:
*/


#ifndef __CDBMailBaseObject_10_1_h__
#define __CDBMailBaseObject_10_1_h__	1

#include "CDBBaseObject.10.1.h"

class CDBMailBaseObject_10_1 : public CDBBaseObject_10_1
{
	public :
				CDBMailBaseObject_10_1	( 	StdDBObjHeader_10_1		*inObjHeader,
											StdDBObjFooter_10_1		*inObjFooter,
											void				*inObjData,
											const OSType		inObjSignature,
											const uInt32		inObjVersion,
											const uInt32		inObjSize 		);
		virtual	~CDBMailBaseObject_10_1	( void );

		virtual CDBBaseObject_10_1*		Use	( CBaseDatabase_10_1	*inBaseDB = NULL);
		static	CDBMailBaseObject_10_1*	MailUniversalFindByID	(	const ObjID			inObjID,
																const OSType			inObjType,
																const uInt32			inObjVersion,
																const uInt32			inObjSize,
																ObjAllocFuncPtr_10_1	inObjAllocFuncPtr	);
		// Thread OwnerShip
		virtual	ExceptionCode	GetObjectLock		( const Boolean inWaitForObjectLock,
												  	  const uInt32	inMaxWaitTime = kSafetyWaitTime_10_1 );
		virtual	void			ReleaseObjectLock	( const Boolean inNotifyOtherThreadsFlag );
		virtual	void			WakeUpObjectThreads	( void );

		virtual void			ChkCompilerStructAlignment	( void );
		virtual void			ReportBackwardCompatibility	( const uInt32 curSize, const uInt32 correctSize, char *inBaseClassName, char *inFieldName );
};

class CDBMailObjectCacheList_10_1 : public CDBBaseObjectCacheList_10_1
{
	public:
				CDBMailObjectCacheList_10_1();
		virtual ~CDBMailObjectCacheList_10_1();
		
		virtual void			DoListLock		( void );
		virtual void			DoListRelease	( void );
};

class CDBMailObjectCache_10_1 : public CDBBaseObjectCache_10_1
{
	public:
				 CDBMailObjectCache_10_1	();
		virtual	~CDBMailObjectCache_10_1	();
		
		virtual void		SetBaseDBPtr		( CBaseDatabase_10_1 *inObject );

		virtual	void		Wait				( const uInt32 inIndex );
		virtual	void		Signal				( const uInt32 inIndex );
};


#endif // __CDBMailBaseObject_10_1_h__
