/*
	File:		CIDTable.h

	Copyright:	 2003 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:
*/


#ifndef __CIDTable_10_1_h__
#define __CIDTable_10_1_h__	1

#include "DatabaseTypes.h"

typedef struct
{
	uInt32	fDataTableVersion;
	
	OSType	fTableType;
	uInt32	fDataSize;		// size of the entry data

	uInt32	fCount;			// current number of entries in this table
	uInt32	fMaxCount;		// max number of entries in this table

	ObjID	fMinID;			// min ID, present in this table
	ObjID	fMaxID;			// max ID present in this table

	PageID	fNextID;
	PageID	fPrevID;
	
	long	fSanityValue;
} SIDTableHeader_10_1;

const uInt32 kMaxIDTableSize_10_1	= (kStandardPageSize - sizeof(SIDTableHeader_10_1));
const uInt32 kCIDTableVersion_10_1	= 0x00550001 + sizeof(SIDTableHeader_10_1) + kMaxIDTableSize_10_1;
const uInt32 kCIDNullIndex_10_1		= 0xffffffff;

typedef struct
{
	SIDTableHeader_10_1	fIDTableHeader;
	char				fIDTableData[ kMaxIDTableSize_10_1 ];
} SIDTable_10_1;

class CIDTable_10_1
{
	public:
							CIDTable_10_1		( const OSType inTableType, const uInt32 inEntrySize = 0);
		virtual 			~CIDTable_10_1		( void );
		
		static void		CheckBackwardCompatibility		( void );		
		static void		ReportBackwardCompatibility		( const uInt32 curSize, const uInt32 correctSize );		
		static uInt32	GetEntryMaxByteSize				( void );

		virtual OSStatus	SetTable			( void *inTablePtr, const PageID inPageID);
		
		virtual	OSStatus	AddID2List			( const ObjID inEntryID, const void *inEntryData = NULL , Boolean allowNewMin = false, Boolean allowNewMax = true);
		virtual OSStatus	RemoveIDFromList	( const ObjID inEntryID );
		virtual OSStatus	FindEntry			( const ObjID inEntryID, uInt32 &outEntryIndex );
		virtual OSStatus	GetEntry			( const uInt32 inIndex, ObjID &outObjID, const Ptr inEntryData = NULL );
		virtual OSStatus	SetEntryData		( const ObjID inEntryID, const void *inEntryData = NULL );
		virtual OSStatus	ResetEntryID		( const ObjID inOldEntryID, const ObjID inNewEntryID );

		virtual OSType		GetTableType		( void );		

		virtual uInt32		GetEntryDataSize	( void );
		virtual uInt32		GetEntryMaxCount	( void );

		virtual OSStatus	SetEntryCount		( const uInt32 inEntryCount );
		virtual uInt32		GetEntryCount		( void );

		virtual OSStatus	SetEntryIDMin		( const uInt32 inEntryIDMin, Boolean inForceSet = false);
		virtual uInt32		GetEntryIDMin		( void );

		virtual OSStatus	SetEntryIDMax		( const uInt32 inEntryIDMax, Boolean inForceSet = false );
		virtual uInt32		GetEntryIDMax		( void );
		
		virtual OSStatus	ClearIDTable		( void );

		virtual PageID		GetNextID			( void );
		virtual OSStatus    SetNextID			( const PageID inNextIDTable );
		
		virtual PageID		GetPrevID			( void );
		virtual OSStatus    SetPrevID			( const PageID inNextIDTable );
		
		virtual	OSStatus	SetTablePageID		( const PageID inPageID );
		virtual	PageID		GetTablePageID		( void );
		
		enum
		{
			kIDTableNoErr = 0,
			kIDTableFull = -1,
			kIDTableNoSuchObject = -2,
			kIDTableDuplicateObject = -3,
			kIDTableObjNoAdd = -4,
			kIDTableIndexOutOfRange = -5,
			kIDTableEntryCountTooBig = -6,
			kIDTableNoInsertAllowed = -7,
			kIDNewMinNotAllowed = -8,
			kIDNewMaxNotAllowed = -9
		};
	
	protected:
		virtual OSStatus	DeleteEntry 	(const uInt32 inIndex);
		virtual OSStatus	SetEntry		(const uInt32 inIndex, const ObjID inObjID, const void * inEntryData = NULL);
		virtual OSStatus	InsertEntry		(const uInt32 inIndex, const ObjID inObjID, const void * inEntryData = NULL);
		virtual OSStatus	SetEntry2ObjID	(const uInt32 inIndex, const ObjID inNewObjID);		
				OSStatus	SanityCheck		( void );

		// volitile data, no read/write to disk
		PageID			fPageID;
		SIDTableHeader_10_1	fTempHeader;
		
		// Data portion of the object, this can be saved and restored
		// to disk....
		SIDTable_10_1		*fIDTablePtr;
};

#endif	// __CIDTable_10_1_h__
