/*
	$Id: DSHostPrefs.cpp,v 1.1 2003/04/20 23:34:11 dasenbro Exp $

	File:		DSHostPrefs.cpp

	Contains:	implementation of DSHostPrefs object

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: DSHostPrefs.cpp,v $
		Revision 1.1  2003/04/20 23:34:11  dasenbro
		Initial check-in.
		
		Revision 1.4  2002/06/13 01:28:23  dasenbro
		Set fOutMailPopupFlags == 2 so that default is no outgoing mail.
		
		Revision 1.3  2002/04/18 18:09:10  dasenbro
		Changed bool to Bool for word alignment.
		
		Revision 1.2  2002/03/21 16:38:52  dasenbro
		Addes network transition support.
		
		Revision 1.1  2002/03/11 23:06:43  dasenbro
		Initial check-in.
		


	To Do:
*/

#include <stdlib.h>
#include <DirectoryService/DirServicesConst.h>

#include "DSHostPrefs.h"

#define		kBCCOutUserStructRecName				"bcc_out_user"

#define		kDeliverLocalOnlyFlag					kDSNativeAttrTypePrefix"deliver_local_only_flag"
#define		kLogRejectionsFlag						kDSNativeAttrTypePrefix"log_rejections_flag"
#define		kSendBCCFromHostFlag					kDSNativeAttrTypePrefix"send_bcc_to_user_flag"
#define		kSendBCCFromHostUserStruct				kDSNativeAttrTypePrefix"send_bcc_to_user_struct"

#define		kOutMailPopupValue						kDSNativeAttrTypePrefix"out_mail_popup_value"
#define		kNotifySenderOfNDRFlag					kDSNativeAttrTypePrefix"notify_sndr_ndr_flag"
#define		kNotifyPostmasterOfNDRFlag				kDSNativeAttrTypePrefix"notify_pm_ndr_flag"
#define		kRelaySMTPViaFlag						kDSNativeAttrTypePrefix"relay_smtp_via_flag"
#define		kRelaySMTPServerString					kDSNativeAttrTypePrefix"relay_smtp_server_string"
#define		kExpireUndeliverableMailValue			kDSNativeAttrTypePrefix"expire_out_mail_hours_value"
#define		kRetryFailedConnMinValue				kDSNativeAttrTypePrefix"retry_failed_conn_min_value"
#define		kNotifySenderOfNDRValue					kDSNativeAttrTypePrefix"notify_sndr_ndr_hours_value"

#define		kDNSRequestValue						kDSNativeAttrTypePrefix"dns_request_value"
#define		kCacheSettingsValue						kDSNativeAttrTypePrefix"cache_settings_value"
#define		kDNSCacheMinutesValue					kDSNativeAttrTypePrefix"dsn_cache_minutes_value"
#define		kOpenConnTimeoutSecsValue				kDSNativeAttrTypePrefix"open_conn_timeout_value"
#define		kReadWriteTimeoutSecsValue				kDSNativeAttrTypePrefix"read_write_timeout_value"
#define		kSMTPOutPortValue						kDSNativeAttrTypePrefix"smtp_out_port_value"


// --------------------------------------------------------------------------------
//	* DSHostPrefs ()
//
// --------------------------------------------------------------------------------

DSHostPrefs::DSHostPrefs ( void )
{
	fDeliverToLocalOnlyFlag		= false;
	fLogRejectionsFlag			= false;
	fSendBCCofAllToUserFlag		= false;
	fSendBCCofAllToUserInfo		= nil;

	fOutMailPopupFlags			= 2;
	fNotifySenderOfNDRFlag		= false;
	fNotifyPostmasterOfNDR		= false;
	fRelaySMTPFlag				= false;
	fSMTPRelayServerName		= nil;
	fExpireMsgAfterHours		= 72;
	fRetryFailedMinutes			= 30;
	fNotifySenderOfNDRHours		= 4;

	fDNS_RequestButtonFlag		= 1;
	fCacheSettingsButtonFlag	= 1;
	fCacheDNSMinutes			= 720;
	fOpenConnTimeoutSeconds		= 120;
	fReadWriteTimeoutSeconds	= 120;
	fOutSMTPPortNumber			= 25;

} // DSHostPrefs


// --------------------------------------------------------------------------------
//	* ~DSHostPrefs ()
//
// --------------------------------------------------------------------------------

DSHostPrefs::~DSHostPrefs ( void )
{
} // ~DSHostPrefs


//--------------------------------------------------------------------------------------------------
//	* GetDeliverToLocalOnlyFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::GetDeliverToLocalOnlyFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fDeliverToLocalOnlyFlag, kDeliverLocalOnlyFlag, outFlag, inForceRead );

	return ( dsStatus );

} // GetDeliverToLocalOnlyFlag


//--------------------------------------------------------------------------------------------------
//	* SetDeliverToLocalOnlyFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::SetDeliverToLocalOnlyFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fDeliverToLocalOnlyFlag, kDeliverLocalOnlyFlag, inFlag, inForceWrite );

	return ( dsStatus );

} // SetDeliverToLocalOnlyFlag


//--------------------------------------------------------------------------------------------------
//	* GetLogRejectionsFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::GetLogRejectionsFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fLogRejectionsFlag, kLogRejectionsFlag, outFlag, inForceRead );

	return ( dsStatus );

} // GetLogRejectionsFlag


//--------------------------------------------------------------------------------------------------
//	* SetLogRejectionsFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::SetLogRejectionsFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fLogRejectionsFlag, kLogRejectionsFlag, inFlag, inForceWrite );

	return ( dsStatus );

} // SetLogRejectionsFlag


//--------------------------------------------------------------------------------------------------
//	* GetSendBCC_CopiesOfAllFlag
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::GetSendBCC_CopiesOfAllFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fSendBCCofAllToUserFlag, kSendBCCFromHostFlag, outFlag, inForceRead );

	return ( dsStatus );

} // GetLogRejectionsFlag


//--------------------------------------------------------------------------------------------------
//	* SetSendBCC_CopiesOfAllFlag
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::SetSendBCC_CopiesOfAllFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fSendBCCofAllToUserFlag, kSendBCCFromHostFlag, inFlag, inForceWrite );

	return ( dsStatus );

} // SetLogRejectionsFlag


//--------------------------------------------------------------------------------------------------
//	* GetSendBCC_CopiesOfAllUser ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::GetSendBCC_CopiesOfAllUser ( UserStruct *inUserInfo, Bool inForceRead )
{
	tDirStatus		dsStatus	= eDSNoErr;

	if ( inUserInfo != nil )
	{
		dsStatus = this->GetUserStructMember( fSendBCCofAllToUserInfo, kBCCOutUserStructRecName, inUserInfo, inForceRead );
	}

	return( dsStatus );

} // GetSendBCC_CopiesOfAllUser


//--------------------------------------------------------------------------------------------------
//	* SetSendBCC_CopiesOfAllUser ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::SetSendBCC_CopiesOfAllUser ( const UserStruct *inUserInfo, Bool inForceWrite )
{
	tDirStatus		dsStatus	= eDSNoErr;

	if ( inUserInfo != nil )
	{
		dsStatus = this->SetUserStructMember( fSendBCCofAllToUserInfo, kBCCOutUserStructRecName, inUserInfo, inForceWrite );
	}

	return( dsStatus );

} // SetSendBCC_CopiesOfAllUser


//--------------------------------------------------------------------------------------------------
//	* GetOutMailPopupFlags
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::GetOutMailPopupFlags ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fOutMailPopupFlags, kOutMailPopupValue, outValue, inForceRead );

	return ( dsStatus );

} // GetOutMailPopupFlags


//--------------------------------------------------------------------------------------------------
//	* SetOutMailPopupFlags
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::SetOutMailPopupFlags ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetValueMember( fOutMailPopupFlags, kOutMailPopupValue, inValue, inForceWrite );

	return ( dsStatus );

} // SetOutMailPopupFlags


//--------------------------------------------------------------------------------------------------
//	* GetNotifySenderOfNDRFlag
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::GetNotifySenderOfNDRFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fNotifySenderOfNDRFlag, kNotifySenderOfNDRFlag, outFlag, inForceRead );

	return ( dsStatus );

} // GetNotifySenderOfNDRFlag


//--------------------------------------------------------------------------------------------------
//	* SetNotifySenderOfNDRFlag
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::SetNotifySenderOfNDRFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fNotifySenderOfNDRFlag, kNotifySenderOfNDRFlag, inFlag, inForceWrite );

	return ( dsStatus );

} // SetNotifySenderOfNDRFlag


//--------------------------------------------------------------------------------------------------
//	* GetNotifySenderOfNDRHours
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::GetNotifySenderOfNDRHours ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fNotifySenderOfNDRHours, kNotifySenderOfNDRValue, outValue, inForceRead );

	return ( dsStatus );

} // GetNotifySenderOfNDRHours


//--------------------------------------------------------------------------------------------------
//	* SetNotifySenderOfNDRHours
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::SetNotifySenderOfNDRHours ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetValueMember( fNotifySenderOfNDRHours, kNotifySenderOfNDRValue, inValue, inForceWrite );

	return ( dsStatus );

} // SetNotifySenderOfNDRHours


//--------------------------------------------------------------------------------------------------
//	* GetNotifyPostmasterOfNDR
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::GetNotifyPostmasterOfNDR ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fNotifyPostmasterOfNDR, kNotifyPostmasterOfNDRFlag, outFlag, inForceRead );

	return ( dsStatus );

} // GetNotifyPostmasterOfNDR


//--------------------------------------------------------------------------------------------------
//	* SetNotifyPostmasterOfNDR
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::SetNotifyPostmasterOfNDR ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fNotifyPostmasterOfNDR, kNotifyPostmasterOfNDRFlag, inFlag, inForceWrite );

	return ( dsStatus );

} // SetNotifyPostmasterOfNDR


//--------------------------------------------------------------------------------------------------
//	* GetRelaySMTPFlag
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::GetRelaySMTPFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fRelaySMTPFlag, kRelaySMTPViaFlag, outFlag, inForceRead );

	return ( dsStatus );

} // GetRelaySMTPFlag


//--------------------------------------------------------------------------------------------------
//	* SetRelaySMTPFlag
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::SetRelaySMTPFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fRelaySMTPFlag, kRelaySMTPViaFlag, inFlag, inForceWrite );

	return ( dsStatus );

} // SetRelaySMTPFlag


//--------------------------------------------------------------------------------------------------
//	* GetRelaySMTPServer ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::GetRelaySMTPServer ( CString &outStr, Bool inForceRead )
{
	tDirStatus			dsStatus	= eDSNoErr;

	dsStatus = this->GetStringMember( fSMTPRelayServerName, kRelaySMTPServerString, outStr, inForceRead );
	if ( dsStatus == eDSAttributeNotFound )
	{
		outStr.Clear();
		dsStatus = this->SetAttributeValue( kRelaySMTPServerString, outStr.GetData() );
	}

	return( dsStatus );

} // GetRelaySMTPServer


//--------------------------------------------------------------------------------------------------
//	* SetRelaySMTPServer ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::SetRelaySMTPServer ( const char *inStr, Bool inForceWrite )
{
	tDirStatus			dsStatus	= eDSNoErr;

	dsStatus = SetStringMember( fSMTPRelayServerName, kRelaySMTPServerString, inStr, inForceWrite );

	return( dsStatus );

} // SetRelaySMTPServer


//--------------------------------------------------------------------------------------------------
//	* GetExpireOutMailAfterHours
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::GetExpireOutMailAfterHours ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fExpireMsgAfterHours, kExpireUndeliverableMailValue, outValue, inForceRead );

	return ( dsStatus );

} // GetExpireOutMailAfterHours


//--------------------------------------------------------------------------------------------------
//	* SetExpireOutMailAfterHours
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::SetExpireOutMailAfterHours ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetValueMember( fExpireMsgAfterHours, kExpireUndeliverableMailValue, inValue, inForceWrite );

	return ( dsStatus );

} // SetExpireOutMailAfterHours


//--------------------------------------------------------------------------------------------------
//	* GetRetryFailedMinutes
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::GetRetryFailedMinutes ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fRetryFailedMinutes, kRetryFailedConnMinValue, outValue, inForceRead );

	return ( dsStatus );

} // GetRetryFailedMinutes


//--------------------------------------------------------------------------------------------------
//	* SetRetryFailedMinutes
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::SetRetryFailedMinutes ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetValueMember( fRetryFailedMinutes, kRetryFailedConnMinValue, inValue, inForceWrite );

	return ( dsStatus );

} // SetRetryFailedMinutes


//--------------------------------------------------------------------------------------------------
//	* GetDNSRequestButtonFlags
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::GetDNSRequestButtonFlags ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fDNS_RequestButtonFlag, kDNSRequestValue, outValue, inForceRead );

	return ( dsStatus );

} // GetDNSRequestButtonFlags


//--------------------------------------------------------------------------------------------------
//	* SetDNSRequestButtonFlags
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::SetDNSRequestButtonFlags ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetValueMember( fDNS_RequestButtonFlag, kDNSRequestValue, inValue, inForceWrite );

	return ( dsStatus );

} // SetDNSRequestButtonFlags


//--------------------------------------------------------------------------------------------------
//	* GetCacheSettingsButtonFlags
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::GetCacheSettingsButtonFlags ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fCacheSettingsButtonFlag, kCacheSettingsValue, outValue, inForceRead );

	return ( dsStatus );

} // GetCacheSettingsButtonFlags


//--------------------------------------------------------------------------------------------------
//	* SetCacheSettingsButtonFlags
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::SetCacheSettingsButtonFlags ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetValueMember( fCacheSettingsButtonFlag, kCacheSettingsValue, inValue, inForceWrite );

	return ( dsStatus );

} // SetCacheSettingsButtonFlags


//--------------------------------------------------------------------------------------------------
//	* GetCacheDNSMinutes
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::GetCacheDNSMinutes ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fCacheDNSMinutes, kDNSCacheMinutesValue, outValue, inForceRead );

	return ( dsStatus );

} // GetCacheDNSMinutes


//--------------------------------------------------------------------------------------------------
//	* SetCacheDNSMinutes
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::SetCacheDNSMinutes ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetValueMember( fCacheDNSMinutes, kDNSCacheMinutesValue, inValue, inForceWrite );

	return ( dsStatus );

} // SetCacheDNSMinutes


//--------------------------------------------------------------------------------------------------
//	* GetOpenConnTimeoutSeconds
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::GetOpenConnTimeoutSeconds ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fOpenConnTimeoutSeconds, kOpenConnTimeoutSecsValue, outValue, inForceRead );

	return ( dsStatus );

} // GetOpenConnTimeoutSeconds


//--------------------------------------------------------------------------------------------------
//	* SetOpenConnTimeoutSeconds
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::SetOpenConnTimeoutSeconds ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetValueMember( fOpenConnTimeoutSeconds, kOpenConnTimeoutSecsValue, inValue, inForceWrite );

	return ( dsStatus );

} // SetOpenConnTimeoutSeconds


//--------------------------------------------------------------------------------------------------
//	* GetReadWriteTimeoutSeconds
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::GetReadWriteTimeoutSeconds ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fReadWriteTimeoutSeconds, kReadWriteTimeoutSecsValue, outValue, inForceRead );

	return ( dsStatus );

} // GetReadWriteTimeoutSeconds


//--------------------------------------------------------------------------------------------------
//	* SetReadWriteTimeoutSeconds
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::SetReadWriteTimeoutSeconds ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetValueMember( fReadWriteTimeoutSeconds, kReadWriteTimeoutSecsValue, inValue, inForceWrite );

	return ( dsStatus );

} // SetReadWriteTimeoutSeconds


//--------------------------------------------------------------------------------------------------
//	* GetOutSMTPPortNumber
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::GetOutSMTPPortNumber ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fOutSMTPPortNumber, kSMTPOutPortValue, outValue, inForceRead );

	return ( dsStatus );

} // GetOutSMTPPortNumber


//--------------------------------------------------------------------------------------------------
//	* SetOutSMTPPortNumber
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSHostPrefs::SetOutSMTPPortNumber ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetValueMember( fOutSMTPPortNumber, kSMTPOutPortValue, inValue, inForceWrite );

	return ( dsStatus );

} // SetOutSMTPPortNumber


