/*
	$Id: DSMailGroup.h,v 1.1 2003/04/20 23:34:11 dasenbro Exp $

	File:		DSMailGroup.h

	Contains:	class definition of DSMailGroup object

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: DSMailGroup.h,v $
		Revision 1.1  2003/04/20 23:34:11  dasenbro
		Initial check-in.
		
		Revision 1.11  2002/03/21 16:38:52  dasenbro
		Addes network transition support.
		
		Revision 1.10  2001/06/21 20:50:54  dasenbro
		Updated file header info.
		
		Revision 1.9  2001/06/21 17:22:46  dasenbro
		Added Change History.
		

	Projector History:


	To Do:
*/

#ifndef __DSMailGroup_h__
#define __DSMailGroup_h__ 1

#include "MailUGCommon.h"

// Group member list type
typedef	Str63	GroupMemberList;

class DSMailGroup 
{
public:

typedef enum {
	eMailGroupNoErr		= 0,
	eMemoryError		= -9001,
	eNullGroupName		= -9002,
	eInvalidDataType	= -9003,
	eItemNotFound		= -9004,
	eMalformedAttr		= -9005,
	eWrongVersion		= -9006,
	eNoGroupID			= -9007
} eMailGroupErr;

public:

	// Constructor/Destructor
			 DSMailGroup					( void );
 			 DSMailGroup					( DSMailGroup *inMailGroup );
	virtual	~DSMailGroup					( void );


	// Verification
	eMailGroupErr	VerifyMailAttrVers		( void );

	// Set Attributes
	eMailGroupErr	SetGroupName			( const char *inGroupName );
	eMailGroupErr	SetGroupID				( const uInt32 inGroupID );

	// Get Attributes
	uInt32			GetGroupID	 			( void );
	const char*		GetName					( void );

	Boolean			IsExpanded				( void );

	eMUGError		ExpandGroup				( void );

	uInt32			GetMemberCount			( void );
	void			SetMemberCount			( uInt32 inCount );

	Boolean			GetGroupMembers			( uInt32 *ioArrayBuffer, const uInt32 inBufferLen, uInt32 &outCount );
	Boolean			GetGroupMembers			( GroupMemberList **outMemberArray, uInt32 &outCount );
	void			SetGroupMembers			( GroupMemberList *inMemberArray );

	// Authentication
	eMUGAuthResults		ValidatePassword 		( const char *inPassword );

//	Boolean		GetGroups				( uInt32 *outGroups );

protected:
	void		CopyString				( char **outDestStr, char *inSourceStr );


	uInt32				fGroupID;							// Group ID
	char			   *fGroupName;
	Boolean				fIsExpanded;
	uInt32				fMemberCount;
	GroupMemberList	   *fMemberArray;
};

#endif // __DSMailGroup_h__
