/*
	$Id: DSMailUser.h,v 1.1 2003/04/20 23:34:11 dasenbro Exp $

	File:		DSMailUser.h

	Contains:	class definition of DSMailUser object

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: DSMailUser.h,v $
		Revision 1.1  2003/04/20 23:34:11  dasenbro
		Initial check-in.
		
		Revision 1.18  2002/04/18 18:09:10  dasenbro
		Changed bool to Bool for word alignment.
		
		Revision 1.17  2002/03/21 16:38:52  dasenbro
		Addes network transition support.
		
		Revision 1.16  2002/02/20 21:08:03  dasenbro
		Added user disk quota keys and members.
		
		Revision 1.15  2002/01/14 17:30:58  dasenbro
		Initial S4 updates.
		
		Revision 1.14  2001/06/21 20:50:55  dasenbro
		Updated file header info.
		
		Revision 1.13  2001/06/21 17:20:11  dasenbro
		*** empty log message ***
		
		Revision 1.12  2001/05/23 22:28:26  dasenbro
		Added GetGroups() for ACL support.
		


	To Do:
*/

#ifndef __DSMailUser_h__
#define __DSMailUser_h__ 1

#include <CoreFoundation/CFData.h>
#include <CoreFoundation/CFString.h>
#include <CoreFoundation/CFNumber.h>
#include <CoreFoundation/CFPropertyList.h>

#include "MailUGCommon.h"


// Mail user attribute version
#define	kXMLKeyAttrVersion				"kAttributeVersion"
	#define	kXMLValueVersion				"Apple Mail 1.0"

// Is APOP Required
#define	kXMLKeyAPOPRequired				"kAPOPRequired"
	#define	kXMLValueYesAPOP				"APOPRequired"
	#define	kXMLValueNoAPOP					"APOPNotRequired"

// Auto forward key (has no specific value)
#define	kXMLKeyAutoFwd					"kAutoForwardValue"

// IMAP login state
#define	kXMLKeykIMAPLoginState			"kIMAPLoginState"
	#define	kXMLValueIMAPLoginOK			"IMAPAllowed"
	#define	kXMLValueIMAPLogInNotOK			"IMAPDeny"

// POP3 login state
#define	kXMLKeyPOP3LoginState			"kPOP3LoginState"
	#define	kXMLValuePOP3LoginOK			"POP3Allowed"
	#define	kXMLValuePOP3LoginNotOK			"POP3Deny"


// Account location key (has no specific value)
#define	kXMLKeyAcctLoc					"kMailAccountLocation"

// Mail location key (has no specific value)
#define	kXMLKeyMailLoc					"kMailLocation"

// Account state
#define	kXMLKeyAcctState				"kMailAccountState"
	#define	kXMLValueAcctEnabled			"Enabled"
	#define	kXMLValueAcctDisabled			"Off"
	#define	kXMLValueAcctFwd				"Forward"

// Notify
#define	kXMLKeyNotifyState				"kNotificationState"
	#define	kXMLValueNotifyOff				"NotificationOff"
	#define	kXMLValueNotifyLastIP			"NotificationLastIP"
	#define	kXMLValueNotifyStaticIP			"NotificationStaticIP"

// Disk Quota  (has no specific value)
#define	kXMLKeyDiskQuota				"kUserDiskQuota"

// Static IP address of notification (has no specific value)
#define	kXMLKeykNotifyStaticIP			"kNotificationStaticIPValue"

// Separate or shared inbox
#define	kXMLKeySeparateInbox			"kSeparateInboxState"
	#define	kXMLValueSharedInbox			"OneInbox"
	#define	kXMLValueSeparateInbox			"DualInbox"

// Show POP in IMAP
#define	kXMLKeyShowPOP3InIMAP			"kShowPOP3InboxInIMAP"
	#define	kXMLValueShowPOP				"ShowPOP3Inbox"
	#define	kXMLValueDontShowPOP			"HidePOP3Inbox"

// Deliver to local UNIX inbodx
#define	kXMLKeyDeliveToUNIXInbox			"kDeliverToUNIXInbox"
	#define	kXMLValueDeliverToUNIX			"DeliverToUNIX"
	#define	kXMLValueDontDeliverToUNIX		"DontDeliverToUNIX"


class DSMailUser 
{
public:

	typedef enum {
		eMailUserNoErr		= 0,
		eMemoryError		= -8001,
		eNullUserName		= -8002,
		eInvalidDataType	= -8003,
		eItemNotFound		= -8004,
		eMalformedAttr		= -8005,
		eWrongVersion		= -8006,
		eNoUserID			= -8007,
		eEmptyString		= -8008
	} eMailUserErr;
	
	typedef enum {
		eUnknownAcctState	= 0,
		eAcctEnabled		= 1,
		eAcctDisabled		= 2,
		eAcctForwarded		= 3
	} eMailAcctState;
	
	typedef enum {
		eUnknownNotifyState	= 0,
		eNotifyDisabled		= 1,
		eNotifyUseLastIP	= 2,
		eNotifyUseStaticIP	= 3
	} eNotifyState;

public:

	// Constructor/Destructor
			 DSMailUser					( void );
 			 DSMailUser					( DSMailUser *inMailUser );
	virtual	~DSMailUser					( void );


	// Verification
	eMailUserErr	VerifyMailAttrVers		( void );

	// Set Attributes
	const char*		GetUserName				( void );
	eMailUserErr	SetUserName				( const char *inUserName );

	const char*		GetRealName				( void );
	eMailUserErr	SetRealName				( const char *inRealName );

	uInt32			GetUserID	 			( void );
	void			SetUserID				( const uInt32 inUserID );

	uInt32			GetDiskQuota			( void );
	void			SetDiskQuota			( const uInt32 inQuota );

	uInt32			GetGroupID	 			( void );
	void			SetGroupID				( const uInt32 inGroupID );

	const char*		GetUserLocation			( void );
	eMailUserErr	SetUserLocation			( const char *inUserLocation );

	const char*		GetAcctLocation			( void );
	eMailUserErr	SetAcctLocFromXML		( void );

	const char*		GetMailLocation			( void );
	eMailUserErr	SetMailLocFromXML		( void );

	const char*		GetNotifyIPAddress		( void );
	eMailUserErr	SetNotifyIPAddrFromXML	( void );

	eMailUserErr	SetAutoFwd				( const char *inEmailAddress );
	eMailUserErr	SetAttrsFromXML			( char *inXMLData );
	eMailUserErr	GetAPOPFromXML			( void );
	eMailUserErr	GetIMAPLoginFromXML		( void );
	eMailUserErr	GetPOP3LoginFromXML		( void );
	eMailUserErr	GetAcctStateFromXML		( void );
	eMailUserErr	GetAutoFwdFromXML		( void );
	eMailUserErr	GetNotifyFromXML		( void );
	eMailUserErr	GetDiskQuotaFromXML		( void );
	eMailUserErr	GetSeparateInboxFromXML	( void );
	eMailUserErr	GetShowPopInImapFromXML	( void );
	eMailUserErr	GetLocalDeliveryFromXML	( void );

	// Get Attributes
	Bool			IsMailEnabled			( void );
	Bool			IsPOPLoginEnabled		( void );
	Bool			IsIMAPLoginEnabled		( void );
	Bool			IsAPOPRequired			( void );
	Bool			IsInboxShared			( void );
	Bool			IsShowPOPInIMAP			( void );
	Bool			IsNotificationOn		( void );
	Bool			IsAdminEnabled			( void );
	Bool			UseLastIPAddress		( void );
	Bool			IsSMTPForwardEnabled	( void );
	Bool			DeliverToUNIXInbox		( void );
	const char*		GetSMTPForward			( void );

	// Authentication
	//Bool		ValidateAPOPDigest 		( const char *inTimestamp, const char *inAPOPDigest, OAMStatus& outErr );

	uInt32			GetGroups				( uInt32 *outGroups );
	Bool			IsAccountLocal			( char *outFwdTo );

protected:
	void			CopyString				( char **outDestStr, char *inSourceStr );

	CFDataRef			fDataRef;			// 
	CFPropertyListRef	fPlistRef;			// 
	CFDictionaryRef		fDictRef;			// 

	uInt32				fUserID;			// 
	uInt32				fGroupID;			// 
	uInt32				fDiskQuota;			//
	eMailAcctState		fAcctState;			// 
	eNotifyState		fNotifyState;		// 
	Bool				fAPOPRequired;		// 
	Bool				fOneInbox;			// 
	Bool				fShowPOPInIMAP;		// 
	Bool				fPOP3Login;			// 
	Bool				fIMAPLogin;			// 
	Bool				fUNIXInbox;			// 
	char			   *fName;				// 
	char			   *fRealName;			// 
	char			   *fUserLocation;		// 
	char			   *fAccountLoc;		// 
	char			   *fMailLocation;		//
	char			   *fNotifyIPAddr;		// 
	char			   *fAutoFwdAddr;		// 
};

#endif // __DSMailUser_h__
