/*
	$Id: DSServerPrefs.cpp,v 1.1 2003/04/20 23:34:11 dasenbro Exp $

	File:		DSServerPrefs.cpp

	Contains:	implementation of DSServerPrefs object

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: DSServerPrefs.cpp,v $
		Revision 1.1  2003/04/20 23:34:11  dasenbro
		Initial check-in.
		
		Revision 1.16  2002/07/13 01:17:48  dasenbro
		Added new attribute get/set/initialize routines for temp SSL certificates.
		
		Revision 1.15  2002/07/09 02:43:28  dasenbro
		Added address to GetBCCName().
		
		Revision 1.14  2002/07/04 18:20:22  dasenbro
		Changed return value in ForwardToAnyUser() to fFWDUnknownLocalFlag.
		
		Revision 1.13  2002/06/04 18:01:54  dasenbro
		Fixed a typo in Get/SetRequireCRAM_MD5_IMAP_Flag() routines.
		
		Revision 1.12  2002/05/30 17:14:31  dasenbro
		Added Get/SetRequireCRAM_MD5_IMAP_Flag() routines.
		
		Revision 1.11  2002/05/20 21:17:41  dasenbro
		Set allowed relay lists to true.
		
		Revision 1.10  2002/05/09 16:58:56  dasenbro
		Changed all str... calls to CUtils::Str... to be NULL safe.
		
		Revision 1.9  2002/04/18 18:09:10  dasenbro
		Changed bool to Bool for word alignment.
		
		Revision 1.8  2002/04/16 05:53:20  dasenbro
		Set fUseDefaultSpamServerFlag == false by default.
		
		Revision 1.7  2002/03/25 22:56:16  dasenbro
		Added SSL consts for IMAP and POP ports.
		
		Revision 1.6  2002/03/21 16:38:52  dasenbro
		Addes network transition support.
		
		Revision 1.5  2002/03/11 23:07:52  dasenbro
		Added support for directory based host prefs.
		
		Revision 1.4  2002/03/05 19:28:57  dasenbro
		Added get/set routines for SMTP rejection list and added delete
		attribute value member.
		
		Revision 1.3  2002/02/20 21:13:13  dasenbro
		Added new keys and disk quota get/set member functions.
		
		Revision 1.2  2002/01/23 22:14:44  dasenbro
		Added new members for Get/Set of alternate mail daemon mailbox location.
		
		Revision 1.1  2002/01/14 17:31:28  dasenbro
		Initial S4 updates.
		
		

	To Do:
*/

#include <stdlib.h>

#include "DSServerPrefs.h"
#include "DSMgr.h"
#include "CUtils.h"
#include "COSUtils.h"
#include "CString.h"

#define		kFwdLocalUserStructRecName		"fwd_unknown_local_user"
#define		kBCC_UserStructRecName			"bcc_user"

#define		kNoRespName						"EMPTY RESPONSE NAME"
#define		kDefaultBlackHoleServer			"blackholes.mail-abuse.org"
#define		kSMTP_InGreeting				kDSNativeAttrTypePrefix"smtp_in_greeting"
#define		kSMTP_OutGreeting				kDSNativeAttrTypePrefix"smtp_out_greeting"
#define		kPOP3_Greeting					kDSNativeAttrTypePrefix"pop3_greeting"
#define		kIMAP_Greeting					kDSNativeAttrTypePrefix"imap_greeting"
#define		kLastIPAddress					kDSNativeAttrTypePrefix"last_ip_addr"
#define		kMaxMsgSizeFlag					kDSNativeAttrTypePrefix"max_msg_size_flag"
#define		kMaxMsgSizeValue				kDSNativeAttrTypePrefix"max_msg_size_value"
#define		kBCC_Flag						kDSNativeAttrTypePrefix"send_bcc_flag"
#define		kBCC_User						kDSNativeAttrTypePrefix"send_bcc_user"
#define		kAutoDeleteFlag					kDSNativeAttrTypePrefix"auto_delete_flag"
#define		kSeenDays						kDSNativeAttrTypePrefix"auto_delete_msg_read_value"
#define		kUnseenDays						kDSNativeAttrTypePrefix"auto_delete_msg_unread_value"
#define		kFwdUnknownLocalUserFlag		kDSNativeAttrTypePrefix"fwd_unknown_local_flag"
#define		kFwdUnknownLocalUser			kDSNativeAttrTypePrefix"fwd_unknown_local_user"
#define		kBlackholeServerName			kDSNativeAttrTypePrefix"junk_mail_server_name"
#define		kUseBlackholeServerFlag			kDSNativeAttrTypePrefix"use_junk_mail_server_flag"
#define		kCustomSpamServerList			kDSNativeAttrTypePrefix"custom_junk_mail_servers_list"
#define		kLogBad_SMTP_NamesFlag			kDSNativeAttrTypePrefix"log_bad_smtp_names_flag"
#define		kRejectBad_SMTP_NamesFlag		kDSNativeAttrTypePrefix"reject_bad_smtp_names_flag"
#define		kRequireLocalFrom				kDSNativeAttrTypePrefix"require_local_from_flag"
#define		kRejectIfNotInHostListFlag		kDSNativeAttrTypePrefix"reject_not_in_host_list_flag"
#define		kRejectSMTPHostList				kDSNativeAttrTypePrefix"smtp_reject_host_list"
#define		kEnableSMTP_Flag				kDSNativeAttrTypePrefix"enable_smtp_flag"
#define		kSMTP_OptionsPopupValue			kDSNativeAttrTypePrefix"smtp_options_value"
#define		kSMTP_InPortValue				kDSNativeAttrTypePrefix"smtp_in_port_value"
#define		kSMTP_OutPortValue				kDSNativeAttrTypePrefix"smtp_out_port_value"
#define		kEnablePOP3_Flag				kDSNativeAttrTypePrefix"enable_pop3_flag"
#define		kPOP3_PortValue					kDSNativeAttrTypePrefix"POP3_port_value"
#define		kEnableIMAP_Flag				kDSNativeAttrTypePrefix"enable_imap_flag"
#define		kIMAP_PortValue					kDSNativeAttrTypePrefix"imap_port_value"
#define		kEnableASIA_Flag				kDSNativeAttrTypePrefix"enable_admin_port_flag"
#define		kASIA_PortValue					kDSNativeAttrTypePrefix"admin_port_value"
#define		kEnableNotifyMailFlag			kDSNativeAttrTypePrefix"enable_notify_mail_flag"
#define		kNotifyMailPortValue			kDSNativeAttrTypePrefix"notify_mail_port_value"
#define		kSMTPRelayWhenBackupFlag		kDSNativeAttrTypePrefix"smtp_relay_when_backup_flag"
#define		kUndeliverNDRToPMFlag			kDSNativeAttrTypePrefix"undliv_ndr_to_pm_flag"
#define		kAllowNDRsForBulkMailFlag		kDSNativeAttrTypePrefix"bulk_mail_ndrs_flag"
#define		kCaseSensativeFldrNamesFlag		kDSNativeAttrTypePrefix"case_sensative_fldr_names_flag"
#define		kRequreCRAM_MD5_IMAP_Flag		kDSNativeAttrTypePrefix"require_cram_md5_imap_flag"
#define		kConnPerIMAPAcctPerIPvalue		kDSNativeAttrTypePrefix"conn_per_imap_acct_per_ip_value"
#define		kIMAPConnTimeoutValue			kDSNativeAttrTypePrefix"imap_conn_timeout_value"
#define		kMsgExpirationValue				kDSNativeAttrTypePrefix"msg_expire_value"
#define		kMsgExpireWarningValue			kDSNativeAttrTypePrefix"msg_expire_warning_value"
#define		kFwdAllMailToFlag				kDSNativeAttrTypePrefix"fwd_all_mail_to_flag"
#define		kFwdAllMailToUser				kDSNativeAttrTypePrefix"fwd_all_mail_to_user"
#define		kDNSCachePopupValue				kDSNativeAttrTypePrefix"dsn_cache_popup_value"
#define		kRespectTTLFlag					kDSNativeAttrTypePrefix"respect_ttl_flag"
#define		kDSNCacheDeltaValue				kDSNativeAttrTypePrefix"dns_cache_delta_value"
#define		kResolveMXListFlag				kDSNativeAttrTypePrefix"resolve_mx_list_flag"
#define		kResolveARecordFlag				kDSNativeAttrTypePrefix"resolve_a_record_flag"
#define		kCheckMaxMsgSizeFlag			kDSNativeAttrTypePrefix"check_max_msg_size_flag"
#define		kWarnSenderFlag					kDSNativeAttrTypePrefix"warn_sender_flag"
#define		kWarnPostasterFlag				kDSNativeAttrTypePrefix"warn_postmaster_flag"
#define		kOpenTimeoutValue				kDSNativeAttrTypePrefix"open_timeout_value"
#define		kReadWriteTimeoutValue			kDSNativeAttrTypePrefix"read_write_timeout_value"

#define		kServerLogBitMapValue			kDSNativeAttrTypePrefix"server_log_bit_map_value"
#define		kErrorLogBitMapValue			kDSNativeAttrTypePrefix"error_log_bit_map_value"

#define		kRequireAPOPFlag				kDSNativeAttrTypePrefix"require_apop_flag"
#define		kRequireSMTP_CRAM_MD5_Flag		kDSNativeAttrTypePrefix"smtp_cram_md5_flag"
#define		kAllowPlainLoginFlag			kDSNativeAttrTypePrefix"smtp_plain_login_flag"
#define		kAlternateDBLocationFlag		kDSNativeAttrTypePrefix"alternate_db_location_flag"
#define		kAlternateDBLocationValue		kDSNativeAttrTypePrefix"alternate_db_location_value"
#define		kAllowedRelayServerFlag			kDSNativeAttrTypePrefix"open_relay_addr_flag"
#define		kAllowedRelayServerList			kDSNativeAttrTypePrefix"open_relay_addr_list"

#define		kAltInboxLocationValue			kDSNativeAttrTypePrefix"alt_inbox_loc_value"
#define		kInboxDelimiterValue			kDSNativeAttrTypePrefix"msg_delimiter_value"

#define		kDiskThresholdLowValue			kDSNativeAttrTypePrefix"disk_threshold_percent_low_value"
#define		kDiskThresholdMediumValue		kDSNativeAttrTypePrefix"disk_threshold_percent_med_value"
#define		kDiskThresholdHighValue			kDSNativeAttrTypePrefix"disk_threshold_percent_high_value"
#define		kDiskQuotaCheckIntervalValue	kDSNativeAttrTypePrefix"disk_quota_check_seconds_value"

#define		kKerberosOptionsPopupValue		kDSNativeAttrTypePrefix"kerberos_options_value"

#define		kAllowTempSSLCertsFlag			kDSNativeAttrTypePrefix"allow_temp_SSL_certs_flag"

static const	uInt32		kMaxMessageSize	= 10240;


// --------------------------------------------------------------------------------
//	* DSServerPrefs ()
//
// --------------------------------------------------------------------------------

DSServerPrefs::DSServerPrefs ( void )
{
	uInt32		i		= 0;

	fNodeRef					= 0;
	fRecordRef					= 0;
	fDirRef						= 0;
	fNodeBuff					= nil;

	// Protocol Greetings
	fSMTP_InGreeting			= nil;
	fSMTP_OutGreeting			= nil;
	fPOP3_Greeting				= nil;
	fIMAP_Greeting				= nil;
	fASIA_Greeting				= nil;

	fOurLastIPAddress			= 0;

	fMaxMessageSizeFlag			= false;
	fMaxMessageSizeValue		= kMaxMessageSize;

	fBCC_Flag					= false;
	fBCC_User					= nil;
	fBCC_UserStruct				= nil;

	fAutoMailDeleteFlag			= false;
	fDeleteUnseenDays			= 120;
	fDeleteSeenDays				= 90;

	fFWDUnknownLocalFlag		= false;
	fFWDUnknownLocalUser		= nil;
	fFWDUnknownLocalUserStruct	= nil;

	fCheckSMTP_InFlag			= false;

	fUseDefaultSpamServerFlag	= false;
	fDefaultSpamServer			= nil;

	fUseCustomSpamServersFlag	= false;
	fCustomSpamServerList		= nil;

	fLogIfBadSMTPNameFlag		= false;
	fRejectIfBadNameFlag		= false;

	fRequireLocalFromFlag		= false;

	fRejectIfNotInHostListFlag	= false;
	fRejectSMTPHostList			= nil;

	fSMTP_InState				= kSMTPStateAppleMail;

	fSMTP_InEnabled				= true;
	fSMTP_InPortNumber			= 25;

	fSMTP_OutEnabled			= true;
	fSMTP_OutPortNumber			= 25;

	fIMAP_Enabled				= true;
	fIMAP_PortNumber			= 143;

	fPOP_Enabled				= true;
	fPOP_PortNumber				= 110;

	fNotifyMail_Enabled			= true;
	fNotifyMail_PortNumber		= 79;

	fAdminPort_Enabled			= true;
	fAdminPort_PortNumber		= 626;

	fSMTPRelayWhenBackupFlag	= false;
	fSendUndelivNDRToPMFlag		= false;
	fAllowNDRsBulkMailFlag		= false;

	fCaseSensativeFldrNameFlag	= false;
	fRequreCRAM_MD5_IMAP_Flag	= false;

	fConnPerIMAPAcctPerIP		= 32;
	fIMAPConnIdleTimeout		= 30;	// In minutes

	for ( i = 0; i < kMaxBitMapLogEntries; i++ )
	{
		fMSPServerLogMessageBitMap[ i ] = 0;
		fMSPErrorLogMessageBitMap[ i ]  = 0;
	}

//	for ( i = kSLStartTransLogMsgs; i <= kSLEndTransLogMsgs; i++ )
//	{
//		this->ClearLogMsgBit( kAServerLogType, i );
//	}

// Standard - 'Mail In' panel
	fMSPStdMailInForwardMailForUnknownLocalUsersChk		= false;
	fMSPStdMailInDontAllowAutoHostEntryCreationChk		= false;

// Standard - 'Mail Out' panel
	fMSPStdMailOutHoldOutgoingMailBtn					= false;
	fMSPStdMailOutWarnSenderOfNonDeliveryAfterBtn		= true;
	fMSPStdMailOutMessageExpiresAfterEdit				= 72;
	fMSPStdMailOutWarnSenderOfNonDeliveryAfterEdit		= 4;
	fMSPStdMailOutWarnPostmasterOfNonDeliveryAfterBtn	= false;
	fMSPStdMailOutForwardAllMailToChk					= false;
	fMSPStdMailOutForwardAllMailToEdit					= nil;

// Advanced - 'Network' panel
	fMSPAdvNetworkDNSPopup								= 1;
	fMSPAdvNetworkResolveMXListChk						= true;
	fMSPAdvNetworkResolveDNSARecordChk					= true;
	fMSPAdvNetworkOpenConnectionTimeoutEdit				= 120;
	fMSPAdvNetworkReadWriteTimeoutEdit					= 120;
	fMSPAdvNetworkRespectTimeToLiveBtn					= true;
	fMSPAdvNetworkCacheDNSInformationBtn				= false;
	fMSPAdvNetworkCacheDNSInformationForEdit			= 720;

	fMSPAdvMiscFlagsByte1		= 0;
	fMSPAdvMiscFlagsByte1	   |= kMSSFDeleteAllEmptyDefaultHostsChk;

	// New valuses
	fRequireAPOPFlag			= false;
	fRequireSMTP_CRAM_MD5_Flag	= false;
	fAllowOther_SMTP_AuthFlag	= false;
	fUseAltDBLocationFlag		= false;
	fAltDBLocationValue			= nil;
	fAltInboxLocationValue		= nil;
	fInboxDelimiterValue		= nil;
	fAllowedRelayList			= nil;
	fAllowedRelayFlag			= true;

	fDiskThresholdPercentLow	= 75;
	fDiskThresholdPercentMedium	= 85;
	fDiskThresholdPercentHigh	= 95;

	fDiskQuotaCheckInterval		= 60 * 60 * 24;

	fKerberosState				= kKerberosStateOff;

	fAllowTempSSLCertsFlag		= false;

} // DSServerPrefs


// --------------------------------------------------------------------------------
//	* ~DSServerPrefs ()
//
// --------------------------------------------------------------------------------

DSServerPrefs::~DSServerPrefs ( void )
{
	if ( fSMTP_InGreeting != nil )
	{
		free( fSMTP_InGreeting );
		fSMTP_InGreeting = nil;
	}

	if ( fSMTP_OutGreeting != nil )
	{
		free( fSMTP_OutGreeting );
		fSMTP_OutGreeting = nil;
	}

	if ( fPOP3_Greeting != nil )
	{
		free( fPOP3_Greeting );
		fPOP3_Greeting = nil;
	}

	if ( fIMAP_Greeting != nil )
	{
		free( fIMAP_Greeting );
		fIMAP_Greeting = nil;
	}

	if ( fCustomSpamServerList != nil )
	{
		CString::FreeStringList( &fCustomSpamServerList );
		fCustomSpamServerList = nil;
	}

	if ( fAllowedRelayList != nil )
	{
		CString::FreeStringList( &fAllowedRelayList );
		fAllowedRelayList = nil;
	}

	if ( fRejectSMTPHostList != nil )
	{
		CString::FreeStringList( &fRejectSMTPHostList );
		fRejectSMTPHostList = nil;
	}

	if ( fRecordRef != 0 )
	{
		(void)::dsCloseRecord( fRecordRef );
		fRecordRef = 0;
	}
} // ~DSServerPrefs


// --------------------------------------------------------------------------------
//	* GetSMTP_InGreeting ()
//
//		- CServerPrefs::GetSMTPResponseName
//
// --------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetSMTP_InGreeting ( CString &outStr, Bool inForceRead )
{
	tDirStatus			dsStatus	= eDSNoErr;
	const char		   *pTmpStr		= nil;

	if ( (inForceRead == true) && (fSMTP_InGreeting != nil) )
	{
		free( fSMTP_InGreeting );
		fSMTP_InGreeting = nil;
	}

	if ( fSMTP_InGreeting != nil )
	{
		outStr.Set( fSMTP_InGreeting );
	}
	else
	{
		dsStatus = this->GetAttributeValue( kSMTP_InGreeting, outStr );
		if ( (dsStatus != eDSNoErr) || (outStr.GetLength() == 0) )
		{
//			pTmpStr = CNetworkUtilities::GetOurDNSName( kPrimaryIPAddr );
//			outStr.Set( pTmpStr );
		}

		fSMTP_InGreeting = (char *)::malloc( outStr.GetLength() + 2 );
		CUtils::Strcpy( fSMTP_InGreeting, outStr.GetData() );
	}

	return( dsStatus );

} // GetSMTP_InGreeting


// --------------------------------------------------------------------------------
//	* SetSMTP_InGreeting ()
//
//		- CServerPrefs::SetSMTPResponseName
//
// --------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetSMTP_InGreeting ( const char *inStr, Bool inForceWrite )
{
	tDirStatus				dsStatus		= eDSNoErr;

	if ( inStr != nil )
	{
		if ( (inForceWrite == true) || (fSMTP_InGreeting == nil) )
		{
			dsStatus = this->SetAttributeValue( kSMTP_InGreeting, inStr );
		}
		else if ( fSMTP_InGreeting != nil )
		{
			if ( CUtils::Strcmp( fSMTP_InGreeting, inStr ) != 0 )
			{
				dsStatus = this->SetAttributeValue( kSMTP_InGreeting, inStr );
			}
		}

		if ( fSMTP_InGreeting != nil )
		{
			if ( CUtils::Strcmp( fSMTP_InGreeting, inStr ) != 0 )
			{
				free( fSMTP_InGreeting );
				fSMTP_InGreeting = nil;
			}
		}

		if ( fSMTP_InGreeting == nil )
		{
			fSMTP_InGreeting = (char *)::malloc( CUtils::Strlen( inStr ) + 2 );
			CUtils::Strcpy( fSMTP_InGreeting, inStr );
		}
	}

	return( dsStatus );

} // SetSMTP_InGreeting


// --------------------------------------------------------------------------------
//	* GetSMTP_OutGreeting ()
//
//		- CServerPrefs::GetSMTPOutResponseName
//
// --------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetSMTP_OutGreeting ( CString &outStr, Bool inForceRead )
{
	tDirStatus			dsStatus	= eDSNoErr;
	const char		   *pTmpStr		= nil;

	if ( (inForceRead == true) && (fSMTP_OutGreeting != nil) )
	{
		free( fSMTP_OutGreeting );
		fSMTP_OutGreeting = nil;
	}

	if ( fSMTP_OutGreeting != nil )
	{
		outStr.Set( fSMTP_OutGreeting );
	}
	else
	{
		dsStatus = this->GetAttributeValue( kSMTP_OutGreeting, outStr );
		if ( (dsStatus != eDSNoErr) || (outStr.GetLength() == 0) )
		{
//			pTmpStr = CNetworkUtilities::GetOurDNSName( kPrimaryIPAddr );
//			outStr.Set( pTmpStr );
		}

		fSMTP_OutGreeting = (char *)::malloc( outStr.GetLength() + 2 );
		CUtils::Strcpy( fSMTP_OutGreeting, outStr.GetData() );
	}
	return( dsStatus );

} // GetSMTP_OutGreeting


// --------------------------------------------------------------------------------
//	* SetSMTP_OutGreeting ()
//
//		- CServerPrefs::SetSMTPOutResponseName
//
// --------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetSMTP_OutGreeting ( const char *inStr, Bool inForceWrite )
{
	tDirStatus				dsStatus		= eDSNoErr;

	if ( inStr != nil )
	{
		if ( (inForceWrite == true) || (fSMTP_OutGreeting == nil) )
		{
			dsStatus = this->SetAttributeValue( kSMTP_OutGreeting, inStr );
		}
		else if ( fSMTP_OutGreeting != nil )
		{
			if ( CUtils::Strcmp( fSMTP_OutGreeting, inStr ) != 0 )
			{
				dsStatus = this->SetAttributeValue( kSMTP_OutGreeting, inStr );
			}
		}

		if ( fSMTP_OutGreeting != nil )
		{
			if ( CUtils::Strcmp( fSMTP_OutGreeting, inStr ) != 0 )
			{
				free( fSMTP_OutGreeting );
				fSMTP_OutGreeting = nil;
			}
		}

		if ( fSMTP_OutGreeting == nil )
		{
			fSMTP_OutGreeting = (char *)::malloc( CUtils::Strlen( inStr ) + 2 );
			CUtils::Strcpy( fSMTP_OutGreeting, inStr );
		}
	}

	return( dsStatus );

} // SetSMTP_OutGreeting


// --------------------------------------------------------------------------------
//	* GetPOP3_Greeting ()
//
//		- CServerPrefs::GetPOP3ResponseName
//
// --------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetPOP3_Greeting ( CString &outStr, Bool inForceRead )
{
	tDirStatus			dsStatus	= eDSNoErr;
	const char		   *pTmpStr		= nil;

	if ( (inForceRead == true) && (fPOP3_Greeting != nil) )
	{
		free( fPOP3_Greeting );
		fPOP3_Greeting = nil;
	}

	if ( fPOP3_Greeting != nil )
	{
		outStr.Set( fPOP3_Greeting );
	}
	else
	{
		dsStatus = this->GetAttributeValue( kPOP3_Greeting, outStr );
		if ( (dsStatus != eDSNoErr) || (outStr.GetLength() == 0) )
		{
//			pTmpStr = CNetworkUtilities::GetOurDNSName( kPrimaryIPAddr );
//			outStr.Set( pTmpStr );
		}

		fPOP3_Greeting = (char *)::malloc( outStr.GetLength() + 2 );
		CUtils::Strcpy( fPOP3_Greeting, outStr.GetData() );
	}
	return( dsStatus );

} // GetPOP3_Greeting


// --------------------------------------------------------------------------------
//	* SetPOP3_Greeting ()
//
//		- CServerPrefs::SetPOP3ResponseName
//
// --------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetPOP3_Greeting ( const char *inStr, Bool inForceWrite )
{
	tDirStatus				dsStatus		= eDSNoErr;

	if ( inStr != nil )
	{
		if ( (inForceWrite == true) || (fPOP3_Greeting == nil) )
		{
			dsStatus = this->SetAttributeValue( kPOP3_Greeting, inStr );
		}
		else if ( fPOP3_Greeting != nil )
		{
			if ( CUtils::Strcmp( fPOP3_Greeting, inStr ) != 0 )
			{
				dsStatus = this->SetAttributeValue( kPOP3_Greeting, inStr );
			}
		}

		if ( fPOP3_Greeting != nil )
		{
			if ( CUtils::Strcmp( fPOP3_Greeting, inStr ) != 0 )
			{
				free( fPOP3_Greeting );
				fPOP3_Greeting = nil;
			}
		}

		if ( fPOP3_Greeting == nil )
		{
			fPOP3_Greeting = (char *)::malloc( CUtils::Strlen( inStr ) + 2 );
			CUtils::Strcpy( fPOP3_Greeting, inStr );
		}
	}

	return( dsStatus );

} // SetPOP3_Greeting


// --------------------------------------------------------------------------------
//	* GetIMAP_Greeting ()
//
//		- CServerPrefs::GetIMAPResponseName
//
// --------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetIMAP_Greeting ( CString &outStr, Bool inForceRead )
{
	tDirStatus			dsStatus	= eDSNoErr;
	const char		   *pTmpStr		= nil;

	if ( (inForceRead == true) && (fIMAP_Greeting != nil) )
	{
		free( fIMAP_Greeting );
		fIMAP_Greeting = nil;
	}

	if ( fIMAP_Greeting != nil )
	{
		outStr.Set( fIMAP_Greeting );
	}
	else
	{
		dsStatus = this->GetAttributeValue( kIMAP_Greeting, outStr );
		if ( (dsStatus != eDSNoErr) || (outStr.GetLength() == 0) )
		{
//			pTmpStr = CNetworkUtilities::GetOurDNSName( kPrimaryIPAddr );
//			outStr.Set( pTmpStr );
		}

		fIMAP_Greeting = (char *)::malloc( outStr.GetLength() + 2 );
		CUtils::Strcpy( fIMAP_Greeting, outStr.GetData() );
	}

	return( dsStatus );

} // GetIMAP_Greeting


// --------------------------------------------------------------------------------
//	* SetIMAP_Greeting ()
//
//		- CServerPrefs::SetIMAPResponseName
//
// --------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetIMAP_Greeting ( const char *inStr, Bool inForceWrite )
{
	tDirStatus				dsStatus		= eDSNoErr;

	if ( inStr != nil )
	{
		if ( (inForceWrite == true) || (fIMAP_Greeting == nil) )
		{
			dsStatus = this->SetAttributeValue( kIMAP_Greeting, inStr );
		}
		else if ( fIMAP_Greeting != nil )
		{
			if ( CUtils::Strcmp( fIMAP_Greeting, inStr ) != 0 )
			{
				dsStatus = this->SetAttributeValue( kIMAP_Greeting, inStr );
			}
		}

		if ( fIMAP_Greeting != nil )
		{
			if ( CUtils::Strcmp( fIMAP_Greeting, inStr ) != 0 )
			{
				free( fIMAP_Greeting );
				fIMAP_Greeting = nil;
			}
		}

		if ( fIMAP_Greeting == nil )
		{
			fIMAP_Greeting = (char *)::malloc( CUtils::Strlen( inStr ) + 2 );
			CUtils::Strcpy( fIMAP_Greeting, inStr );
		}
	}

	return( dsStatus );

} // SetIMAP_Greeting


//--------------------------------------------------------------------------------------------------
//	* GetOurLastIPAddr ()
//
//		- uInt32 CServerPrefs::GetOurLastIPAddr( void )
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetOurLastIPAddr ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fOurLastIPAddress, kLastIPAddress, outValue, inForceRead );

	return( dsStatus );

} // GetOurLastIPAddr


//--------------------------------------------------------------------------------------------------
//	* SetOurLastIPAddr ()
//
//		- void CServerPrefs::SetOurLastIPAddr ( const uInt32 inIPAddr )
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetOurLastIPAddr ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetValueMember( fOurLastIPAddress, kLastIPAddress, inValue, inForceWrite );

	return( dsStatus );

} // SetOurLastIPAddr


//--------------------------------------------------------------------------------------------------
//	* GetMaxMessageSizeFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetMaxMessageSizeFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fMaxMessageSizeFlag, kMaxMsgSizeFlag, outFlag, inForceRead );

	return( dsStatus );

} // GetMaxMessageSizeFlag


//--------------------------------------------------------------------------------------------------
//	* SetMaxMessageSizeFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetMaxMessageSizeFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fMaxMessageSizeFlag, kMaxMsgSizeFlag, inFlag, inForceWrite );

	return( dsStatus );

} // SetMaxMessageSizeFlag


//--------------------------------------------------------------------------------------------------
//	* GetMaxMessageSize ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetMaxMessageSize ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fMaxMessageSizeValue, kMaxMsgSizeValue, outValue, inForceRead );

	return( dsStatus );

} // GetMaxMessageSize


//--------------------------------------------------------------------------------------------------
//	* SetMaxMessageSize ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetMaxMessageSize ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetValueMember( fMaxMessageSizeValue, kMaxMsgSizeValue, inValue, inForceWrite );

	return( dsStatus );

} // SetMaxMessageSize


//--------------------------------------------------------------------------------------------------
//	* GetBCC_Flag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetBCC_Flag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fBCC_Flag, kBCC_Flag, outFlag, inForceRead );

	return( dsStatus );

} // GetBCC_Flag


//--------------------------------------------------------------------------------------------------
//	* SetBCC_Flag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetBCC_Flag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fBCC_Flag, kBCC_Flag, inFlag, inForceWrite );

	return( dsStatus );

} // SetBCC_Flag


//--------------------------------------------------------------------------------------------------
//	* GetBCC_User ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetBCC_User ( CString &outStr, Bool inForceRead )
{
	tDirStatus		dsStatus	= eDSNoErr;
	const char	   *pTmpStr		= nil;

	dsStatus = this->GetEmailAddrMember( fBCC_User, kBCC_User, outStr, inForceRead );

	return( dsStatus );

} // GetBCC_User


//--------------------------------------------------------------------------------------------------
//	* SetBCC_User ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetBCC_User ( const char *inStr, Bool inForceWrite )
{
	tDirStatus		dsStatus	= eDSNoErr;

	dsStatus = this->SetEmailAddrMember( fBCC_User, kBCC_User, inStr, inForceWrite );

	return( dsStatus );

} // SetBCC_User


//--------------------------------------------------------------------------------------------------
//	* GetBCC_UserStruct ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetBCC_UserStruct ( UserStruct *inUserInfo, Bool inForceRead )
{
	tDirStatus		dsStatus	= eDSNoErr;

	if ( inUserInfo != nil )
	{
		dsStatus = GetUserStructMember( fBCC_UserStruct, kBCC_UserStructRecName, inUserInfo, inForceRead );
	}

	return( dsStatus );

} // GetBCC_UserStruct


//--------------------------------------------------------------------------------------------------
//	* SetBCC_UserStruct
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetBCC_UserStruct ( const UserStruct *inUserInfo, Bool inForceWrite )
{
	tDirStatus		dsStatus	= eDSNoErr;

	if ( inUserInfo != nil )
	{
		dsStatus = SetUserStructMember( fBCC_UserStruct, kBCC_UserStructRecName, inUserInfo, inForceWrite );
	}

	return( dsStatus );

} // SetBCC_UserStruct


//--------------------------------------------------------------------------------------------------
//	* GetBCCName ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetBCCName ( CString &outStr )
{
	tDirStatus		dsStatus	= eDSNoErr;

	if ( fBCC_UserStruct == nil )
	{
		dsStatus = this->GetBCC_UserStruct( nil );
	}

	if ( (fBCC_UserStruct != nil) && (dsStatus == eDSNoErr) )
	{
		if ( (fBCC_UserStruct->fID != 0) && (fBCC_UserStruct->fUserName[ 0 ] != '\0') )
		{
			outStr.Set( &fBCC_UserStruct->fUserName[ 1 ], fBCC_UserStruct->fUserName[ 0 ] );
		}
	}

	return( dsStatus );
	
} // GetBCCName


//--------------------------------------------------------------------------------------------------
//	* GetAutoMailDeleteFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetAutoMailDeleteFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fAutoMailDeleteFlag, kAutoDeleteFlag, outFlag, inForceRead );

	return( dsStatus );

} // GetAutoMailDeleteFlag


//--------------------------------------------------------------------------------------------------
//	* SetAutoMailDeleteFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetAutoMailDeleteFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fAutoMailDeleteFlag, kAutoDeleteFlag, inFlag, inForceWrite );

	return( dsStatus );

} // SetAutoMailDeleteFlag


//--------------------------------------------------------------------------------------------------
//	* GetDeleteUnseenDays ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetDeleteUnseenDays ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fDeleteUnseenDays, kUnseenDays, outValue, inForceRead );

	return( dsStatus );

} // GetDeleteUnseenDays


//--------------------------------------------------------------------------------------------------
//	* SetDeleteUnseenDays ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetDeleteUnseenDays ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetValueMember( fDeleteUnseenDays, kUnseenDays, inValue, inForceWrite );

	return( dsStatus );

} // SetDeleteUnseenDays


//--------------------------------------------------------------------------------------------------
//	* GetDeleteSeenDays ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetDeleteSeenDays ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fDeleteSeenDays, kSeenDays, outValue, inForceRead );

	return( dsStatus );

} // GetDeleteSeenDays


//--------------------------------------------------------------------------------------------------
//	* SetDeleteSeenDays ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetDeleteSeenDays ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetValueMember( fDeleteSeenDays, kSeenDays, inValue, inForceWrite );

	return( dsStatus );

} // SetDeleteSeenDays


//--------------------------------------------------------------------------------------------------
//	* GetFWDUnknownLoalUserFlag
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetFWDUnknownLoalUserFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fFWDUnknownLocalFlag, kFwdUnknownLocalUserFlag, outFlag, inForceRead );

	return( dsStatus );

} // GetFWDUnknownLoalUserFlag


//--------------------------------------------------------------------------------------------------
//	* SetFWDUnknownLoalUserFlag
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetFWDUnknownLoalUserFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fFWDUnknownLocalFlag, kFwdUnknownLocalUserFlag, inFlag, inForceWrite );

	if ( fMSPStdMailInForwardMailForUnknownLocalUsersChk != inFlag )
	{
		fMSPStdMailInForwardMailForUnknownLocalUsersChk = inFlag;
	}

	return( dsStatus );

} // SetFWDUnknownLoalUserFlag


//--------------------------------------------------------------------------------------------------
//	* GetFWDUnknownLoalUserUserStruct ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetFWDUnknownLoalUserUserStruct ( UserStruct *inUserInfo, Bool inForceRead )
{
	tDirStatus		dsStatus	= eDSNoErr;

	if ( inUserInfo != nil )
	{
		dsStatus = GetUserStructMember( fFWDUnknownLocalUserStruct, kFwdLocalUserStructRecName, inUserInfo, inForceRead );
	}

	return( dsStatus );

} // GetFWDUnknownLoalUserUserStruct


//--------------------------------------------------------------------------------------------------
//	* SetFWDUnknownLoalUserUserStruct ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetFWDUnknownLoalUserUserStruct ( const UserStruct *inUserInfo, Bool inForceWrite )
{
	tDirStatus		dsStatus	= eDSNoErr;

	if ( inUserInfo != nil )
	{
		dsStatus = SetUserStructMember( fFWDUnknownLocalUserStruct, kFwdLocalUserStructRecName, inUserInfo, inForceWrite );
	}

	return( dsStatus );

} // SetFWDUnknownLoalUserUserStruct


//--------------------------------------------------------------------------------------------------
//	* GetFWDUnknownLoalUser ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetFWDUnknownLoalUser ( CString &outStr, Bool inForceRead )
{
	tDirStatus		dsStatus	= eDSNoErr;
	const char	   *pTmpStr		= nil;

	dsStatus = this->GetEmailAddrMember( fFWDUnknownLocalUser, kFwdUnknownLocalUser, outStr, inForceRead );

	return( dsStatus );

} // GetFWDUnknownLoalUser


//--------------------------------------------------------------------------------------------------
//	* SetFWDUnknownLoalUser ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetFWDUnknownLoalUser ( const char *inStr, Bool inForceWrite )
{
	tDirStatus		dsStatus	= eDSNoErr;

	dsStatus = this->SetEmailAddrMember( fFWDUnknownLocalUser, kFwdUnknownLocalUser, inStr, inForceWrite );

	return( dsStatus );

} // SetFWDUnknownLoalUser


//--------------------------------------------------------------------------------------------------
//	* GetAnyUserName ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetAnyUserName ( CString &outStr )
{
	tDirStatus		dsStatus	= eDSNoErr;

	if ( fFWDUnknownLocalUserStruct == nil )
	{
		dsStatus = this->GetFWDUnknownLoalUserUserStruct( nil );
	}

	if ( (fFWDUnknownLocalUserStruct != nil) && (dsStatus == eDSNoErr) )
	{
		if ( (fFWDUnknownLocalUserStruct->fID != 0) && (fFWDUnknownLocalUserStruct->fUserName[ 0 ] != '\0') )
		{
			outStr.Set( &fFWDUnknownLocalUserStruct->fUserName[ 1 ], fFWDUnknownLocalUserStruct->fUserName[ 0 ] );
		}
	}

	return( dsStatus );
	
} // GetAnyUserName


//--------------------------------------------------------------------------------------------------
//	* GetUseBlackholeServerFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetUseBlackholeServerFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fCheckSMTP_InFlag, kUseBlackholeServerFlag, outFlag, inForceRead );

	return( dsStatus );

} // GetUseBlackholeServerFlag


//--------------------------------------------------------------------------------------------------
//	* SetUseBlackholeServerFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetUseBlackholeServerFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fCheckSMTP_InFlag, kUseBlackholeServerFlag, inFlag, inForceWrite );

//	SetDoRBLSMTPConnFlag( inFlag );

	return( dsStatus );

} // SetUseBlackholeServerFlag


//--------------------------------------------------------------------------------------------------
//	* GetBlackholeServerName ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetBlackholeServerName ( CString &outStr, Bool inForceRead )
{
	tDirStatus			dsStatus	= eDSNoErr;

	dsStatus = this->GetStringMember( fDefaultSpamServer, kBlackholeServerName, outStr, inForceRead );
	if ( dsStatus == eDSAttributeNotFound )
	{
		outStr.Set( "" );
		dsStatus = this->SetAttributeValue( kBlackholeServerName, outStr.GetData() );
	}

	return( dsStatus );

} // GetBlackholeServerName


//--------------------------------------------------------------------------------------------------
//	* SetBlackholeServerName ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetBlackholeServerName ( const char *inStr, Bool inForceWrite )
{
	tDirStatus			dsStatus	= eDSNoErr;

	dsStatus = SetStringMember( fDefaultSpamServer, kBlackholeServerName, inStr, inForceWrite );

	return( dsStatus );

} // SetBlackholeServerName


//--------------------------------------------------------------------------------------------------
//	* GetCustomSpamServerList
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetCustomSpamServerList ( StrListObj **outStrList, Bool inForceRead )
{
	tDirStatus			dsStatus	= eDSNoErr;
	const char		   *pTmpStr		= nil;

	if ( (inForceRead == true) && (fCustomSpamServerList != nil) )
	{
		CString::FreeStringList( &fCustomSpamServerList );
		fCustomSpamServerList = nil;
	}

	if ( fCustomSpamServerList != nil )
	{
		CString::DuplicateStringList( outStrList, fCustomSpamServerList );
	}
	else
	{
		dsStatus = this->GetAttributeValues( kCustomSpamServerList, &fCustomSpamServerList );
		if ( dsStatus == eDSNoErr )
		{
			CString::DuplicateStringList( outStrList, fCustomSpamServerList );
		}
	}

	return( dsStatus );

} // GetCustomSpamServerList


//--------------------------------------------------------------------------------------------------
//	* SetCustomSpamServerList
//
//--------------------------------------------------------------------------------------------------

//void CServerPrefs::SetCustomSpamServerList ( const char *inSrvrName, uInt32 inLen )
//{
//	uInt32		uiStrLen	= inLen;
//	CString		legacy( 128 );
//
//
//	if ( (inSrvrName != nil) && (inLen != 0) )
//	{
//		if ( uiStrLen > kStrSize )
//		{
//			uiStrLen = kStrSize - 1;
//		}
//
//		::memset( fServerPrefsData.fPrefsData.fCustomSpamSrvr, 0, kStrSize ); 
//		::memcpy( fServerPrefsData.fPrefsData.fCustomSpamSrvr, inSrvrName, inLen );
//
//		// - This is for legacy support and will be deleted soon
//		legacy.Set( inSrvrName, inLen );
//		SetCustomRBLDomainName( legacy );
//		
//		this->SetDirty();
//	}
//} // SetCustomSpamServerList


//--------------------------------------------------------------------------------------------------
//	* GetLogIfBadSMTPNameFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetLogIfBadSMTPNameFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fLogIfBadSMTPNameFlag, kLogBad_SMTP_NamesFlag, outFlag, inForceRead );

	return( dsStatus );

} // GetLogIfBadSMTPNameFlag


//--------------------------------------------------------------------------------------------------
//	* SetLogIfBadSMTPNameFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetLogIfBadSMTPNameFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fLogIfBadSMTPNameFlag, kLogBad_SMTP_NamesFlag, inFlag, inForceWrite );

	return( dsStatus );

} // SetLogIfBadSMTPNameFlag


//--------------------------------------------------------------------------------------------------
//	* GetRejectIfNameNoMatchFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetRejectIfNameNoMatchFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fRejectIfBadNameFlag, kRejectBad_SMTP_NamesFlag, outFlag, inForceRead );

	return( dsStatus );

} // GetRejectIfNameNoMatchFlag


//--------------------------------------------------------------------------------------------------
//	* SetRejectIfNameNoMatchFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetRejectIfNameNoMatchFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fRejectIfBadNameFlag, kRejectBad_SMTP_NamesFlag, inFlag, inForceWrite );

	return( dsStatus );

} // SetRejectIfNameNoMatchFlag


//--------------------------------------------------------------------------------------------------
//	* GetRequireLocalFromFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetRequireLocalFromFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fRequireLocalFromFlag, kRequireLocalFrom, outFlag, inForceRead );

	return( dsStatus );

} // GetRequireLocalFromFlag


//--------------------------------------------------------------------------------------------------
//	* SetRequireLocalFromFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetRequireLocalFromFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fRequireLocalFromFlag, kRequireLocalFrom, inFlag, inForceWrite );

	return( dsStatus );

} // SetRequireLocalFromFlag


//--------------------------------------------------------------------------------------------------
//	* GetSMTPRejectServerFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetSMTPRejectServerFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fRejectIfNotInHostListFlag, kRejectIfNotInHostListFlag, outFlag, inForceRead );

	return( dsStatus );

} // GetSMTPRejectServerFlag


//--------------------------------------------------------------------------------------------------
//	* SetSMTPRejectServerFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetSMTPRejectServerFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fRejectIfNotInHostListFlag, kRejectIfNotInHostListFlag, inFlag, inForceWrite );

	return( dsStatus );

} // SetSMTPRejectServerFlag


//--------------------------------------------------------------------------------------------------
//	* GetSMTPRejectServerList ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetSMTPRejectServerList ( StrListObj **outStrList, Bool inForceRead )
{
	tDirStatus			dsStatus	= eDSNoErr;
	const char		   *pTmpStr		= nil;

	if ( (inForceRead == true) && (fRejectSMTPHostList != nil) )
	{
		CString::FreeStringList( &fRejectSMTPHostList );
		fRejectSMTPHostList = nil;
	}

	if ( fRejectSMTPHostList != nil )
	{
		CString::DuplicateStringList( outStrList, fRejectSMTPHostList );
	}
	else
	{
		dsStatus = this->GetAttributeValues( kRejectSMTPHostList, &fRejectSMTPHostList );
		if ( dsStatus == eDSNoErr )
		{
			CString::DuplicateStringList( outStrList, fRejectSMTPHostList );
		}
	}

	return( dsStatus );

} // GetSMTPRejectServerList


//--------------------------------------------------------------------------------------------------
//	* SetSMTPRejectServerList ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetSMTPRejectServerList ( const StrListObj *inStrList, Bool inForceWrite )
{
		  tDirStatus	dsStatus	= eDSNoErr;
	const StrListObj   *pStrObj		= nil;

	ResetAttribute( kRejectSMTPHostList );
	
	pStrObj = inStrList;
	while ( pStrObj != nil )
	{
		if ( pStrObj->fString != nil )
		{
			dsStatus = this->AddAttributeValue( kRejectSMTPHostList, pStrObj->fString );
		}
		pStrObj = pStrObj->fNext;
	}

	if ( fRejectSMTPHostList != nil )
	{
		CString::FreeStringList( &fRejectSMTPHostList );
		fRejectSMTPHostList = nil;
	}

	dsStatus = this->GetAttributeValues( kRejectSMTPHostList, &fRejectSMTPHostList );

	return( dsStatus );

} // SetSMTPRejectServerList


//--------------------------------------------------------------------------------------------------
//	* AddSMTPRejectServer ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::AddSMTPRejectServer ( const char *inStr, Bool inForceWrite )
{
	tDirStatus			dsStatus	= eDSNoErr;

	dsStatus = this->AddAttributeValue( kRejectSMTPHostList, inStr );

	return( dsStatus );

} // AddSMTPRejectServer


//--------------------------------------------------------------------------------------------------
//	* RemoveSMTPRejectFromList ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::RemoveSMTPRejectFromList ( const char *inStr, Bool inForceWrite )
{
	tDirStatus			dsStatus	= eDSNoErr;

	dsStatus = this->RemoveAttributeValue( kRejectSMTPHostList, inStr );

	if ( fAllowedRelayList != nil )
	{
		CString::FreeStringList( &fAllowedRelayList );
		fAllowedRelayList = nil;
	}

	return( dsStatus );

} // RemoveSMTPRejectFromList


//--------------------------------------------------------------------------------------------------
//	* GetSMTP_State ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetSMTP_State ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fSMTP_InState, kSMTP_OptionsPopupValue, outValue, inForceRead );

	return( dsStatus );

} // GetSMTP_State


//--------------------------------------------------------------------------------------------------
//	* SetSMTP_State ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetSMTP_State ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	if ( (fSMTP_InState != inValue) || (inForceWrite == true) )
	{
		if ( inValue == kSMTPStateAppleMail )
		{
			// Enable Apple Mail SMTP
			this->SetSMTP_EnabledFlag( true );

			dsStatus = this->SetValueMember( fSMTP_InState, kSMTP_OptionsPopupValue, inValue, inForceWrite );
		}
		else if ( inValue == kSMTPStateUseOtherMTA )
		{
			// Disable Apple Mail SMTP but setup scanner thread
			this->SetSMTP_EnabledFlag( false );

			dsStatus = this->SetValueMember( fSMTP_InState, kSMTP_OptionsPopupValue, inValue, inForceWrite );

			// Set the sendmail rules
// xxx Start Input thread
//			DoSendmailRules();
		}
		else
		{
			// Disable Apple Mail SMTP but setup

			this->SetSMTP_EnabledFlag( false );

			dsStatus = this->SetValueMember( fSMTP_InState, kSMTP_OptionsPopupValue, inValue, inForceWrite );
		}

	}

	return( dsStatus );

} // SetSMTP_State


//--------------------------------------------------------------------------------------------------
//	* GetKerberosState ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetKerberosState ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fKerberosState, kKerberosOptionsPopupValue, outValue, inForceRead );

	return( dsStatus );

} // GetKerberosState


//--------------------------------------------------------------------------------------------------
//	* SetKerberosState ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetKerberosState ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	if ( (fKerberosState != inValue) || (inForceWrite == true) )
	{
		dsStatus = this->SetValueMember( fKerberosState, kKerberosOptionsPopupValue, inValue, inForceWrite );
	}

	return( dsStatus );

} // SetKerberosState


//--------------------------------------------------------------------------------------------------
//	* GetSMTP_EnabledFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetSMTP_EnabledFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fSMTP_InEnabled, kEnableSMTP_Flag, outFlag, inForceRead );

	return( dsStatus );

} // GetSMTP_EnabledFlag


//--------------------------------------------------------------------------------------------------
//	* SetSMTP_EnabledFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetSMTP_EnabledFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;
	Bool			bCurrState		= fSMTP_InEnabled;

	dsStatus = this->SetBoolMember( fSMTP_InEnabled, kEnableSMTP_Flag, inFlag, inForceWrite );

	if ( bCurrState != inFlag )
	{
	}

	return( dsStatus );

} // SetSMTP_EnabledFlag


//--------------------------------------------------------------------------------------------------
//	* GetIMAP_EnabledFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetIMAP_EnabledFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fIMAP_Enabled, kEnableIMAP_Flag, outFlag, inForceRead );

	return( dsStatus );

} // GetIMAP_EnabledFlag


//--------------------------------------------------------------------------------------------------
//	* SetIMAP_EnabledFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetIMAP_EnabledFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;
	Bool			bCurrState		= fIMAP_Enabled;

	dsStatus = this->SetBoolMember( fIMAP_Enabled, kEnableIMAP_Flag, inFlag, inForceWrite );

	if ( bCurrState != inFlag )
	{
	}

	return( dsStatus );

} // SetIMAP_EnabledFlag


//--------------------------------------------------------------------------------------------------
//	* GetPOP3_EnabledFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetPOP3_EnabledFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fPOP_Enabled, kEnablePOP3_Flag, outFlag, inForceRead );

	return( dsStatus );

} // GetPOP3_EnabledFlag


//--------------------------------------------------------------------------------------------------
//	* SetPOP3_EnabledFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetPOP3_EnabledFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;
	Bool			bCurrState		= fPOP_Enabled;

	dsStatus = this->SetBoolMember( fPOP_Enabled, kEnablePOP3_Flag, inFlag, inForceWrite );

	if ( bCurrState != inFlag )
	{
	}

	return( dsStatus );

} // SetPOP3_EnabledFlag


//--------------------------------------------------------------------------------------------------
//	* GetNofifyEnabledFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetNofifyEnabledFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fNotifyMail_Enabled, kEnableNotifyMailFlag, outFlag, inForceRead );

	return( dsStatus );

} // GetNofifyEnabledFlag


//--------------------------------------------------------------------------------------------------
//	* SetNofifyEnabledFlag
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetNofifyEnabledFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;
	Bool			bCurrState		= fNotifyMail_Enabled;

	dsStatus = this->SetBoolMember( fNotifyMail_Enabled, kEnableNotifyMailFlag, inFlag, inForceWrite );

	if ( bCurrState != inFlag )
	{
	}

	return( dsStatus );

} // SetNofifyEnabledFlag


//--------------------------------------------------------------------------------------------------
//	* GetSMTPRelayWhenBackupFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetSMTPRelayWhenBackupFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fSMTPRelayWhenBackupFlag, kSMTPRelayWhenBackupFlag, outFlag, inForceRead );

	return( dsStatus );

} // GetSMTPRelayWhenBackupFlag


//--------------------------------------------------------------------------------------------------
//	* SetSMTPRelayWhenBackupFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetSMTPRelayWhenBackupFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fSMTPRelayWhenBackupFlag, kSMTPRelayWhenBackupFlag, inFlag, inForceWrite );

	return( dsStatus );

} // SetSMTPRelayWhenBackupFlag


//--------------------------------------------------------------------------------------------------
//	* GetSendUndelivNDRToPMFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetSendUndelivNDRToPMFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fSendUndelivNDRToPMFlag, kUndeliverNDRToPMFlag, outFlag, inForceRead );

	return( dsStatus );

} // GetSendUndelivNDRToPMFlag


//--------------------------------------------------------------------------------------------------
//	* SetSendUndelivNDRToPMFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetSendUndelivNDRToPMFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fSendUndelivNDRToPMFlag, kUndeliverNDRToPMFlag, inFlag, inForceWrite );

	return( dsStatus );

} // SetSendUndelivNDRToPMFlag


//--------------------------------------------------------------------------------------------------
//	* GetAllowNDRsBulkMailFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetAllowNDRsBulkMailFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fAllowNDRsBulkMailFlag, kAllowNDRsForBulkMailFlag, outFlag, inForceRead );

	return( dsStatus );

} // GetAllowNDRsBulkMailFlag


//--------------------------------------------------------------------------------------------------
//	* SetAllowNDRsBulkMailFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetAllowNDRsBulkMailFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fAllowNDRsBulkMailFlag, kAllowNDRsForBulkMailFlag, inFlag, inForceWrite );

	return( dsStatus );

} // SetAllowNDRsBulkMailFlag


//--------------------------------------------------------------------------------------------------
//	* GetAllowIMAPAdminAccessFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetAllowIMAPAdminAccessFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fAdminPort_Enabled, kEnableASIA_Flag, outFlag, inForceRead );

	return( dsStatus );

} // GetAllowIMAPAdminAccessFlag


//--------------------------------------------------------------------------------------------------
//	* SetAllowIMAPAdminAccessFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetAllowIMAPAdminAccessFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;
	Bool			bCurrState		= fAdminPort_Enabled;

	dsStatus = this->SetBoolMember( fAdminPort_Enabled, kEnableASIA_Flag, inFlag, inForceWrite );

	if ( bCurrState != inFlag )
	{
	}

	return( dsStatus );

} // SetAllowIMAPAdminAccessFlag


//--------------------------------------------------------------------------------------------------
//	* GetAdminPort ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetAdminPort ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetAdminPortNumber( outValue, inForceRead );

	return( dsStatus );

} // GetAdminPort


//--------------------------------------------------------------------------------------------------
//	* GetAdminPortNumber ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetAdminPortNumber ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fAdminPort_PortNumber, kASIA_PortValue, outValue, inForceRead );

	return( dsStatus );

} // GetAdminPortNumber


//--------------------------------------------------------------------------------------------------
//	* SetAdminPortNumber ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetAdminPortNumber ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;
	uInt32			uiCurrValue		= fAdminPort_PortNumber;

	dsStatus = this->SetValueMember( fAdminPort_PortNumber, kASIA_PortValue, inValue, inForceWrite );

	if ( uiCurrValue != inValue )
	{
	}

	return( dsStatus );

} // SetAdminPortNumber

//--------------------------------------------------------------------------------------------------
//	* GetCaseSensativeFldrNameFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetCaseSensativeFldrNameFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fCaseSensativeFldrNameFlag, kCaseSensativeFldrNamesFlag, outFlag, inForceRead );

	return( dsStatus );

} // GetCaseSensativeFldrNameFlag


//--------------------------------------------------------------------------------------------------
//	* SetCaseSensativeFldrNameFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetCaseSensativeFldrNameFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fCaseSensativeFldrNameFlag, kCaseSensativeFldrNamesFlag, inFlag, inForceWrite );

	return( dsStatus );

} // SetCaseSensativeFldrNameFlag


//--------------------------------------------------------------------------------------------------
//	* GetRequireCRAM_MD5_IMAP_Flag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetRequireCRAM_MD5_IMAP_Flag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fRequreCRAM_MD5_IMAP_Flag, kRequreCRAM_MD5_IMAP_Flag, outFlag, inForceRead );

	return( dsStatus );

} // GetRequireCRAM_MD5_IMAP_Flag


//--------------------------------------------------------------------------------------------------
//	* SetRequireCRAM_MD5_IMAP_Flag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetRequireCRAM_MD5_IMAP_Flag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fRequreCRAM_MD5_IMAP_Flag, kRequreCRAM_MD5_IMAP_Flag, inFlag, inForceWrite );

	return( dsStatus );

} // SetRequireCRAM_MD5_IMAP_Flag


//--------------------------------------------------------------------------------------------------
//	* GetConnPerIMAPAcctPerIP
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetConnPerIMAPAcctPerIP ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fConnPerIMAPAcctPerIP, kConnPerIMAPAcctPerIPvalue, outValue, inForceRead );

	return( dsStatus );

} // GetConnPerIMAPAcctPerIP


//--------------------------------------------------------------------------------------------------
//	* SetConnPerIMAPAcctPerIP
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetConnPerIMAPAcctPerIP ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetValueMember( fConnPerIMAPAcctPerIP, kConnPerIMAPAcctPerIPvalue, inValue, inForceWrite );

	return( dsStatus );

} // SetConnPerIMAPAcctPerIP


//--------------------------------------------------------------------------------------------------
//	* GetIMAPConnIdleTimeout
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetIMAPConnIdleTimeout ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fIMAPConnIdleTimeout, kIMAPConnTimeoutValue, outValue, inForceRead );

	return( dsStatus );

} // GetIMAPConnIdleTimeout


//--------------------------------------------------------------------------------------------------
//	* SetIMAPConnIdleTimeout
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetIMAPConnIdleTimeout ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetValueMember( fIMAPConnIdleTimeout, kIMAPConnTimeoutValue, inValue, inForceWrite );

	return( dsStatus );

} // SetIMAPConnIdleTimeout


//--------------------------------------------------------------------------------------------------
//	* GetMsgExpirationHours ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetMsgExpirationHours ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fMSPStdMailOutMessageExpiresAfterEdit, kMsgExpirationValue, outValue, inForceRead );

	return( dsStatus );

} // GetMsgExpirationHours


//--------------------------------------------------------------------------------------------------
//	* GetMsgWarningHours
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetMsgWarningHours ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fMSPStdMailOutWarnSenderOfNonDeliveryAfterEdit, kMsgExpireWarningValue, outValue, inForceRead );

	return( dsStatus );

} // GetMsgWarningHours


//--------------------------------------------------------------------------------------------------
//	* GetForwardRemoteMsgFlag
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetForwardRemoteMsgFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fMSPStdMailOutForwardAllMailToChk, kFwdAllMailToFlag, outFlag, inForceRead );

	return( dsStatus );

} // GetForwardRemoteMsgFlag


//--------------------------------------------------------------------------------------------------
//	* SetForwardRemoteMsgFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetForwardRemoteMsgFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fMSPStdMailOutForwardAllMailToChk, kFwdAllMailToFlag, inFlag, inForceWrite );

	return( dsStatus );

} // GetForwardRemoteMsgFlag


//--------------------------------------------------------------------------------------------------
//	* GetForwardRemoteMsgName ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetForwardRemoteMsgName ( CString &outStr, Bool inForceRead )
{
	tDirStatus			dsStatus	= eDSNoErr;

	dsStatus = this->GetEmailAddrMember( fMSPStdMailOutForwardAllMailToEdit, kFwdAllMailToUser, outStr, inForceRead );

	return( dsStatus );

} // GetForwardRemoteMsgName


//--------------------------------------------------------------------------------------------------
//	* GetServerDNSCachePopUp ()
//
//		- kServerPrefsAdvNetworkDNSPopupCacheDNS			= 1
//		  kServerPrefsAdvNetworkDNSPopupAlwaysCheckDNS		= 2
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetServerDNSCachePopUp ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fMSPAdvNetworkDNSPopup, kDNSCachePopupValue, outValue, inForceRead );

	return( dsStatus );

} // GetServerDNSCachePopUp


//--------------------------------------------------------------------------------------------------
//	* GetServerDNSCacheDeltaType ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetServerDNSCacheDeltaType ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;
	Bool			bFlag			= false;

	dsStatus = this->GetBoolMember( fMSPAdvNetworkRespectTimeToLiveBtn, kRespectTTLFlag, &bFlag, inForceRead );

	if ( fMSPAdvNetworkRespectTimeToLiveBtn == true )
	{
		*outValue = kServerRespectTTLValue;
	}
	else if ( fMSPAdvNetworkCacheDNSInformationBtn == true )
	{
		*outValue = kServerUseCustomCacheDeltaValue;
	}
	else
	{
		*outValue = kServerNoDNSDeltaValue;
	}

	return( dsStatus );

} // GetServerDNSCacheDeltaType


//--------------------------------------------------------------------------------------------------
//	* GetServerDNSCacheDeltaValue ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetServerDNSCacheDeltaValue ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fMSPAdvNetworkCacheDNSInformationForEdit, kDSNCacheDeltaValue, outValue, inForceRead );

	return( dsStatus );

} // GetServerDNSCacheDeltaValue


//--------------------------------------------------------------------------------------------------
//	* GetServerResolveMXFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetServerResolveMXFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fMSPAdvNetworkResolveMXListChk, kResolveMXListFlag, outFlag, inForceRead );

	return( dsStatus );

} // GetServerResolveMXFlag


//--------------------------------------------------------------------------------------------------
//	* GetServerResolveARecord ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetServerResolveARecord ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fMSPAdvNetworkResolveDNSARecordChk, kResolveARecordFlag, outFlag, inForceRead );

	return( dsStatus );

} // GetServerResolveARecord


//--------------------------------------------------------------------------------------------------
//	* GetMsgWarningFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetMsgWarningFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fMSPStdMailOutWarnSenderOfNonDeliveryAfterBtn, kWarnSenderFlag, outFlag, inForceRead );

	return( dsStatus );

} // GetMsgWarningFlag


//--------------------------------------------------------------------------------------------------
//	* GetWarn_PM_OfNonDelivery ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetWarn_PM_OfNonDelivery ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fMSPStdMailOutWarnPostmasterOfNonDeliveryAfterBtn, kWarnPostasterFlag, outFlag, inForceRead );

	return( dsStatus );

} // GetWarn_PM_OfNonDelivery


//--------------------------------------------------------------------------------------------------
//	* GetSMTPInPort ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetSMTPInPort ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fSMTP_InPortNumber, kSMTP_InPortValue, outValue, inForceRead );

	return( dsStatus );

} // GetSMTPInPort


//--------------------------------------------------------------------------------------------------
//	* SetSMTPInPort ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetSMTPInPort ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;
	uInt32			uiCurrValue		= fSMTP_InPortNumber;

	dsStatus = this->SetValueMember( fSMTP_InPortNumber, kSMTP_InPortValue, inValue, inForceWrite );

	if ( uiCurrValue != inValue )
	{
	}

	return( dsStatus );

} // SetSMTPInPort


//--------------------------------------------------------------------------------------------------
//	* GetSMTPOutPort ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetSMTPOutPort ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fSMTP_OutPortNumber, kSMTP_OutPortValue, outValue, inForceRead );

	return( dsStatus );

} // GetSMTPOutPort


//--------------------------------------------------------------------------------------------------
//	* SetSMTPOutPort ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetSMTPOutPort ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;
	uInt32			uiCurrValue		= fSMTP_OutPortNumber;

	dsStatus = this->SetValueMember( fSMTP_OutPortNumber, kSMTP_OutPortValue, inValue, inForceWrite );

	if ( uiCurrValue != inValue )
	{
	}

	return( dsStatus );

} // SetSMTPOutPort


//--------------------------------------------------------------------------------------------------
//	* GetIMAPPort ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetIMAPPort ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fIMAP_PortNumber, kIMAP_PortValue, outValue, inForceRead );

	return( dsStatus );

} // GetIMAPPort


//--------------------------------------------------------------------------------------------------
//	* SetIMAPPort ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetIMAPPort ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;
	uInt32			uiCurrValue		= fIMAP_PortNumber;

	dsStatus = this->SetValueMember( fIMAP_PortNumber, kIMAP_PortValue, inValue, inForceWrite );

	if ( uiCurrValue != inValue )
	{
	}

	return( dsStatus );

} // SetIMAPPort


//--------------------------------------------------------------------------------------------------
//	* GetPOP3Port ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetPOP3Port ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fPOP_PortNumber, kPOP3_PortValue, outValue, inForceRead );

	return( dsStatus );

} // GetPOP3Port


//--------------------------------------------------------------------------------------------------
//	* SetPOP3Port ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetPOP3Port ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;
	uInt32			uiCurrValue		= fPOP_PortNumber;

	dsStatus = this->SetValueMember( fPOP_PortNumber, kPOP3_PortValue, inValue, inForceWrite );

	if ( uiCurrValue != inValue )
	{
	}

	return( dsStatus );

} // SetPOP3Port


//--------------------------------------------------------------------------------------------------
//	* GetNotifyMailPort ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetNotifyMailPort ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fNotifyMail_PortNumber, kNotifyMailPortValue, outValue, inForceRead );

	return( dsStatus );

} // GetNotifyMailPort


//--------------------------------------------------------------------------------------------------
//	* SetNotifyMailPort ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetNotifyMailPort ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;
	uInt32			uiCurrValue		= fNotifyMail_PortNumber;

	dsStatus = this->SetValueMember( fNotifyMail_PortNumber, kNotifyMailPortValue, inValue, inForceWrite );

	if ( uiCurrValue != inValue )
	{
	}

	return( dsStatus );

} // SetNotifyMailPort


//----------------------------------------------------------------------------------
// * GetThisProtocolPort ()
//
// ---------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetThisProtocolPort ( PortSelector inPortSelector, uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	switch ( inPortSelector )
	{
		case kSMTP_Port:
			dsStatus = this->GetSMTPInPort( outValue, inForceRead );
			break;

		case kPOP3_Port:
			dsStatus = this->GetPOP3Port( outValue, inForceRead );
			break;

		case kIMAP4_Port:
			dsStatus = this->GetIMAPPort( outValue, inForceRead );
			break;

		case kSMTP_SSL_Port:
//			dsStatus = this->GetIMAPPort( outValue, inForceRead );
			*outValue = kSMTP_SSL_Port;
			break;

		case kASIA_Port:
			dsStatus = this->GetAdminPort( outValue, inForceRead );
			break;
	
		case kIMAP_SSL_Port:
//			dsStatus = this->GetAdminPort( outValue, inForceRead );
			*outValue = kIMAP_SSL_Port;
			break;
	
		case kPOP3_SSL_Port:
//			dsStatus = this->GetAdminPort( outValue, inForceRead );
			*outValue = kPOP3_SSL_Port;
			break;
	
		default:
			break;
	}

	return( dsStatus );

} // GetThisProtocolPort


//----------------------------------------------------------------------------------
// * SetThisProtocolPort ()
//
// ---------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetThisProtocolPort ( const PortSelector inPortSelector, const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	switch ( inPortSelector )
	{
		case kSMTP_Port:
			dsStatus = this->SetSMTPInPort( inValue, inForceWrite );
			break;

		case kPOP3_Port:
			dsStatus = this->SetPOP3Port( inValue, inForceWrite );
			break;

		case kIMAP4_Port:
			dsStatus = this->SetIMAPPort( inValue, inForceWrite );
			break;

		case kSMTP_SSL_Port:
//			dsStatus = this->SetAdminPortNumber( inValue, inForceWrite );
			break;

		case kASIA_Port:
			dsStatus = this->SetAdminPortNumber( inValue, inForceWrite );
			break;

		case kIMAP_SSL_Port:
//			dsStatus = this->SetAdminPortNumber( inValue, inForceWrite );
			break;

		case kPOP3_SSL_Port:
//			dsStatus = this->SetAdminPortNumber( inValue, inForceWrite );
			break;

		default:
			break;
	}

	return( dsStatus );

} // SetThisPortocolPort
	

//--------------------------------------------------------------------------------------------------
//	* GetOpenTimeout ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetOpenTimeout ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fMSPAdvNetworkOpenConnectionTimeoutEdit, kOpenTimeoutValue, outValue, inForceRead );

	return( dsStatus );

} // GetOpenTimeout


//--------------------------------------------------------------------------------------------------
//	* GetRdWrTimeout ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetRdWrTimeout ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fMSPAdvNetworkReadWriteTimeoutEdit, kReadWriteTimeoutValue, outValue, inForceRead );

	return( dsStatus );

} // GetRdWrTimeout


//----------------------------------------------------------------------------------
// * IsProtocolOn()
//
//		- returns the prefs whether this listener is turned on
//
// ---------------------------------------------------------------------------------

Bool DSServerPrefs::IsProtocolOn ( uInt32 inProtocolType )
{
	Bool		bResult		= false;

	switch ( inProtocolType )
	{
		case kSMTP_Type:
			bResult = this->IsSMTP_On();
			break;

		case kPOP3_Type:
			bResult = this->IsPOP3_On();
			break;

		case kIMAP4_Type:
			bResult = this->IsIMAP_On();
			break;

		case kSMTP_SSL_Type:
//			bResult = this->IsAdminPort_On();
			bResult = true;
			break;

		case kASIA_Type:
			bResult = this->IsAdminPort_On();
			break;

		case kIMAP_SSL_Type:
//			bResult = this->IsAdminPort_On();
			bResult = true;
			break;

		case kPOP3_SSL_Type:
//			bResult = this->IsAdminPort_On();
			bResult = true;
			break;

		case kUknownType:
        default:
			bResult = false;
			break;	
	}

	return( bResult );

} // IsProtocolOn


//----------------------------------------------------------------------------------
// * SetProtocolState ()
//
//	- Sets the state (on or off) of the protocl in server preferences
// ---------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetProtocolState ( const uInt32 inProtocolType, const Bool inFlag )
{
	tDirStatus		dsStatus		= eDSNoErr;

	switch ( inProtocolType )
	{
		case kSMTP_Type:
			dsStatus = this->SetSMTP_EnabledFlag ( inFlag );
			break;

		case kPOP3_Type:
			dsStatus = this->SetPOP3_EnabledFlag ( inFlag );
			break;

		case kIMAP4_Type:
			dsStatus = this->SetIMAP_EnabledFlag ( inFlag );
			break;

		case kSMTP_SSL_Type:
//			dsStatus = this->SetAllowIMAPAdminAccessFlag ( inFlag );
			break;

		case kASIA_Type:
			dsStatus = this->SetAllowIMAPAdminAccessFlag ( inFlag );
			break;

		case kIMAP_SSL_Type:
//			dsStatus = this->SetAllowIMAPAdminAccessFlag ( inFlag );
			break;

		case kPOP3_SSL_Type:
//			dsStatus = this->SetAllowIMAPAdminAccessFlag ( inFlag );
			break;

		default:
			break;
	}

	return( dsStatus );

} // SetProtocolState


//--------------------------------------------------------------------------------------------------
//	* IsPOP3_On ()
//
//--------------------------------------------------------------------------------------------------

Bool DSServerPrefs::IsPOP3_On ( void )
{
	return( fPOP_Enabled );

} // IsPOP3_On


//--------------------------------------------------------------------------------------------------
//	* IsSMTP_On ()
//
//--------------------------------------------------------------------------------------------------

Bool DSServerPrefs::IsSMTP_On ( void )
{
	return( fSMTP_InEnabled );

} // IsSMTP_On


//--------------------------------------------------------------------------------------------------
//	* IsIMAP_On ()
//
//--------------------------------------------------------------------------------------------------

Bool DSServerPrefs::IsIMAP_On ( void )
{
	return( fIMAP_Enabled );

} // IsIMAP_On


//--------------------------------------------------------------------------------------------------
//	* IsNotifyMail_On ()
//
//--------------------------------------------------------------------------------------------------

Bool DSServerPrefs::IsNotifyMail_On ( void )
{
	return( fNotifyMail_Enabled );

} // IsNotifyMail_On


//--------------------------------------------------------------------------------------------------
//	* IsAdminPort_On ()
//
//--------------------------------------------------------------------------------------------------

Bool DSServerPrefs::IsAdminPort_On ( void )
{
	return( fAdminPort_Enabled );

} // IsAdminPort_On


//--------------------------------------------------------------------------------------------------
//	* IsHoldMailOn ()
//
//--------------------------------------------------------------------------------------------------

Bool DSServerPrefs::IsHoldMailOn ( void )
{
	return( fMSPStdMailOutHoldOutgoingMailBtn );

} // IsHoldMailOn


//--------------------------------------------------------------------------------------------------
//	* ForwardToAnyUser ()
//
//--------------------------------------------------------------------------------------------------

Bool DSServerPrefs::ForwardToAnyUser ( void )
{
	return( fFWDUnknownLocalFlag );

} // ForwardToAnyUser


//--------------------------------------------------------------------------------------------------
//	* CantCreateLocalHosts ()
//
//--------------------------------------------------------------------------------------------------

Bool DSServerPrefs::CantCreateLocalHosts ( void )
{
	return( fMSPStdMailInDontAllowAutoHostEntryCreationChk == true );

} // CantCreateLocalHosts


//--------------------------------------------------------------------------------------------------
//	* LocalFromMustExist ()
//
//--------------------------------------------------------------------------------------------------

Bool DSServerPrefs::LocalFromMustExist ( void )
{
	return( fRequireLocalFromFlag == true );

} // LocalFromMustExist


//--------------------------------------------------------------------------------------------------
//	* IsExpireMessagesOn ()
//
//--------------------------------------------------------------------------------------------------

Bool DSServerPrefs::IsExpireMessagesOn ( void )
{
	return( fAutoMailDeleteFlag == true );

} // IsExpireMessagesOn


//--------------------------------------------------------------------------------------------------
//	* IsCaseSensitiveOn ()
//
//--------------------------------------------------------------------------------------------------

Bool DSServerPrefs::IsCaseSensitiveOn ( void )
{
	return( fCaseSensativeFldrNameFlag );

} // IsCaseSensitiveOn


//--------------------------------------------------------------------------------------------------
//	* SendBulkNDRs ()
//
//--------------------------------------------------------------------------------------------------

Bool DSServerPrefs::SendBulkNDRs ( void )
{
	return( fMSPAdvMiscFlagsByte1 & kMSSFSendBulkNDRsChk );

} // SendBulkNDRs


//--------------------------------------------------------------------------------------------------
//	* FwdBadNDRsToPostmaster ()
//
//--------------------------------------------------------------------------------------------------

Bool DSServerPrefs::FwdBadNDRsToPostmaster ( void )
{
	return( fMSPAdvMiscFlagsByte1 & kMSSFFwdAllUndelivNDRsToPMChk );

} // FwdBadNDRsToPostmaster


//--------------------------------------------------------------------------------------------------
//	* VerifySMTPInConnections ()
//
//--------------------------------------------------------------------------------------------------

Bool DSServerPrefs::VerifySMTPInConnections ( void )
{
	if ( (fRejectIfBadNameFlag == true) || (fLogIfBadSMTPNameFlag == true) )
	{
		return( true );
	}

	return( false );

} // VerifySMTPInConnections


//--------------------------------------------------------------------------------------------------
//	* IngoreAntiSPAMIfRelay ()
//
//--------------------------------------------------------------------------------------------------

Bool DSServerPrefs::IngoreAntiSPAMIfRelay ( void )
{
	return( (fMSPAdvMiscFlagsByte1 & kMSSFBackupServerModeChk) != 0);

} // IngoreAntiSPAMIfRelay


//--------------------------------------------------------------------------------------------------
//	* DeleteDefaultHosts ()
//
//--------------------------------------------------------------------------------------------------

Bool DSServerPrefs::DeleteDefaultHosts ( void )
{
	return( (fMSPAdvMiscFlagsByte1 & kMSSFDeleteAllEmptyDefaultHostsChk) != 0 );

} // DeleteDefaultHosts


//--------------------------------------------------------------------------------------------------
//	* GetIMAPIdleTime ()
//
//--------------------------------------------------------------------------------------------------

uInt32 DSServerPrefs::GetIMAPIdleTime ( void )
{
	return( fIMAPConnIdleTimeout );

} // GetIMAPIdleTime


//--------------------------------------------------------------------------------------------------
//	* GetMaxIMAPConnections ()
//
//--------------------------------------------------------------------------------------------------

uInt32 DSServerPrefs::GetMaxIMAPConnections ( void )
{
	return( fConnPerIMAPAcctPerIP );

} // GetMaxIMAPConnections


//--------------------------------------------------------------------------------------------------
//	* GetUseCustomRBLDomainFlag ()
//
//--------------------------------------------------------------------------------------------------

Bool DSServerPrefs::GetUseCustomRBLDomainFlag ( void )
{
	return( fUseCustomSpamServersFlag );

} // GetUseCustomRBLDomainFlag


//--------------------------------------------------------------------------------------------------
//	* UseOtherMTA ()
//
//--------------------------------------------------------------------------------------------------

Bool DSServerPrefs::UseOtherMTA ( void )
{
	Bool	bResult		= false;

	if ( fSMTP_InState == kSMTPStateUseOtherMTA )
	{
		bResult = true;
	}

	return( bResult );

} // UseOtherMTA


//--------------------------------------------------------------------------------------------------
//	* GetLogMessageBitMap ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetLogMessageBitMap ( const ELogType inLogType )
{
	tDirStatus			dsStatus	= eDSNoErr;
	const char		   *pType		= nil;
	CString				csTmpStr( 128 );
	uInt32				uiVal_00	= 0;
	uInt32				uiVal_01	= 0;
	uInt32				uiVal_02	= 0;
	uInt32				uiVal_03	= 0;
	uInt32				uiVal_04	= 0;
	uInt32				uiVal_05	= 0;
	uInt32				uiVal_06	= 0;
	uInt32				uiVal_07	= 0;
	uInt32				uiVal_08	= 0;
	uInt32				uiVal_09	= 0;
	uInt32				uiVal_10	= 0;
	uInt32				uiVal_11	= 0;
	uInt32				uiVal_12	= 0;
	uInt32				uiVal_13	= 0;
	uInt32				uiVal_14	= 0;
	uInt32				uiVal_15	= 0;

	if ( inLogType == kAServerLogType )
	{
		pType = kServerLogBitMapValue;
	}
	else if ( inLogType == kAnErrorLogType )
	{
		pType = kErrorLogBitMapValue;
	}
	else
	{
		dsStatus = eDSInvalidAttributeType;
	}

	if ( dsStatus == eDSNoErr )
	{
		dsStatus = this->GetAttributeValue( pType, csTmpStr );
		if ( (dsStatus == eDSNoErr) & (csTmpStr.GetLength() > 0) )
		{
			::sscanf( csTmpStr.GetData(), "%ld %ld %ld %ld %ld %ld %ld %ld %ld %ld %ld %ld %ld %ld %ld %ld",
						&uiVal_00, &uiVal_01, &uiVal_02, &uiVal_03, &uiVal_04, &uiVal_05, &uiVal_06, &uiVal_07,
						&uiVal_08, &uiVal_09, &uiVal_10, &uiVal_11, &uiVal_12, &uiVal_13, &uiVal_14, &uiVal_15 );
	
			if ( inLogType == kAServerLogType )
			{
				fMSPServerLogMessageBitMap[ 0 ] = uiVal_00;
				fMSPServerLogMessageBitMap[ 1 ] = uiVal_01;
				fMSPServerLogMessageBitMap[ 2 ] = uiVal_02;
				fMSPServerLogMessageBitMap[ 3 ] = uiVal_03;
				fMSPServerLogMessageBitMap[ 4 ] = uiVal_04;
				fMSPServerLogMessageBitMap[ 5 ] = uiVal_05;
				fMSPServerLogMessageBitMap[ 6 ] = uiVal_06;
				fMSPServerLogMessageBitMap[ 7 ] = uiVal_07;
				fMSPServerLogMessageBitMap[ 8 ] = uiVal_08;
				fMSPServerLogMessageBitMap[ 9 ] = uiVal_09;
				fMSPServerLogMessageBitMap[ 10 ] = uiVal_10;
				fMSPServerLogMessageBitMap[ 11 ] = uiVal_11;
				fMSPServerLogMessageBitMap[ 12 ] = uiVal_12;
				fMSPServerLogMessageBitMap[ 13 ] = uiVal_13;
				fMSPServerLogMessageBitMap[ 14 ] = uiVal_14;
				fMSPServerLogMessageBitMap[ 15 ] = uiVal_15;
			}
			else if ( inLogType == kAnErrorLogType )
			{
				fMSPErrorLogMessageBitMap[ 0 ] = uiVal_00;
				fMSPErrorLogMessageBitMap[ 1 ] = uiVal_01;
				fMSPErrorLogMessageBitMap[ 2 ] = uiVal_02;
				fMSPErrorLogMessageBitMap[ 3 ] = uiVal_03;
				fMSPErrorLogMessageBitMap[ 4 ] = uiVal_04;
				fMSPErrorLogMessageBitMap[ 5 ] = uiVal_05;
				fMSPErrorLogMessageBitMap[ 6 ] = uiVal_06;
				fMSPErrorLogMessageBitMap[ 7 ] = uiVal_07;
				fMSPErrorLogMessageBitMap[ 8 ] = uiVal_08;
				fMSPErrorLogMessageBitMap[ 9 ] = uiVal_09;
				fMSPErrorLogMessageBitMap[ 10 ] = uiVal_10;
				fMSPErrorLogMessageBitMap[ 11 ] = uiVal_11;
				fMSPErrorLogMessageBitMap[ 12 ] = uiVal_12;
				fMSPErrorLogMessageBitMap[ 13 ] = uiVal_13;
				fMSPErrorLogMessageBitMap[ 14 ] = uiVal_14;
				fMSPErrorLogMessageBitMap[ 15 ] = uiVal_15;
			}
		}
	}

	return( dsStatus );

} // GetLogMessageBitMap


//--------------------------------------------------------------------------------------------------
//	* SetLogMessageBitMap ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetLogMessageBitMap ( const ELogType inLogType )
{
	tDirStatus			dsStatus	= eDSNoErr;
	const char		   *pType		= nil;
	CString				csTmpStr( 128 );
	uInt32				uiVal_00	= 0;
	uInt32				uiVal_01	= 0;
	uInt32				uiVal_02	= 0;
	uInt32				uiVal_03	= 0;
	uInt32				uiVal_04	= 0;
	uInt32				uiVal_05	= 0;
	uInt32				uiVal_06	= 0;
	uInt32				uiVal_07	= 0;
	uInt32				uiVal_08	= 0;
	uInt32				uiVal_09	= 0;
	uInt32				uiVal_10	= 0;
	uInt32				uiVal_11	= 0;
	uInt32				uiVal_12	= 0;
	uInt32				uiVal_13	= 0;
	uInt32				uiVal_14	= 0;
	uInt32				uiVal_15	= 0;

	if ( inLogType == kAServerLogType )
	{
		pType = kServerLogBitMapValue;

		uiVal_00 = fMSPServerLogMessageBitMap[ 0 ];
		uiVal_01 = fMSPServerLogMessageBitMap[ 1 ];
		uiVal_02 = fMSPServerLogMessageBitMap[ 2 ];
		uiVal_03 = fMSPServerLogMessageBitMap[ 3 ];
		uiVal_04 = fMSPServerLogMessageBitMap[ 4 ];
		uiVal_05 = fMSPServerLogMessageBitMap[ 5 ];
		uiVal_06 = fMSPServerLogMessageBitMap[ 6 ];
		uiVal_07 = fMSPServerLogMessageBitMap[ 7 ];
		uiVal_08 = fMSPServerLogMessageBitMap[ 8 ];
		uiVal_09 = fMSPServerLogMessageBitMap[ 9 ];
		uiVal_10 = fMSPServerLogMessageBitMap[ 10 ];
		uiVal_11 = fMSPServerLogMessageBitMap[ 11 ];
		uiVal_12 = fMSPServerLogMessageBitMap[ 12 ];
		uiVal_13 = fMSPServerLogMessageBitMap[ 13 ];
		uiVal_14 = fMSPServerLogMessageBitMap[ 14 ];
		uiVal_15 = fMSPServerLogMessageBitMap[ 15 ];
	}
	else if ( inLogType == kAnErrorLogType )
	{
		pType = kErrorLogBitMapValue;

		uiVal_00 = fMSPErrorLogMessageBitMap[ 0 ];
		uiVal_01 = fMSPErrorLogMessageBitMap[ 1 ];
		uiVal_02 = fMSPErrorLogMessageBitMap[ 2 ];
		uiVal_03 = fMSPErrorLogMessageBitMap[ 3 ];
		uiVal_04 = fMSPErrorLogMessageBitMap[ 4 ];
		uiVal_05 = fMSPErrorLogMessageBitMap[ 5 ];
		uiVal_06 = fMSPErrorLogMessageBitMap[ 6 ];
		uiVal_07 = fMSPErrorLogMessageBitMap[ 7 ];
		uiVal_08 = fMSPErrorLogMessageBitMap[ 8 ];
		uiVal_09 = fMSPErrorLogMessageBitMap[ 9 ];
		uiVal_10 = fMSPErrorLogMessageBitMap[ 10 ];
		uiVal_11 = fMSPErrorLogMessageBitMap[ 11 ];
		uiVal_12 = fMSPErrorLogMessageBitMap[ 12 ];
		uiVal_13 = fMSPErrorLogMessageBitMap[ 13 ];
		uiVal_14 = fMSPErrorLogMessageBitMap[ 14 ];
		uiVal_15 = fMSPErrorLogMessageBitMap[ 15 ];
	}
	else
	{
		dsStatus = eDSInvalidAttributeType;
	}


	if ( dsStatus == eDSNoErr )
	{
		csTmpStr.Sprintf( "%u %u %u %u %u %u %u %u %u %u %u %u %u %u %u %u",
						uiVal_00, uiVal_01, uiVal_02, uiVal_03, uiVal_04, uiVal_05, uiVal_06, uiVal_07,
						uiVal_08, uiVal_09, uiVal_10, uiVal_11, uiVal_12, uiVal_13, uiVal_14, uiVal_15 );

		dsStatus = this->SetAttributeValue( pType, csTmpStr );
	}

	return( dsStatus );

} // SetLogMessageBitMap


//--------------------------------------------------------------------------------------------------
//	* IsLogMsgBitSet ()
//
//--------------------------------------------------------------------------------------------------

Bool DSServerPrefs::IsLogMsgBitSet ( const ELogType inLogType, const uInt32 inMsgBit2Check )
{
	Bool	result = false;

	if ( (this != NULL) && (inMsgBit2Check < (32 * kMaxBitMapLogEntries)) )
	{
		const uInt32	theIndex2Check = inMsgBit2Check / 32;
		const uInt32	theMask = 0x01 << (inMsgBit2Check - (theIndex2Check * 32));
		
		switch (inLogType)
		{
			case kAServerLogType:
				result = ((fMSPServerLogMessageBitMap[theIndex2Check] & theMask) != 0);
				break;
			
			case kAnErrorLogType:
				result = ((fMSPErrorLogMessageBitMap[theIndex2Check] & theMask) != 0);
				break;
			default:
				break;
		}
	}

	return(result);

} // IsLogMsgBitSet


//--------------------------------------------------------------------------------------------------
//	* SetLogMsgBit ()
//
//--------------------------------------------------------------------------------------------------

void DSServerPrefs::SetLogMsgBit ( const ELogType inLogType, const uInt32 inMsgBit2Set )
{
	if ((this != NULL) && (inMsgBit2Set < (32 * kMaxBitMapLogEntries)))
	{
		const uInt32	theIndex2Check = inMsgBit2Set / 32;
		const uInt32	theMask = 0x01 << (inMsgBit2Set - (theIndex2Check * 32));

		switch ( inLogType )
		{
			case kAServerLogType:
				if ((fMSPServerLogMessageBitMap[theIndex2Check] | theMask) != fMSPServerLogMessageBitMap[theIndex2Check])
				{
					fMSPServerLogMessageBitMap[theIndex2Check] = (fMSPServerLogMessageBitMap[theIndex2Check] | theMask);
					this->SetLogMessageBitMap( inLogType );
				}
				break;
			
			case kAnErrorLogType:
				if ((fMSPErrorLogMessageBitMap[theIndex2Check] | theMask) != fMSPErrorLogMessageBitMap[theIndex2Check])
				{
					fMSPErrorLogMessageBitMap[theIndex2Check] = (fMSPErrorLogMessageBitMap[theIndex2Check] | theMask);
					this->SetLogMessageBitMap( inLogType );
				}
				break;

			default:
				break;
		}
	}
} //  SetLogMsgBit


//--------------------------------------------------------------------------------------------------
//	* ClearLogMsgBit ()
//
//--------------------------------------------------------------------------------------------------

void DSServerPrefs::ClearLogMsgBit ( const ELogType inLogType, const uInt32 inMsgBit2Clear )
{
	if ((this != NULL) && (inMsgBit2Clear < (32 * kMaxBitMapLogEntries)))
	{
		const uInt32	theIndex2Check = inMsgBit2Clear / 32;
		const uInt32	theMask = ~(0x01 << (inMsgBit2Clear - (theIndex2Check * 32)));

		switch ( inLogType )
		{
			case kAServerLogType:
				if ((fMSPServerLogMessageBitMap[theIndex2Check] & theMask) != fMSPServerLogMessageBitMap[theIndex2Check])
				{
					fMSPServerLogMessageBitMap[theIndex2Check] = (fMSPServerLogMessageBitMap[theIndex2Check] & theMask);
					this->SetLogMessageBitMap( inLogType );
				}
				break;
			
			case kAnErrorLogType:
				if ((fMSPErrorLogMessageBitMap[theIndex2Check] & theMask) != fMSPErrorLogMessageBitMap[theIndex2Check])
				{
					fMSPErrorLogMessageBitMap[theIndex2Check] = (fMSPErrorLogMessageBitMap[theIndex2Check] & theMask);
					this->SetLogMessageBitMap( inLogType );
				}
				break;

			default:
				break;
		}
	}
} // ClearLogMsgBit




// --- ---  --- ---  --- ---  --- ---  --- ---  --- ---  --- ---  --- ---  --- ---  --- ---
//
//	- New Methods -
//
// --- ---  --- ---  --- ---  --- ---  --- ---  --- ---  --- ---  --- ---  --- ---  --- ---


//--------------------------------------------------------------------------------------------------
//	* GetRequireAPOP_Flag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetRequireAPOP_Flag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fRequireAPOPFlag, kRequireAPOPFlag, outFlag, inForceRead );

	return( dsStatus );

} // GetRequireAPOP_Flag


//--------------------------------------------------------------------------------------------------
//	* SetRequireAPOP_Flag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetRequireAPOP_Flag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fRequireAPOPFlag, kRequireAPOPFlag, inFlag, inForceWrite );

	return( dsStatus );

} // SetRequireAPOP_Flag


//--------------------------------------------------------------------------------------------------
//	* GetSMTP_CRAM_MD5_Value ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetSMTP_CRAM_MD5_Value ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fRequireSMTP_CRAM_MD5_Flag, kRequireSMTP_CRAM_MD5_Flag, outValue, inForceRead );

	return( dsStatus );

} // GetSMTP_CRAM_MD5_Value


//--------------------------------------------------------------------------------------------------
//	* SetSMTP_CRAM_MD5_Value ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetSMTP_CRAM_MD5_Value ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetValueMember( fRequireSMTP_CRAM_MD5_Flag, kRequireSMTP_CRAM_MD5_Flag, inValue, inForceWrite );

	return( dsStatus );

} // SetSMTP_CRAM_MD5_Value


//--------------------------------------------------------------------------------------------------
//	* GetOtherSMTPAuthFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetOtherSMTPAuthFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fAllowOther_SMTP_AuthFlag, kAllowPlainLoginFlag, outFlag, inForceRead );

	return( dsStatus );

} // GetOtherSMTPAuthFlag


//--------------------------------------------------------------------------------------------------
//	* SetOtherSMTPAuthFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetOtherSMTPAuthFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fAllowOther_SMTP_AuthFlag, kAllowPlainLoginFlag, inFlag, inForceWrite );

	return( dsStatus );

} // SetOtherSMTPAuthFlag


//--------------------------------------------------------------------------------------------------
//	* GetAltDBLocationFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetAltDBLocationFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fUseAltDBLocationFlag, kAlternateDBLocationFlag, outFlag, inForceRead );

	return( dsStatus );

} // GetAltDBLocationFlag


//--------------------------------------------------------------------------------------------------
//	* SetAltDBLocationFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetAltDBLocationFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fUseAltDBLocationFlag, kAlternateDBLocationFlag, inFlag, inForceWrite );

	return( dsStatus );

} // SetAltDBLocationFlag


//--------------------------------------------------------------------------------------------------
//	* GetAltDBLocationValue ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetAltDBLocationValue ( CString &outStr, Bool inForceRead )
{
	tDirStatus			dsStatus	= eDSNoErr;

	dsStatus = this->GetStringMember( fAltDBLocationValue, kAlternateDBLocationValue, outStr, inForceRead );
	if ( (dsStatus == eDSAttributeNotFound) || (outStr.GetLength() == 0) )
	{
		// Get the devault DB location
		outStr.Set( "/Library/AppleMailServer" );
		dsStatus = this->SetAttributeValue( kAlternateDBLocationValue, outStr.GetData() );
	}

	return( dsStatus );

} // GetAltDBLocationValue


//--------------------------------------------------------------------------------------------------
//	* SetAltDBLocationValue ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetAltDBLocationValue ( const char *inStr, Bool inForceWrite )
{
	tDirStatus			dsStatus	= eDSNoErr;

	dsStatus = SetStringMember( fAltDBLocationValue, kAlternateDBLocationValue, inStr, inForceWrite );

	return( dsStatus );

} // SetAltDBLocationValue


//--------------------------------------------------------------------------------------------------
//	* GetAltInboxLocationValue ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetAltInboxLocationValue ( CString &outStr, Bool inForceRead )
{
	tDirStatus			dsStatus	= eDSNoErr;

	dsStatus = this->GetStringMember( fAltInboxLocationValue, kAltInboxLocationValue, outStr, inForceRead );
	if ( (dsStatus == eDSAttributeNotFound) || (outStr.GetLength() == 0) )
	{
		// Get the devault DB location
		outStr.Set( "/var/mail/" );
		dsStatus = this->SetAttributeValue( kAltInboxLocationValue, outStr.GetData() );
	}

	return( dsStatus );

} // GetAltInboxLocationValue


//--------------------------------------------------------------------------------------------------
//	* SetAltInboxLocationValue ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetAltInboxLocationValue ( const char *inStr, Bool inForceWrite )
{
	tDirStatus			dsStatus	= eDSNoErr;

	dsStatus = SetStringMember( fAltInboxLocationValue, kAltInboxLocationValue, inStr, inForceWrite );

	return( dsStatus );

} // SetAltInboxLocationValue


//--------------------------------------------------------------------------------------------------
//	* GetInboxDelimiterValue ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetInboxDelimiterValue ( CString &outStr, Bool inForceRead )
{
	tDirStatus			dsStatus	= eDSNoErr;

	dsStatus = this->GetStringMember( fInboxDelimiterValue, kInboxDelimiterValue, outStr, inForceRead );
	if ( (dsStatus == eDSAttributeNotFound) || (outStr.GetLength() == 0) )
	{
		// Get the devault DB location
		outStr.Sprintf( "%s", "\nFrom " );
		dsStatus = this->SetAttributeValue( kInboxDelimiterValue, outStr.GetData() );
	}

	return( dsStatus );

} // GetInboxDelimiterValue


//--------------------------------------------------------------------------------------------------
//	* SetInboxDelimiterValue ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetInboxDelimiterValue ( const char *inStr, Bool inForceWrite )
{
	tDirStatus			dsStatus	= eDSNoErr;

	dsStatus = SetStringMember( fInboxDelimiterValue, kInboxDelimiterValue, inStr, inForceWrite );

	return( dsStatus );

} // SetInboxDelimiterValue


//--------------------------------------------------------------------------------------------------
//	* GetUseAllowedRelayListFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetUseAllowedRelayListFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fAllowedRelayFlag, kAllowedRelayServerFlag, outFlag, inForceRead );

	return( dsStatus );

} // GetUseAllowedRelayListFlag


//--------------------------------------------------------------------------------------------------
//	* SetUseAllowedRelayListFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetUseAllowedRelayListFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fAllowedRelayFlag, kAllowedRelayServerFlag, inFlag, inForceWrite );

	return( dsStatus );

} // SetUseAllowedRelayListFlag


//--------------------------------------------------------------------------------------------------
//	* GetAllowedRelayList ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetAllowedRelayList ( StrListObj **outStrList, Bool inForceRead )
{
	tDirStatus			dsStatus	= eDSNoErr;
	const char		   *pTmpStr		= nil;

	if ( (inForceRead == true) && (fAllowedRelayList != nil) )
	{
		CString::FreeStringList( &fAllowedRelayList );
		fAllowedRelayList = nil;
	}

	if ( fAllowedRelayList != nil )
	{
		CString::DuplicateStringList( outStrList, fAllowedRelayList );
	}
	else
	{
		dsStatus = this->GetAttributeValues( kAllowedRelayServerList, &fAllowedRelayList );
		if ( dsStatus == eDSNoErr )
		{
			CString::DuplicateStringList( outStrList, fAllowedRelayList );
		}
	}

	return( dsStatus );

} // GetAllowedRelayList


//--------------------------------------------------------------------------------------------------
//	* SetAllowedRelayList ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetAllowedRelayList ( const StrListObj *inStrList, Bool inForceWrite )
{
		  tDirStatus	dsStatus	= eDSNoErr;
	const StrListObj   *pStrObj		= nil;

	ResetAttribute( kAllowedRelayServerList );
	
	pStrObj = inStrList;
	while ( pStrObj != nil )
	{
		if ( pStrObj->fString != nil )
		{
			dsStatus = this->AddAttributeValue( kAllowedRelayServerList, pStrObj->fString );
		}
		pStrObj = pStrObj->fNext;
	}

	if ( fAllowedRelayList != nil )
	{
		CString::FreeStringList( &fAllowedRelayList );
		fAllowedRelayList = nil;
	}

	dsStatus = this->GetAttributeValues( kAllowedRelayServerList, &fAllowedRelayList );

	return( dsStatus );

} // SetAllowedRelayList


//--------------------------------------------------------------------------------------------------
//	* AddRelayHostToList ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::AddRelayHostToList ( const char *inStr, Bool inForceWrite )
{
	tDirStatus			dsStatus	= eDSNoErr;

	dsStatus = this->AddAttributeValue( kAllowedRelayServerList, inStr );

	return( dsStatus );

} // AddRelayHostToList


//--------------------------------------------------------------------------------------------------
//	* RemoveRelayHostFromList ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::RemoveRelayHostFromList ( const char *inStr, Bool inForceWrite )
{
	tDirStatus			dsStatus	= eDSNoErr;

	dsStatus = this->RemoveAttributeValue( kAllowedRelayServerList, inStr );

	if ( fAllowedRelayList != nil )
	{
		CString::FreeStringList( &fAllowedRelayList );
		fAllowedRelayList = nil;
	}

	return( dsStatus );

} // RemoveRelayHostFromList


//--------------------------------------------------------------------------------------------------
//	* GetDiskQuotaThreshold ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetDiskQuotaThreshold ( uInt32 *outValue, eDiskThreshold inWhich, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	switch ( inWhich )
	{
		case kLowPercentage:
			dsStatus = this->GetValueMember( fDiskThresholdPercentLow, kDiskThresholdLowValue, outValue, inForceRead );
			break;

		case kMediumPercentage:
			dsStatus = this->GetValueMember( fDiskThresholdPercentMedium, kDiskThresholdMediumValue, outValue, inForceRead );
			break;

		case kHighPercentage:
			dsStatus = this->GetValueMember( fDiskThresholdPercentHigh, kDiskThresholdHighValue, outValue, inForceRead );
			break;
	}

	return( dsStatus );

} // GetDiskQuotaThreshold


//--------------------------------------------------------------------------------------------------
//	* SetDiskQuotaThreshold ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetDiskQuotaThreshold ( const uInt32 inValue, eDiskThreshold inWhich, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	switch ( inWhich )
	{
		case kLowPercentage:
			dsStatus = this->SetValueMember( fDiskThresholdPercentLow, kDiskThresholdLowValue, inValue, inForceWrite );
			break;

		case kMediumPercentage:
			dsStatus = this->SetValueMember( fDiskThresholdPercentMedium, kDiskThresholdMediumValue, inValue, inForceWrite );
			break;

		case kHighPercentage:
			dsStatus = this->SetValueMember( fDiskThresholdPercentHigh, kDiskThresholdHighValue, inValue, inForceWrite );
			break;
	}

	return( dsStatus );

} // SetDiskQuotaThreshold


//--------------------------------------------------------------------------------------------------
//	* GetDiskQuotaThreshold ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetDiskQuotaCheckInterval ( uInt32 *outValue, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetValueMember( fDiskQuotaCheckInterval, kDiskQuotaCheckIntervalValue, outValue, inForceRead );

	return( dsStatus );

} // GetDiskQuotaCheckInterval


//--------------------------------------------------------------------------------------------------
//	* SetDiskQuotaCheckInterval ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetDiskQuotaCheckInterval ( const uInt32 inValue, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetValueMember( fDiskQuotaCheckInterval, kDiskQuotaCheckIntervalValue, inValue, inForceWrite );

	return( dsStatus );

} // SetDiskQuotaCheckInterval


//--------------------------------------------------------------------------------------------------
//	* GetAllowTempSSLCertsFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::GetAllowTempSSLCertsFlag ( Bool *outFlag, Bool inForceRead )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->GetBoolMember( fAllowTempSSLCertsFlag, kAllowTempSSLCertsFlag, outFlag, inForceRead );

	return( dsStatus );

} // GetAllowTempSSLCertsFlag


//--------------------------------------------------------------------------------------------------
//	* SetAllowTempSSLCertsFlag ()
//
//--------------------------------------------------------------------------------------------------

tDirStatus DSServerPrefs::SetAllowTempSSLCertsFlag ( const Bool inFlag, Bool inForceWrite )
{
	tDirStatus		dsStatus		= eDSNoErr;

	dsStatus = this->SetBoolMember( fAllowTempSSLCertsFlag, kAllowTempSSLCertsFlag, inFlag, inForceWrite );

	return( dsStatus );

} // SetAllowTempSSLCertsFlag


