/*
	$Id: DSServerPrefs.h,v 1.1 2003/04/20 23:34:11 dasenbro Exp $

	File:		DSServerPrefs.h

	Contains:	class definition of DSServerPrefs object

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1996-2002 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: DSServerPrefs.h,v $
		Revision 1.1  2003/04/20 23:34:11  dasenbro
		Initial check-in.
		
		Revision 1.12  2002/07/13 01:17:48  dasenbro
		Added new attribute get/set/initialize routines for temp SSL certificates.
		
		Revision 1.11  2002/06/04 18:01:55  dasenbro
		Fixed a typo in Get/SetRequireCRAM_MD5_IMAP_Flag() routines.
		
		Revision 1.10  2002/05/30 17:12:42  dasenbro
		Added Get/SetRequireCRAM_MD5_IMAP_Flag() routines.
		
		Revision 1.9  2002/05/09 16:58:56  dasenbro
		Changed all str... calls to CUtils::Str... to be NULL safe.
		
		Revision 1.8  2002/04/18 18:09:10  dasenbro
		Changed bool to Bool for word alignment.
		
		Revision 1.7  2002/04/16 05:54:28  dasenbro
		Removed unneeded SMPT flags.
		
		Revision 1.6  2002/03/21 16:38:52  dasenbro
		Addes network transition support.
		
		Revision 1.5  2002/03/11 23:07:53  dasenbro
		Added support for directory based host prefs.
		
		Revision 1.4  2002/03/05 19:28:57  dasenbro
		Added get/set routines for SMTP rejection list and added delete
		attribute value member.
		
		Revision 1.3  2002/02/20 21:13:32  dasenbro
		Added new keys and disk quota get/set member functions.
		
		Revision 1.2  2002/01/23 22:14:33  dasenbro
		Added new members for Get/Set of alternate mail daemon mailbox location.
		
		Revision 1.1  2002/01/14 17:31:28  dasenbro
		Initial S4 updates.
		
		


	To Do:
*/

#ifndef __DSServerPrefs_h__
#define __DSServerPrefs_h__ 1

#include <CoreFoundation/CFData.h>
#include <CoreFoundation/CFString.h>
#include <CoreFoundation/CFNumber.h>
#include <CoreFoundation/CFPropertyList.h>
#include <DirectoryService/DirServicesTypes.h>

#include "DSPrefs.h"
#include "MailUGCommon.h"
#include "MailGlobals.h"

typedef enum
{
	kServerNoDNSDeltaValue,
	kServerRespectTTLValue,
	kServerUseCustomCacheDeltaValue
} eServerDNSDeltaType;

typedef enum
{
	kLowPercentage		= 1,
	kMediumPercentage	= 2,
	kHighPercentage		= 3,
} eDiskThreshold;

const uInt32 	kMaxBitMapLogEntries = 16;	// 16 * 32 = 512 bits, therefore enable disable 512 individual messages

class CString;

class DSServerPrefs : public DSPrefs
{
public:

	// Constructor/Destructor
					DSServerPrefs				( void );
	virtual		   ~DSServerPrefs				( void );

	// Public accessors
	tDirStatus		GetSMTP_InGreeting			( CString &outStr, Bool inForceRead = false );
	tDirStatus		SetSMTP_InGreeting			( const char *inStr, Bool inForceWrite = false );

	tDirStatus		GetSMTP_OutGreeting			( CString &outStr, Bool inForceRead = false );
	tDirStatus		SetSMTP_OutGreeting			( const char *inStr, Bool inForceWrite = false );

	tDirStatus		GetPOP3_Greeting			( CString &outStr, Bool inForceRead = false );
	tDirStatus		SetPOP3_Greeting			( const char *inStr, Bool inForceWrite = false );;

	tDirStatus		GetIMAP_Greeting			( CString &outStr, Bool inForceRead = false );
	tDirStatus		SetIMAP_Greeting			( const char *inStr, Bool inForceWrite = false );;

	tDirStatus		GetOurLastIPAddr			( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetOurLastIPAddr			( const uInt32 inIPAddr, Bool inForceWrite = false );;

	tDirStatus		GetMaxMessageSizeFlag		( Bool *outFlag, Bool inForceRead = false );
	tDirStatus		SetMaxMessageSizeFlag		( const Bool inFlag, Bool inForceWrite = false );;

	tDirStatus		GetMaxMessageSize			( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetMaxMessageSize			( const uInt32 inValue, Bool inForceWrite = false );;

	tDirStatus		GetBCC_Flag					( Bool *outFlag, Bool inForceRead = false );
	tDirStatus		SetBCC_Flag					( const Bool inFlag, Bool inForceWrite = false );;

	tDirStatus		GetBCC_User					( CString &outStr, Bool inForceRead = false );
	tDirStatus		SetBCC_User					( const char *inStr, Bool inForceWrite = false );;

	tDirStatus		GetBCC_UserStruct			( UserStruct *inUserInfo, Bool inForceRead = false );
	tDirStatus		SetBCC_UserStruct			( const UserStruct *inUserInfo, Bool inForceWrite = false );;

	tDirStatus		GetBCCName					( CString &outStr );

	tDirStatus		GetAutoMailDeleteFlag		( Bool *outFlag, Bool inForceRead = false );
	tDirStatus		SetAutoMailDeleteFlag		( const Bool inFlag, Bool inForceWrite = false );;

	tDirStatus		GetDeleteUnseenDays			( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetDeleteUnseenDays			( const uInt32 inValue, Bool inForceWrite = false );;

	tDirStatus		GetDeleteSeenDays			( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetDeleteSeenDays			( const uInt32 inValue, Bool inForceWrite = false );;

	tDirStatus		GetFWDUnknownLoalUserFlag	( Bool *outValue, Bool inForceRead = false );
	tDirStatus		SetFWDUnknownLoalUserFlag	( const Bool inFlag, Bool inForceWrite = false );;

	tDirStatus		GetFWDUnknownLoalUser		( CString &outStr, Bool inForceRead = false );
	tDirStatus		SetFWDUnknownLoalUser		( const char *inStr, Bool inForceWrite = false );;

	tDirStatus		GetFWDUnknownLoalUserUserStruct ( UserStruct *inUserInfo, Bool inForceRead = false );
	tDirStatus		SetFWDUnknownLoalUserUserStruct ( const UserStruct *inUserInfo, Bool inForceWrite = false );;

	tDirStatus		GetAnyUserName				( CString &outStr );

	tDirStatus		GetUseBlackholeServerFlag	( Bool *outValue, Bool inForceRead = false );
	tDirStatus		SetUseBlackholeServerFlag	( const Bool inFlag, Bool inForceWrite = false );;

	tDirStatus		GetBlackholeServerName		( CString &outStr, Bool inForceRead = false );
	tDirStatus		SetBlackholeServerName		( const char *inStr, Bool inForceWrite = false );;

	tDirStatus		GetCustomSpamServerList		( StrListObj **inStrList, Bool inForceRead = false );
	tDirStatus		SetCustomSpamServerList		( const StrListObj *inStrList, Bool inForceWrite = false );;

	tDirStatus		GetLogIfBadSMTPNameFlag		( Bool *outValue, Bool inForceRead = false );
	tDirStatus		SetLogIfBadSMTPNameFlag		( const Bool inFlag, Bool inForceWrite = false );;

	tDirStatus		GetRejectIfNameNoMatchFlag	( Bool *outValue, Bool inForceRead = false );
	tDirStatus		SetRejectIfNameNoMatchFlag	( const Bool inFlag, Bool inForceWrite = false );;

	tDirStatus		GetRequireLocalFromFlag		( Bool *outValue, Bool inForceRead = false );
	tDirStatus		SetRequireLocalFromFlag		( const Bool inFlag, Bool inForceWrite = false );;

	tDirStatus		GetSMTPRejectServerFlag		( Bool *outValue, Bool inForceRead = false );
	tDirStatus		SetSMTPRejectServerFlag		( const Bool inFlag, Bool inForceWrite = false );;

	tDirStatus		GetSMTPRejectServerList		( StrListObj **outStrList, Bool inForceRead = false );
	tDirStatus		SetSMTPRejectServerList		( const StrListObj *inStrList, Bool inForceWrite = false );;
	tDirStatus		AddSMTPRejectServer			( const char *inStr, Bool inForceWrite = false );
	tDirStatus		RemoveSMTPRejectFromList   	( const char *inStr, Bool inForceWrite = false );

	tDirStatus		GetSMTP_State				( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetSMTP_State				( const uInt32 inFlag, Bool inForceWrite = false );;

	tDirStatus		GetKerberosState			( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetKerberosState			( const uInt32 inFlag, Bool inForceWrite = false );;

	tDirStatus		GetSMTP_EnabledFlag			( Bool *outValue, Bool inForceRead = false );
	tDirStatus		SetSMTP_EnabledFlag			( const Bool inFlag, Bool inForceWrite = false );;

	tDirStatus		GetIMAP_EnabledFlag			( Bool *outValue, Bool inForceRead = false );
	tDirStatus		SetIMAP_EnabledFlag			( const Bool inFlag, Bool inForceWrite = false );;

	tDirStatus		GetPOP3_EnabledFlag			( Bool *outValue, Bool inForceRead = false );
	tDirStatus		SetPOP3_EnabledFlag			( const Bool inFlag, Bool inForceWrite = false );;

	tDirStatus		GetNofifyEnabledFlag		( Bool *outValue, Bool inForceRead = false );
	tDirStatus		SetNofifyEnabledFlag		( const Bool inFlag, Bool inForceWrite = false );;

	tDirStatus		GetSMTPRelayWhenBackupFlag	( Bool *outValue, Bool inForceRead = false );
	tDirStatus		SetSMTPRelayWhenBackupFlag	( const Bool inFlag, Bool inForceWrite = false );;

	tDirStatus		GetSendUndelivNDRToPMFlag	( Bool *outValue, Bool inForceRead = false );
	tDirStatus		SetSendUndelivNDRToPMFlag	( const Bool inFlag, Bool inForceWrite = false );;

	tDirStatus		GetAllowNDRsBulkMailFlag	( Bool *outValue, Bool inForceRead = false );
	tDirStatus		SetAllowNDRsBulkMailFlag	( const Bool inFlag, Bool inForceWrite = false );;

	tDirStatus		GetAllowIMAPAdminAccessFlag	( Bool *outValue, Bool inForceRead = false );
	tDirStatus		SetAllowIMAPAdminAccessFlag	( const Bool inFlag, Bool inForceWrite = false );;

	tDirStatus		GetAdminPort				( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		GetAdminPortNumber			( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetAdminPortNumber			( uInt32 inValue, Bool inForceWrite = false );;

	tDirStatus		GetCaseSensativeFldrNameFlag( Bool *outFlag, Bool inForceRead = false );
	tDirStatus		SetCaseSensativeFldrNameFlag( const Bool inFlag, Bool inForceWrite = false );;

	tDirStatus		GetRequireCRAM_MD5_IMAP_Flag( Bool *outFlag, Bool inForceRead = false );
	tDirStatus		SetRequireCRAM_MD5_IMAP_Flag( const Bool inFlag, Bool inForceWrite = false );;

	tDirStatus		GetConnPerIMAPAcctPerIP		( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetConnPerIMAPAcctPerIP		( const uInt32 inValue, Bool inForceWrite = false );;

	tDirStatus		GetIMAPConnIdleTimeout		( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetIMAPConnIdleTimeout		( const uInt32 inValue, Bool inForceWrite = false );;

	tDirStatus		GetMsgExpirationHours		( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		GetMsgWarningHours			( uInt32 *outValue, Bool inForceRead = false );
	
	tDirStatus		GetForwardRemoteMsgFlag		( Bool *outValue, Bool inForceRead = false );
	tDirStatus		SetForwardRemoteMsgFlag		( const Bool inFlag, Bool inForceWrite = false );;

	tDirStatus		GetForwardRemoteMsgName		( CString &outStr, Bool inForceRead = false );

	tDirStatus		GetServerDNSCachePopUp		( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		GetServerDNSCacheDeltaType	( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		GetServerDNSCacheDeltaValue	( uInt32 *outValue, Bool inForceRead = false );

	tDirStatus		GetServerResolveMXFlag		( Bool *outValue, Bool inForceRead = false );
	tDirStatus		GetServerResolveARecord		( Bool *outValue, Bool inForceRead = false );
	tDirStatus		GetMsgWarningFlag			( Bool *outValue, Bool inForceRead = false );
	tDirStatus		GetWarn_PM_OfNonDelivery	( Bool *outValue, Bool inForceRead = false );

	tDirStatus		GetSMTPInPort				( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetSMTPInPort				( const uInt32 inValue, Bool inForceWrite = false );;

	tDirStatus		GetSMTPOutPort				( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetSMTPOutPort				( const uInt32 inValue, Bool inForceWrite = false );;

	tDirStatus		GetIMAPPort					( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetIMAPPort					( const uInt32 inValue, Bool inForceWrite = false );;

	tDirStatus		GetPOP3Port					( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetPOP3Port					( const uInt32 inValue, Bool inForceWrite = false );;

	tDirStatus		GetNotifyMailPort			( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetNotifyMailPort			( const uInt32 inValue, Bool inForceWrite = false );;

	tDirStatus		GetThisProtocolPort			( PortSelector inPortSelector, uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetThisProtocolPort			( const PortSelector inPortSelector, const uInt32 inValue, Bool inForceWrite = false );;	

	tDirStatus		GetOpenTimeout				( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		GetRdWrTimeout				( uInt32 *outValue, Bool inForceRead = false );

	tDirStatus		GetLogMessageBitMap			( const ELogType inLogType );
	tDirStatus		SetLogMessageBitMap			( const ELogType inLogType );

	tDirStatus		GetRequireAPOP_Flag			( Bool *outFlag, Bool inForceRead = false );
	tDirStatus		SetRequireAPOP_Flag			( const Bool inFlag,   Bool inForceWrite = false );

	tDirStatus		GetSMTP_CRAM_MD5_Value		( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetSMTP_CRAM_MD5_Value		( const uInt32 inValue,   Bool inForceWrite = false );

	tDirStatus		GetOtherSMTPAuthFlag		( Bool *outFlag, Bool inForceRead = false );
	tDirStatus		SetOtherSMTPAuthFlag		( const Bool inFlag,   Bool inForceWrite = false );

	tDirStatus		GetAltDBLocationFlag		( Bool *outFlag, Bool inForceRead = false );
	tDirStatus		SetAltDBLocationFlag		( const Bool inFlag, Bool inForceWrite = false );

	tDirStatus		GetAltDBLocationValue		( CString &outStr, Bool inForceRead = false );
	tDirStatus		SetAltDBLocationValue		( const char *inStr, Bool inForceWrite = false );

	tDirStatus		GetAltInboxLocationValue	( CString &outStr, Bool inForceRead = false );
	tDirStatus		SetAltInboxLocationValue	( const char *inStr, Bool inForceWrite = false );

	tDirStatus		GetInboxDelimiterValue		( CString &outStr, Bool inForceRead = false );
	tDirStatus		SetInboxDelimiterValue		( const char *inStr, Bool inForceWrite = false );

	tDirStatus		GetUseAllowedRelayListFlag	( Bool *outFlag, Bool inForceRead = false );
	tDirStatus		SetUseAllowedRelayListFlag	( const Bool inFlag, Bool inForceWrite = false );

	tDirStatus		GetAllowedRelayList			( StrListObj **outStrList, Bool inForceRead = false );
	tDirStatus		SetAllowedRelayList			( const StrListObj *inStrList, Bool inForceWrite = false );
	tDirStatus		AddRelayHostToList			( const char *inSrvrName, Bool inForceWrite = false );
	tDirStatus		RemoveRelayHostFromList		( const char *inStr, Bool inForceWrite = false );

	tDirStatus		GetDiskQuotaThreshold		( uInt32 *outValue, eDiskThreshold inWhich, Bool inForceRead = false );
	tDirStatus		SetDiskQuotaThreshold		( const uInt32 inValue, eDiskThreshold inWhich, Bool inForceWrite = false );

	tDirStatus		GetDiskQuotaCheckInterval	( uInt32 *outValue, Bool inForceRead = false );
	tDirStatus		SetDiskQuotaCheckInterval	( const uInt32 inValue, Bool inForceWrite = false );

	tDirStatus		GetAllowTempSSLCertsFlag	( Bool *outFlag, Bool inForceRead = false );
	tDirStatus		SetAllowTempSSLCertsFlag	( const Bool inFlag, Bool inForceWrite = false );

	Bool			IsProtocolOn				( uInt32 inProtocolType );
	tDirStatus		SetProtocolState			( const uInt32 inProtocolType, const Bool inFlag );

	Bool			IsPOP3_On					( void );
	Bool			IsSMTP_On					( void );
	Bool			IsIMAP_On					( void );
	Bool			IsNotifyMail_On				( void );
	Bool			IsAdminPort_On				( void );
	Bool			IsHoldMailOn				( void );
	Bool			ForwardToAnyUser			( void );
	Bool			CantCreateLocalHosts		( void );
	Bool			LocalFromMustExist			( void );
	Bool			IngoreAntiSPAMIfRelay		( void );
	Bool			IsExpireMessagesOn			( void );
	Bool			IsCaseSensitiveOn			( void );
	Bool			SendBulkNDRs				( void );
	Bool			FwdBadNDRsToPostmaster		( void );
	Bool			VerifySMTPInConnections		( void );
	Bool			DeleteDefaultHosts			( void );
	Bool			GetUseCustomRBLDomainFlag	( void );
	Bool			UseOtherMTA					( void );

	uInt32			GetIMAPIdleTime				( void );
	uInt32			GetMaxIMAPConnections		( void );

	Bool			IsLogMsgBitSet				( const ELogType inLogType, const uInt32 inMsgBit2Check );
	void			SetLogMsgBit				( const ELogType inLogType, const uInt32 inMsgBit2Set );
	void			ClearLogMsgBit				( const ELogType inLogType, const uInt32 inMsgBit2Clear );

private:
	char			   *fSMTP_InGreeting;
	char			   *fSMTP_OutGreeting;
	char			   *fPOP3_Greeting;
	char			   *fIMAP_Greeting;
	char			   *fASIA_Greeting;
	uInt32				fOurLastIPAddress;
	Bool				fMaxMessageSizeFlag;			// Max message size check box
	uInt32				fMaxMessageSizeValue;			// Max message size value
	Bool				fBCC_Flag;						// BCC on/off check box
	char			   *fBCC_User;						// BCC user email address
	UserStruct		   *fBCC_UserStruct;				// BCC user struct
	Bool				fAutoMailDeleteFlag;			// Automatic mail deletion check box
	uInt32				fDeleteUnseenDays;				// Delete mail if unseen in ??? days
	uInt32				fDeleteSeenDays;				// Delete mail if seen in ??? days
	Bool				fFWDUnknownLocalFlag;			// Forward mail to unknown local users check box
	char			   *fFWDUnknownLocalUser;			// Forward mail to unknown local users to this email address
	UserStruct		   *fFWDUnknownLocalUserStruct;		// BCC user struct
	Bool				fCheckSMTP_InFlag;				// Check incoming SMTP Connections flag
	Bool				fUseDefaultSpamServerFlag;		// Use default spam server button
	char			   *fDefaultSpamServer;				// Default spam server name
	Bool				fUseCustomSpamServersFlag;		// Use custom spam server button
	StrListObj		   *fCustomSpamServerList;			// Custom spam server list
	Bool				fLogIfBadSMTPNameFlag;			// Log if SMTP name dows not match flag
	Bool				fRejectIfBadNameFlag;			// Reject if name does not match address flag
	Bool				fRequireLocalFromFlag;			// Reject if not local from flag
	Bool				fRejectIfNotInHostListFlag;		// Reject if not in host lilst flag
	StrListObj		   *fRejectSMTPHostList;			// List of SMTP hosts to reject connections from
	uInt32				fSMTP_InState;					// SMTP In enabled flag
	Bool				fSMTP_InEnabled;				// SMTP Out enabled flag
	Bool				fSMTP_OutEnabled;				// SMTP Out enabled flag
	uInt32				fSMTP_InPortNumber;				// SMTP in port number
	uInt32				fSMTP_OutPortNumber;			// SMTP out port number
	Bool				fIMAP_Enabled;					// IMAP enabled flag
	uInt32				fIMAP_PortNumber;				// IMAP port number
	Bool				fPOP_Enabled;					// POP3 enabled flag
	uInt32				fPOP_PortNumber;				// POP3 port number
	Bool				fNotifyMail_Enabled;			// Notify enabled flag
	uInt32				fNotifyMail_PortNumber;			// Notify port number
	Bool				fSMTPRelayWhenBackupFlag;		// Allow SMTP relay when host is a backup for destination flag
	Bool				fSendUndelivNDRToPMFlag;		// Send undeliverable NDRs to postmaster flat
	Bool				fAllowNDRsBulkMailFlag;			// Allow NDRs for bulk mail flag
	Bool				fAdminPort_Enabled;				// Admin enabled flag
	uInt32				fAdminPort_PortNumber;			// Admin port number
	Bool				fCaseSensativeFldrNameFlag;		// Use case sensative IMap folder names
	Bool				fRequreCRAM_MD5_IMAP_Flag;		// Require CRAM-MD5 flag
	uInt32				fConnPerIMAPAcctPerIP;			// Allow ??? IMAP connections per user ona a single IP Addr
	uInt32				fIMAPConnIdleTimeout;			// Terminate conn after ???  mins

	uInt32				fMSPServerLogMessageBitMap[ kMaxBitMapLogEntries ];
	uInt32				fMSPErrorLogMessageBitMap[ kMaxBitMapLogEntries ];

	Bool				fMSPStdMailOutForwardAllMailToChk;							// 307
	uInt32				fMSPStdMailOutWarnSenderOfNonDeliveryAfterEdit;				// 305
	uInt32				fMSPStdMailOutMessageExpiresAfterEdit;						// 304
	char			   *fMSPStdMailOutForwardAllMailToEdit;							// 308
	uInt32				fMSPAdvNetworkDNSPopup;										// 4
	Bool				fMSPAdvNetworkRespectTimeToLiveBtn;							// 111
	uInt32				fMSPAdvNetworkCacheDNSInformationForEdit;					// 113
	Bool				fMSPAdvNetworkResolveMXListChk;								// 101
	Bool				fMSPAdvNetworkCacheDNSInformationBtn;						// 112
	Bool				fMSPAdvNetworkResolveDNSARecordChk;							// 102
	Bool				fMSPStdMailOutWarnSenderOfNonDeliveryAfterBtn;				// 303
	Bool				fMSPStdMailOutWarnPostmasterOfNonDeliveryAfterBtn;			// 306
	uInt32				fMSPAdvNetworkOpenConnectionTimeoutEdit;					// 103
	uInt32				fMSPAdvNetworkReadWriteTimeoutEdit;							// 104
	Bool				fMSPStdMailOutHoldOutgoingMailBtn;							// 302
	Bool				fMSPStdMailInForwardMailForUnknownLocalUsersChk;			// 205
	Bool				fMSPStdMailInDontAllowAutoHostEntryCreationChk;				// 208
//	Bool				fLocalFromMustExist;

	uInt32				fMSPAdvMiscFlagsByte1;										// MailServerPrefsFlagsAdvanced1

	Bool				fRequireAPOPFlag;
	uInt32				fRequireSMTP_CRAM_MD5_Flag;
	Bool				fAllowOther_SMTP_AuthFlag;
	Bool				fUseAltDBLocationFlag;
	char			   *fAltDBLocationValue;
	char			   *fAltInboxLocationValue;
	char			   *fInboxDelimiterValue;

	StrListObj		   *fAllowedRelayList;			// Open relay address list
	Bool				fAllowedRelayFlag;

	uInt32				fDiskThresholdPercentLow;
	uInt32				fDiskThresholdPercentMedium;
	uInt32				fDiskThresholdPercentHigh;

	uInt32				fDiskQuotaCheckInterval;

	uInt32				fKerberosState;					// Kerberos state
	uInt32				fAllowTempSSLCertsFlag;			// Allow temp SSL certificates
};

#endif // __DSServerPrefs_h__
