/*
	File:		CAccount.10.1.h

	Contains:	C++ class definition of account objects

	Copyright:	 2003 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CAccount.10.1.h,v $
		Revision 1.1  2003/04/20 23:46:10  dasenbro
		Initial check-in.
		

	To Do:
*/


#ifndef __CAccount_10_1_h__
#define __CAccount_10_1_h__	1

#include "CMailDatabase.10.1.h"
#include "CDBBaseObject.10.1.h"
#include "CDBMailBaseObject.10.1.h"

#include "DatabaseTypes.h"
#include "MailUGCommon.h"
#include "CTextObjMgr.h"
#include "DSMailUser.h"

typedef enum {
	kNotifyUser_10_1	= 0x01,		// Notify the user
	kNotifyOn_10_1		= 0x02,		// Is the notify user option on
	kUseLastIP_10_1		= 0x04		// Use last IP Address
} eNotifyState_10_1;

typedef enum {
	kUnknown_10_1		= 0x00,
	kActive_10_1		= 0x01,
	kDeleted_10_1		= 0x02,
	kMismatch_10_1		= 0x04,
	kMerging_10_1		= 0x08,
	kDumpToFile_10_1	= 0x10
} eAccountState_10_1;

const	uInt32		kOkToReturnName_10_1 = 0x00000008;

#pragma options align=mac68k
typedef struct
{
	StdDBObjHeader_10_1	fDBHeader;
	// Object IDs 
			 ObjID	fAccountID;				// this is us (denormalized)
	volatile ObjID	fPOP3InboxID;			// this is our POP3 inbox mail spool
	volatile ObjID	fIMAP4InboxID;			// this is our IMAP4 inbox mail spool
			 ObjID	fMailUserID;			// ID of the DSMailUser this maps to

	// Reserved
	uInt32			fACLFolderSynch;		// 
	uInt32			fReserved2;				// reserverd

	// Various account flags
	uInt32			fAcctFlags;
	uInt32			fReturnNameOk;

	// Account Information
	TextStrObj		fAcctNameObj;
	TextStrObj		fDirPathObj;

	eAccountState_10_1	fAccountState;					// kActive, kDeleted, kMismatch

	// Notification Information
	Boolean			fNotify;						// User client needs to be notified
	uInt32			fNotifyIPAddress;				// TCP/IP address to ping when new mail arrives
	uInt32			fNotifyIPAddrCache;				// TCP/IP address cache from directory 
	uInt32			fNotifyFailures;				// count of successive notify failures. 
													// At some point, we give up

	StdDBObjFooter_10_1	fDBFooter;
} CAccountData_10_1;

#pragma options align=reset


typedef CAccountData_10_1 *CAccountDataPtr_10_1;

// CDBMailBaseObject Constants
const uInt32 kAccountDataSize_10_1	= (sizeof (CAccountData_10_1));
const uInt32 kAccountVersion_10_1	= kDBCurrentVersion_10_1 + kAccountDataSize_10_1;
								  
const ObjID keMismatchedAccountID_10_1	= 0xFFFFFFFF;
const ObjID keDeletedAccountID_10_1		= 0x7FFFFFFF;

class CAccount_10_1 : public CDBMailBaseObject_10_1
{
public:
	typedef enum
	{
		kCreate = true,
		kDontCreate = false
	} CreateOnDemand;

	// Static Methods
	static CAccount_10_1* 	Find			( DSMailUser* inMailUser, CreateOnDemand inCreate );
	static CAccount_10_1*	Create			( DSMailUser* inMailUser );
	static Boolean 		Delete			( CAccount_10_1* inAccount );
	static uInt32		Count			( void );
	static Boolean		GetSetFields	( const eFieldDataRequest_10_1 inFieldRequest, const void *inObjDataPtr, void *outFieldData);

	static 	CAccount_10_1*		FindByID			( const	ObjID	inObjectID );
	static	CDBBaseObject_10_1*	ObjectAllocNew		( void );

	static	OSType		GetObjTypeConstant	( void ) { return kAccountSignature_10_1; }
	static	uInt32		GetObjVersConstant	( void ) { return kAccountVersion_10_1; }
	static	uInt32		GetObjSizeConstant	( void ) { return kAccountDataSize_10_1; }
	
	virtual	void		ChkCompilerStructAlignment	( void );

	virtual	ObjID		GetObjectID			( void );
			void		Done				( CAccount_10_1* &inPtr );

	// Construction/Destruction
				CAccount_10_1	( void );
	virtual    ~CAccount_10_1	( void );

	// Object IDs 
	ObjID			GetAccountID(void);

	ObjID			GetPOP3InboxID				( CreateOnDemand inCreate = kCreate );
	void			SetPOP3InboxID				( ObjID inMailSpoolID );

	ObjID			GetIMAP4InboxID				( CreateOnDemand inCreate = kCreate );
	void			SetIMAP4InboxID				( ObjID inMailSpoolID );

	ObjID			GetPOP3InboxIDOnly			( void );
	ObjID			GetIMAP4InboxIDOnly			( void );

	void			SetDirty					( void );

	// Account Information
	const char *	GetAccountName				( void );
	void			SetAccountName				( const char* inAccountName );

	ObjID			GetMailUserID				( void );
	void			SetMailUserID				( const ObjID inMailUserID );

	const char *	GetDirectoryPath			( void );
	void			SetDirectoryPath			( const char * inDirectoryPath );

	void			SetAccountState				( eAccountState_10_1 inAccountState );
	eAccountState_10_1	GetAccountState				( void);

	uInt32			GetACLFolderSynchStamp		( void );
	void			SetACLFolderSynchStamp		( const uInt32 inTimeStamp );

	Boolean			Validate					( DSMailUser* inMailUser );

	// Notification Methods
	uInt32 			GetNotifyIPAddress			( void );
	void			SetNotifyIPAddress			( uInt32 inNotifyAddress );

	void			SetNotifyUserOn				( void );
	void			SetNotifyUserOff			( void );

	void			SetNotifyOn					( void );
	void			SetNotifyOff				( void );

	void			SetUseLastIPAddrOn			( void );
	void			SetUseLastIPAddrOff			( void );

	bool			IsNotifyOn					( void );
	bool			UseLastIPAddress			( void );
	Boolean			IsNotifyPending				( void );

	void			ResetNotifyFailures			( void );
	uInt32			IncreaseNotifyFailures		( void );

	uInt32			GetAdminSetIPNotifyAddr		( void );
	void			SetAdminSetIPNotifyAddr		( uInt32 inAdminSetIPAddr );

	// Posting
	Boolean 		Post						( ObjID inEnvelopeID, DSMailUser* mailUser );

	// POP3 Server
	Boolean			GetPOPContext				( DSMailUser *inDSMailUser, char * outPOPContext );
	void			ReleasePOPContext			( char * inPOPContext );

	uInt32			GetReturnNameOk				( void );
	void			SetReturnNameOk				( uInt32 inValue );

public:
	char		   		*fPOPContext;
	CAccountData_10_1	fAccountData;	// this portion stored on disk...

private:
	char		   *fAcctNameStr;
	char		   *fDirPathStr;

};

#endif // __CAccount_10_1_h__
