/*
	File:		ServerPrefs.10.1.h

	Contains:	

	Copyright:	 2003 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: ServerPrefs.10.1.h,v $
		Revision 1.1  2003/04/20 23:46:10  dasenbro
		Initial check-in.
		

	To Do:
*/


#ifndef __ServerPrefs_10_1_h__
#define __ServerPrefs_10_1_h__	1

const uInt32	kStrSize			= 128;
const uInt32 	kMaxBitMapLogEntries = 16;	// 16 * 32 = 512 bits, therefore enable disable 512 individual messages


//typedef struct PrefsStruct
//{
//	sInt32		fID;
//	uInt32		fType;
//	char		fUserName[ 64 ];
//	char		fRealName[ 64 ];
//	char		fPath[ 128 ];
//} PrefsStruct;

typedef struct ServerPrefs
{
  // Mail Server Settings
  // - Messages pane
	bool		fMaxMessageSizeFlag;				// Max message size check box
	uInt32		fMaxMessageSizeValue;				// Max message size value

	bool		fBCC_Flag;							// BCC on/off check box
//	PrefsStruct	fBCC_UserInfo;						// BCC user data
	UserStruct	fBCC_UserInfo;						// BCC user data

// old field - needs to die
uInt32 fMSPStdMailInSendBCCToUandGID;// 204 is text. Data is uInt32.

	bool		fAutoMailDeleteFlag;				// Automatic mail deletion check box
	uInt32		fDeleteUnseenDays;					// Delete mail if unseen in ??? days
	uInt32		fDeleteSeenDays;					// Delete mail if seen in ??? days

	bool		fFWDUnknownLocalFlag;				// Forward mail to unknown local users check box
//	PrefsStruct	fFWDUnknownLocalUserInfo;			// Forward mail to unknown local users to this user XML data
	UserStruct	fFWDUnknownLocalUserInfo;			// Forward mail to unknown local users to this user XML data

  // Mail Server Settings
  // - Spam pane
	bool		fCheckSMTP_InFlag;					// Check incoming SMTP Connections flag
	bool		fUseDefaultSpamSrvr;				// Use default spam server button
	char		fDefaultSpamSrvr[ kStrSize ];		// Custom spam server name - MED - Needs to be changed to new text object
	bool		fUseCustomSpamSrvr;					// Use custom spam server button
	char		fCustomSpamSrvr[ kStrSize ];		// Custom spam server name - MED - Needs to be changed to new text object

	bool		fLogIfBadSMTPNameFlag;				// Log if SMTP name dows not match flag
	bool		fRejectIfBadNameFlag;				// Reject if name does not match address flag

	bool		fRequireLocalFromFlag;				// Reject if not local from flag
	bool		fRejectIfNotInHostListFlag;			// Reject if not in host lilst flag

  // Mail Server Settings
  // - Protocols pane
	uInt32		fSMTP_InState;						// SMTP In enabled flag
	bool		fSMTP_InEnabled;					// SMTP Out enabled flag
	bool		fSMTP_OutEnabled;					// SMTP Out enabled flag

	uInt32		fSMTP_InPortNumber;					// SMTP in port number
	uInt32		fSMTP_OutPortNumber;				// SMTP out port number

	bool		fIMAP_Enabled;						// IMAP enabled flag
	uInt32		fIMAP_PortNumber;					// IMAP port number

	bool		fPOP_Enabled;						// POP3 enabled flag
	uInt32		fPOP_PortNumber;					// POP3 port number

	bool		fNotifyMail_Enabled;				// Notify enabled flag
	uInt32		fNotifyMail_PortNumber;				// Notify port number

  // Mail Server Settings
  // - SMTP Options...
	char		fSMTP_InGreeting[ kStrSize ];
	char		fSMTP_OutGreeting[ kStrSize ];

	bool		fSMTPRelayWhenBackupFlag;			// Allow SMTP relay when host is a backup for destination flag
	bool		fSendUndelivNDRToPMFlag;			// Send undeliverable NDRs to postmaster flat
	bool		fAllowNDRsBulkMailFlag;				// Allow NDRs for bulk mail flag

  // Mail Server Settings
  // - IMAP Options...
	char		fIMAP_Greeting[ kStrSize ];			// IMAP greeting
	char		fAdminPort_Greeting[ kStrSize ];	// Set admin port greeting same as IMAP greeting

	bool		fAdminPort_Enabled;					// Admin enabled flag
	uInt32		fAdminPort_PortNumber;				// Admin port number

	bool		fCaseSensativeFldrNameFlag;			// Use case sensative IMap folder names

	uInt32		fConnPerIMAPAcctPerIP;				// Allow ??? IMAP connections per user ona a single IP Addr
	uInt32		fIMAPConnIdleTimeout;				// Terminate conn after ???  mins

  // Mail Server Settings
  // - POP3 Options...
	char		fPOP_Greeting[ kStrSize ];


  // Other Mis settings
	uInt32		fSMTP_OutConnLimit;
	uInt32		fSMTP_InConnLimit;
	uInt32		fPOP_ConnLimit;
	uInt32		fIMAP_ConnLimit;
	uInt32		fAdminPort_ConnLimit;
	uInt32		fNotifyMail_ConnLimit;

	char		fNotifyMail_Greeting[ kStrSize ];

	uInt32		fMaxIMAP_MessagesPerFolder;			// Max number of IMAP messages per folder

	uInt32		fDB_FlushFrequency;
	uInt32		fDB_CacheSize;
	uInt32		fDB_MinFreeSpace;
	char		fDB_Location[ kStrSize ];

// Standard - 'Mail In' panel
	uInt32					fMSPStdMailInForwardMailForUnknownLocalUsersUandGID;		// 206 is text. Data is uInt32.
	bool					fMSPStdMailInForwardMailForUnknownLocalUsersChk;			// 205
	bool					fLocalFromMustExist;
	bool					fMSPStdMailInDontAllowAutoHostEntryCreationChk;				// 208

// Standard - 'Mail Out' panel
	bool					fMSPStdMailOutAllowOutgoingMailBtn;							// 301
	bool					fMSPStdMailOutHoldOutgoingMailBtn;							// 302
	bool					fMSPStdMailOutWarnSenderOfNonDeliveryAfterBtn;				// 303
	uInt32					fMSPStdMailOutMessageExpiresAfterEdit;						// 304
	uInt32					fMSPStdMailOutWarnSenderOfNonDeliveryAfterEdit;				// 305
	bool					fMSPStdMailOutWarnPostmasterOfNonDeliveryAfterBtn;			// 306
	bool					fMSPStdMailOutForwardAllMailToChk;							// 307
	Str255					fMSPStdMailOutForwardAllMailToEdit;							// 308

// Advanced - 'Network' panel
	uInt32					fMSPAdvNetworkDNSPopup;										// 4
							// kServerPrefsAdvNetworkDNSPopupCacheDNS				= 1;
							// kServerPrefsAdvNetworkDNSPopupAlwaysCheckDNS		= 2;
								
	bool					fMSPAdvNetworkResolveMXListChk;								// 101
	bool					fMSPAdvNetworkResolveDNSARecordChk;							// 102
	uInt32					fMSPAdvNetworkOpenConnectionTimeoutEdit;					// 103
	uInt32					fMSPAdvNetworkReadWriteTimeoutEdit;							// 104
	bool					fMSPAdvNetworkRespectTimeToLiveBtn;							// 111
	bool					fMSPAdvNetworkCacheDNSInformationBtn;						// 112
	uInt32					fMSPAdvNetworkCacheDNSInformationForEdit;					// 113

	uInt32					fMSPServerLogMessageBitMap[ kMaxBitMapLogEntries ];
	uInt32					fMSPErrorLogMessageBitMap[ kMaxBitMapLogEntries ];

//	uInt32					fMaxIMAP_MessagesPerFolder;
	
	uInt32					fMSPAdvMiscFlagsByte1;										// MailServerPrefsFlagsAdvanced1

// New Directory (U&G) preferecne
	bool					fMSPDSExpireCacheUGAtShutdownChk;
	bool					fMSPDSExpireCacheUGAtStartupChk;
	uInt32					fMSPDSTimeToLive;

	// Note: In order to not disturb the db we're using this previously unimplemented boolean
	// as a byte of 8 bit flags.
	
	// Note: Window positions now unused. Positions saved in resource.
//	MSPoint					fMSPStdWindowPositionTopLeftUnused;
//	MSPoint					fMSPStdWindowPositionBottomRightUnused;
	
//	MSPoint					fMSPAdvWindowPositionTopLeftUnused;
//	MSPoint					fMSPAdvWindowPositionBottomRightUnused;

} ServerPrefs_10_1;

#endif  //  __ServerPrefs_10_1_h__