/*
	$Id: CAccount.h,v 1.1 2003/04/20 23:45:33 dasenbro Exp $

	File:		CAccount.h

	Contains:	C++ class definition of account objects

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Nick Brosnahan

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CAccount.h,v $
		Revision 1.1  2003/04/20 23:45:33  dasenbro
		Initial check-in.
		
		Revision 1.21  2002/05/30 17:09:48  dasenbro
		Added a bool to GetSpoolsSize() to verify the mail spools.
		
		Revision 1.20  2002/04/18 18:09:11  dasenbro
		Changed bool to Bool for word alignment.
		
		Revision 1.19  2002/03/21 16:41:23  dasenbro
		Updated file version information.
		
		Revision 1.18  2002/02/20 20:59:43  dasenbro
		Added some DB migration info to object data and spool size check for user disk quota.
		
		Revision 1.17  2002/01/14 17:27:41  dasenbro
		Initial S4 updates.
		
		Revision 1.16  2001/06/21 20:50:58  dasenbro
		Updated file header info.
		
		Revision 1.15  2001/06/21 18:18:47  dasenbro
		Added Change History.
		

	Projector History:

	  <ASM6>	 2/11/99	MED		Added new fingerprint checking fixes.
	  <ASM5>	  2/8/99	MED		Added a 'create' parameter to CAccount::Find().
	  <ASM4>	  2/4/99	MED		Temporarily commented out fingerprint stuff (will add back later).
	  <ASM3>	 1/24/99	MED		Added getters for POP3 and IMAP inbox ID's.
		<10>	 9/14/98	MED		Added Get/Set for unused 1 and 2.
		 <9>	  6/1/98	DOR		Remove the "kAdd" argument from Create since we no longer use it.
		 <8>	 5/19/98	MED		Added future expansion data members.
		 <7>	03/23/98	DOR		Mark some fields volatile for safety sake.
		 <5>	  3/9/98	DOR		Get/Set/Clear OwnerThreadID has been moved to CDBObject
		 <4>	12/16/97	MED		Added owner thread ID's for CNotifyClient.
		 <3>	12/15/97	MED		Added fields to DB struct for NotifyMail.
		 <2>	12/15/97	DOR		Update the object version to "include" the size of the
									dataportion of the object, and add an assert to "FindByID" that
									checks the version of the object.

	To Do:
*/


#ifndef __CAccount_h__
#define __CAccount_h__	1

#include "CDBMailBaseObject.h"
#include "CString.h"
#include "CStatMgr.h"
#include "DatabaseTypes.h"
#include "MailUGCommon.h"
#include "CTextObjMgr.h"


class DSMailUser;

typedef enum {
	kNotifyUser		= 0x01,		// Notify the user
	kNotifyOn		= 0x02,		// Is the notify user option on
	kUseLastIP		= 0x04		// Use last IP Address
} eNotifyState;

typedef enum {
	kStateMask			= 0x000000FF,
	kUnknown			= 0x00000000,
	kActive				= 0x00000001,
	kDumpToFile			= 0x00000002,
	kDiskQuotaMask		= 0x0000FF00,
	kNoRestrictions		= 0x00000100,
	kLevel_1_Warning	= 0x00000200,
	kLevel_2_Warning	= 0x00000400,
	kLevel_3_Warning	= 0x00000800,
	kMailboxFull		= 0x00001000
} eAccountState;

const	uInt32		kOkToReturnName = 0x00000008;

#pragma options align=mac68k
typedef struct
{
	StdDBObjHeader	fDBHeader;
	// Object IDs 
			 ObjID	fAccountID;				// this is us (denormalized)
	volatile ObjID	fPOP3InboxID;			// this is our POP3 inbox mail spool
	volatile ObjID	fIMAP4InboxID;			// this is our IMAP4 inbox mail spool
			 ObjID	fMailUserID;			// ID of the DSMailUser this maps to

	// Reserved
	uInt32			fACLFolderSynch;		// 
	uInt32			fReserved2;				// reserverd

	// Various account flags
	uInt32			fAcctFlags;
	uInt32			fReturnNameOk;

	// Account Information
	TextStrObj		fAcctNameObj;
	TextStrObj		fDirPathObj;

	eAccountState	fAccountState;					// kActive, kDeleted, kMismatch

	// Notification Information
	Boolean			fNotify;						// User client needs to be notified
	uInt32			fNotifyIPAddress;				// TCP/IP address to ping when new mail arrives
	uInt32			fNotifyIPAddrCache;				// TCP/IP address cache from directory 
	uInt32			fNotifyFailures;				// count of successive notify failures. 
													// At some point, we give up

	StdDBObjFooter	fDBFooter;
} CAccountData;

#pragma options align=reset


typedef CAccountData *CAccountDataPtr;

// CDBMailBaseObject Constants
const uInt32 kAccountDataSize = (sizeof (CAccountData));
const uInt32 kAccountVersion = kDBCurrentVersion + kAccountDataSize;
								  
const ObjID keMismatchedAccountID = 0xFFFFFFFF;
const ObjID keDeletedAccountID = 0x7FFFFFFF;

class CAccount : public CDBMailBaseObject
{
public:
	typedef enum
	{
		kCreate = true,
		kDontCreate = false
	} CreateOnDemand;

	// Static Methods
	static CAccount*	 	Find			( DSMailUser* inMailUser, CreateOnDemand inCreate );
	static CAccount*		Create			( DSMailUser* inMailUser );
	static Boolean 			Delete			( CAccount* inAccount );
	static uInt32			Count			( void );
	static Boolean			GetSetFields	( const eFieldDataRequest inFieldRequest, const void *inObjDataPtr, void *outFieldData);

	static 	CAccount*		FindByID			( const	ObjID	inObjectID );
	static	CDBBaseObject*	ObjectAllocNew		( void );

	static	OSType		GetObjTypeConstant	( void ) { return kAccountSignature; }
	static	uInt32		GetObjVersConstant	( void ) { return kAccountVersion; }
	static	uInt32		GetObjSizeConstant	( void ) { return kAccountDataSize; }
	
	virtual	void		ChkCompilerStructAlignment	( void );

	virtual	ObjID		GetObjectID			( void );
			void		Done				( CAccount* &inPtr );

	// Construction/Destruction
				CAccount	( void );
	virtual    ~CAccount	( void );

	// Object IDs 
	ObjID			GetAccountID(void);

	ObjID			GetPOP3InboxID				( CreateOnDemand inCreate = kCreate );
	void			SetPOP3InboxID				( ObjID inMailSpoolID );

	ObjID			GetIMAP4InboxID				( CreateOnDemand inCreate = kCreate );
	void			SetIMAP4InboxID				( ObjID inMailSpoolID );

	ObjID			GetPOP3InboxIDOnly			( void );
	ObjID			GetIMAP4InboxIDOnly			( void );

	void			SetDirty					( void );

	// Account Information
	const char *	GetAccountName				( void );
	void			SetAccountName				( const char* inAccountName );

	const char*		GetMailLocation				( void );
	void			SetMailLocation				( const char* inMailLocation );

	ObjID			GetMailUserID				( void );
	void			SetMailUserID				( const ObjID inMailUserID );

	const char *	GetDirectoryPath			( void );
	void			SetDirectoryPath			( const char * inDirectoryPath );

	void			SetAccountState				( eAccountState inAccountState );
	eAccountState	GetAccountState				( void);

	uInt32			GetACLFolderSynchStamp		( void );
	void			SetACLFolderSynchStamp		( const uInt32 inTimeStamp );

	Boolean			Validate					( DSMailUser* inMailUser );

	// Notification Methods
	uInt32 			GetNotifyIPAddress			( void );
	void			SetNotifyIPAddress			( uInt32 inNotifyAddress );

	void			SetNotifyUserOn				( void );
	void			SetNotifyUserOff			( void );

	void			SetNotifyOn					( void );
	void			SetNotifyOff				( void );

	void			SetUseLastIPAddrOn			( void );
	void			SetUseLastIPAddrOff			( void );

	Bool			IsNotifyOn					( void );
	Bool			UseLastIPAddress			( void );
	Boolean			IsNotifyPending				( void );

	void			ResetNotifyFailures			( void );
	uInt32			IncreaseNotifyFailures		( void );

	uInt32			GetAdminSetIPNotifyAddr		( void );
	void			SetAdminSetIPNotifyAddr		( uInt32 inAdminSetIPAddr );

	// Posting
	Boolean 		Post						( ObjID inEnvelopeID, DSMailUser* mailUser );
	sInt32			PostToInbox					( ObjID inEnvelopeID, DSMailUser *inMailUser, Bool bPostToPopInbox );

	uInt32			GetSpoolsSize				( bool inVerifySpools = false );

	// POP3 Server
	Boolean			GetPOPContext				( DSMailUser *inDSMailUser, char *outPOPContext );
	void			ReleasePOPContext			( char *inPOPContext );

	uInt32			GetReturnNameOk				( void );
	void			SetReturnNameOk				( uInt32 inValue );

private:
	sInt32			SynchAccount				( DSMailUser *inMailUser );
	sInt32			SynchFolders				( const char *inPath, const uInt32 inAcctID, const uInt32 inGroupID );

public:
//	CPOPContext	   *fPOPContext;
	CAccountData	fAccountData;	// this portion stored on disk...

private:
	CString		   *fMailLocation;
	char		   *fAcctNameStr;
	char		   *fDirPathStr;

};

#endif // __CAccount_h__
