/*
	$Id: CEnvelopeInfo.cpp,v 1.2 2003/07/22 18:43:08 dasenbro Exp $

	File:		CEnvelopeInfo.cpp

	Contains:	C++ implementation of EnvelopeInfo pointers to Envelopes.

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.2 $

	Written by:	Nick Brosnahan

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CEnvelopeInfo.cpp,v $
		Revision 1.2  2003/07/22 18:43:08  dasenbro
		Mark messages that have been migrated.
		
		Revision 1.1  2003/04/20 23:45:34  dasenbro
		Initial check-in.
		
		Revision 1.17  2002/07/16 01:16:33  dasenbro
		Added better handling of missing data files.
		
		Revision 1.16  2002/06/07 22:47:38  dasenbro
		Removed commented code in CheckExpiration().
		
		Revision 1.15  2002/06/04 17:57:58  dasenbro
		Added UnLockTheCache() to the catch().
		
		Revision 1.14  2002/04/18 18:09:12  dasenbro
		Changed bool to Bool for word alignment.
		
		Revision 1.13  2002/04/16 06:04:41  dasenbro
		Cleaned up try/catch blocks.
		
		Revision 1.12  2002/03/21 16:41:23  dasenbro
		Updated file version information.
		
		Revision 1.11  2002/03/11 23:42:01  dasenbro
		Now read host prefs from directory.
		
		Revision 1.10  2002/01/14 17:27:40  dasenbro
		Initial S4 updates.
		
		Revision 1.9  2001/06/21 20:50:58  dasenbro
		Updated file header info.
		
		Revision 1.8  2001/06/21 17:48:33  dasenbro
		Added Change History.
		

	Projector History:

	  <ASM4>	  2/4/99	MED		Added getter/setter for fReserved1 and set that fReserved1 to
									::time(nil) when a message is first seen.
		 <3>	10/30/98	DOR		Fix it so that when the object's 2nd ID changes that it is
									immediately flushed to the Database so that the 2nd ID iteration
									table is updated, even before the object's final "Done" is
									called.
		 <2>	10/13/98	DOR		Lock the cache when deleting an object.
		<27>	 9/21/98	DOR		Change all uses of "Assert_" to "MailAssert"..
		<26>	 9/21/98	DOR		Don't Use NULL Pointers.
		<25>	  6/1/98	DOR		Fix "GetSetFields"
		<24>	  6/1/98	DOR		Remove the "kAdd" argument from Create since we no longer use
									it.
		<23>	  6/1/98	MED		Changed ::Create to be a more kinder and gentler ::Create.
		<22>	 5/29/98	DOR		Add a NULL check to some code.
		<21>	 5/19/98	MED		Added future expansion data members.
		<20>	  5/8/98	DOR		Only send NDR's for the recipients that belong to the spool
									where the message is being deleted.
		<19>	  4/2/98	DOR		Change call to gDB->removeObject
		<18>	03/24/98	DOR		Fix a memory leak with Host preferences.
		<17>	 3/14/98	DOR		Close up a race condition in ::Create..
		<15>	 3/11/98	MED		Changed FindByID() to do a Use() only if it created the object,
									FindMe() now does an explicit Use().
		<14>	 3/10/98	DOR		CMailSpool::Remove changed, make adjustments in how we call it..
		<13>	  3/9/98	DOR		Fix KillEnvelope.
		<12>	  3/9/98	DOR		Change KillEnvelope to only kill the envelope in the current
									spool, rather than all copies.
		<11>	 2/16/98	DOR		Make the warning's code pay attention to the "Warning's Flag" in
									the Mail-Out Server Settings.
		<10>	  2/3/98	MED		Cleaned OSUtil.cp into CUtils.cp, COSUtils.cp and
									CSmartYield.cp.
		 <9>	12/15/97	DOR		Update the object version to "include" the size of the
									dataportion of the object, and add an assert to "FindByID" that
									checks the version of the object.
		 <8>	12/12/97	DOR		NDR changes.
		 <7>	12/10/97	MED		We get warning and other prefs from the DB instead of ASD.
		 <6>	 12/3/97	MED		Changed CInHostEntryPref to CHostEntryPref.
		 <5>	 12/2/97	DOR		Add code to support rejecting messages.
		 <4>	 12/2/97	DOR		Warning now respect HI preference settings.
		 <3>	11/21/97	DOR		Add code to check for warnings.
		 <2>	11/20/97	MED		Changed Throw to Throw_ for non-Debug build.

	To Do:
*/


#include <time.h>
#include <sys/stat.h>

#include "CEnvelopeInfo.h"
#include "CMailSpool.h"
#include "CEnvelope.h"
#include "DSMgr.h"
#include "DSServerPrefs.h"
#include "CStatMgr.h"
#include "CMailDatabase.h"
#include "CUtils.h"
#include "CGlobals.h"
#include "DSHostPrefs.h"


extern CMailDatabase	*gDB;	// From CAppServer.cpp

Boolean	CEnvelopeInfo::GetSetFields	(const eFieldDataRequest inFieldRequest, const void *inObjDataPtr, void *outFieldData)
{
	Boolean	result = false;
	CEnvInfoData	*theData		= (CEnvInfoData *) inObjDataPtr;
	CEnvelopeInfo	*aTempObject	= NULL;
	ObjID			*anObjIDPtr		= (ObjID *) outFieldData;

	switch (inFieldRequest)
	{
		case kSetObjID:
			if (theData != NULL)
			{
				theData->fEnvelopeInfoID = *anObjIDPtr;
			}
			break;
			
		case k2ndIDRequest:
			if (theData != NULL)
			{
				if (theData->fMailSpoolID != 0)
				{
					*anObjIDPtr = theData->fMailSpoolID;
					result = true;
				}
			}
			break;

		case kObjectPINGRequest:
			// cause the objects constructor to get called, so we force a check of
			// the struct alignment...
			aTempObject = new CEnvelopeInfo;
			delete aTempObject;
			break;

		case k2ndIDTargetChk:
			// fall through...
			
		case kStringNameRequest:
		default:
			result = false;
			break;
	}
	
	return result;
}


ObjID CEnvelopeInfo::GetObjectID	( void )
{
	return fEnvInfoData.fEnvelopeInfoID;
}

//--------------------------------------------------------------------------------------------------
//	 Done
//
//--------------------------------------------------------------------------------------------------

void CEnvelopeInfo::Done ( CEnvelopeInfo* &inPtr )
{
	CDBBaseObject *aDBObject = (CDBBaseObject *) inPtr;
	aDBObject->Done(aDBObject);
	inPtr = (CEnvelopeInfo *)aDBObject;

}


CDBBaseObject * CEnvelopeInfo::ObjectAllocNew	( void )
{
	return new CEnvelopeInfo;
}

CEnvelopeInfo* CEnvelopeInfo::FindByID ( const ObjID inObjectID )
{
	return (CEnvelopeInfo *) CDBMailBaseObject::MailUniversalFindByID(	inObjectID,
														CEnvelopeInfo::GetObjTypeConstant(),
														CEnvelopeInfo::GetObjVersConstant(),
														CEnvelopeInfo::GetObjSizeConstant(),
														CEnvelopeInfo::ObjectAllocNew		);
} // FindByID





CEnvelopeInfo* CEnvelopeInfo::FindBySpoolEnvelope (ObjID inMailSpoolID, ObjID inEnvelopeID)
{
	if ((inMailSpoolID == 0) || (inEnvelopeID == 0))
	{
		return (NULL);
	}
	
	SDBIterator		*theIterator = NULL;
	ObjID			theEnvInfoID;
	CEnvelopeInfo	*theEnvInfo = NULL;
	CMailSpool		*theMailSpool = NULL;
	
	
	theMailSpool = CMailSpool::FindByID(inMailSpoolID);
	if (theMailSpool != NULL)
	{
		theIterator = theMailSpool->GetEnvelopeInfoIterator();

		while (gDB->NextObject(theIterator, theEnvInfoID) == kNoErr)
		{
			theEnvInfo = CEnvelopeInfo::FindByID(theEnvInfoID);
			if (theEnvInfo != NULL)
			{
				if (theEnvInfo->GetEnvelopeID() == inEnvelopeID)
				{
					break;
				}
				
				theEnvInfo->Done(theEnvInfo);
			}
		}
		theMailSpool->ReleaseEnvelopeInfoIterator(theIterator);
	}
	
	
	return theEnvInfo;
}


CEnvelopeInfo* CEnvelopeInfo::Create (	ObjID	 inMailSpoolID,
										ObjID	 inEnvelopeID,
										uInt32	 inMsgSize )
{
	CEnvelopeInfo* theEnvelopeInfo = new CEnvelopeInfo;
	OSErr	result;
	ObjID	aNewID;
	
	try
	{
		ThrowIfMemFail_( theEnvelopeInfo );
		
		(gDB->GetBaseObjectCachePtr())->LockTheCache(CEnvelopeInfo::GetObjTypeConstant());
		
		result = gDB->CreateObj(CEnvelopeInfo::GetObjTypeConstant(), aNewID, theEnvelopeInfo->GetEnvInfoData());
		if ( result == CMailDatabase::kDBNoErr )
		{
			theEnvelopeInfo->Use();
			theEnvelopeInfo->SetMailSpoolID(inMailSpoolID);
			theEnvelopeInfo->SetEnvelopeID(inEnvelopeID);
			theEnvelopeInfo->SetMsgSize(inMsgSize);	
			theEnvelopeInfo->SetDirty();
		}
		else
		{
			delete theEnvelopeInfo;
			theEnvelopeInfo = NULL;
		}
			
		(gDB->GetBaseObjectCachePtr())->UnLockTheCache(CEnvelopeInfo::GetObjTypeConstant());
	}

	catch ( long err )
	{
		(gDB->GetBaseObjectCachePtr())->UnLockTheCache(CEnvelopeInfo::GetObjTypeConstant());
	}
	
	catch ( ... )
	{
		(gDB->GetBaseObjectCachePtr())->UnLockTheCache(CEnvelopeInfo::GetObjTypeConstant());
	}

	return( theEnvelopeInfo );
}

Boolean CEnvelopeInfo::Delete(CEnvelopeInfo* inEnvelopeInfo)
{
	OSErr	result;
	// Note: This method should only _ever_ be called from CMailSpool::Remove()
	//       We do not remove references to CEnvelopes here.

	Boolean deleted = false;
	
	try
	{
		if ( inEnvelopeInfo != NULL )
		{
			(gDB->GetBaseObjectCachePtr())->LockTheCache(CEnvelopeInfo::GetObjTypeConstant());

			result = gDB->RemoveObj(CEnvelopeInfo::GetObjTypeConstant(), inEnvelopeInfo->GetEnvelopeInfoID());
			deleted = (result == kNoErr);
			if (deleted)
			{
				inEnvelopeInfo->fEnvInfoData.fEnvelopeInfoID = 0;
			}
			
			(gDB->GetBaseObjectCachePtr())->UnLockTheCache(CEnvelopeInfo::GetObjTypeConstant());
		}
	}

	catch ( long err )
	{
		(gDB->GetBaseObjectCachePtr())->UnLockTheCache(CEnvelopeInfo::GetObjTypeConstant());
	}

	catch ( ... )
	{
		(gDB->GetBaseObjectCachePtr())->UnLockTheCache(CEnvelopeInfo::GetObjTypeConstant());
	}

	return( deleted );
}

uInt32 CEnvelopeInfo::Count(void)
{
	OSErr result;
	uInt32 aCount = 0;
	result = gDB->GetObjectCount (CEnvelopeInfo::GetObjTypeConstant(), aCount);	// of ourselves
	if (result != kNoErr)
	{
		aCount = 0;
	}
	
	return aCount;
}

#pragma mark -

CEnvelopeInfo::CEnvelopeInfo ( void ) :
	CDBMailBaseObject(	&fEnvInfoData.fDBHeader,
				&fEnvInfoData.fDBFooter,
				&fEnvInfoData,
				CEnvelopeInfo::GetObjTypeConstant(),
				CEnvelopeInfo::GetObjVersConstant(),
				CEnvelopeInfo::GetObjSizeConstant() )
{
	fEnvInfoData.fEnvelopeInfoID	 = 0;
	fEnvInfoData.fMailSpoolID		 = 0;
	fEnvInfoData.fEnvelopeID		 = 0;
	fEnvInfoData.fSeenTime			 = 0;
	fEnvInfoData.fMessageUID		 = 0;
	fEnvInfoData.fMessageSize		 = 0;	
	fEnvInfoData.fEnvInfoWarningTime = 0;	
	fEnvInfoData.fFlags				 = 0;

	// Reserved
	fEnvInfoData.fReserved2			= kReservedConst;

	this->ChkCompilerStructAlignment();
} // CEnvelopeInfo



CEnvelopeInfo::~CEnvelopeInfo()
{
}

void	CEnvelopeInfo::ChkCompilerStructAlignment	( void )
{
	/*
		this dump was aquired by using the MPW command DumpSYM - TTE from the .xsym file produced
		from a Code Warrior Pro 1 Release Build of the AppleShare IP Mail Server for MacOS version 6.2
		
		this version of the structure is consider the "reference" standard for all future ASIP Mail Servers.
		If the structure does NOT match these offsets the version of the Mail Server that 
		you are compiling will _NOT_ be compatible with AppleShare IP 6.0, 6.1, or 6.2 (this also effects
		the AppleShare IP Mail Tool, and to a more limited extent the AppleShare IP Mail Admin since some
		of these structures are passed across the wire..)
		
		If _ANY_ of these Asserts "fire" you've got a backwards compatibility problem that _MUST_ be fixed!!
		
		this code wasn't put here for my personal amusement, this code was put here from a hard earned lesson
		that simple changes to headers/compilers _WILL_ break this stuff, better to know now than after we
		ship.  Look upon this code as a debugging AIDE, not an impediment.
		
		Type Name:  CEnvInfoData		TINFO offset: 45724		(TINFO SYM file offset (hex): $12329C)
			RecordOf
			offset 0 NamedTypeOf fDBHeader TypeDef of "Type ID 248"
			offset 12 NamedTypeOf fEnvelopeInfoID 
			offset 16 NamedTypeOf fMailSpoolID unsigned long 
			offset 20 NamedTypeOf fEnvelopeID 
			offset 24 NamedTypeOf fReserved1 unsigned long 
			offset 28 NamedTypeOf fReserved2 
			offset 32 NamedTypeOf fMessageSize unsigned long 
			offset 36 NamedTypeOf fFlags 
			offset 40 NamedTypeOf fEnvInfoWarningTime unsigned long 
			offset 44 NamedTypeOf fDBFooter 
	*/

	static Boolean	aRunOnceFlag = false;	
	if (aRunOnceFlag == false)
	{
		//FileFormatSaftyChk(CEnvInfoData, fDBHeader, 			0);
		//FileFormatSaftyChk(CEnvInfoData, fEnvelopeInfoID,		12);		// this is us (denormalized)
		//FileFormatSaftyChk(CEnvInfoData, fMailSpoolID,			16);			// this is the mail spool we belong to
		//FileFormatSaftyChk(CEnvInfoData, fEnvelopeID,			20);			// this is the envelope we point at
		//FileFormatSaftyChk(CEnvInfoData, fReserved1,				24);
		//FileFormatSaftyChk(CEnvInfoData, fReserved2,				28);
		//FileFormatSaftyChk(CEnvInfoData, fMessageSize, 			32);
		//FileFormatSaftyChk(CEnvInfoData, fFlags, 				36);
		//FileFormatSaftyChk(CEnvInfoData, fEnvInfoWarningTime,	40);
		//FileFormatSaftyChk(CEnvInfoData, fDBFooter, 			44);
//		this->ReportBackwardCompatibility(sizeof(CEnvInfoData),	48,	"CEnvInfoData", "SIZEOF()");
//		this->ReportBackwardCompatibility(kEnvelopeInfoDataSize,	48,	"CEnvInfoData", "kEnvelopeInfoDataSize");
	}
	
	aRunOnceFlag = true;
}

#pragma mark -

ObjID CEnvelopeInfo::GetEnvelopeInfoID(void)
{
	return (fEnvInfoData.fEnvelopeInfoID);
}

// ---------------------------------------------------------------------------
//	* GetMessageUID ()
//
// ---------------------------------------------------------------------------

ObjID CEnvelopeInfo::GetMessageUID ( void )
{
	return( fEnvInfoData.fMessageUID );

} // GetMessageUID


// ---------------------------------------------------------------------------
//	* SetMessageUID ()
//
// ---------------------------------------------------------------------------

void CEnvelopeInfo::SetMessageUID ( ObjID inUID )
{
	if ( (this != NULL) && (fEnvInfoData.fMessageUID != inUID) )
	{
		fEnvInfoData.fMessageUID = inUID;
		this->setDirty();
	}
} // SetMessageUID


ObjID CEnvelopeInfo::GetMailSpoolID ( void )
{
	return( fEnvInfoData.fMailSpoolID );
}

void CEnvelopeInfo::SetDirty ( void )
{
	if ((this != NULL) && (this->GetEnvelopeInfoID() != 0))
	{
		this->setDirty();
	}
}

CEnvInfoData* CEnvelopeInfo::GetEnvInfoData ( void )
{
	if (this != NULL)
	{
		return( &fEnvInfoData );
	}

	return( NULL );
}

uInt32 CEnvelopeInfo::GetMigrationFlag ( void )
{
	return ( fEnvInfoData.fReserved2 );
}

void CEnvelopeInfo::SetMigrationFlag( uInt32 inMigrationFlag )
{
	if ( fEnvInfoData.fReserved2 != inMigrationFlag )
	{
		fEnvInfoData.fReserved2 = inMigrationFlag;
		this->SetDirty();
	}
}

void CEnvelopeInfo::SetMailSpoolID ( ObjID inMailSpoolID )
{
	// the MailSpool ID is used as a CMailDatabase 2nd-ID object.  We need to flush
	// this through to the mail db immediately so that any iteration that is
	// going on will reflect the proper list iteration...
	// if you don't understand why this is important you don't understand the
	// Mail server's DB & our caching code and you shouldn't be changing it.
	
	try
	{
			if ( fEnvInfoData.fMailSpoolID != inMailSpoolID )
		{
			(gDB->GetBaseObjectCachePtr())->LockTheCache( CEnvelopeInfo::GetObjTypeConstant() );
			fEnvInfoData.fMailSpoolID = inMailSpoolID;
			this->SetDirty();
			this->setDirty(true);
			(gDB->GetBaseObjectCachePtr())->UnLockTheCache( CEnvelopeInfo::GetObjTypeConstant() );
		}
	}

	catch ( ... )
	{
		(gDB->GetBaseObjectCachePtr())->UnLockTheCache( CEnvelopeInfo::GetObjTypeConstant() );
	}
}

ObjID CEnvelopeInfo::GetEnvelopeID(void)
{
	return (fEnvInfoData.fEnvelopeID);
}

void CEnvelopeInfo::SetEnvelopeID(ObjID inEnvelopeID)
{
	if (fEnvInfoData.fEnvelopeID != inEnvelopeID)
	{
		fEnvInfoData.fEnvelopeID = inEnvelopeID;
		this->SetDirty();
	}
}

#pragma mark -

uInt32 CEnvelopeInfo::GetMsgSize(Boolean inIncludeStatus)
{
	if (inIncludeStatus)
	{
		if (this->IsPOP3Read())
			return (fEnvInfoData.fMessageSize + 11);		// length of "Status: R"<CR><LF>
	}

	return (fEnvInfoData.fMessageSize);
}

void CEnvelopeInfo::SetMsgSize(uInt32 inMsgSize)
{
	if (fEnvInfoData.fMessageSize != inMsgSize)
	{
		fEnvInfoData.fMessageSize = inMsgSize;
		this->SetDirty();
	}
}

uInt32 CEnvelopeInfo::GetFlags(void)
{
	return (fEnvInfoData.fFlags);
}

void CEnvelopeInfo::SetFlags ( uInt32 inFlags )
{
	CMailSpool	*pMailSpool	= nil;

	// Set the envelope info flags
	if ( fEnvInfoData.fFlags != inFlags )
	{
		// Get this envelopes Mail Spool
		pMailSpool = CMailSpool::FindByID( this->GetMailSpoolID() );
		if ( pMailSpool != nil )
		{
			// Going from Seen to Unseen
			if ( (fEnvInfoData.fFlags & kIMAP4Seen) && (!(inFlags & kIMAP4Seen)) )
			{
				pMailSpool->IncrementUnseenCount();
			}
			// Unseen to Seen
			else if ( (!(fEnvInfoData.fFlags & kIMAP4Seen)) && (inFlags & kIMAP4Seen) )
			{
				pMailSpool->DecrementUnseenCount();
			}

			pMailSpool->Done( pMailSpool );
		}

		// Has it already been seen
		if ( fEnvInfoData.fFlags & kIMAP4Seen )
		{
		}

		fEnvInfoData.fFlags = inFlags;
		if ( fEnvInfoData.fFlags & kIMAP4Seen )
		{
			if ( this->GetSeenTime() == 0 )
			{
				SetSeenTime( ::time( nil ) );
			}
		}
		this->SetDirty();
	}
}

uInt32 CEnvelopeInfo::GetEnvInfoWarnTime(void)
{
	return (fEnvInfoData.fEnvInfoWarningTime);
}

void CEnvelopeInfo::SetEnvInfoWarnTime(const uInt32 inWarnTime)
{
	if (fEnvInfoData.fEnvInfoWarningTime != inWarnTime)
	{
		fEnvInfoData.fEnvInfoWarningTime = inWarnTime;
		this->SetDirty();
	}
}

uInt32 CEnvelopeInfo::GetSeenTime ( void )
{
	return ( fEnvInfoData.fSeenTime );
}

void CEnvelopeInfo::SetSeenTime ( const uInt32 inValue )
{
	if ( fEnvInfoData.fSeenTime != inValue )
	{
		fEnvInfoData.fSeenTime = inValue;
		this->SetDirty();
	}
}

#pragma mark -

Boolean CEnvelopeInfo::IsPOP3Read(void)
{
	return ((fEnvInfoData.fFlags & kPOP3Read) != 0);
}

Boolean CEnvelopeInfo::IsPOP3Deleted(void)
{
	return ((fEnvInfoData.fFlags & kPOP3Deleted) != 0);
}

void CEnvelopeInfo::SetPOP3Read ( Boolean inValue )
{
	if ( inValue == true )
	{
		fEnvInfoData.fFlags |= kPOP3Read;
		if ( this->GetSeenTime() == 0 )
		{
			SetSeenTime( ::time( nil ) );
		}
	}
	else
	{
		fEnvInfoData.fFlags &= ~kPOP3Read;
	}
	this->SetDirty();
}

void CEnvelopeInfo::SetPOP3Deleted(Boolean inValue)
{
	if (inValue == true)
		fEnvInfoData.fFlags |= kPOP3Deleted;
	else
		fEnvInfoData.fFlags &= ~kPOP3Deleted;

	this->SetDirty();
}

#pragma mark -

uInt32 CEnvelopeInfo::GetMessageSize(Boolean inIncludeStatus)
{
	return (this->GetMsgSize(inIncludeStatus));
}

#pragma mark -

void CEnvelopeInfo::Finish( char *inHostEntry, uInt32 inFinishType )
{
}

void CEnvelopeInfo::FinishRouting( CMailSpool* inMailSpool, CEnvelope* inEnvelope )
{
	Bool			SendPostmasterNDR	= false;
	DSHostPrefs		*pHostPrefs			= NULL;

	// First Generate Error Messages

	pHostPrefs = DSMgr::GetHostPrefsObj();
	if ( pHostPrefs != nil )
	{
		pHostPrefs->GetNotifyPostmasterOfNDR( &SendPostmasterNDR );
	}

	// If there are no recipients remaining to be routed, 
	// we can remove the envelopeinfo from the incoming mail spool.
	
	if (inEnvelope->GetRecipientCount(CEnvelope::kPendingRoutingCount) == 0)
	{
		inMailSpool->Remove( this );
	}
}

void CEnvelopeInfo::FinishSending (CMailSpool* inMailSpool, CEnvelope* inEnvelope)
{
}


// ---------------------------------------------------------------------------
//		* CEnvelopeInfo LogExpiration
//
//			Log expiration message  
// ---------------------------------------------------------------------------

void CEnvelopeInfo::LogExpiration ( CEnvelope *inEnvelope, const char* inHostName, uInt32 inCount )
{
} // LogExpiration

void CEnvelopeInfo::RejectMessage ( char *inHostEntry, CMailSpool* inMailSpool, CEnvelope* inEnvelope )
{
} // 


void CEnvelopeInfo::CheckExpiration ( char *inHostEntry, CMailSpool* inMailSpool, CEnvelope* inEnvelope)
{
}

void CEnvelopeInfo::CheckWarning (char *inHostEntry, CMailSpool* inMailSpool, CEnvelope* inEnvelope)
{
}


void CEnvelopeInfo::BounceDisabled (CMailSpool* inMailSpool, CEnvelope* inEnvelope)
{
}

void CEnvelopeInfo::KillEnvelope(const Boolean inNotifySender)
{
}


bool CEnvelopeInfo::VerifyMessage ( void )
{
	bool			bResult			= false;
	sInt32			siResult		= kNoErr;
	CEnvelope	   *pEnvObj			= NULL;
	struct stat		statbuf;

	pEnvObj = CEnvelope::FindByID( this->GetEnvelopeID() );
	if ( pEnvObj != NULL )
	{
		siResult = ::stat( pEnvObj->GetDataFilePath(), &statbuf );
		if ( siResult == 0 )
		{
			bResult = true;
		}
		pEnvObj->Done( pEnvObj );
	}

	return( bResult );

} // 
