/*
	$Id: CEnvelopeInfo.h,v 1.2 2003/07/22 18:43:08 dasenbro Exp $

	File:		CEnvelopeInfo.h

	Contains:	C++ class definition for EnvelopeInfo pointer objects to Envelopes

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.2 $

	Written by:	Nick Brosnahan

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CEnvelopeInfo.h,v $
		Revision 1.2  2003/07/22 18:43:08  dasenbro
		Mark messages that have been migrated.
		
		Revision 1.1  2003/04/20 23:45:34  dasenbro
		Initial check-in.
		
		Revision 1.10  2002/07/16 01:16:33  dasenbro
		Added better handling of missing data files.
		
		Revision 1.9  2002/03/21 16:41:23  dasenbro
		Updated file version information.
		
		Revision 1.8  2001/06/21 20:50:58  dasenbro
		Updated file header info.
		
		Revision 1.7  2001/06/21 18:18:47  dasenbro
		Added Change History.
		

	Projector History:

	  <ASM2>	  2/4/99	MED		Added getter/setter for fReserved1.
		<12>	  6/1/98	DOR		Remove the "kAdd" argument from Create since we no longer use
									it.
		<11>	 5/19/98	MED		Added future expansion data members.
		 <9>	  3/9/98	DOR		Changes to KillEnvelope.
		 <8>	12/15/97	DOR		Update the object version to "include" the size of the
									dataportion of the object, and add an assert to "FindByID" that
									checks the version of the object.
		 <7>	12/12/97	DOR		NDR Changes
		 <6>	 12/2/97	DOR		Add code to support rejecting messages.
		 <5>	 12/2/97	DOR		Warning's now respect HI preferences.
		 <4>	11/21/97	DOR		Add code to deal with non-delivery warnings.
		 <3>	10/22/97	MED		Moved the changed flage to the IMAP session.
		 <2>	10/22/97	MED		Added a changed flag to the IMAP envelope info flags.

	To Do:
*/


#ifndef __CEnvelopeInfo_h__
#define __CEnvelopeInfo_h__	1

#include "CDBMailBaseObject.h"
#include "DatabaseTypes.h"
#include "CIDTable.h"
#include "CMailDatabase.h"

class CMailSpool;
class CEnvelope;


typedef struct
{
	StdDBObjHeader	fDBHeader;
	ObjID			fEnvelopeInfoID;		// this is us (denormalized)
	ObjID			fMailSpoolID;			// this is the mail spool we belong to
	ObjID			fEnvelopeID;			// this is the envelope we point at
	ObjID			fSeenTime;				// set the time this message was seen
	
	// Reserved
	uInt32			fMessageUID;			// messgae UID
	uInt32			fReserved2;				// reserverd

	// EnvelopeInfo Information
	uInt32			fMessageSize;
	uInt32			fFlags;
	uInt32			fEnvInfoWarningTime;
	StdDBObjFooter	fDBFooter;
} CEnvInfoData;

// CDBMailBaseObject constants
const uInt32 kEnvelopeInfoDataSize = sizeof (CEnvInfoData);								  
const uInt32 kEnvelopeInfoVersion = kDBCurrentVersion + kEnvelopeInfoDataSize;

class CEnvelopeInfo : public CDBMailBaseObject
{
public:

	typedef enum
	{
		kNone			= 0x00000000,
		
		// POP3
		kPOP3FlagsMask 	= 0x0000000F,
		kPOP3Read		= 0x00000001,	
		kPOP3Deleted	= 0x00000002,	
		
		// IMAP4
		kIMAP4FlagsMask	= 0x00000FF0,
		kIMAP4Seen		= 0x00000010,	
		kIMAP4Answered	= 0x00000020,	
		kIMAP4Flagged	= 0x00000040,	
		kIMAP4Deleted	= 0x00000080,	
		kIMAP4Draft		= 0x00000100,
		kIMAP4Recent	= 0x00000200
	} EnvelopeInfoFlags;

	// Static Methods
	static CEnvelopeInfo*	FindBySpoolEnvelope (ObjID inMailSpoolID, ObjID inEnvelopeID); 
											     
	static CEnvelopeInfo*	Create(ObjID inMailSpoolID, ObjID inEnvelopeID, uInt32 inMsgSize );
	static Boolean			Delete(CEnvelopeInfo* inEnvelopeInfo);
	static uInt32			Count(void);
	static Boolean			GetSetFields	(const eFieldDataRequest inFieldRequest, const void *inObjDataPtr, void *outFieldData);

	static 	CEnvelopeInfo*	FindByID		( const	ObjID	inObjectID );
	static	CDBBaseObject*	ObjectAllocNew		( void );

	static	OSType		GetObjTypeConstant	( void ) { return kEnvelopeInfoSignature; }
	static	uInt32		GetObjVersConstant	( void ) { return kEnvelopeInfoVersion; }
	static	uInt32		GetObjSizeConstant	( void ) { return kEnvelopeInfoDataSize; }
	virtual	ObjID		GetObjectID			( void );

// Construction/Destruction
				CEnvelopeInfo(void);
	virtual		~CEnvelopeInfo(void);
	virtual		void ChkCompilerStructAlignment(void);

	void		Done( CEnvelopeInfo* &inPtr );
						
	// Object IDs
	ObjID		GetEnvelopeInfoID(void);
	
	ObjID		GetMessageUID	( void );
	void		SetMessageUID	( ObjID inUID );

	ObjID		GetMailSpoolID(void);
	void		SetMailSpoolID(ObjID inMailSpoolID);

	ObjID		GetEnvelopeID(void);
	void		SetEnvelopeID(ObjID inEnvelopeID);

	// CEnvelopeInfo Information 
	uInt32		GetMsgSize(Boolean inIncludeStatus = false);
	void		SetMsgSize(uInt32 inMsgSize);

	uInt32		GetFlags(void);
	void		SetFlags(uInt32 inFlags);
	
	uInt32		GetEnvInfoWarnTime(void);
	void		SetEnvInfoWarnTime(const uInt32 inWarnTime);
 
	uInt32		GetSeenTime			( void );
	void		SetSeenTime			( const uInt32 inWarnTime );
	
	uInt32		GetMigrationFlag	( void );
	void		SetMigrationFlag	( uInt32 inMigrationFlag );

	// POP3 Flags
	Boolean		IsPOP3Read(void);
	Boolean		IsPOP3Deleted(void);
	
	void		SetPOP3Read(Boolean inValue);
	void		SetPOP3Deleted(Boolean inValue);

	// CEnvelope Methods 
	uInt32		GetMessageSize(Boolean inIncludeStatus = false);	// convenience
				
	enum 
	{ 
		kRouting 			= 0x00000001, 
		kSending			= 0x00000002,
		kExpiration 		= 0x00000004,
		kBounceDisabled		= 0x00000008,
		kWarningCheck		= 0x00000010,
		kRejectThisMessage  = 0x00000020
	};
	
	void Finish(char *inHostEntry, uInt32 inFinishType);
	void KillEnvelope (Boolean inNotifySender);
	

	void FinishRouting	 ( CMailSpool* inMailSpool, CEnvelope* inEnvelope );
	void FinishSending	 ( CMailSpool* inMailSpool, CEnvelope* inEnvelope );
	void CheckExpiration ( char *inHostEntry, CMailSpool* inMailSpool, CEnvelope* inEnvelope );
	void CheckWarning	 ( char *inHostEntry, CMailSpool* inMailSpool, CEnvelope* inEnvelope );
	void RejectMessage	 ( char *inHostEntry, CMailSpool* inMailSpool, CEnvelope* inEnvelope );
	void LogExpiration	 ( CEnvelope *inEnvelope, const char* inHostName, uInt32 inCount );
	void BounceDisabled	 ( CMailSpool* inMailSpool, CEnvelope* inEnvelope );
	
	CEnvInfoData*	GetEnvInfoData ( void );
	void			SetDirty ( void );

	bool			VerifyMessage	( void );
	
	CEnvInfoData	fEnvInfoData;
};

//------------------------------------------------------------------------------
#endif // __CEnvelopeInfo_h__
