/*
	$Id: CMimePart.cpp,v 1.1 2003/04/20 23:30:51 dasenbro Exp $

	File:		CMimePart.cpp

	Contains:	C++ implemenation of the message envelope container class

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CMimePart.cpp,v $
		Revision 1.1  2003/04/20 23:30:51  dasenbro
		Initial check-in.
		
		Revision 1.5  2002/03/21 16:41:32  dasenbro
		Updated file version information.
		
		Revision 1.4  2001/06/21 20:51:04  dasenbro
		Updated file header info.
		
		Revision 1.3  2001/06/21 19:34:01  dasenbro
		Added Change History.
		

	Projector History:

	  <ASM3>	 2/24/99	MED		Initialize a data member string to null.
	  <ASM2>	 1/24/99	MED		Added DecLastPart.

	To Do:
*/


#include "CMimePart.h"

#include <string.h>
#include <stdio.h>



//--------------------------------------------------------------------------------------------------
//	* CMimePart
//
//--------------------------------------------------------------------------------------------------

CMimePart::CMimePart ( void )
{
	fIsText			= false;
	fMsgPartNum		= 0;
	fPartOffset		= 0;
	fPartLength		= 0;
	fLineCount		= 0;
	::memset( fBaseParts, 0, sizeof( fBaseParts ) );
	::memset( fBaseStr, 0, kMaxPartLen );
} // CMimePart



//--------------------------------------------------------------------------------------------------
//	* ~CMimePart
//
//--------------------------------------------------------------------------------------------------

CMimePart::~CMimePart ( void )
{
} // ~CMimePart



//--------------------------------------------------------------------------------------------------
//	* GetIsText
//
//		- Returns 'true' if the current MIME part is of type "TEXT"
//
//--------------------------------------------------------------------------------------------------

Boolean CMimePart::GetIsText ( void )
{
	return( fIsText );
} // GetIsText



//--------------------------------------------------------------------------------------------------
//	* SetIsText
//
//		- Set to 'true' if the current MIME part is of type "TEXT"
//
//--------------------------------------------------------------------------------------------------

void CMimePart::SetIsText ( Boolean inIsText )
{
	fIsText = inIsText;
} // SetIsText



//--------------------------------------------------------------------------------------------------
//	* GetMsgPartID
//
//		- Returns the current MIME part's 'message part' number
//
//--------------------------------------------------------------------------------------------------

uInt32 CMimePart::GetMsgPartID ( void )
{
	return( fMsgPartNum );
} // GetMsgPartID



//--------------------------------------------------------------------------------------------------
//	* SetMsgPartID
//
//		- Sets the current MIME part's 'message part' number
//
//--------------------------------------------------------------------------------------------------

void CMimePart::SetMsgPartID ( uInt32 inMessagePartID )
{
	fMsgPartNum = inMessagePartID;
} // SetMsgPartID



//--------------------------------------------------------------------------------------------------
//	* GetOffset
//
//		- Returns the offset from the start of the current "message part"
//		 	for the current MIME part
//
//--------------------------------------------------------------------------------------------------

uInt32 CMimePart::GetOffset ( void )
{
	return( fPartOffset );
} // GetOffset



//--------------------------------------------------------------------------------------------------
//	* SetOffset
//
//		- Sets the offset to the current MIME part into the current "message part"
//
//--------------------------------------------------------------------------------------------------

void CMimePart::SetOffset ( uInt32 inOffset )
{
	fPartOffset = inOffset;
} // SetOffset



//--------------------------------------------------------------------------------------------------
//	* GetLength
//
//		- Returns the length of the current MIME part
//
//--------------------------------------------------------------------------------------------------

uInt32 CMimePart::GetLength ( void )
{
	return( fPartLength );
} // GetLength



//--------------------------------------------------------------------------------------------------
//	* SetLength
//
//		- Sets the length of the current MIME part
//
//--------------------------------------------------------------------------------------------------

void CMimePart::SetLength ( uInt32 inLength )
{
	fPartLength = inLength;
} // SetLength



//--------------------------------------------------------------------------------------------------
//	* GetLineCount
//
//		- Returns the line count for the current MIME part
//
//--------------------------------------------------------------------------------------------------

uInt32 CMimePart::GetLineCount ( void )
{
	return( fLineCount );
} // GetLineCount



//--------------------------------------------------------------------------------------------------
//	* SetLineCount
//
//		- Sets the line count for the current MIME part
//
//--------------------------------------------------------------------------------------------------

void CMimePart::SetLineCount ( uInt32 inLineCount )
{
	fLineCount = inLineCount;
} // SetLineCount



//--------------------------------------------------------------------------------------------------
//	* GetPartNumStr
//
//		- Returns the MIME part number base
//
//--------------------------------------------------------------------------------------------------

char* CMimePart::GetPartNumStr ( void )
{
	return( fBaseStr );
} // GetPartNumber



//--------------------------------------------------------------------------------------------------
//	* IncLastPart
//
//		- Find the last non-zero element in the array and increment it by 1
//
//--------------------------------------------------------------------------------------------------

void CMimePart::IncLastPart ( void )
{
	sInt16		i = 0;

	if ( fBaseParts[0] == 0 )
	{
		fBaseParts[0] = 1;
	}
	else
	{
		while ( fBaseParts[i] != 0 && (i < kMaxMimeParts) )
		{
			i++;
		}
		if ( i > 0 )
		{
			fBaseParts[i - 1]++;
		}
	}
} // IncLastPart



//--------------------------------------------------------------------------------------------------
//	* DecLastPart
//
//		- Find the last non-zero element in the array and decrements it by 1
//
//--------------------------------------------------------------------------------------------------

void CMimePart::DecLastPart ( void )
{
	sInt16		i = 0;

	if ( fBaseParts[0] == 0 )
	{
		fBaseParts[0] = 1;
	}
	else
	{
		while ( fBaseParts[i] != 0 && (i < kMaxMimeParts) )
		{
			i++;
		}
		if ( i > 0 )
		{
			fBaseParts[i - 1]--;
		}
	}
} // DecLastPart



//--------------------------------------------------------------------------------------------------
//	* ZeroLastSubPart
//
//		- Find the last non-zero element in the array and set it to zero
//
//--------------------------------------------------------------------------------------------------

void CMimePart::ZeroLastSubPart ( void )
{
	sInt16		i = 0;

	while ( fBaseParts[i] != 0 && (i < kMaxMimeParts) )
	{
		i++;
	}
	if ( i > 1 )
	{
		fBaseParts[i - 1] = 0;
	}
} // ZeroLastSubPart


//-----------------------------------------------------------------------------------
//	* IncNextBasePart
//
//		- Find the next '0' element in the array and set it to 1
//
//-----------------------------------------------------------------------------------

void CMimePart::IncNextBasePart ( void )
{
	sInt16		i = 0;

	while ( fBaseParts[ i ] != 0 && (i < kMaxMimeParts) )
	{
		i++;
	}

	fBaseParts[ i ] = 1;
} // IncNextBasePart



//-----------------------------------------------------------------------------------
//	* SetMimePartNumber
//
//-----------------------------------------------------------------------------------

void CMimePart::SetMimePartNumber ( void )
{
	sInt16		i = 0;
	char		numStr[8];

	// reset it to null
	fBaseStr[0] = '\0';

	while ( fBaseParts[i] != 0 && (i < kMaxMimeParts) )
	{
		::sprintf( numStr, "%d", fBaseParts[i] );
		if ( i > 0 )
		{
			::strcat( fBaseStr, "." );
		}
		::strcat( fBaseStr, numStr );
		i++;
	}
} // SetMimePartNumber



