/*
	$Id: IMAPStrings.h,v 1.1 2003/04/20 23:30:51 dasenbro Exp $

	File:		IMAPStrings.h

	Contains:	

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: IMAPStrings.h,v $
		Revision 1.1  2003/04/20 23:30:51  dasenbro
		Initial check-in.
		
		Revision 1.11  2002/06/10 22:42:29  dasenbro
		Added strings and consts for required auth methods Kerberos and CRAM-MD5.
		
		Revision 1.10  2002/05/20 21:24:55  dasenbro
		Added "Not Admin" response.
		
		Revision 1.9  2002/03/25 22:54:49  dasenbro
		Added SSL response codes, strings and consts.
		
		Revision 1.8  2002/03/21 16:41:33  dasenbro
		Updated file version information.
		
		Revision 1.7  2001/06/21 20:51:04  dasenbro
		Updated file header info.
		
		Revision 1.6  2001/06/21 19:38:12  dasenbro
		Added Change History.
		

	Projector History:

	 <ASM20>	 3/28/99	MED		Added consts for new indexing status strings.
	 <ASM19>	 3/15/99	MED		Added yet another error const.
	 <ASM18>	  2/8/99	MED		Added user remote/local error consts.
		<17>	11/20/98	MED		Added kErrBadTermSequenceStr.
		<16>	 9/28/98	MED		Added some status string consts.
		<15>	 9/21/98	MED		Added kErrBogusDateStringStr const.
		<14>	 9/17/98	MED		Added kErrCantModOwnerStr const.
		<13>	 9/14/98	MED		Added more imap errors.
		<12>	  9/8/98	MED		Added const for invalid rights and misc alerts.
		<11>	 8/24/98	MED		Added a "Disk Full" const.
		<10>	 8/10/98	MED		Added ACL error consts.
		 <9>	 5/20/98	MED		Added Unexpected extra arguments error const.
		 <8>	  5/6/98	MED		Added a max messages per mailbox error const.
		 <7>	 4/28/98	MED		Added more of the same old stuff.
		 <6>	 4/25/98	MED		Added some error constants.
		 <5>	 4/22/98	MED		Added a const for Invalid body section.
		 <4>	 3/29/98	MED		Added null, missing and unrecognized command consts.
		 <3>	 3/28/98	MED		Added a pop locked mailbox error const.
		 <2>	 3/17/98	MED		Added resource string indexes for imap response strings.

	To Do:
*/

#ifndef __IMAPStrings_h__
#define __IMAPStrings_h__ 1

enum {
	kIndexFolders			= 3000,
	kImapNoErrStrResID		= 3001,
	kImapBadErrStrResID		= 3002,
	kImapASIPErrStrResID	= 3003,
	kImapAdminErrStrResID	= 3004,
	kImapCompleteStrResID	= 3005,
	kImapAlertStrResID		= 3006,
	kACLErrStrResID			= 3007,
	kImapEnd				= 9999
};


// static const int kIndexFolders			=	3000;

enum 
{
	kStrIndexes		= 1,
	kStrMsgData		= 2
};


//****
// NO Error strings
//****

// static const int kImapNoErrStrResID		=	3001;

enum 
{
	kStrServerError				=  1,
	kStrInvalidTag				=  2,
	kStrBadLogin				=  3,
	kStrMboxIsReadOnly			=  4,
	kStrNoMbox					=  5,
	kStrMboxIsNoSel				=  6,
	kStrEmptyName				=  7,
	kStrBadCharsInMBoxName		=  8,
	kStrInvalidAttribute		=  9,
	kStrMBoxExists				= 10,
	kStrCantDeleteInbox			= 11,
	kStrMBoxHasInferiors		= 12,
	kStrCantUnSubInbox			= 13,
	kStrUnKnownCharSet			= 14,
	kStrMBoxChangedSize			= 15,
	kStrMBoxLockedByPop			= 16,
	kStrReselectMBox			= 17,
	kStrMBoxNameTooLong			= 18,
	kStrMaxNumbOfMBoxes			= 19,
	kStrMaxDepthMBoxes			= 20,
	kStrAccessDenied			= 21,
	kStrMaxMsgsPerMbox			= 22,
	kStrInvalidRights			= 23,
	kStrNoCreateShrdMbox		= 24,
	kStrMailNotEnabled			= 25,
	kStrAutoforwardOn			= 26,
	kStrCantModOwner			= 27,
	kStrUnsupportedCmd			= 28,
	kStrMailboxInUse			= 29,
	kStrCantExpunge				= 30,
	kStrTLSAlreadyStarted		= 31,
	kStrSSLSessionRequired		= 32,
	kStrNotAdminUser			= 33,
	kStrLoginDisabled			= 34,
	kStrCRAM_MD5Required		= 35,
	kStrKerberosRequired		= 36,
	kNoErrorsEnd				= 0
};


//****
// BAD Error strings
//****

// static const int kImapBadErrStrResID	=	3002;

enum 
{
	kStrMissingArgs				=  1,
	kStrInvalidArg				=  2,
	kStrUnexpectedArg			=  3,
	kStrBogusSequence			=  4,
	kStrUnexpectedCmd			=  5,
	kStrBogusCriteria			=  6,
	kStrNoMBoxSelected			=  7,
	kStrInvalBodyPartial		=  8,
	kStrNullIMAPCommand			=  9,
	kStrMissingCommand			= 10,
	kStrUnRreconCommand			= 11,
	kStrInvalBodySection		= 12,
	kStrBogusDateString			= 13,
	kStrBadTermSequence			= 14,
	kBadErrorsEnd				=  0
};


//****
// ASIP Specific IMAP Error strings
//****

// static const int kImapASIPErrStrResID	=	3003;

enum 
{
	kStrCantCreatePop3Inbox			=  1,
	kStrNoPop3InboxInveriors		=  2,
	kStrCantDeletePop3Inbox			=  3,
	kStrCantRenamePop3Inbox			=  4,
	kStrCantRenameUsersInbox		=  5,
	kStrNoImapSession				=  6,
	kStrNoNetworkEndpoint			=  7,
	kStrMaxConnections				=  8,
	kStrNotNumberString				=  9,
	kStrNoAcctOnThisSrvr			= 10,
	kStrUserAcctOnThisServer		= 11,
	kStrUserDoesNotExist			= 12,
	kStrCantContactAgent			= 13,

	kStrDiskFull					= 14,
	kStrDatabaseIsFull				= 15,
	kStrUnknownServerError			= 16,
	kAIPErrorsEnd					= 0
};

//****
// IMAP Admin Port Error strings
//****

// static const int kImapAdminErrStrResID	=	3004;

enum 
{
	kStrOpNotAllowed			= 1,
	kStrCantCreateMBox			= 2,
	kStrCantCopyToMBox			= 3,
	kStrCantDeleteMBox			= 4,
	kStrCantAppendToMBox		= 5,
	kAdminErrorsEnd				= 0
};



//****
// IMAP Completion strings
//****

// static const int kImapCompleteStrResID	=	3005;

enum 
{
	kCmdCompleted			= 1,
	kCompleteEnd				= 0
};



//****
// IMAP Alert strings
//****

// static const int kImapAlertStrResID		=	3006;

enum 
{
	kStrAlertMaxMsgCount		=  1,
	kStrAlertServerShutdown		=  2,
	kStrAlertUserInactivity		=  3,
	kStrAlertAdminDisconnect	=  4,
	kStrAlertConnTerminated		=  5,
	kStrAlertBusyIndexing		=  6,
	kStrAlertBusySearching		=  7,
	kStrAlertBusyFetching		=  8,
	kStrAlertIndexStatus		=  9,
	kStrAlertSearchStatus		= 10,
	kStrAlertMakeTOCStatus		= 11,
	kStrAlertResponseStatus		= 12,
	kStrAlertsEnd				=  0
};



//****
// ACL Error strings
//****

// static const int kACLErrStrResID		=	3007;

enum 
{
	kStrACLNotAdmin				= 1,
	kStrACLNoSuchUserorGrp		= 2,
	kStrACLInsufficientRights	= 3,
	kACLErrorsEnd				= 0
};



#endif	// __IMAPStrings_h__
