/*
	$Id: CTextObject.h,v 1.1 2003/04/20 23:31:08 dasenbro Exp $

	File:		CTextObject.h

	Contains:	C++ class definitions for generic

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by:	Michael Dasenbrock

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CTextObject.h,v $
		Revision 1.1  2003/04/20 23:31:08  dasenbro
		Initial check-in.
		
		Revision 1.7  2002/07/19 01:58:21  dasenbro
		Prevent objects from adding data and not releasing it.  Also cleaned up
		a DB object leak.
		
		Revision 1.6  2002/03/21 16:41:42  dasenbro
		Updated file version information.
		
		Revision 1.5  2001/06/21 19:55:00  dasenbro
		Added Change History.
		

	Projector History:


	To Do:
*/

#ifndef __CTextObject_h__
#define __CTextObject_h__ 1

#include "CDBMailBaseObject.h"
#include "CMailDatabase.h"

// WARNING!!!! Many of the assumptions about the operation of the server (maximum number of connections,
// maximum write-behind cache depth, server performance, footprint, etc.) are set assuming that kMessagePartSize
// is near 8K.  If you change this value and don't understand the implications, you get what you deserve.
// If you make it bigger then the server will overestimate the "load" it can handle and most likely crash
// under stress/volume with out of memory problems....if you make it smaller the performance will tank
// upload/download, and the server will not fully utilize it's partition....don't screw with this value!!!

typedef struct
{	// NOTE: this structure should be kept in sync with the fields in the actual
	// CMessagePartData struct...
	StdDBObjHeader	fDBHeader;
	ObjID			fObjectID;
	ObjID			fNextObj;
	uInt32			fItemCount;
	uInt32			fOffset;

	// Reserved
	uInt32			fReserved1;				// reserverd
	uInt32			fReserved2;				// reserverd

	StdDBObjFooter	fDBFooter;
} STextObjectHdr4Calc;

const uInt32 kTextSlopSafety	= 12;
const uInt32 kTextObjSize		= ((kMaxIDTableSize - kTextSlopSafety) / 2) - (sizeof( ObjID ) + sizeof( STextObjectHdr4Calc ));

typedef struct
{
	StdDBObjHeader	fDBHeader;
	ObjID			fObjectID;
	ObjID			fNextObj;
	uInt32			fItemCount;
	uInt32			fOffset;

	// Reserved
	uInt32			fReserved1;				// reserverd
	uInt32			fReserved2;				// reserverd

	char			fStringData[ kTextObjSize ];

	StdDBObjFooter	fDBFooter;
} CTextObjectData;

const uInt32 kTextObjectDataSize	= sizeof( CTextObjectData );						  
const uInt32 kTextObjectVersion		= kDBCurrentVersion + kTextObjectDataSize;


#define		kStringMarker	"\0X"

class CTextObject : public CDBMailBaseObject
{
public:
typedef enum {
	kNoError			= 0,
	kNullStirng			= -1076,
	kObjectFull			= -1077,
	kStringTooBig		= -1078,
	kOffsetTooBig		= -1079,
	kInvalidOffset		= -1080,
	kInvalidString		= -1081,
	kEmptyDestString	= -1082,
	kCorruptStrObj		= -1083,
	kEmptyStrObject		= -1084,
	kStringNotFound		= -1085
} eTextObjErrs;

	// Static Methods
	static CTextObject*		Create				( void );
	static Boolean 			Delete				( CTextObject *inObjPtr );
	static uInt32			Count				( void );
	static void				VerifyAll			( void );
	static Boolean			GetSetFields		( const eFieldDataRequest inFieldRequest, const void *inObjDataPtr,  void *outFieldData );
	static CTextObject*		FindByID			( const	ObjID inObjectID );
	static CDBBaseObject*	ObjectAllocNew		( void );

	static	OSType		GetObjTypeConstant	( void ) { return kTextObjectSignature; }
	static	uInt32		GetObjVersConstant	( void ) { return kTextObjectVersion; }
	static	uInt32		GetObjSizeConstant	( void ) { return kTextObjectDataSize; }

	virtual	ObjID		GetObjectID					( void );
	virtual	void		ChkCompilerStructAlignment	( void );
			void		Done						( CTextObject* &inPtr );

	// Construction/Destruction
						CTextObject			( void );
	virtual		 	   ~CTextObject			( void );

		void			InitObject			( void );

		ObjID			GetMyObjectID		( void );
		void			SetMyObjectID		( ObjID inObjID );

		ObjID			GetNextObjectID		( void );
		void			SetNextObjectID		( ObjID inObjID );

		uInt32			GetOffset			( void );
		void			SetOffset			( uInt32 inOffset );

		sInt32			GetItemCount		( void );
		void			SetItemCount		( sInt32 inCount );

		void			IncrementItemCount	( void );
		void			DecrementItemCount	( void );

		char*			GetDataBlock		( void );
		void			SetDataBlock		( char *inData );

		sInt32			AddString			( const char *inString, uInt16 *outOffset );
		sInt32			RemoveString		( uInt16 inOffset );
		sInt32			GetString			( uInt16 inOffset, char **outStr );

	CTextObjectData*	GetMyObjectData		( void );
	void				SetDirty			( void );

protected:

private:
	CTextObjectData		fObjectData;

};	// CTextObject

#endif // __CTextObject_h__

