/*
	$Id: CIDList.cpp,v 1.1 2003/04/20 23:29:40 dasenbro Exp $

	File:	CIDList.cpp

	Contains: Implementation of the various OS Utilities

	Version:	Apple Mail Server - Mac OS X :  $Revision: 1.1 $

	Written by: Michael Dasenbrock

	Copyright:	 1996-2001 by Apple Computer, Inc., all rights reserved.

 	NOT_FOR_OPEN_SOURCE <to be reevaluated at a later time>

	Change History:

		$Log: CIDList.cpp,v $
		Revision 1.1  2003/04/20 23:29:40  dasenbro
		Initial check-in.
		
		Revision 1.4  2002/03/21 16:41:47  dasenbro
		Updated file version information.
		
		Revision 1.3  2001/06/21 20:08:42  dasenbro
		Added Change History.
		

	Projector History:

*/


#include "CIDList.h"
#include "CMailDatabase.h"


CIDList::CIDList()
{
	this->ClearIDList();
}

CIDList::~CIDList()
{
	this->ClearIDList();
}

Boolean	CIDList::AddID2List (	ObjID	inData,
								Boolean	inDataFlag,
								Boolean	inDuplicateSuppress	)
{
	uInt32 i;
	Boolean	aResult = true;

	if ((inData == kEmptyValue) || (inData == kDeadValue))
	{
		return false;
	}

	if (inDuplicateSuppress == true)
	{

		for (i=0; i<this->GetMaxItemCount(); i++)
		{
			if (fDataList[i] == inData)
			{
				return false;
			}
		}
	}

	for (i=0; i<this->GetMaxItemCount(); i++)
	{
		if (fDataList[i] == kEmptyValue)
		{
			fDataList[i] = inData;
			fDataFlagList[i] = inDataFlag;
			return true;
		}
	}

	return false;
}

void CIDList::ClearIDList ( void )
{
	uInt32 i;

	for (i=0; i<this->GetMaxItemCount(); i++)
	{
		fDataList[i] = kEmptyValue;
		fDataFlagList[i] = false;
	}
}

uInt32	CIDList::GetItemCount ( void )
{
	uInt32	i, aResult = 0;

	for (i=0; i<this->GetMaxItemCount(); i++)
	{
		if (fDataList[i] != kEmptyValue)
		{
			aResult++;
		}
	}

	return aResult;
}

Boolean	CIDList::GetItem (	uInt32	inIndex,
							ObjID	&outData,
							Boolean	&outDataFlag,
							Boolean	inClearItem		)
{
	if (inIndex >= this->GetMaxItemCount())
	{
		return false;
	}

	if ((fDataList[inIndex] != kEmptyValue) && (fDataList[inIndex] != kDeadValue))
	{
		outData = fDataList[inIndex];
		outDataFlag = fDataFlagList[inIndex];
		if (inClearItem == true)
		{
			fDataList[inIndex] = kEmptyValue;
			fDataFlagList[inIndex] = false;
		}

		return true;
	}

	return false;
}

Boolean	CIDList::GetFirstItem (	ObjID	&outData,
								Boolean &outDataFlag	)
{
	uInt32	i;

	for (i=0; i<this->GetMaxItemCount(); i++)
	{
		if (this->GetItem(i, outData, outDataFlag, true))
		{
			return true;
		}
	}

	return false;
}



// MED 1-14-97
// Get the next item in the list starting with "inNextItem"

Boolean	CIDList::GetNextItem ( uInt32 &inNextItem, ObjID &outData, Boolean &outDataFlag, const Boolean inClearItem )
{
	uInt32	i;

	if ( inNextItem >= this->GetMaxItemCount() )
	{
		// we have hit the end of the list.  Reset to start of list which is 0
		inNextItem = 0;
		return( false );
	}

	for ( i = inNextItem; i < this->GetMaxItemCount(); i++ )
	{
		if ( this->GetItem( i, outData, outDataFlag, inClearItem ) )
		{
			// set inNextItem to next item in list
			inNextItem = i + 1;
			return( true );
		}
	}

	// restart counter
	inNextItem = 0;

	return( false );
} // GetNextItem


uInt32	CIDList::GetMaxItemCount ( void )
{
	return kMaxDataCount;
}
