/* $Copyright:
 *
 * Copyright 1998-2000 by the Massachusetts Institute of Technology.
 * 
 * All rights reserved.
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of M.I.T. not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Furthermore if you modify
 * this software you must label your software as modified software and not
 * distribute it in such a fashion that it might be confused with the
 * original MIT software. M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * Individual source code files are copyright MIT, Cygnus Support,
 * OpenVision, Oracle, Sun Soft, FundsXpress, and others.
 * 
 * Project Athena, Athena, Athena MUSE, Discuss, Hesiod, Kerberos, Moira,
 * and Zephyr are trademarks of the Massachusetts Institute of Technology
 * (MIT).  No commercial use of these trademarks may be made without prior
 * written permission of MIT.
 * 
 * "Commercial use" means use of a name in a product or other for-profit
 * manner.  It does NOT prevent a commercial firm from referring to the MIT
 * trademarks in order to convey information (although in doing so,
 * recognition of their trademark status should be given).
 * $
 */

/* $Header: /cvs/repository/iservers/Servers/cyrus/cyrus_sasl/mac/CommonKClient/mac_kclient3/Headers/KerberosSupport/Utilities.h,v 1.1 2004/03/31 18:08:39 dasenbro Exp $ */

/*
 * Utilities.h - Public header file for the Utilities library
 */
 
#ifndef __UTILITIES__
#define __UTILITIES__

#include <time.h>
#include <KerberosSupport/pwd.h>

#include <ConditionalMacros.h>
#include <MacTypes.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

/************************/
/* Structures and Types */
/************************/

/* common types for POSIX structures */
typedef	unsigned char	u_char;
typedef	unsigned short	u_short;
typedef	unsigned int	u_int;
typedef	unsigned long	u_long;

typedef unsigned char   uchar_t;
typedef unsigned short  ushort_t;
/*typedef UInt32  uint_t;*/   /* We don't define uint_t because OpenTransport.h does. */
typedef unsigned long	ulong_t;

typedef char   *caddr_t;
typedef SInt32  daddr_t;
typedef SInt16  cnt_t;

typedef ulong_t paddr_t;
typedef uchar_t use_t;
typedef SInt16  sysid_t;
typedef SInt16  index_t;


/**********/
/* Macros */
/**********/

/* macros for BSD memory utilities */
#define bzero(dest, nbytes)			memset(dest, 0, nbytes)
#define bcopy(src, dest, nbytes)	memcpy(dest, src, nbytes)
#define bcmp(ptr1, ptr2, nbytes)	memcmp(ptr1, ptr2, nbytes)
#define index(s, c)					strchr(s, c)
#define rindex(s, c)				strrchr(s, c)


/***********************/
/* Function Prototypes */
/***********************/

/* String Utilities */
int strcasecmp(const char *s1, const char *s2);
int strncasecmp(const char *s1, const char *s2, register int n);
char *strtoken (const char *s, const char *delim, int index);
char *strdup (const char *s);
void swab(register char *from, register char *to, register int n);

/* Time Utilities */
int gettimeofday (struct timeval *tp, struct timezone *);
int settimeofday (struct timeval *tp, struct timezone *);
void get_gmt_offset(void);
void mac_time_to_unix_time (time_t *time);
void unix_time_to_mac_time (time_t *time);
void msl_time_to_unix_time (time_t *time);
void unix_time_to_msl_time (time_t *time);

/* Mac OS X Runtime utilities */
Boolean	RunningUnderClassic (void);
Boolean	RunningUnderMacOSX (void);


#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif /* __UTILTIES__ */