/*=============================================================================
	CAAudioFilePlayer.h
	
	$Log: CAAudioFilePlayer.h,v $
	Revision 1.3  2004/10/15 17:10:34  dwyatt
	CAAudioFile rewrite to use ExtAudioFile (changeable via compile flag in CAAudioFile.h)
	
	Revision 1.2  2004/09/30 21:05:39  jcm10
	flat headers
	
	Revision 1.1  2004/01/14 00:08:09  dwyatt
	moved from Source/Tests/AudioFileUtility/Utility
	
	Revision 1.8  2003/12/04 00:59:02  dwyatt
	refactoring
	
	Revision 1.7  2003/10/15 00:27:30  dwyatt
	refactor on top of CABufferQueue
	
	Revision 1.6  2003/10/09 23:23:13  dwyatt
	refactor/cleanup to support CAAudioFileRecorder
	
	Revision 1.5  2003/09/11 00:48:31  dwyatt
	Stop/Start are now virtual overrides
	
	Revision 1.4  2003/08/04 23:44:12  dwyatt
	refactoring for subclassing
	
	Revision 1.3  2003/07/25 23:29:12  dwyatt
	use constant strings for operations in CAXException
	
	Revision 1.2  2003/07/09 19:13:28  dwyatt
	sync with base class changes
	
	Revision 1.1  2003/06/23 23:07:37  dwyatt
	initial checkin
	
	created Thu Jun 19 2003, Doug Wyatt
	Copyright (c) 2003 Apple Computer, Inc.  All Rights Reserved

	$NoKeywords: $
=============================================================================*/

#ifndef __CAAudioFilePlayer_h__
#define __CAAudioFilePlayer_h__

#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
	#include <AudioUnit/AudioUnit.h>
#else
	#include <AudioUnit.h>
#endif
#include "CAAudioFileStreamer.h"

// Simple player -- owns an output unit
class CAAudioFilePlayer : public CAAudioFileReader {
public:
	CAAudioFilePlayer(int nBuffers, UInt32 ioBufferSizeBytes);
	virtual ~CAAudioFilePlayer();

	// $$$ to add: change device, HAL I/O buffer size

	virtual void	Start();
	virtual void	Stop();
	void			SetVolume(double volume);		// 0-1
	
	void			SetFile(const FSRef &inFile);

protected:
	// our virtual methods:
	virtual void	SetupChannelMapping();
	
	AudioUnit		GetOutputUnit() { return mOutputUnit; }

protected:
	static OSStatus	InputProc(
							void *						inRefCon,
							AudioUnitRenderActionFlags *ioActionFlags,
							const AudioTimeStamp *		inTimeStamp,
							UInt32 						inBusNumber,
							UInt32 						inNumberFrames,
							AudioBufferList *			ioData);

	OSStatus		GetPlayBuffer(
							UInt32						inNumberFrames,
							AudioBufferList *			ioData);

	AudioUnit		mOutputUnit;
};

#endif // __CAAudioFilePlayer_h__
