//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//	AudioFileData.cpp
//
//	$Log: AudioFileData.cpp,v $
//	Revision 1.5  2003/06/19 18:55:39  bills
//	fix warnings
//	
//	Revision 1.4  2003/04/18 23:05:14  baron
//	Use AudioFileReadPackets() in the special case of short files that are read entirely into memory.
//	
//	Revision 1.3  2003/04/09 22:33:11  baron
//	Pass audio data around by packets instead of bytes.
//	
//	Revision 1.2  2002/06/01 23:58:19  bills
//	first pass at v2 units
//	
//	Revision 1.1  2002/05/18 01:19:47  bills
//	new location
//	
//	Revision 1.1  2002/05/17 07:56:45  bills
//	new dir loc
//	
//	Revision 1.4  2002/05/17 07:48:05  bills
//	Add FilePlay "C" API
//	
//	Revision 1.3  2002/05/16 09:07:13  bills
//	use a single read thread for files
//	
//	Revision 1.2  2002/05/15 06:21:59  bills
//	now use AudioConverter to do file reading
//	
//	Revision 1.1  2002/05/14 08:12:23  bills
//	initial checkin
//	
// 	
//	General class for playing back a file read totally into memory
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#include "AudioFilePlayer.h"
                                        
AudioFileData::AudioFileData (	AudioFilePlayer		&inParent, 
                                AudioFileID 		&inFile, 
                                SInt64 				inFileLength,
                                SInt64				inPacketCount,
                                UInt32				inMaxPacketSize,
                                UInt32				inChunkSizeInPackets)
	: AudioFileManager (inParent, inFile),
	  mFileLength (UInt32(inFileLength))
{
	mFileBuffer = (char*) malloc (mFileLength);
    mPacketDescriptions = (AudioStreamPacketDescription*)calloc (1, inMaxPacketSize * inPacketCount);
    
	//read the entire contents into buffer
    OSStatus  result = AudioFileReadPackets (	mAudioFileID, 
                                                false,
                                                &mFileLength,
                                                mPacketDescriptions,
                                                0, 
                                                &inChunkSizeInPackets, 
                                                (void *) mFileBuffer);
    	THROW_RESULT("AudioFileReadPackets")
        mCurrentPacketCountInBuffer = inChunkSizeInPackets; // all the packets are in memory
}

OSStatus AudioFileData::GetFileData (void** inOutData, UInt32 *inOutDataSize, UInt32 *outPacketCount, 															AudioStreamPacketDescription	**outPacketDescriptions)
{
	if (mFirstTime || mIsLooping) {
		*inOutData = mFileBuffer;
		*inOutDataSize = mFileLength;
        *outPacketCount = mCurrentPacketCountInBuffer;
		*outPacketDescriptions = mPacketDescriptions;
        mFirstTime = false;
	} else {
		*inOutDataSize = 0;
		*inOutData = 0;
        *outPacketCount = mCurrentPacketCountInBuffer;
		*outPacketDescriptions = mPacketDescriptions;
		mShouldFinish = true;
	}
	
	return noErr;
}

void 	AudioFileData::AfterRender ()
{
	if (mShouldFinish)
	{
		mParent.DoNotification (kAudioFilePlay_FileIsFinished);
	}
}

void	AudioFileData::DoConnect ()
{
	mFirstTime = true;
	mShouldFinish = false;
}
