/*=============================================================================
	CAAudioValueRange.h

	$Log: CAAudioValueRange.h,v $
	Revision 1.6  2004/11/17 23:14:33  jcm10
	add Union()
	
	Revision 1.5  2004/08/19 09:33:42  jcm10
	add Intersection
	
	Revision 1.4  2004/08/18 23:05:13  jcm10
	add a std::binary_function version of operator<() so that it's easy to sort lists of these guys
	
	Revision 1.3  2004/06/07 18:54:43  jcm10
	add some more operations
	
	Revision 1.2  2003/11/20 22:56:53  dwyatt
	__COREAUDIO_USE_FLAT_INCLUDES__
	
	Revision 1.1  2002/05/21 00:53:09  jcm10
	first checked in
	
	Revision 0.0  Sun May 19 2002 14:03:49 US/Pacific  moorf
	Created
		
	$NoKeywords: $
=============================================================================*/
#if !defined(__CAAudioValueRange_h__)
#define __CAAudioValueRange_h__

//=============================================================================
//	Includes
//=============================================================================

//	System Includes
#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
	#include <CoreAudio/CoreAudioTypes.h>
#else
	#include <CoreAudioTypes.h>
#endif

//	Standard Library Includes
#include <functional>

//=============================================================================
//	CAAudioValueRange
//=============================================================================

struct CAAudioValueRange
:
	public AudioValueRange
{

//	Construction/Destruction
public:
						CAAudioValueRange()																{ mMinimum = 0.0; mMaximum = 0.0; }
						CAAudioValueRange(const AudioValueRange& v)										{ mMinimum = v.mMinimum; mMaximum = v.mMaximum; }
						CAAudioValueRange(Float64 inMinimum, Float64 inMaximum)							{ mMinimum = inMinimum; mMaximum = inMaximum; }

//	Assignment
public:
	CAAudioValueRange&	operator=(const AudioValueRange& v)												{ mMinimum = v.mMinimum; mMaximum = v.mMaximum; return *this; }

//  Operations
public:
	static bool			ContainsValue(const AudioValueRange& inRange, Float64 inValue)					{ return (inValue >= inRange.mMinimum) && (inValue <= inRange.mMaximum); }
	static Float64		PickCommonSampleRate(const AudioValueRange& inRange);
	static bool			IsStrictlyLessThan(const AudioValueRange& x, const AudioValueRange& y)			{ return x.mMaximum < y.mMinimum; }
	static bool			IsStrictlyGreaterThan(const AudioValueRange& x, const AudioValueRange& y)		{ return x.mMinimum > y.mMaximum; }
	static bool			IsStrictlyContainedBy(const AudioValueRange& x, const AudioValueRange& y)		{ return (x.mMinimum >= y.mMinimum) && (x.mMaximum <= y.mMaximum); }
	static bool			OverlapsLow(const AudioValueRange& x, const AudioValueRange& y)					{ return (x.mMinimum < y.mMinimum) && (x.mMaximum >= y.mMinimum) && (x.mMaximum <= y.mMaximum); }
	static bool			OverlapsHigh(const AudioValueRange& x, const AudioValueRange& y)				{ return (x.mMinimum >= y.mMinimum) && (x.mMinimum <= y.mMaximum) && (x.mMaximum > y.mMaximum); }
	static bool			Intersection(const AudioValueRange& x, const AudioValueRange& y, AudioValueRange& outRange);
	static bool			Union(const AudioValueRange& x, const AudioValueRange& y, AudioValueRange& outRange);

//	STL Helpers
public:
	struct	LessThan
	:
		public std::binary_function<AudioValueRange, AudioValueRange, bool>
	{
		bool	operator()(const AudioValueRange& x, const AudioValueRange& y) const
		{
			return x.mMinimum < y.mMinimum;
		}
	};
	
};

inline bool	operator<(const AudioValueRange& x, const AudioValueRange& y)								{ return x.mMinimum < y.mMinimum; }
inline bool	operator==(const AudioValueRange& x, const AudioValueRange& y)								{ return (x.mMinimum == y.mMinimum) && (x.mMaximum == y.mMaximum); }
inline bool	operator!=(const AudioValueRange& x, const AudioValueRange& y)								{ return !(x == y); }
inline bool	operator<=(const AudioValueRange& x, const AudioValueRange& y)								{ return (x < y) || (x == y); }
inline bool	operator>=(const AudioValueRange& x, const AudioValueRange& y)								{ return !(x < y); }
inline bool	operator>(const AudioValueRange& x, const AudioValueRange& y)								{ return !((x < y) || (x == y)); }

#endif
