/*=============================================================================
	CAAutoDisposer.h

	$Log: CAAutoDisposer.h,v $
	Revision 1.3  2004/01/09 03:34:41  jcm10
	in CAAutoFree, malloc enough memory
	
	Revision 1.2  2003/05/22 19:05:08  jcm10
	add operator[] to CAAutoFree
	
	Revision 1.1  2002/09/05 22:36:40  jcm10
	first checked in
	
	Revision 1.2  2001/11/15 01:41:52  moorf
	use C libraries without the namespace to make cpp-precomp happy
	
	Revision 1.1  2001/11/14 02:49:15  moorf
	first checked in
	
	Revision 0.0  Thu Jun 14 2001  moorf
	created
		
	$NoKeywords: $
=============================================================================*/
#if !defined(__CAAutoDisposer_h__)
#define __CAAutoDisposer_h__

//=============================================================================
//	Includes
//=============================================================================

#include <stdlib.h>
#include <new>

//=============================================================================
//	CAAutoFree
//=============================================================================

template <class T>
class	CAAutoFree
{

//	Construction/Destruction
public:
	CAAutoFree(UInt32 inSize) { mPointer = static_cast<T*>(malloc(inSize * sizeof(T))); if(mPointer == NULL) { throw std::bad_alloc(); } }
	CAAutoFree(void* inPointer) : mPointer(static_cast<T*>(inPointer)) {}
	CAAutoFree(T* inPointer) : mPointer(inPointer) {}
	~CAAutoFree() { free(mPointer); }
	operator T*() const { return mPointer; }
	T& operator*() const { return *mPointer; }
	T* operator->() const { return mPointer; }
	T& operator[](int inIndex) const { return mPointer[inIndex]; }

private:
	T*	mPointer;

};

//=============================================================================
//	CAAutoDelete
//=============================================================================

template <class T>
class	CAAutoDelete
{

//	Construction/Destruction
public:
	CAAutoDelete() { mPointer = new T; }
	CAAutoDelete(T* inPointer) : mPointer(inPointer) {}
	~CAAutoDelete() { delete mPointer; }
	operator T*() const { return mPointer; }
	T& operator*() const { return *mPointer; }
	T* operator->() const { return mPointer; }

private:
	T*	mPointer;

};

//=============================================================================
//	CAAutoArrayDelete
//=============================================================================

template <class T>
class	CAAutoArrayDelete
{

//	Construction/Destruction
public:
	CAAutoArrayDelete(UInt32 inNumberItems) { mPointer = new T[inNumberItems]; }
	CAAutoArrayDelete(T* inPointer) : mPointer(inPointer) {}
	~CAAutoArrayDelete() { delete[] mPointer; }
	operator T*() const { return mPointer; }
	T& operator[](int inIndex) const { return mPointer[inIndex]; }

private:
	T*	mPointer;

};

#endif
