/*=============================================================================
	CACFArray.cpp

	$Log: CACFArray.cpp,v $
	Revision 1.6  2004/11/24 20:20:48  jcm10
	add methods for insertion
	
	Revision 1.5  2004/09/14 19:53:57  jcm10
	add GetBool()
	
	Revision 1.4  2004/01/29 00:24:18  jcm10
	add CanModify() and Clear()
	
	Revision 1.3  2004/01/12 20:35:52  jcm10
	add some new methods
	
	Revision 1.2  2003/05/22 19:07:18  jcm10
	rework this class to prevent polymorphic problems with CFTypes
	
	Revision 1.1  2003/05/04 00:00:16  jcm10
	first checked in
	
	Revision 0.0  Sat May 03 2003 11:29:31 US/Pacific  moorf
	Created
		
	$NoKeywords: $
=============================================================================*/

//=============================================================================
//	Includes
//=============================================================================

//	Self Include
#include "CACFArray.h"

//	PublicUtility Includes
#include "CACFNumber.h"

//=============================================================================
//	CACFArray
//=============================================================================

bool	CACFArray::HasItem(const void* inItem) const
{
	bool theAnswer = false;
	if(mCFArray != NULL)
	{
		CFRange theRange = { 0, CFArrayGetCount(mCFArray)};
		theAnswer = CFArrayContainsValue(mCFArray, theRange, inItem);
	}
	return theAnswer;
}

bool	CACFArray::GetIndexOfItem(const void* inItem, UInt32& outIndex) const
{
	bool theAnswer = false;
	outIndex = 0;
	if(mCFArray != NULL)
	{
		CFRange theRange = { 0, CFArrayGetCount(mCFArray)};
		CFIndex theIndex = CFArrayGetFirstIndexOfValue(mCFArray, theRange, inItem);
		if(theIndex != -1)
		{
			theAnswer = true;
			outIndex = theIndex;
		}
	}
	return theAnswer;
}

bool	CACFArray::GetBool(UInt32 inIndex, bool& outValue) const
{
	bool theAnswer = false;
	
	CFTypeRef theValue = NULL;
	if(GetCFType(inIndex, theValue))
	{
		if((theValue != NULL) && (CFGetTypeID(theValue) == CFBooleanGetTypeID()))
		{
			outValue = CFBooleanGetValue(static_cast<CFBooleanRef>(theValue));
			theAnswer = true;
		}
		else if((theValue != NULL) && (CFGetTypeID(theValue) == CFNumberGetTypeID()))
		{
			SInt32 theNumericValue = 0;
			CFNumberGetValue(static_cast<CFNumberRef>(theValue), kCFNumberSInt32Type, &theNumericValue);
			outValue = theNumericValue != 0;
			theAnswer = true;
		}
	}
	
	return theAnswer;
}

bool	CACFArray::GetSInt32(UInt32 inIndex, SInt32& outItem) const
{
	bool theAnswer = false;
	
	CFTypeRef theItem = NULL;
	if(GetCFType(inIndex, theItem))
	{
		if((theItem != NULL) && (CFGetTypeID(theItem) == CFNumberGetTypeID()))
		{
			CFNumberGetValue(static_cast<CFNumberRef>(theItem), kCFNumberSInt32Type, &outItem);
			theAnswer = true;
		}
	}
	
	return theAnswer;
}

bool	CACFArray::GetUInt32(UInt32 inIndex, UInt32& outItem) const
{
	bool theAnswer = false;
	
	CFTypeRef theItem = NULL;
	if(GetCFType(inIndex, theItem))
	{
		if((theItem != NULL) && (CFGetTypeID(theItem) == CFNumberGetTypeID()))
		{
			CFNumberGetValue(static_cast<CFNumberRef>(theItem), kCFNumberSInt32Type, &outItem);
			theAnswer = true;
		}
	}
	
	return theAnswer;
}

bool	CACFArray::GetSInt64(UInt32 inIndex, SInt64& outItem) const
{
	bool theAnswer = false;
	
	CFTypeRef theItem = NULL;
	if(GetCFType(inIndex, theItem))
	{
		if((theItem != NULL) && (CFGetTypeID(theItem) == CFNumberGetTypeID()))
		{
			CFNumberGetValue(static_cast<CFNumberRef>(theItem), kCFNumberSInt64Type, &outItem);
			theAnswer = true;
		}
	}
	
	return theAnswer;
}

bool	CACFArray::GetUInt64(UInt32 inIndex, UInt64& outItem) const
{
	bool theAnswer = false;
	
	CFTypeRef theItem = NULL;
	if(GetCFType(inIndex, theItem))
	{
		if((theItem != NULL) && (CFGetTypeID(theItem) == CFNumberGetTypeID()))
		{
			CFNumberGetValue(static_cast<CFNumberRef>(theItem), kCFNumberSInt64Type, &outItem);
			theAnswer = true;
		}
	}
	
	return theAnswer;
}

bool	CACFArray::GetFloat32(UInt32 inIndex, Float32& outItem) const
{
	bool theAnswer = false;
	
	CFTypeRef theItem = NULL;
	if(GetCFType(inIndex, theItem))
	{
		if((theItem != NULL) && (CFGetTypeID(theItem) == CFNumberGetTypeID()))
		{
			CFNumberGetValue(static_cast<CFNumberRef>(theItem), kCFNumberFloat32Type, &outItem);
			theAnswer = true;
		}
	}
	
	return theAnswer;
}

bool	CACFArray::GetFloat64(UInt32 inIndex, Float64& outItem) const
{
	bool theAnswer = false;
	
	CFTypeRef theItem = NULL;
	if(GetCFType(inIndex, theItem))
	{
		if((theItem != NULL) && (CFGetTypeID(theItem) == CFNumberGetTypeID()))
		{
			CFNumberGetValue(static_cast<CFNumberRef>(theItem), kCFNumberFloat64Type, &outItem);
			theAnswer = true;
		}
	}
	
	return theAnswer;
}

bool	CACFArray::GetString(UInt32 inIndex, CFStringRef& outItem) const
{
	bool theAnswer = false;
	
	CFTypeRef theItem = NULL;
	if(GetCFType(inIndex, theItem))
	{
		if((theItem != NULL) && (CFGetTypeID(theItem) == CFStringGetTypeID()))
		{
			outItem = static_cast<CFStringRef>(theItem);
			theAnswer = true;
		}
	}
	
	return theAnswer;
}

bool	CACFArray::GetArray(UInt32 inIndex, CFArrayRef& outItem) const
{
	bool theAnswer = false;
	
	CFTypeRef theItem = NULL;
	if(GetCFType(inIndex, theItem))
	{
		if((theItem != NULL) && (CFGetTypeID(theItem) == CFArrayGetTypeID()))
		{
			outItem = static_cast<CFArrayRef>(theItem);
			theAnswer = true;
		}
	}
	
	return theAnswer;
}

bool	CACFArray::GetDictionary(UInt32 inIndex, CFDictionaryRef& outItem) const
{
	bool theAnswer = false;
	
	CFTypeRef theItem = NULL;
	if(GetCFType(inIndex, theItem))
	{
		if((theItem != NULL) && (CFGetTypeID(theItem) == CFDictionaryGetTypeID()))
		{
			outItem = static_cast<CFDictionaryRef>(theItem);
			theAnswer = true;
		}
	}
	
	return theAnswer;
}

bool	CACFArray::GetCFType(UInt32 inIndex, CFTypeRef& outItem) const
{
	bool theAnswer = false;
	
	if((mCFArray != NULL) && (inIndex < GetNumberItems()))
	{
		outItem = CFArrayGetValueAtIndex(mCFArray, inIndex);
		theAnswer = outItem != NULL;
	}
	
	return theAnswer;
}

bool	CACFArray::AppendSInt32(SInt32 inItem)
{
	bool theAnswer = false;
	
	if((mCFArray != NULL) && mMutable)
	{
		CACFNumber theItem(inItem);
		if(theItem.IsValid())
		{
			theAnswer = AppendCFType(theItem.GetCFNumber());
		}
	}
	
	return theAnswer;
}

bool	CACFArray::AppendUInt32(UInt32 inItem)
{
	bool theAnswer = false;
	
	if((mCFArray != NULL) && mMutable)
	{
		CACFNumber theItem(inItem);
		if(theItem.IsValid())
		{
			theAnswer = AppendCFType(theItem.GetCFNumber());
		}
	}
	
	return theAnswer;
}

bool	CACFArray::AppendSInt64(SInt64 inItem)
{
	bool theAnswer = false;
	
	if((mCFArray != NULL) && mMutable)
	{
		CACFNumber theItem(inItem);
		if(theItem.IsValid())
		{
			theAnswer = AppendCFType(theItem.GetCFNumber());
		}
	}
	
	return theAnswer;
}

bool	CACFArray::AppendUInt64(UInt64 inItem)
{
	bool theAnswer = false;
	
	if((mCFArray != NULL) && mMutable)
	{
		CACFNumber theItem(inItem);
		if(theItem.IsValid())
		{
			theAnswer = AppendCFType(theItem.GetCFNumber());
		}
	}
	
	return theAnswer;
}

bool	CACFArray::AppendFloat32(Float32 inItem)
{
	bool theAnswer = false;
	
	if((mCFArray != NULL) && mMutable)
	{
		CACFNumber theItem(inItem);
		if(theItem.IsValid())
		{
			theAnswer = AppendCFType(theItem.GetCFNumber());
		}
	}
	
	return theAnswer;
}

bool	CACFArray::AppendFloat64(Float64 inItem)
{
	bool theAnswer = false;
	
	if((mCFArray != NULL) && mMutable)
	{
		CACFNumber theItem(inItem);
		if(theItem.IsValid())
		{
			theAnswer = AppendCFType(theItem.GetCFNumber());
		}
	}
	
	return theAnswer;
}

bool	CACFArray::AppendString(const CFStringRef inItem)
{
	return AppendCFType(inItem);
}

bool	CACFArray::AppendArray(const CFArrayRef inItem)
{
	return AppendCFType(inItem);
}

bool	CACFArray::AppendDictionary(const CFDictionaryRef inItem)
{
	return AppendCFType(inItem);
}

bool	CACFArray::AppendCFType(const CFTypeRef inItem)
{
	bool theAnswer = false;
	
	if((mCFArray != NULL) && mMutable)
	{
		CFArrayAppendValue(mCFArray, inItem);
		theAnswer = true;
	}
	
	return theAnswer;
}

bool	CACFArray::InsertSInt32(UInt32 inIndex, SInt32 inItem)
{
	bool theAnswer = false;
	
	if((mCFArray != NULL) && mMutable)
	{
		CACFNumber theItem(inItem);
		if(theItem.IsValid())
		{
			theAnswer = InsertCFType(inIndex, theItem.GetCFNumber());
		}
	}
	
	return theAnswer;
}

bool	CACFArray::InsertUInt32(UInt32 inIndex, UInt32 inItem)
{
	bool theAnswer = false;
	
	if((mCFArray != NULL) && mMutable)
	{
		CACFNumber theItem(inItem);
		if(theItem.IsValid())
		{
			theAnswer = InsertCFType(inIndex, theItem.GetCFNumber());
		}
	}
	
	return theAnswer;
}

bool	CACFArray::InsertSInt64(UInt32 inIndex, SInt64 inItem)
{
	bool theAnswer = false;
	
	if((mCFArray != NULL) && mMutable)
	{
		CACFNumber theItem(inItem);
		if(theItem.IsValid())
		{
			theAnswer = InsertCFType(inIndex, theItem.GetCFNumber());
		}
	}
	
	return theAnswer;
}

bool	CACFArray::InsertUInt64(UInt32 inIndex, UInt64 inItem)
{
	bool theAnswer = false;
	
	if((mCFArray != NULL) && mMutable)
	{
		CACFNumber theItem(inItem);
		if(theItem.IsValid())
		{
			theAnswer = InsertCFType(inIndex, theItem.GetCFNumber());
		}
	}
	
	return theAnswer;
}

bool	CACFArray::InsertFloat32(UInt32 inIndex, Float32 inItem)
{
	bool theAnswer = false;
	
	if((mCFArray != NULL) && mMutable)
	{
		CACFNumber theItem(inItem);
		if(theItem.IsValid())
		{
			theAnswer = InsertCFType(inIndex, theItem.GetCFNumber());
		}
	}
	
	return theAnswer;
}

bool	CACFArray::InsertFloat64(UInt32 inIndex, Float64 inItem)
{
	bool theAnswer = false;
	
	if((mCFArray != NULL) && mMutable)
	{
		CACFNumber theItem(inItem);
		if(theItem.IsValid())
		{
			theAnswer = InsertCFType(inIndex, theItem.GetCFNumber());
		}
	}
	
	return theAnswer;
}

bool	CACFArray::InsertString(UInt32 inIndex, const CFStringRef inItem)
{
	return InsertCFType(inIndex, inItem);
}

bool	CACFArray::InsertArray(UInt32 inIndex, const CFArrayRef inItem)
{
	return InsertCFType(inIndex, inItem);
}

bool	CACFArray::InsertDictionary(UInt32 inIndex, const CFDictionaryRef inItem)
{
	return InsertCFType(inIndex, inItem);
}

bool	CACFArray::InsertCFType(UInt32 inIndex, const CFTypeRef inItem)
{
	bool theAnswer = false;
	
	if((mCFArray != NULL) && mMutable)
	{
		if(inIndex < GetNumberItems())
		{
			CFArrayInsertValueAtIndex(mCFArray, inIndex, inItem);
		}
		else
		{
			CFArrayAppendValue(mCFArray, inItem);
		}
		theAnswer = true;
	}
	
	return theAnswer;
}

bool	CACFArray::SetSInt32(UInt32 inIndex, SInt32 inItem)
{
	bool theAnswer = false;
	
	if((mCFArray != NULL) && mMutable && (inIndex <= GetNumberItems()))
	{
		CACFNumber theItem(inItem);
		if(theItem.IsValid())
		{
			theAnswer = SetCFType(inIndex, theItem.GetCFNumber());
		}
	}
	
	return theAnswer;
}

bool	CACFArray::SetUInt32(UInt32 inIndex, UInt32 inItem)
{
	bool theAnswer = false;
	
	if((mCFArray != NULL) && mMutable && (inIndex <= GetNumberItems()))
	{
		CACFNumber theItem(inItem);
		if(theItem.IsValid())
		{
			theAnswer = SetCFType(inIndex, theItem.GetCFNumber());
		}
	}
	
	return theAnswer;
}

bool	CACFArray::SetSInt64(UInt32 inIndex, SInt64 inItem)
{
	bool theAnswer = false;
	
	if((mCFArray != NULL) && mMutable && (inIndex <= GetNumberItems()))
	{
		CACFNumber theItem(inItem);
		if(theItem.IsValid())
		{
			theAnswer = SetCFType(inIndex, theItem.GetCFNumber());
		}
	}
	
	return theAnswer;
}

bool	CACFArray::SetUInt64(UInt32 inIndex, UInt64 inItem)
{
	bool theAnswer = false;
	
	if((mCFArray != NULL) && mMutable && (inIndex <= GetNumberItems()))
	{
		CACFNumber theItem(inItem);
		if(theItem.IsValid())
		{
			theAnswer = SetCFType(inIndex, theItem.GetCFNumber());
		}
	}
	
	return theAnswer;
}

bool	CACFArray::SetFloat32(UInt32 inIndex, Float32 inItem)
{
	bool theAnswer = false;
	
	if((mCFArray != NULL) && mMutable && (inIndex <= GetNumberItems()))
	{
		CACFNumber theItem(inItem);
		if(theItem.IsValid())
		{
			theAnswer = SetCFType(inIndex, theItem.GetCFNumber());
		}
	}
	
	return theAnswer;
}

bool	CACFArray::SetFloat64(UInt32 inIndex, Float64 inItem)
{
	bool theAnswer = false;
	
	if((mCFArray != NULL) && mMutable && (inIndex <= GetNumberItems()))
	{
		CACFNumber theItem(inItem);
		if(theItem.IsValid())
		{
			theAnswer = SetCFType(inIndex, theItem.GetCFNumber());
		}
	}
	
	return theAnswer;
}

bool	CACFArray::SetString(UInt32 inIndex, const CFStringRef inItem)
{
	return SetCFType(inIndex, inItem);
}

bool	CACFArray::SetArray(UInt32 inIndex, const CFArrayRef inItem)
{
	return SetCFType(inIndex, inItem);
}

bool	CACFArray::SetDictionary(UInt32 inIndex, const CFDictionaryRef inItem)
{
	return SetCFType(inIndex, inItem);
}

bool	CACFArray::SetCFType(UInt32 inIndex, const CFTypeRef inItem)
{
	bool theAnswer = false;
	
	if((mCFArray != NULL) && mMutable && (inIndex <= GetNumberItems()))
	{
		CFArraySetValueAtIndex(mCFArray, inIndex, inItem);
		theAnswer = true;
	}
	
	return theAnswer;
}
