/*=============================================================================
	CACFData.h

	$Log: CACFData.h,v $
	Revision 1.4  2004/11/03 07:33:48  jcm10
	add GetDataPtr()
	
	Revision 1.3  2004/10/29 01:42:43  jcm10
	remove the unneeded reinterpret_cast
	
	Revision 1.2  2003/11/20 22:56:53  dwyatt
	__COREAUDIO_USE_FLAT_INCLUDES__
	
	Revision 1.1  2002/06/05 22:38:25  jcm10
	overhaul how default device management works
	
	Revision 0.0  Thu May 30 2002 14:57:30 US/Pacific  moorf
	Created
		
	$NoKeywords: $
=============================================================================*/
#if !defined(__CACFData_h__)
#define __CACFData_h__

//=============================================================================
//	Includes
//=============================================================================

#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
	#include <CoreAudio/CoreAudioTypes.h>
#else
	#include <CoreAudioTypes.h>
#endif

//=============================================================================
//	CACFData
//=============================================================================

class CACFData
{

//	Construction/Destruction
public:
				CACFData(CFDataRef inCFData, bool inWillRelease = true) : mCFData(inCFData), mWillRelease(inWillRelease) {}
				CACFData(const void* inData, UInt32 inDataSize) : mCFData(NULL), mWillRelease(true) { mCFData = CFDataCreate(NULL, static_cast<const UInt8*>(inData), inDataSize); }
				~CACFData() { Release(); }
				CACFData(const CACFData& inNumber) : mCFData(inNumber.mCFData), mWillRelease(inNumber.mWillRelease) { Retain(); }
	CACFData&	operator=(const CACFData& inNumber) { Release(); mCFData = inNumber.mCFData; mWillRelease = inNumber.mWillRelease; Retain(); return *this; }
	CACFData&	operator=(CFDataRef inCFData) { Release(); mCFData = inCFData; mWillRelease = true; return *this; }

private:
	void		Retain() { if(mWillRelease && (mCFData != NULL)) { CFRetain(mCFData); } }
	void		Release() { if(mWillRelease && (mCFData != NULL)) { CFRelease(mCFData); } }
	
	CFDataRef	mCFData;
	bool		mWillRelease;

//	Operations
public:
	void		AllowRelease() { mWillRelease = true; }
	void		DontAllowRelease() { mWillRelease = false; }
	bool		IsValid() { return mCFData != NULL; }

//	Value Access
public:
	CFDataRef	GetCFData() const { return mCFData; }
	CFDataRef	CopyCFData() const { if(mCFData != NULL) { CFRetain(mCFData); } return mCFData; }
	
	UInt32		GetSize() const { return CFDataGetLength(mCFData); }
	const void*	GetDataPtr() const { return CFDataGetBytePtr(mCFData); }
	void		CopyData(UInt32 inStartOffset, void* outData, UInt32 inDataSize) const { CFRange theRange = { inStartOffset, inDataSize }; CFDataGetBytes(mCFData, theRange, static_cast<UInt8*>(outData)); }
	
	SInt32		GetSInt32() const { SInt32 theAnswer = 0; CopyData(0, &theAnswer, sizeof(SInt32)); return theAnswer; }
	Float32		GetFloat32() const { Float32 theAnswer = 0; CopyData(0, &theAnswer, sizeof(Float32)); return theAnswer; }

};

#endif
