/*=============================================================================
	CACFMachPort.cp

	$Log: CACFMachPort.cpp,v $
	Revision 1.2  2005/01/28 00:58:06  jcm10
	fix gcc4 warnings
	
	Revision 1.1  2004/08/23 06:22:35  jcm10
	first checked in
	
	Revision 1.4  2004/02/06 22:03:18  jcm10
	make sure to release the CF object (thanks Sean!)
	
	Revision 1.3  2002/05/30 21:21:31  jcm10
	clean up some stuff
	
	Revision 1.2  2002/04/18 02:37:29  jcm10
	remove need for include of AudioHardware.h
	
	Revision 1.1  2002/03/01 01:52:40  jcm10
	moved here from ../Utility
	
	Revision 1.2  2002/02/28 23:24:29  jcm10
	added the CA prefix to DebugMacros and LogMacros for more consistency
	
	Revision 1.1  2001/03/21 03:15:51  jcm10
	make setting the format work
	
	Revision 0.0  2001/03/20 18:55:41  jcm10
	created
		
	$NoKeywords: $
=============================================================================*/

//=============================================================================
//	Includes
//=============================================================================

#include "CACFMachPort.h"
#include "CAException.h"
#include "CADebugMacros.h"

//=============================================================================
//	CACFMachPort
//=============================================================================

CACFMachPort::CACFMachPort(CFMachPortCallBack inCallBack, void* inUserData)
:
	mMachPort(NULL),
	mRunLoopSource(NULL)
{
	CFMachPortContext theContext = { 1, inUserData, NULL, NULL, NULL };
	mMachPort = CFMachPortCreate(NULL, inCallBack, &theContext, NULL);
	ThrowIf(mMachPort == NULL, CAException('what'), "CACFMachPort::CACFMachPort: couldn't create the CFMachPort");

	mRunLoopSource = CFMachPortCreateRunLoopSource(NULL, mMachPort, 0);
	if(mRunLoopSource == NULL)
	{
		CFMachPortInvalidate(mMachPort);
		CFRelease(mMachPort);
		mMachPort = NULL;
		DebugMessage("CACFMachPort::CACFMachPort: couldn't create the CFRunLoopSource");
		throw CAException('what');
	}
}

CACFMachPort::~CACFMachPort()
{
	if(mRunLoopSource)
	{
		CFRelease(mRunLoopSource);
	}
	
	if(mMachPort != NULL)
	{
		CFMachPortInvalidate(mMachPort);
		CFRelease(mMachPort);
	}
}
