/*=============================================================================
	CACFMessagePort.cpp

	$Log: CACFMessagePort.cpp,v $
	Revision 1.4  2005/01/28 00:58:06  jcm10
	fix gcc4 warnings
	
	Revision 1.3  2002/06/06 03:10:37  jcm10
	CACFLocalMessagePort can fail when creating the local port
	
	Revision 1.2  2002/06/05 22:38:25  jcm10
	overhaul how default device management works
	
	Revision 1.1  2002/05/30 21:21:16  jcm10
	first checked in
	
	Revision 0.0  Wed May 29 2002 18:50:01 US/Pacific  moorf
	Created
		
	$NoKeywords: $
=============================================================================*/

//=============================================================================
//	Includes
//=============================================================================

#include "CACFMessagePort.h"
#include "CADebugMacros.h"
#include "CAException.h"

//=============================================================================
//	CACFLocalMessagePort
//=============================================================================

CACFLocalMessagePort::CACFLocalMessagePort(CFStringRef inName, CFMessagePortCallBack inPortCallBack, CFMessagePortInvalidationCallBack inInvalidationCallBack, void* inUserData)
:
	mMessagePort(NULL),
	mRunLoopSource(NULL)
{
	//	create the CFMessagePort
	CFMessagePortContext theContext = { 0, inUserData, NULL, NULL, NULL };
	mMessagePort = CFMessagePortCreateLocal(NULL, inName, inPortCallBack, &theContext, NULL);
	if(mMessagePort != NULL)
	{
		//	add the invalidation callback, if any
		if(inInvalidationCallBack != NULL)
		{
			CFMessagePortSetInvalidationCallBack(mMessagePort, inInvalidationCallBack);
		}
	
		//	get the run loop source
		mRunLoopSource = CFMessagePortCreateRunLoopSource(NULL, mMessagePort, 0);
		if(mRunLoopSource == NULL)
		{
			CFRelease(mMessagePort);
			mMessagePort = NULL;
			DebugMessage("CACFLocalMessagePort::CACFLocalMessagePort: couldn't create the CFRunLoopSource");
			throw CAException('what');
		}
	}
}

CACFLocalMessagePort::~CACFLocalMessagePort()
{
	if(mMessagePort != NULL)
	{
		CFMessagePortInvalidate(mMessagePort);
		CFRelease(mMessagePort);
	}
	
	if(mRunLoopSource != NULL)
	{
		CFRelease(mRunLoopSource);
	}
}

//=============================================================================
//	CACFRemoteMessagePort
//=============================================================================

CACFRemoteMessagePort::CACFRemoteMessagePort(CFStringRef inName, CFMessagePortInvalidationCallBack inInvalidationCallBack)
:
	mMessagePort(NULL),
	mRunLoopSource(NULL)
{
	//	create the CFMessagePort
	mMessagePort = CFMessagePortCreateRemote(NULL, inName);
	if(mMessagePort != NULL)
	{
		//	failure to create a remote port does not need to throw an exception
		//	because it isn't really an error since the port in question may not
		//	exist and this fact requires a more complex response than an excpeption
		//	provides for.
		
		//	add the invalidation callback, if any
		if(inInvalidationCallBack != NULL)
		{
			CFMessagePortSetInvalidationCallBack(mMessagePort, inInvalidationCallBack);
		}
	
		//	get the run loop source
		mRunLoopSource = CFMessagePortCreateRunLoopSource(NULL, mMessagePort, 0);
		if(mRunLoopSource == NULL)
		{
			CFRelease(mMessagePort);
			mMessagePort = NULL;
			DebugMessage("CACFRemoteMessagePort::CACFRemoteMessagePort: couldn't create the CFRunLoopSource");
			throw CAException('what');
		}
	}
}

CACFRemoteMessagePort::~CACFRemoteMessagePort()
{
	if(mMessagePort != NULL)
	{
		//CFMessagePortInvalidate(mMessagePort);
		CFRelease(mMessagePort);
	}
	
	if(mRunLoopSource != NULL)
	{
		CFRelease(mRunLoopSource);
	}
}
