/*=============================================================================
	CACFMessagePort.h

	$Log: CACFMessagePort.h,v $
	Revision 1.5  2003/12/08 20:58:58  jcm10
	use the right incantation for figuring out whether or not to use framework style includes
	
	Revision 1.4  2003/11/22 00:05:27  dwyatt
	fix flat include
	
	Revision 1.3  2002/06/06 03:10:37  jcm10
	CACFLocalMessagePort can fail when creating the local port
	
	Revision 1.2  2002/06/05 22:38:25  jcm10
	overhaul how default device management works
	
	Revision 1.1  2002/05/30 21:21:16  jcm10
	first checked in
	
	Revision 0.0  Tue May 28 2002 21:16:45 US/Pacific  moorf
	Created
		
	$NoKeywords: $
=============================================================================*/
#if !defined(__CACFMessagePort_h__)
#define __CACFMessagePort_h__

//=============================================================================
//	Includes
//=============================================================================

#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
	#include <CoreFoundation/CFMessagePort.h>
#else
	#include <CFMessagePort.h>
#endif

//=============================================================================
//	CACFLocalMessagePort
//=============================================================================

class CACFLocalMessagePort
{

//	Construction/Destruction
public:
						CACFLocalMessagePort(CFStringRef inName, CFMessagePortCallBack inPortCallBack, CFMessagePortInvalidationCallBack inInvalidationCallBack, void* inUserData = NULL);
	virtual				~CACFLocalMessagePort();

//	Attributes
public:
	bool				IsValid() const { return mMessagePort != NULL; }
	CFMessagePortRef	GetMessagePortRef() const { return mMessagePort; }
	CFRunLoopSourceRef	GetRunLoopSource() const { return mRunLoopSource; }

//	Implementation
protected:
	CFMessagePortRef	mMessagePort;
	CFRunLoopSourceRef	mRunLoopSource;

};

//=============================================================================
//	CACFRemoteMessagePort
//=============================================================================

class CACFRemoteMessagePort
{

//	Construction/Destruction
public:
						CACFRemoteMessagePort(CFStringRef inName, CFMessagePortInvalidationCallBack inInvalidationCallBack);
	virtual				~CACFRemoteMessagePort();

//	Attributes
public:
	bool				IsValid() const { return mMessagePort != NULL; }
	CFMessagePortRef	GetMessagePortRef() const { return mMessagePort; }
	CFRunLoopSourceRef	GetRunLoopSource() const { return mRunLoopSource; }

//	Operations
public:
	SInt32				SendRequest(SInt32 inMessageID, CFDataRef inData, CFTimeInterval inSendTimeout, CFTimeInterval inReceiveTimout) const { return CFMessagePortSendRequest(mMessagePort, inMessageID, inData, inSendTimeout, inReceiveTimout, NULL, NULL); }
	SInt32				SendRequest(SInt32 inMessageID, CFDataRef inData, CFTimeInterval inSendTimeout, CFTimeInterval inReceiveTimout, CFStringRef inReplyMode, CFDataRef& outReturnData) const { return CFMessagePortSendRequest(mMessagePort, inMessageID, inData, inSendTimeout, inReceiveTimout, inReplyMode, &outReturnData); }

//	Implementation
protected:
	CFMessagePortRef	mMessagePort;
	CFRunLoopSourceRef	mRunLoopSource;

};

#endif
