/*=============================================================================
	CACFNumber.h

	$Log: CACFNumber.h,v $
	Revision 1.8  2003/12/16 20:15:23  dwyatt
	GetSInt64 was returning SInt32
	
	Revision 1.7  2003/11/20 22:56:53  dwyatt
	__COREAUDIO_USE_FLAT_INCLUDES__
	
	Revision 1.6  2003/05/22 19:05:29  jcm10
	add some new constructors
	
	Revision 1.5  2003/05/04 00:01:32  jcm10
	add constructor for Float64
	
	Revision 1.4  2002/06/11 19:57:01  jcm10
	add SInt64 support
	
	Revision 1.3  2002/04/18 02:20:12  jcm10
	clean up the header inclusion
	
	Revision 1.2  2002/04/10 01:15:20  jcm10
	assignment operators return a reference
	
	Revision 1.1  2002/03/01 01:52:40  jcm10
	moved here from ../Utility
	
	Revision 1.4  2001/03/20 00:03:25  jcm10
	make the default devices persistent
	
	Revision 1.3  2001/03/14 23:48:38  jcm10
	Lots of changes to support the new driver API
	
	Revision 1.2  2001/02/24 04:55:24  jcm10
	make it build
	
	Revision 1.1  2001/02/23 23:43:21  jcm10
	first checked in
	
	Revision 0.0  2001/02/23 12:34:56  jcm10
	created
		
	$NoKeywords: $
=============================================================================*/
#if !defined(__CACFNumber_h__)
#define __CACFNumber_h__

//=============================================================================
//	Includes
//=============================================================================

#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
	#include <CoreAudio/CoreAudioTypes.h>
	#include <CoreFoundation/CFNumber.h>
#else
	#include <CoreAudioTypes.h>
	#include <CFNumber.h>
#endif

//=============================================================================
//	CACFNumber
//=============================================================================

class	CACFNumber
{
//	Construction/Destruction
public:
				CACFNumber(CFNumberRef inCFNumber, bool inWillRelease = true) : mCFNumber(inCFNumber), mWillRelease(inWillRelease) {}
				CACFNumber(SInt32 inValue) : mCFNumber(CFNumberCreate(NULL, kCFNumberSInt32Type, &inValue)), mWillRelease(true) {}
				CACFNumber(UInt32 inValue) : mCFNumber(CFNumberCreate(NULL, kCFNumberSInt32Type, &inValue)), mWillRelease(true) {}
				CACFNumber(SInt64 inValue) : mCFNumber(CFNumberCreate(NULL, kCFNumberSInt64Type, &inValue)), mWillRelease(true) {}
				CACFNumber(UInt64 inValue) : mCFNumber(CFNumberCreate(NULL, kCFNumberSInt64Type, &inValue)), mWillRelease(true) {}
				CACFNumber(Float32 inValue) : mCFNumber(CFNumberCreate(NULL, kCFNumberFloat32Type, &inValue)), mWillRelease(true) {}
				CACFNumber(Float64 inValue) : mCFNumber(CFNumberCreate(NULL, kCFNumberFloat64Type, &inValue)), mWillRelease(true) {}
				~CACFNumber() { Release(); }
				CACFNumber(const CACFNumber& inNumber) : mCFNumber(inNumber.mCFNumber), mWillRelease(inNumber.mWillRelease) { Retain(); }
	CACFNumber&	operator=(const CACFNumber& inNumber) { Release(); mCFNumber = inNumber.mCFNumber; mWillRelease = inNumber.mWillRelease; Retain(); return *this; }
	CACFNumber&	operator=(CFNumberRef inCFNumber) { Release(); mCFNumber = inCFNumber; mWillRelease = true; return *this; }

private:
	void		Retain() { if(mWillRelease && (mCFNumber != NULL)) { CFRetain(mCFNumber); } }
	void		Release() { if(mWillRelease && (mCFNumber != NULL)) { CFRelease(mCFNumber); } }
	
	CFNumberRef	mCFNumber;
	bool		mWillRelease;

//	Operations
public:
	void		AllowRelease() { mWillRelease = true; }
	void		DontAllowRelease() { mWillRelease = false; }
	bool		IsValid() { return mCFNumber != NULL; }

//	Value Access
public:
	CFNumberRef	GetCFNumber() const { return mCFNumber; }
	CFNumberRef	CopyCFNumber() const { if(mCFNumber != NULL) { CFRetain(mCFNumber); } return mCFNumber; }

	SInt8		GetSInt8() const { SInt8 theAnswer = 0; if(mCFNumber != NULL) { CFNumberGetValue(mCFNumber, kCFNumberSInt8Type, &theAnswer); } return theAnswer; }
	SInt32		GetSInt32() const { SInt32 theAnswer = 0; if(mCFNumber != NULL) { CFNumberGetValue(mCFNumber, kCFNumberSInt32Type, &theAnswer); } return theAnswer; }
	Float32		GetFloat32() const { Float32 theAnswer = 0.0; if(mCFNumber != NULL) { CFNumberGetValue(mCFNumber, kCFNumberFloat32Type, &theAnswer); } return theAnswer; }
	Float32		GetFixed32() const;
	SInt64		GetSInt64() const { SInt64 theAnswer = 0; if(mCFNumber != NULL) { CFNumberGetValue(mCFNumber, kCFNumberSInt64Type, &theAnswer); } return theAnswer; }
};

#endif
