/*==================================================================================================
	CACFPreferences.h

	$Log: CACFPreferences.h,v $
	Revision 1.3  2004/11/03 07:34:37  jcm10
	roll out the current app domain stuff
	
	Revision 1.2  2004/11/03 03:51:44  jcm10
	add the ability to save prefs in the current app domain
	
	Revision 1.1  2004/03/31 20:59:05  jcm10
	first checked in
	
	Revision 0.0  Tue Mar 30 2004 20:37:50 US/Pacific  moorf
	Created
		
	$NoKeywords: $
==================================================================================================*/
#if !defined(__CACFPreferences_h__)
#define __CACFPreferences_h__

//==================================================================================================
//	Includes
//==================================================================================================

//	System Includes
#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
	#include <CoreFoundation/CoreFoundation.h>
#else
	#include <CoreFoundation.h>
#endif

//==================================================================================================
//	CACFPreferences
//==================================================================================================

class CACFPreferences
{

//	Operations
public:
	static CFPropertyListRef	CopyValue(CFStringRef inKey, bool inCurrentUser, bool inCurrentHost);
	static CFStringRef			CopyStringValue(CFStringRef inKey, bool inCurrentUser, bool inCurrentHost);
	static CFNumberRef			CopyNumberValue(CFStringRef inKey, bool inCurrentUser, bool inCurrentHost);
	static CFArrayRef			CopyArrayValue(CFStringRef inKey, bool inCurrentUser, bool inCurrentHost);
	static CFDictionaryRef		CopyDictionaryValue(CFStringRef inKey, bool inCurrentUser, bool inCurrentHost);
	static void					SetValue(CFStringRef inKey, CFPropertyListRef inValue, bool inCurrentUser, bool inCurrentHost, bool inSynchronize);
	static void					DeleteValue(CFStringRef inKey, bool inCurrentUser, bool inCurrentHost, bool inSynchronize);
	static void					Synchronize(bool inCurrentUser, bool inCurrentHost, bool inForce);
	static void					MarkPrefsOutOfDate(bool inCurrentUser, bool inCurrentHost);
	static void					MarkPrefsClean(bool inCurrentUser, bool inCurrentHost);
	static void					SendNotification(CFStringRef inName);

private:
	static bool					ArePrefsOutOfDate(bool inCurrentUser, bool inCurrentHost);
	
	static bool					sAnyUserAnyHostPrefsOutOfDate;
	static bool					sAnyUserCurrentHostPrefsOutOfDate;
	static bool					sCurrentUserAnyHostPrefsOutOfDate;
	static bool					sCurrentUserCurrentHostPrefsOutOfDate;

};

#endif
