/*=============================================================================
	CACFRunLoopTimer.cpp

	$Log: CACFRunLoopTimer.cpp,v $
	Revision 1.3  2004/04/13 07:06:52  jcm10
	fix compiler warnings
	
	Revision 1.2  2002/03/20 21:09:52  jcm10
	make CACFRunLoopTimer::Cancel do the right thing
	
	Revision 1.1  2002/03/15 02:19:09  jcm10
	first checked in
	
	Revision 0.0  Thu Mar 14 2002 12:46:00 US/Pacific  moorf
	Created
		
	$NoKeywords: $
=============================================================================*/

//=============================================================================
//	Includes
//=============================================================================

#include "CACFRunLoopTimer.h"
#include "CADebugMacros.h"
#include "CAException.h"

//=============================================================================
//	CACFRunLoopTimer
//=============================================================================

CACFRunLoopTimer::CACFRunLoopTimer(CFAbsoluteTime inFireTime, CFTimeInterval inFireInterval)
:
	mRunLoopTimer(NULL)
{
	//	initialize the context
	mRunLoopTimerContext.version = 0;
	mRunLoopTimerContext.info = this;
	mRunLoopTimerContext.retain = NULL;
	mRunLoopTimerContext.release = NULL;
	mRunLoopTimerContext.copyDescription = NULL;
	
	mRunLoopTimer = CFRunLoopTimerCreate(NULL, inFireTime, inFireInterval, 0, 0, (CFRunLoopTimerCallBack)TimerCallBack, &mRunLoopTimerContext);
	ThrowIf(mRunLoopTimer == NULL, CAException('what'), "CACFRunLoopTimer::CACFRunLoopTimer: couldn't create the timer object");
}

CACFRunLoopTimer::~CACFRunLoopTimer()
{
	CFRunLoopTimerInvalidate(mRunLoopTimer);
	CFRelease(mRunLoopTimer);
}

void	CACFRunLoopTimer::FireAt(CFAbsoluteTime inFireTime)
{
	CFRunLoopTimerSetNextFireDate(mRunLoopTimer, inFireTime);
}

void	CACFRunLoopTimer::Cancel()
{
	static const CFAbsoluteTime kLongTimeInTheFuture = 1000000000000.0;
	FireIn(kLongTimeInTheFuture);
}

void	CACFRunLoopTimer::Fire()
{
}

void	CACFRunLoopTimer::TimerCallBack(CFRunLoopTimerRef /*inTimer*/, CACFRunLoopTimer* inTimerObject)
{
	#if	Time_Notification_Thread
		Float64 theStartTime = (Float64)CAHostTimeBase::GetCurrentTimeInNanos();
		printf("-->CACFRunLoopTimer::TimerCallBack at: %.3f\n", theStartTime / 1000000.0);
	#endif

	if(inTimerObject != NULL)
	{
		inTimerObject->Fire();
	}

	#if	Time_Notification_Thread
		Float64 theEndTime = (Float64)CAHostTimeBase::GetCurrentTimeInNanos();
		printf("<--CACFRunLoopTimer::TimerCallBack at: %.3f duration: %.3f\n", theEndTime / 1000000.0, (theStartTime - theEndTime) / 1000000.0);
		fflush(stdout);
	#endif
}
