/*=============================================================================
	CACFRunLoopTimer.h

	$Log: CACFRunLoopTimer.h,v $
	Revision 1.2  2003/11/20 22:56:53  dwyatt
	__COREAUDIO_USE_FLAT_INCLUDES__
	
	Revision 1.1  2002/03/15 02:19:09  jcm10
	first checked in
	
	Revision 0.0  Thu Mar 14 2002 12:37:32 US/Pacific  moorf
	Created
		
	$NoKeywords: $
=============================================================================*/
#if !defined(__CACFRunLoopTimer_h__)
#define __CACFRunLoopTimer_h__

//=============================================================================
//	Includes
//=============================================================================

#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
	#include <CoreAudio/CoreAudioTypes.h>
	#include <CoreFoundation/CFRunLoop.h>
#else
	#include <CoreAudioTypes.h>
	#include <CFRunLoop.h>
#endif

//=============================================================================
//	CACFRunLoopTimer
//=============================================================================

class CACFRunLoopTimer
{

//	Construction/Destruction
public:
							CACFRunLoopTimer(CFAbsoluteTime inFireTime, CFTimeInterval inFireInterval);
	virtual					~CACFRunLoopTimer();

//	Operations
public:
	CFRunLoopTimerRef		GetRunLoopTimerRef() const { return mRunLoopTimer; }
	void					FireAt(CFAbsoluteTime inFireTime);
	void					FireIn(CFAbsoluteTime inFireTime) { FireAt(inFireTime + CFAbsoluteTimeGetCurrent()); }
	void					Cancel();
	
protected:
	virtual void			Fire();
	static void				TimerCallBack(CFRunLoopTimerRef inTimer, CACFRunLoopTimer* inTimerObject);

private:
	CFRunLoopTimerRef		mRunLoopTimer;
	CFRunLoopTimerContext	mRunLoopTimerContext;

};

#endif
