/*=============================================================================
	CACFString.cp

	$Log: CACFString.cpp,v $
	Revision 1.2  2004/10/06 19:50:15  jcm10
	add accessors for getting the length of a CFString in both characters and bytes
	
	Revision 1.1  2004/08/23 06:22:35  jcm10
	first checked in
	
	Revision 1.6  2004/08/05 01:26:46  jcm10
	add an encoding argument to the various GetCString methods
	
	Revision 1.5  2004/07/19 19:07:45  jcm10
	add a static method to CACFString for getting a C string or Unicode string from a CFStringRef
	
	Revision 1.4  2003/09/05 23:52:00  jcm10
	only fill C-strings if the length is greater than 0
	
	Revision 1.3  2003/03/25 03:16:51  jcm10
	use UTF8 encodings
	
	Revision 1.2  2002/08/07 23:14:47  jcm10
	add GetUnicodeString
	
	Revision 1.1  2002/03/01 01:52:40  jcm10
	moved here from ../Utility
	
	Revision 1.4  2001/07/12 03:50:28  jcm10
	since CFStringGetCString returns only the length in characters, we have to add 1 when returning the length
	
	Revision 1.3  2001/04/05 01:32:26  jcm10
	add CACFMutableString
	
	Revision 1.2  2001/03/16 00:42:24  jcm10
	don't release the string after getting a C string from it.
	
	Revision 1.1  2001/03/14 23:48:38  jcm10
	Lots of changes to support the new driver API
	
	Revision 0.0  2001/03/12 14:12:32  jcm10
	created
		
	$NoKeywords: $
=============================================================================*/

//=============================================================================
//	Includes
//=============================================================================

#include "CACFString.h"

//=============================================================================
//	CACFString
//=============================================================================

UInt32	CACFString::GetStringByteLength(CFStringRef inCFString, CFStringEncoding inEncoding)
{
	UInt32 theAnswer = 0;
	
	if(inCFString != NULL)
	{
		CFRange theRange = { 0, CFStringGetLength(inCFString) };
		CFStringGetBytes(inCFString, theRange, inEncoding, 0, false, NULL, 0x7FFFFFFF, (CFIndex*)&theAnswer);
	}
	
	return theAnswer;
}

void	CACFString::GetCString(CFStringRef inCFString, char* outString, UInt32& ioStringSize, CFStringEncoding inEncoding)
{
	if(ioStringSize > 0)
	{
		if(inCFString != NULL)
		{
			CFIndex theLength = 0;
			CFRange theRange = { 0, CFStringGetLength(inCFString) };
			CFStringGetBytes(inCFString, theRange, inEncoding, 0, false, (UInt8*)outString, ioStringSize - 1, &theLength);
			outString[theLength] = 0;
			ioStringSize = theLength + 1;
		}
		else
		{
			outString[0] = 0;
			ioStringSize = 1;
		}
	}
}

void	CACFString::GetUnicodeString(CFStringRef inCFString, UInt16* outString, UInt32& ioStringSize)
{
	if(ioStringSize > 0)
	{
		if(inCFString != NULL)
		{
			CFRange theStringRange = { 0, CFStringGetLength(inCFString) };
			if(static_cast<UInt32>(theStringRange.length) > ioStringSize)
			{
				theStringRange.length = ioStringSize;
			}
			CFStringGetCharacters(inCFString, theStringRange, outString);
			ioStringSize = theStringRange.length;
		}
		else
		{
			outString[0] = 0;
			ioStringSize = 0;
		}
	}
}
