/*=============================================================================
	CAHALTelemetry.h

	$Log: CAHALTelemetry.h,v $
	Revision 1.6  2003/11/20 22:56:53  dwyatt
	__COREAUDIO_USE_FLAT_INCLUDES__
	
	Revision 1.5  2003/07/24 22:44:08  jcm10
	don't allow the telemetry port name to get too big
	
	Revision 1.4  2003/06/20 19:04:06  jcm10
	clean up the telemetry
	
	Revision 1.3  2003/06/19 18:30:47  jcm10
	add new events
	
	Revision 1.2  2003/05/25 01:42:34  jcm10
	change the overload telemetry to be bracket style
	
	Revision 1.1  2003/05/23 19:06:50  jcm10
	first checked in
	
	Revision 0.0  Thu May 22 2003 16:02:50 US/Pacific  moorf
	Created
		
	$NoKeywords: $
=============================================================================*/
#if !defined(__CAHALTelemetry_h__)
#define __CAHALTelemetry_h__

//=============================================================================
//	Includes
//=============================================================================

//	System Includes
#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
	#include <CoreAudio/CoreAudioTypes.h>
#else
	#include <CoreAudioTypes.h>
#endif
#include <string.h>

//=============================================================================
//	CAHALIOCycleRawTelemetryEvent
//=============================================================================

struct	CAHALIOCycleRawTelemetryEvent
{
	UInt64	mEventTime;
	UInt32	mEventKind;
	UInt32	mIOCycleNumber;
	Float64	mRateScalar1;
	Float64	mRateScalar2;
	Float64	mSampleTime1;
	Float64	mSampleTime2;
	UInt64	mHostTime1;
	UInt64	mHostTime2;
	UInt32	mError;
	UInt32	mFlags;
	
	CAHALIOCycleRawTelemetryEvent() { memset(this, 0, sizeof(CAHALIOCycleRawTelemetryEvent)); }
	CAHALIOCycleRawTelemetryEvent(const CAHALIOCycleRawTelemetryEvent& inEvent) { memcpy(this, &inEvent, sizeof(CAHALIOCycleRawTelemetryEvent)); }
	CAHALIOCycleRawTelemetryEvent&	operator=(const CAHALIOCycleRawTelemetryEvent& inEvent) { memcpy(this, &inEvent, sizeof(CAHALIOCycleRawTelemetryEvent)); return *this; }

	struct	MatchEventKind
	{
		UInt32 mEventKind;
		MatchEventKind(UInt32 inEventKind) : mEventKind(inEventKind) {}
		bool operator()(const CAHALIOCycleRawTelemetryEvent& inEvent) const { return inEvent.mEventKind == mEventKind; }
	};
};

//=============================================================================
//	Constants
//=============================================================================

enum
{
	//	Message IDs
	kHALTelemetryMessageGetProperty						= 'getp',
	kHALTelemetryMessageSetProperty						= 'setp',
	kHALTelemetryMessageGetTelemetry					= 'tele',
	kHALTelemetryMessageClearTelemetry					= 'clrt',
	
	//	Property IDs
	kHALTelemetryPropertyIsCapturing					= 'capt',
	kHALTelemetryPropertyEndianness						= 'endi',
	
	//	Values for kHALTelemetryPropertyEndianness
	kHALTelemetryServerIsBigEndian						= 1UL,
	kHALTelemetryServerIsLittleEndian					= 0UL,
	
	//	Flags for CAHALIOCycleRawTelemetryEvent
	kHALIOCycleTelemetryFlagNoneIsValid					= 0,
	kHALIOCycleTelemetryFlagRateScalar1IsValid			= (1UL << 0),
	kHALIOCycleTelemetryFlagRateScalar2IsValid			= (1UL << 1),
	kHALIOCycleTelemetryFlagSampleTime1IsValid			= (1UL << 2),
	kHALIOCycleTelemetryFlagSampleTime2IsValid			= (1UL << 3),
	kHALIOCycleTelemetryFlagHostTime1IsValid			= (1UL << 4),
	kHALIOCycleTelemetryFlagHostTime2IsValid			= (1UL << 5),
	kHALIOCycleTelemetryFlagErrorIsValid				= (1UL << 6),
	kHALIOCycleTelemetryFlagTimeStamp1IsValid			= kHALIOCycleTelemetryFlagRateScalar1IsValid | kHALIOCycleTelemetryFlagSampleTime1IsValid | kHALIOCycleTelemetryFlagHostTime1IsValid,
	kHALIOCycleTelemetryFlagTimeStamp2IsValid			= kHALIOCycleTelemetryFlagRateScalar2IsValid | kHALIOCycleTelemetryFlagSampleTime2IsValid | kHALIOCycleTelemetryFlagHostTime2IsValid,
	kHALIOCycleTelemetryFlagBothTimeStampsAreValid		= kHALIOCycleTelemetryFlagTimeStamp1IsValid | kHALIOCycleTelemetryFlagTimeStamp2IsValid,

	//	Events specified in a CAHALIOCycleRawTelemetryEvent
	kHALIOCycleTelemetryEventInitializeBegin			= 'inib',	//	no data
	kHALIOCycleTelemetryEventInitializeEnd				= 'inie',	//	anchor time (kHALIOCycleTelemetryFlagHostTime1IsValid)
	kHALIOCycleTelemetryEventWorkLoopBegin				= 'wrkb',	//	now (kHALIOCycleTelemetryFlagHostTime1IsValid)
	kHALIOCycleTelemetryEventInputReadBegin				= 'redb',	//	input time (kHALIOCycleTelemetryFlagHostTime1IsValid)
	kHALIOCycleTelemetryEventInputReadEnd				= 'rede',	//	read error (kHALIOCycleTelemetryFlagErrorIsValid)
	kHALIOCycleTelemetryEventIOProcsBegin				= 'iopb',	//	no data
	kHALIOCycleTelemetryEventIOProcsEnd					= 'iope',	//	no data
	kHALIOCycleTelemetryEventOutputWriteBegin			= 'wrib',	//	output time (kHALIOCycleTelemetryFlagHostTime1IsValid)
	kHALIOCycleTelemetryEventOutputWriteEnd				= 'wrie',	//	write error (kHALIOCycleTelemetryFlagErrorIsValid)
	kHALIOCycleTelemetryEventWorkLoopOverloadBegin		= 'ovrb',	//	current time, next wake time (kHALIOCycleTelemetryFlagBothTimeStampsAreValid)
	kHALIOCycleTelemetryEventWorkLoopOverloadEnd		= 'ovre',	//	anchor time (kHALIOCycleTelemetryFlagHostTime1IsValid)
	kHALIOCycleTelemetryEventWorkLoopEnd				= 'wrke',	//	current time, next wake time (kHALIOCycleTelemetryFlagBothTimeStampsAreValid)
	kHALIOCycleTelemetryEventTeardownBegin				= 'trdb',	//	no data
	kHALIOCycleTelemetryEventTeardownEnd				= 'trde',	//	no data
	kHALIOCycleTelemetryEventZeroTimeStampRecieved		= 'zror',	//	zero time (kHALIOCycleTelemetryFlagHostTime1IsValid)
	kHALIOCycleTelemetryEventZeroTimeStampApplied		= 'zroa',	//	zero time (kHALIOCycleTelemetryFlagHostTime1IsValid)
	kHALIOCycleTelemetryEventEarlyZeroTimeStamp			= 'zroe',	//	zero time (kHALIOCycleTelemetryFlagHostTime1IsValid)
	kHALIOCycleTelemetryEventOutOfBoundsZeroTimeStamp   = 'zrob',	//	zero time (kHALIOCycleTelemetryFlagHostTime1IsValid)
	kHALIOCycleTelemetryEventTimelineReset				= 'zres',   //  no data
	kHALIOCycleTelemetryEventResynch					= 'sync',   //  anchor time (kHALIOCycleTelemetryFlagHostTime1IsValid)
	kHALIOCycleTelemetryEventInputDataPresent			= 'inpt',   //  no data
	kHALIOCycleTelemetryEventOutputDataPresent			= 'outp',   //  no data
	kHALIOCycleTelemetryEventStartHardware				= 'gohw',   //  driver error (kHALIOCycleTelemetryFlagErrorIsValid)
	kHALIOCycleTelemetryEventStopHardware				= 'sthw',   //  driver error (kHALIOCycleTelemetryFlagErrorIsValid)
	kHALIOCycleTelemetryEventHardwareStarted			= 'hwgo',   //  no data
	kHALIOCycleTelemetryEventHardwareStopped			= 'hwst',   //  no data
	kHALIOCycleTelemetryEventHardwarePaused				= 'hwpa',   //  no data
	kHALIOCycleTelemetryEventHardwareResumed			= 'hwre',   //  no data
	kHALIOCycleTelemetryEventFormatChangeBegin			= 'fmtb',   //  no data
	kHALIOCycleTelemetryEventFormatChangeEnd			= 'fmte',   //  no data
	kHALIOCycleTelemetryEventMajorEngineChangeBegin		= 'mecb',	//  no data
	kHALIOCycleTelemetryEventMajorEngineChangeEnd		= 'mece'	//  no data
	
};

//	Strings
#define	kHALIOCycleTelemetryServerPortNameFormat		"com.apple.audio.CoreAudio.pid-%d.%lu.%qd.Telemetry.IOCycle"	//	args: pid, the CFHash of the device's UID, and the sum of all unicode characters in device UID
#define	kHALIOCycleTelemetryRunLoopMode					"IOCycleTelemetryMode"
#define	kHALIOCycleTelemetryReturnErrorKey				"return error"
#define	kHALIOCycleTelemetryPropertyIDKey				"property id"
#define	kHALIOCycleTelemetryPropertyValueKey			"property value"

#endif
