/*=============================================================================
	CAIOObject.h

	$Log: CAIOObject.h,v $
	Revision 1.5  2005/01/12 19:32:34  jcm10
	make sure IO_OBJECT_NULL is always defined
	
	Revision 1.4  2004/12/14 23:59:09  jcm10
	use IO_OBJECT_NULL instead of NULL
	
	Revision 1.3  2003/12/19 01:12:14  jcm10
	add missing includes
	
	Revision 1.2  2003/10/09 22:01:13  jcm10
	add methods for getting properties
	
	Revision 1.1  2003/04/19 02:42:43  jcm10
	first checked in
	
	Revision 0.0  Fri Apr 18 2003 17:08:41 US/Pacific  moorf
	Created
		
	$NoKeywords: $
=============================================================================*/
#if !defined(__CAIOObject_h__)
#define __CAIOObject_h__

//=============================================================================
//	Includes
//=============================================================================

//	System Includes
#include <CoreFoundation/CoreFoundation.h>
#include <IOKit/IOKitLib.h>

#if !defined(IO_OBJECT_NULL)
	#define	IO_OBJECT_NULL	((io_object_t) 0)
#endif

//=============================================================================
//	CAIOObject
//=============================================================================

class CAIOObject
{

//	Construction/Destruction
public:
					CAIOObject() : mIOObject(IO_OBJECT_NULL), mWillRelease(true) {}
					CAIOObject(io_object_t inIOObject, bool inWillRelease = true) : mIOObject(inIOObject), mWillRelease(inWillRelease) {}
					~CAIOObject() { Release(); }
					CAIOObject(const CAIOObject& inObject) : mIOObject(inObject.mIOObject), mWillRelease(inObject.mWillRelease) { Retain(); }
	CAIOObject&		operator=(const CAIOObject& inObject) { Release(); mIOObject = inObject.mIOObject; mWillRelease = inObject.mWillRelease; Retain(); return *this; }
	CAIOObject&		operator=(io_object_t inIOObject) { Release(); mIOObject = inIOObject; mWillRelease = true; return *this; }

private:
	void			Retain() { if(mWillRelease && (mIOObject != IO_OBJECT_NULL)) { IOObjectRetain(mIOObject); } }
	void			Release() { if(mWillRelease && (mIOObject != IO_OBJECT_NULL)) { IOObjectRelease(mIOObject); mIOObject = IO_OBJECT_NULL; } }
	
	io_object_t		mIOObject;
	bool			mWillRelease;

//	Operations
public:
	void			AllowRelease() { mWillRelease = true; }
	void			DontAllowRelease() { mWillRelease = false; }
	bool			IsValid() const { return mIOObject != IO_OBJECT_NULL; }
	bool			IsEqual(io_object_t inIOObject) { return IOObjectIsEqualTo(inIOObject, mIOObject); }
	bool			ConformsTo(const io_name_t inClassName) { return IOObjectConformsTo(mIOObject, inClassName); }
	CFTypeRef		GetCFProperty(CFStringRef inKey) const { return IORegistryEntryCreateCFProperty(mIOObject, inKey, NULL, 0); }
	CFNumberRef		GetCFNumberProperty(CFStringRef inKey) const { return static_cast<CFNumberRef>(GetCFProperty(inKey)); }
	CFStringRef		GetCFStringProperty(CFStringRef inKey) const { return static_cast<CFStringRef>(GetCFProperty(inKey)); }

//	Value Access
public:
	io_object_t		GetIOObject() const { return mIOObject; }
	io_object_t		CopyIOObject() const { if(mIOObject != IO_OBJECT_NULL) { IOObjectRetain(mIOObject); } return mIOObject; }

};

#endif
