/*=============================================================================
	CACommand.cp

	$Log: CAProcess.cpp,v $
	Revision 1.3  2003/05/07 23:32:53  baron
	put #include <unistd.h> back in for getpid().
	
	Revision 1.2  2003/05/06 19:45:54  jcm10
	use kill(2) to determine the existence of a given PID
	
	Revision 1.1  2003/02/17 20:37:33  jcm10
	moved here from AudioHardware/Utility
	
	Revision 1.3  2002/05/22 02:43:00  jcm10
	use getpgid instead of GetProcessForPID to determine if a process is around
	
	Revision 1.2  2002/03/14 20:06:18  jcm10
	add GetPID()
	
	Revision 1.1  2002/03/01 02:05:44  jcm10
	moved here from ../../Utility
	
	Revision 1.2  2002/02/28 23:24:29  jcm10
	added the CA prefix to DebugMacros and LogMacros for more consistency
	
	Revision 1.1  2001/08/14 21:26:10  jcm10
	first checked in
	
	Revision 0.0  2001/08/09 20:02:07  jcm10
	created
		
	$NoKeywords: $
=============================================================================*/

//=============================================================================
//	Includes
//=============================================================================

#include "CAProcess.h"
#include <signal.h>
#include <unistd.h>

//=============================================================================
//	CAProcess
//=============================================================================

bool	CAProcess::ProcessExists(pid_t inPID)
{
	//	pids <= 0 are reserved for special purposes and -1 is
	//	used as a sentinel value by the HAL.
	bool theAnswer = inPID > 0;
	
	if(theAnswer)
	{
		//	according to kill(2), the process exists if kill(pid, 0) returns 0
		theAnswer = kill(inPID, 0) == 0;
	}

	
	return theAnswer;
}

pid_t	CAProcess::GetPID()
{
	if(sPID == -1)
	{
		sPID = getpid();
	}
	
	return sPID;
}

pid_t	CAProcess::sPID = -1;
